/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.color.ICC_Profile;
import quadbase.common.util.output.ExceptionConverter;
import quadbase.common.util.output.pdf.PdfException;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfStream;

class PdfICCBased
extends PdfStream {
    protected int NumberOfComponents;

    PdfICCBased(ICC_Profile profile) {
        try {
            this.NumberOfComponents = profile.getNumComponents();
            PdfNumber pNumber = new PdfNumber(this.NumberOfComponents);
            switch (this.NumberOfComponents) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(this.NumberOfComponents + " component(s) is not supported in PDF1.4");
                }
            }
            this.put(PdfName.N, new PdfNumber(this.NumberOfComponents));
            this.bytes = profile.getData();
            this.flateCompress();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

