/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfResource;

class PdfProcSet
implements PdfResource {
    public static final int PDF = 1;
    public static final int TEXT = 2;
    public static final int IMAGEB = 4;
    public static final int IMAGEC = 8;
    public static final int IMAGEI = 16;
    private static int[] types = new int[5];
    private static PdfName[] names = new PdfName[5];
    private static final int N = 5;
    private PdfObject value;

    PdfProcSet(int procset) {
        this.value = PdfProcSet.getProcSet(procset);
    }

    PdfProcSet(PdfIndirectReference procset) {
        this.value = procset;
    }

    @Override
    public PdfName key() {
        return PdfName.PROCSET;
    }

    @Override
    public PdfObject value() {
        return this.value;
    }

    static final PdfArray getProcSet(int procset) {
        PdfArray tmp = new PdfArray();
        for (int i = 0; i < 5; ++i) {
            if ((procset & types[i]) <= 0) continue;
            tmp.add(names[i]);
        }
        return tmp;
    }

    static {
        PdfProcSet.types[0] = 1;
        PdfProcSet.names[0] = PdfName.PDF;
        PdfProcSet.types[1] = 2;
        PdfProcSet.names[1] = PdfName.TEXT;
        PdfProcSet.types[2] = 4;
        PdfProcSet.names[2] = PdfName.IMAGEB;
        PdfProcSet.types[3] = 8;
        PdfProcSet.names[3] = PdfName.IMAGEC;
        PdfProcSet.types[4] = 16;
        PdfProcSet.names[4] = PdfName.IMAGEI;
    }
}

