/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;
import quadbase.common.util.output.DocWriter;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.IntHashtable;
import quadbase.common.util.output.pdf.LZWDecoder;
import quadbase.common.util.output.pdf.PRAcroForm;
import quadbase.common.util.output.pdf.PRIndirectReference;
import quadbase.common.util.output.pdf.PRStream;
import quadbase.common.util.output.pdf.PRTokeniser;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfEncodings;
import quadbase.common.util.output.pdf.PdfEncryption;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfLiteral;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNull;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReaderInstance;
import quadbase.common.util.output.pdf.PdfString;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.RandomAccessFileOrArray;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    protected PRTokeniser tokens;
    protected int[] xref;
    protected PdfObject[] xrefObj;
    protected PdfDictionary trailer;
    protected PdfDictionary[] pages;
    protected PdfDictionary catalog;
    protected PRIndirectReference[] pageRefs;
    protected PRAcroForm acroForm = null;
    protected ArrayList pageInh;
    protected int pagesCount;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected int objNum;
    protected int objGen;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;

    public PdfReader(String filename) throws IOException {
        this(filename, null);
    }

    public PdfReader(String filename, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(filename);
        this.readPdf();
    }

    public PdfReader(byte[] pdfIn) throws IOException {
        this(pdfIn, null);
    }

    public PdfReader(byte[] pdfIn, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(pdfIn);
        this.readPdf();
    }

    public PdfReader(URL url) throws IOException {
        this(url, null);
    }

    public PdfReader(URL url, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(url));
        this.readPdf();
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter writer) {
        return new PdfReaderInstance(this, writer, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        return this.acroForm;
    }

    public int getPageRotation(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfNumber rotate = (PdfNumber)PdfReader.getPdfObject(page.get(PdfName.ROTATE));
        if (rotate == null) {
            return 0;
        }
        int n = rotate.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public Rectangle getPageSizeWithRotation(int index) {
        Rectangle rect = this.getPageSize(index);
        for (int rotation = this.getPageRotation(index); rotation > 0; rotation -= 90) {
            rect = rect.rotate();
        }
        return rect;
    }

    public Rectangle getPageSize(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfArray mediaBox = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(mediaBox);
    }

    public Rectangle getCropBox(int index) {
        PdfDictionary page = this.pages[index - 1];
        PdfArray cropBox = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.CROPBOX));
        if (cropBox == null) {
            return this.getPageSize(index);
        }
        return PdfReader.getNormalizedRectangle(cropBox);
    }

    public HashMap getInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        PdfDictionary info = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (info == null) {
            return map;
        }
        for (PdfName key : info.getKeys()) {
            PdfObject obj = PdfReader.getPdfObject(info.get(key));
            if (obj == null) continue;
            String value = obj.toString();
            switch (obj.type()) {
                case 3: {
                    value = ((PdfString)obj).toUnicodeString();
                    break;
                }
                case 4: {
                    value = PdfName.decodeName(value);
                }
            }
            map.put(PdfName.decodeName(key.toString()), value);
        }
        return map;
    }

    public static Rectangle getNormalizedRectangle(PdfArray box) {
        ArrayList rect = box.getArrayList();
        float llx = ((PdfNumber)rect.get(0)).floatValue();
        float lly = ((PdfNumber)rect.get(1)).floatValue();
        float urx = ((PdfNumber)rect.get(2)).floatValue();
        float ury = ((PdfNumber)rect.get(3)).floatValue();
        return new Rectangle(Math.min(llx, urx), Math.min(lly, ury), Math.max(llx, urx), Math.max(lly, ury));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPdf() throws IOException {
        try {
            PdfObject form;
            String value;
            PdfObject obj;
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception e) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception ne) {
                    throw new IOException("Rebuild failed: " + ne.getMessage() + "; Original message: " + e.getMessage());
                }
            }
            this.readDocObj();
            this.readDecryptedDocObj();
            this.strings.clear();
            this.readPages();
            PdfDictionary info = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
            if (info != null && (obj = PdfReader.getPdfObject(info.get(PdfName.PRODUCER))) != null && obj.type() == 3 && (value = ((PdfString)obj).toUnicodeString()).indexOf("3.01") >= 0) {
                this.eliminateSharedStreams();
            }
            if ((form = this.catalog.get(PdfName.ACROFORM)) != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(form));
                }
                catch (Exception e) {
                    this.acroForm = null;
                }
            }
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
    }

    private void readDecryptedDocObj() throws IOException {
        String s;
        PdfObject o;
        PdfObject encDic = this.trailer.get(PdfName.ENCRYPT);
        if (encDic == null || encDic.toString().equals("null")) {
            return;
        }
        this.encrypted = true;
        PdfDictionary enc = (PdfDictionary)PdfReader.getPdfObject(encDic);
        PdfArray documentIDs = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] documentID = null;
        if (documentIDs != null) {
            o = (PdfObject)documentIDs.getArrayList().get(0);
            s = o.toString();
            documentID = DocWriter.getISOBytes(s);
        }
        s = enc.get(PdfName.U).toString();
        byte[] uValue = DocWriter.getISOBytes(s);
        s = enc.get(PdfName.O).toString();
        byte[] oValue = DocWriter.getISOBytes(s);
        o = enc.get(PdfName.R);
        if (o.type() != 2) {
            throw new IOException("Illegal R value.");
        }
        int rValue = ((PdfNumber)o).intValue();
        if (rValue != 2 && rValue != 3) {
            throw new IOException("Unknown encryption type (" + rValue + ")");
        }
        o = enc.get(PdfName.P);
        if (o.type() != 2) {
            throw new IOException("Illegal P value.");
        }
        int pValue = ((PdfNumber)o).intValue();
        this.decrypt = new PdfEncryption();
        this.decrypt.setupByUserPassword(documentID, this.password, oValue, pValue, rValue == 3);
        if (!Arrays.equals(uValue, this.decrypt.userKey)) {
            this.decrypt.setupByOwnerPassword(documentID, this.password, uValue, oValue, pValue, rValue == 3);
            if (!Arrays.equals(uValue, this.decrypt.userKey)) {
                throw new IOException("Bad user password");
            }
        }
        for (int k = 0; k < this.strings.size(); ++k) {
            PdfString str = (PdfString)this.strings.get(k);
            str.decrypt(this);
        }
    }

    public static PdfObject getPdfObject(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.type() != 10) {
            return obj;
        }
        PRIndirectReference ref = (PRIndirectReference)obj;
        int idx = ref.getNumber();
        if ((obj = ref.getReader().xrefObj[idx]) == null) {
            return PdfNull.PDFNULL;
        }
        return obj;
    }

    protected void pushPageAttributes(PdfDictionary nodePages) {
        PdfDictionary dic = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            dic.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        for (int k = 0; k < pageInhCandidates.length; ++k) {
            PdfObject obj = nodePages.get(pageInhCandidates[k]);
            if (obj == null) continue;
            dic.put(pageInhCandidates[k], obj);
        }
        this.pageInh.add(dic);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PdfDictionary page) throws IOException {
        PdfName type = (PdfName)PdfReader.getPdfObject(page.get(PdfName.TYPE));
        if (type.equals(PdfName.PAGE)) {
            PdfDictionary dic = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            for (PdfName key : dic.getKeys()) {
                if (page.get(key) != null) continue;
                page.put(key, dic.get(key));
            }
            this.pages[this.pagesCount++] = page;
        } else {
            this.pushPageAttributes(page);
            PdfArray kidsPR = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.KIDS));
            ArrayList kids = kidsPR.getArrayList();
            for (int k = 0; k < kids.size(); ++k) {
                this.pageRefs[this.pagesCount] = (PRIndirectReference)kids.get(k);
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObject(this.pageRefs[this.pagesCount]);
                this.iteratePages(kid);
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        PdfNumber count = (PdfNumber)PdfReader.getPdfObject(rootPages.get(PdfName.COUNT));
        this.pages = new PdfDictionary[count.intValue()];
        this.pageRefs = new PRIndirectReference[this.pages.length];
        this.pagesCount = 0;
        this.iteratePages(rootPages);
        this.pageInh = null;
    }

    protected void readDocObj() throws IOException {
        int k;
        ArrayList<PdfObject> streams = new ArrayList<PdfObject>();
        this.xrefObj = new PdfObject[this.xref.length];
        for (k = 1; k < this.xrefObj.length; ++k) {
            PdfObject obj;
            int pos = this.xref[k];
            if (pos <= 0) continue;
            this.tokens.seek(pos);
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid object number.");
            }
            this.objNum = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Invalid generation number.");
            }
            this.objGen = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (!this.tokens.getStringValue().equals("obj")) {
                this.tokens.throwError("Token 'obj' expected.");
            }
            this.xrefObj[k] = obj = this.readPRObject();
            if (obj.type() != 7) continue;
            streams.add(obj);
        }
        for (k = 0; k < streams.size(); ++k) {
            PRStream stream = (PRStream)streams.get(k);
            PdfNumber length = (PdfNumber)PdfReader.killIndirect(stream.get(PdfName.LENGTH));
            stream.setLength(length.intValue());
        }
        this.xref = null;
    }

    static PdfObject killIndirect(PdfObject obj) {
        if (obj == null || obj.type() == 8) {
            return null;
        }
        PdfObject ret = PdfReader.getPdfObject(obj);
        if (obj.type() == 10) {
            PRIndirectReference ref = (PRIndirectReference)obj;
            ref.getReader().xrefObj[ref.getNumber()] = null;
        }
        return ret;
    }

    protected void readXref() throws IOException {
        PdfNumber prev;
        int ch;
        int startxref;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = startxref = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        this.tokens.seek(startxref);
        while ((ch = this.tokens.read()) != -1 && ch != 116) {
        }
        if (ch == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition(ch);
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PdfDictionary)this.readPRObject();
        PdfNumber xrefSize = (PdfNumber)this.trailer.get(PdfName.SIZE);
        this.xref = new int[xrefSize.intValue()];
        this.tokens.seek(startxref);
        this.readXrefSection();
        PdfDictionary trailer2 = this.trailer;
        while ((prev = (PdfNumber)trailer2.get(PdfName.PREV)) != null) {
            this.tokens.seek(prev.intValue());
            this.readXrefSection();
            trailer2 = (PdfDictionary)this.readPRObject();
        }
    }

    protected void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int start = 0;
        int end = 0;
        int pos = 0;
        int gen = 0;
        block0: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            start = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            end = this.tokens.intValue() + start;
            if (start == 1) {
                int back = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                if (pos == 0 && gen == 65535) {
                    --start;
                    --end;
                }
                this.tokens.seek(back);
            }
            if (this.xref.length < end) {
                int[] xref2 = new int[end];
                System.arraycopy(this.xref, 0, xref2, 0, this.xref.length);
                this.xref = xref2;
            }
            int k = start;
            while (true) {
                if (k >= end) continue block0;
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[k] == 0) {
                        if (pos == 0) {
                            this.tokens.throwError("File position 0 cross-reference entry in this xref subsection");
                        }
                        this.xref[k] = pos;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[k] == 0) {
                        this.xref[k] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++k;
            }
            break;
        }
    }

    protected void rebuildXref() throws IOException {
        int[] obj;
        this.tokens.seek(0);
        int[][] xr = new int[1024][];
        int top = 0;
        this.trailer = null;
        byte[] line = new byte[64];
        while (true) {
            int pos = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(line)) break;
            if (line[0] == 116) {
                if (!PdfEncodings.convertToString(line, null).startsWith("trailer")) continue;
                pos = this.tokens.getFilePointer();
                try {
                    PdfDictionary dic = (PdfDictionary)this.readPRObject();
                    if (dic.get(PdfName.ROOT) != null) {
                        this.trailer = dic;
                        continue;
                    }
                    this.tokens.seek(pos);
                }
                catch (Exception e) {
                    this.tokens.seek(pos);
                }
                continue;
            }
            if (line[0] < 48 || line[0] > 57 || (obj = PRTokeniser.checkObjectStart(line)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            if (num >= xr.length) {
                int newLength = num * 2;
                int[][] xr2 = new int[newLength][];
                System.arraycopy(xr, 0, xr2, 0, top);
                xr = xr2;
            }
            if (num >= top) {
                top = num + 1;
            }
            if (xr[num] != null && gen < xr[num][1]) continue;
            obj[0] = pos;
            xr[num] = obj;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[top];
        for (int k = 0; k < top; ++k) {
            obj = xr[k];
            if (obj == null) continue;
            this.xref[k] = obj[0];
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName name = new PdfName(this.tokens.getStringValue());
            PdfObject obj = this.readPRObject();
            int type = obj.type();
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-type == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject obj;
        int type;
        PdfArray array = new PdfArray();
        while (-(type = (obj = this.readPRObject()).type()) != 6) {
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            array.add(obj);
        }
        return array;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int type = this.tokens.getTokenType();
        switch (type) {
            case 7: {
                PdfDictionary dic = this.readDictionary();
                int pos = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int ch = this.tokens.read();
                    if (ch == 13) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    PRStream stream = new PRStream(this, this.tokens.getFilePointer());
                    stream.putAll(dic);
                    stream.setObjNum(this.objNum, this.objGen);
                    return stream;
                }
                this.tokens.seek(pos);
                return dic;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString str = new PdfString(this.tokens.getStringValue(), null);
                str.setObjNum(this.objNum, this.objGen);
                this.strings.add(str);
                return str;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                return new PRIndirectReference(this, this.tokens.getReference(), this.tokens.getGeneration());
            }
        }
        return new PdfLiteral(-type, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] in) {
        byte[] b = PdfReader.FlateDecode(in, true);
        if (b == null) {
            return PdfReader.FlateDecode(in, false);
        }
        return b;
    }

    public static byte[] FlateDecode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] in) {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        int n1 = 0;
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 62; ++k) {
            if (PRTokeniser.isWhitespace(ch)) continue;
            int n = PRTokeniser.getHex(ch);
            if (n == -1) {
                throw new RuntimeException("Illegal character in ASCIIHexDecode.");
            }
            if (first) {
                n1 = n;
            } else {
                out.write((byte)((n1 << 4) + n));
            }
            first = !first;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] in) {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int state = 0;
        int[] chn = new int[5];
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 126; ++k) {
            if (PRTokeniser.isWhitespace(ch)) continue;
            if (ch == 122 && state == 0) {
                out.write(0);
                out.write(0);
                out.write(0);
                out.write(0);
                continue;
            }
            if (ch < 33 || ch > 117) {
                throw new RuntimeException("Illegal character in ASCII85Decode.");
            }
            chn[state] = ch - 33;
            if (++state != 5) continue;
            state = 0;
            int r = 0;
            for (int j = 0; j < 5; ++j) {
                r = r * 85 + chn[j];
            }
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
            out.write((byte)r);
        }
        int r = 0;
        if (state == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (state == 2) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85;
            out.write((byte)(r >> 24));
        } else if (state == 3) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
        } else if (state == 4) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + chn[3] * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
        }
        return out.toByteArray();
    }

    public static byte[] LZWDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LZWDecoder lzw = new LZWDecoder();
        lzw.decode(in, out);
        return out.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int pageNum) {
        if (pageNum > this.pages.length) {
            return null;
        }
        return this.pages[pageNum - 1];
    }

    public PRIndirectReference getPageOrigRef(int pageNum) {
        if (pageNum > this.pageRefs.length) {
            return null;
        }
        return this.pageRefs[pageNum - 1];
    }

    public byte[] getPageContent(int pageNum, RandomAccessFileOrArray file) throws IOException {
        PdfDictionary page = this.getPageN(pageNum);
        if (page == null) {
            return null;
        }
        PdfObject contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS));
        if (contents == null) {
            return null;
        }
        ByteArrayOutputStream bout = null;
        if (contents.type() == 7) {
            return PdfReader.getStreamBytes((PRStream)contents, file);
        }
        PdfArray array = (PdfArray)contents;
        ArrayList list = array.getArrayList();
        bout = new ByteArrayOutputStream();
        for (int k = 0; k < list.size(); ++k) {
            PRStream stream = (PRStream)PdfReader.getPdfObject((PdfObject)list.get(k));
            byte[] b = PdfReader.getStreamBytes(stream, file);
            bout.write(b);
            if (k == list.size() - 1) continue;
            bout.write(10);
        }
        return bout.toByteArray();
    }

    protected void killXref(PdfObject obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference && obj.type() != 10) {
            return;
        }
        switch (obj.type()) {
            case 10: {
                int xr = ((PRIndirectReference)obj).getNumber();
                obj = this.xrefObj[xr];
                this.xrefObj[xr] = null;
                this.freeXref = xr;
                this.killXref(obj);
                break;
            }
            case 5: {
                ArrayList t = ((PdfArray)obj).getArrayList();
                for (int i = 0; i < t.size(); ++i) {
                    this.killXref((PdfObject)t.get(i));
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator i = dic.getKeys().iterator();
                while (i.hasNext()) {
                    this.killXref(dic.get((PdfName)i.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int pageNum, byte[] content) throws IOException {
        PdfDictionary page = this.getPageN(pageNum);
        if (page == null) {
            return;
        }
        PdfObject contents = page.get(PdfName.CONTENTS);
        this.killXref(contents);
        page.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj[this.freeXref] = new PRStream(this, content);
    }

    public static byte[] getStreamBytes(PRStream stream, RandomAccessFileOrArray file) throws IOException {
        byte[] b;
        PdfReader reader = stream.getReader();
        PdfObject filter = PdfReader.getPdfObject(stream.get(PdfName.FILTER));
        if (stream.getOffset() < 0) {
            b = stream.getBytes();
        } else {
            b = new byte[stream.getLength()];
            file.seek(stream.getOffset());
            file.readFully(b);
            PdfEncryption decrypt = reader.getDecrypt();
            if (decrypt != null) {
                decrypt.setHashKey(stream.getObjNum(), stream.getObjGen());
                decrypt.prepareKey();
                decrypt.encryptRC4(b);
            }
        }
        ArrayList filters = new ArrayList();
        if (filter != null) {
            if (filter.type() == 4) {
                filters.add(filter);
            } else if (filter.type() == 5) {
                filters = ((PdfArray)filter).getArrayList();
            }
        }
        for (int j = 0; j < filters.size(); ++j) {
            String name = ((PdfName)PdfReader.getPdfObject((PdfObject)filters.get(j))).toString();
            if (name.equals("/FlateDecode") || name.equals("/Fl")) {
                b = PdfReader.FlateDecode(b);
                continue;
            }
            if (name.equals("/ASCIIHexDecode") || name.equals("/AHx")) {
                b = PdfReader.ASCIIHexDecode(b);
                continue;
            }
            if (name.equals("/ASCII85Decode") || name.equals("/A85")) {
                b = PdfReader.ASCII85Decode(b);
                continue;
            }
            if (name.equals("/LZWDecode")) {
                b = PdfReader.LZWDecode(b);
                continue;
            }
            throw new IOException("The filter " + name + " is not supported.");
        }
        return b;
    }

    public void eliminateSharedStreams() {
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pages.length == 1) {
            return;
        }
        ArrayList<PRIndirectReference> newRefs = new ArrayList<PRIndirectReference>();
        ArrayList<PRStream> newStreams = new ArrayList<PRStream>();
        IntHashtable visited = new IntHashtable();
        for (int k = 0; k < this.pages.length; ++k) {
            PdfObject contents;
            PdfDictionary page = this.pages[k];
            if (page == null || (contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS))) == null) continue;
            if (contents.type() == 7) {
                PRIndirectReference ref = (PRIndirectReference)page.get(PdfName.CONTENTS);
                if (visited.containsKey(ref.getNumber())) {
                    newRefs.add(ref);
                    newStreams.add(new PRStream((PRStream)contents, null));
                    continue;
                }
                visited.put(ref.getNumber(), 1);
                continue;
            }
            PdfArray array = (PdfArray)contents;
            ArrayList list = array.getArrayList();
            for (int j = 0; j < list.size(); ++j) {
                PRIndirectReference ref = (PRIndirectReference)list.get(j);
                if (visited.containsKey(ref.getNumber())) {
                    newRefs.add(ref);
                    newStreams.add(new PRStream((PRStream)PdfReader.getPdfObject(ref), null));
                    continue;
                }
                visited.put(ref.getNumber(), 1);
            }
        }
        if (newStreams.size() == 0) {
            return;
        }
        int start = 1;
        for (int pass = 0; pass < 2; ++pass) {
            for (int k = start; k < this.xrefObj.length; ++k) {
                if (this.xrefObj[k] != null) continue;
                int p = newStreams.size() - 1;
                this.xrefObj[k] = (PRStream)newStreams.get(p);
                PRIndirectReference ref = (PRIndirectReference)newRefs.get(p);
                ref.setNumber(k, 0);
                if (p == 0) {
                    return;
                }
                newStreams.remove(p);
            }
            start = this.xrefObj.length;
            PdfObject[] nxo = new PdfObject[this.xrefObj.length + newStreams.size()];
            System.arraycopy(this.xrefObj, 0, nxo, 0, this.xrefObj.length);
            this.xrefObj = nxo;
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean tampered) {
        this.tampered = tampered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMetadata() throws IOException {
        PdfObject obj = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(obj instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray rf = this.getSafeFile();
        byte[] b = null;
        try {
            rf.reOpen();
            b = PdfReader.getStreamBytes((PRStream)obj, rf);
        }
        finally {
            try {
                rf.close();
            }
            catch (Exception exception) {}
        }
        return b;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }
}

