/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import quadbase.common.util.output.DocWriter;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.pdf.AcroFields;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfImportedPage;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfStamperImp;
import quadbase.common.util.output.pdf.PdfWriter;

public class PdfStamper {
    protected PdfStamperImp stamper;
    private HashMap moreInfo;

    public PdfStamper(PdfReader reader, OutputStream os) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, '\u0000');
    }

    public PdfStamper(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, pdfVersion);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap moreInfo) {
        this.moreInfo = moreInfo;
    }

    public void close() throws DocumentException, IOException {
        this.stamper.close(this.moreInfo);
    }

    public PdfContentByte getUnderContent(int pageNum) {
        return this.stamper.getUnderContent(pageNum);
    }

    public PdfContentByte getOverContent(int pageNum) {
        return this.stamper.getOverContent(pageNum);
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean rotateContents) {
        this.stamper.setRotateContents(rotateContents);
    }

    public void setEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) throws DocumentException {
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(userPassword, ownerPassword, permissions, strength128Bits);
    }

    public void setEncryption(boolean strength, String userPassword, String ownerPassword, int permissions) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(userPassword), DocWriter.getISOBytes(ownerPassword), permissions, strength);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        return this.stamper.getImportedPage(reader, pageNumber);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean flat) {
        this.stamper.setFormFlattening(flat);
    }
}

