/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import quadbase.common.util.output.DocumentException;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.AcroFields;
import quadbase.common.util.output.pdf.ByteBuffer;
import quadbase.common.util.output.pdf.PRIndirectReference;
import quadbase.common.util.output.pdf.PageResources;
import quadbase.common.util.output.pdf.PdfAppearance;
import quadbase.common.util.output.pdf.PdfArray;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfContents;
import quadbase.common.util.output.pdf.PdfDictionary;
import quadbase.common.util.output.pdf.PdfDocument;
import quadbase.common.util.output.pdf.PdfIndirectObject;
import quadbase.common.util.output.pdf.PdfIndirectReference;
import quadbase.common.util.output.pdf.PdfName;
import quadbase.common.util.output.pdf.PdfNumber;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfStream;
import quadbase.common.util.output.pdf.PdfString;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.RandomAccessFileOrArray;
import quadbase.common.util.output.pdf.StampContent;

class PdfStamperImp
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    int[] myXref;
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;

    PdfStamperImp(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        super(new PdfDocument(), os);
        if (reader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        reader.setTampered(true);
        this.reader = reader;
        this.file = reader.getSafeFile();
        if (pdfVersion == '\u0000') {
            super.setPdfVersion(reader.getPdfVersion());
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap moreInfo) throws DocumentException, IOException {
        if (this.closed) {
            return;
        }
        if (this.flat) {
            this.flatFields();
        }
        this.closed = true;
        this.myXref = new int[this.reader.xrefObj.length];
        this.addSharedObjectsToBody();
        PRIndirectReference iInfo = null;
        try {
            this.file.reOpen();
            this.alterContents();
            PdfObject[] xb = this.reader.xrefObj;
            boolean idx = true;
            iInfo = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int skip = -1;
            if (iInfo != null) {
                skip = iInfo.getNumber();
            }
            for (int k = 1; k < xb.length; ++k) {
                if (xb[k] == null || skip == k) continue;
                this.addToBody(xb[k], this.getNewObjectNumber(this.reader, k, 0));
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception xb) {}
        }
        PdfIndirectReference encryption = null;
        PdfObject fileID = null;
        if (this.crypto != null) {
            PdfIndirectObject encryptionObject = this.body.add(this.crypto.getEncryptionDictionary());
            encryption = encryptionObject.getIndirectReference();
            fileID = this.crypto.getFileID();
        }
        PRIndirectReference iRoot = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference root = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, iRoot.getNumber(), 0));
        PdfIndirectReference info = null;
        PdfDictionary oldInfo = (PdfDictionary)PdfReader.getPdfObject(iInfo);
        PdfDictionary newInfo = new PdfDictionary();
        if (oldInfo != null) {
            for (Object key : oldInfo.getKeys()) {
                PdfObject value = PdfReader.getPdfObject(oldInfo.get((PdfName)key));
                newInfo.put((PdfName)key, value);
            }
        }
        if (moreInfo != null) {
            for (Object key : moreInfo.keySet()) {
                PdfName keyName = new PdfName((String)key);
                String value = (String)moreInfo.get(key);
                if (value == null) {
                    newInfo.remove(keyName);
                    continue;
                }
                newInfo.put(keyName, new PdfString(value, "UnicodeBig"));
            }
        }
        if (!newInfo.getKeys().isEmpty()) {
            info = this.addToBody(newInfo).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os);
        PdfWriter.PdfTrailer trailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), root, info, encryption, fileID);
        trailer.toPdf(this, this.os);
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
    }

    void applyRotation(int pageNumber, ByteBuffer out) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle page = this.reader.getPageSizeWithRotation(pageNumber);
        int rotation = page.getRotation();
        switch (rotation) {
            case 90: {
                out.append(PdfContents.ROTATE90);
                out.append(page.top());
                out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                out.append(PdfContents.ROTATE180);
                out.append(page.right());
                out.append(' ');
                out.append(page.top());
                out.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                out.append(PdfContents.ROTATE270);
                out.append('0').append(' ');
                out.append(page.right());
                out.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        for (Integer pageNumber : this.pagesToContent.keySet()) {
            PageStamp ps = (PageStamp)this.pagesToContent.get(pageNumber);
            ByteBuffer out = new ByteBuffer();
            if (ps.under != null) {
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageNumber, out);
                out.append(ps.under.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            if (ps.over != null) {
                out.append(PdfContents.SAVESTATE);
            }
            out.append(this.reader.getPageContent(pageNumber, this.file));
            if (ps.over != null) {
                out.append(' ');
                out.append(PdfContents.RESTORESTATE);
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageNumber, out);
                out.append(ps.over.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            this.reader.setPageContent(pageNumber, out.toByteArray());
            this.alterResources(ps);
        }
    }

    void alterResources(PageStamp ps) {
        PdfDictionary dic = this.reader.getPageN(ps.pageNumber);
        dic.put(PdfName.RESOURCES, ps.pageResources.getResources());
    }

    @Override
    int getNewObjectNumber(PdfReader reader, int number, int generation) {
        if (this.currentPdfReaderInstance == null) {
            if (this.myXref[number] == 0) {
                this.myXref[number] = this.getIndirectReferenceNumber();
            }
            return this.myXref[number];
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(number, generation);
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PageStamp getPageStamp(int pageNum) {
        Integer page = pageNum;
        PageStamp ps = (PageStamp)this.pagesToContent.get(page);
        if (ps == null) {
            ps = new PageStamp(this, this.reader, pageNum);
            this.pagesToContent.put(page, ps);
        }
        return ps;
    }

    PdfContentByte getUnderContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.under == null) {
            ps.under = new StampContent(this, pageNum);
        }
        return ps.under;
    }

    PdfContentByte getOverContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.over == null) {
            ps.over = new StampContent(this, pageNum);
        }
        return ps.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean flat) {
        this.flat = flat;
    }

    void flatFields() {
        this.getAcroFields();
        HashMap fields = this.acroFields.getFields();
        for (AcroFields.Item item : fields.values()) {
            for (int k = 0; k < item.merged.size(); ++k) {
                PdfIndirectReference iref;
                PdfName as;
                PdfDictionary appDic;
                PdfDictionary merged = (PdfDictionary)item.merged.get(k);
                PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.F));
                int flags = 0;
                if (ff != null) {
                    flags = ff.intValue();
                }
                if ((flags & 4) == 0 || (appDic = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.AP))) == null) continue;
                PdfObject obj = appDic.get(PdfName.N);
                PdfAppearance app = null;
                PdfObject objReal = PdfReader.getPdfObject(obj);
                if (obj instanceof PdfIndirectReference && obj.type() != 10) {
                    app = new PdfAppearance((PdfIndirectReference)obj);
                } else if (objReal instanceof PdfStream) {
                    ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                    app = new PdfAppearance((PdfIndirectReference)obj);
                } else if (objReal.type() == 6 && (as = (PdfName)PdfReader.getPdfObject(merged.get(PdfName.AS))) != null && (iref = (PdfIndirectReference)((PdfDictionary)objReal).get(as)) != null) {
                    app = new PdfAppearance(iref);
                    if (iref.type() == 10) {
                        objReal = PdfReader.getPdfObject(iref);
                        ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (app == null) continue;
                Rectangle box = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT)));
                int page = (Integer)item.page.get(k);
                PdfContentByte cb = this.getOverContent(page);
                cb.setLiteral("Q ");
                cb.addTemplate(app, box.left(), box.bottom());
                cb.setLiteral("q ");
            }
        }
        for (int page = 1; page <= this.reader.getNumberOfPages(); ++page) {
            PdfDictionary pageDic = this.reader.getPageN(page);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
            if (annots == null) continue;
            ArrayList ar = annots.getArrayList();
            for (int idx = 0; idx < ar.size(); ++idx) {
                PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)ar.get(idx));
                if (!PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) continue;
                ar.remove(idx);
                --idx;
            }
            if (ar.size() != 0) continue;
            PdfObject obj = pageDic.get(PdfName.ANNOTS);
            if (obj.type() == 10) {
                this.reader.xrefObj[((PRIndirectReference)obj).getNumber()] = null;
            }
            pageDic.remove(PdfName.ANNOTS);
        }
        this.eliminateAcroformObjects();
    }

    void eliminateAcroformObjects() {
        PdfObject acro = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (acro == null) {
            return;
        }
        PdfDictionary acrodic = (PdfDictionary)PdfReader.getPdfObject(acro);
        PdfObject iFields = acrodic.get(PdfName.FIELDS);
        if (iFields != null) {
            PdfDictionary kids = new PdfDictionary();
            kids.put(PdfName.KIDS, iFields);
            this.sweepKids(kids);
        }
        PdfReader.killIndirect(acro);
        this.reader.getCatalog().remove(PdfName.ACROFORM);
    }

    void sweepKids(PdfObject obj) {
        PdfDictionary dic = (PdfDictionary)PdfReader.killIndirect(obj);
        PdfArray kids = (PdfArray)PdfReader.killIndirect(dic.get(PdfName.KIDS));
        if (kids == null) {
            return;
        }
        ArrayList ar = kids.getArrayList();
        for (int k = 0; k < ar.size(); ++k) {
            this.sweepKids((PdfObject)ar.get(k));
        }
    }

    class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp stamper, PdfReader reader, int pageNumber) {
            this.pageNumber = pageNumber;
            this.pageResources = new PageResources();
            PdfDictionary dic = reader.getPageN(pageNumber);
            PdfDictionary resources = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(resources, reader);
        }
    }
}

