/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.io.IOException;
import java.io.OutputStream;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfEncodings;
import quadbase.common.util.output.pdf.PdfEncryption;
import quadbase.common.util.output.pdf.PdfObject;
import quadbase.common.util.output.pdf.PdfReader;
import quadbase.common.util.output.pdf.PdfWriter;

public class PdfString
extends PdfObject {
    protected String value = "";
    protected String encoding = "PDF";
    protected int objNum = 0;
    protected int objGen = 0;

    public PdfString() {
        super(3);
    }

    public PdfString(String value) {
        super(3);
        this.value = value;
    }

    public PdfString(String value, String encoding) {
        super(3);
        this.value = value;
        this.encoding = encoding;
    }

    public PdfString(byte[] bytes) {
        super(3);
        this.value = PdfEncodings.convertToString(bytes, null);
        this.encoding = "";
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        byte[] b = this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value) ? PdfEncodings.convertToBytes(this.value, "PDF") : PdfEncodings.convertToBytes(this.value, this.encoding);
        PdfEncryption crypto = null;
        if (writer != null) {
            crypto = writer.getEncryption();
        }
        if (crypto != null) {
            crypto.prepareKey();
            crypto.encryptRC4(b);
        }
        os.write(PdfContentByte.escapeString(b));
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toUnicodeString() {
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.value;
        }
        byte[] b = PdfEncodings.convertToBytes(this.value, null);
        if (b.length >= 2 && b[0] == -2 && b[1] == -1) {
            return PdfEncodings.convertToString(b, "UnicodeBig");
        }
        return PdfEncodings.convertToString(b, "PDF");
    }

    void setObjNum(int objNum, int objGen) {
        this.objNum = objNum;
        this.objGen = objGen;
    }

    void decrypt(PdfReader reader) {
        PdfEncryption decrypt = reader.getDecrypt();
        if (decrypt != null) {
            decrypt.setHashKey(this.objNum, this.objGen);
            decrypt.prepareKey();
            byte[] b = PdfEncodings.convertToBytes(this.value, null);
            decrypt.encryptRC4(b);
            this.value = PdfEncodings.convertToString(b, null);
        }
    }
}

