/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import quadbase.common.util.output.Cell;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.Row;
import quadbase.common.util.output.Table;
import quadbase.common.util.output.pdf.PdfCell;

class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    private float cellpadding;
    private float cellspacing;

    PdfTable(Table table, float left, float right, float top) {
        super(left, top, right, top);
        PdfCell currentCell;
        int i;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.columns = table.columns();
        this.cellpadding = table.cellpadding();
        this.cellspacing = table.cellspacing();
        float[] positions = table.getWidths(left, right - left);
        this.setLeft(positions[0]);
        this.setRight(positions[positions.length - 1]);
        int rowNumber = 0;
        int groupNumber = 0;
        int firstDataRow = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int rows = table.size() + 1;
        float[] offsets = new float[rows];
        for (int i2 = 0; i2 < rows; ++i2) {
            offsets[i2] = top;
        }
        Iterator rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            boolean groupChange = false;
            Row row = (Row)rowIterator.next();
            if (row.isEmpty()) {
                if (rowNumber < rows - 1 && offsets[rowNumber + 1] > offsets[rowNumber]) {
                    offsets[rowNumber + 1] = offsets[rowNumber];
                }
            } else {
                for (i = 0; i < row.columns(); ++i) {
                    Cell cell;
                    block13: {
                        cell = (Cell)row.getCell(i);
                        if (cell == null) continue;
                        currentCell = new PdfCell(cell, rowNumber, positions[i], positions[i + cell.colspan()], offsets[rowNumber], this.cellspacing, this.cellpadding);
                        try {
                            if (offsets[rowNumber] - currentCell.height() - this.cellpadding < offsets[rowNumber + currentCell.rowspan()]) {
                                offsets[rowNumber + currentCell.rowspan()] = offsets[rowNumber] - currentCell.height() - this.cellpadding;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            if (!(offsets[rowNumber] - currentCell.height() < offsets[rows - 1])) break block13;
                            offsets[rows - 1] = offsets[rowNumber] - currentCell.height();
                        }
                    }
                    if (rowNumber < firstDataRow) {
                        currentCell.setHeader();
                        this.headercells.add(currentCell);
                    }
                    currentCell.setGroupNumber(groupNumber);
                    groupChange |= cell.getGroupChange();
                    this.cells.add(currentCell);
                }
            }
            ++rowNumber;
            if (!groupChange) continue;
            ++groupNumber;
        }
        int n = this.cells.size();
        for (i = 0; i < n; ++i) {
            currentCell = (PdfCell)this.cells.get(i);
            try {
                currentCell.setBottom(offsets[currentCell.rownumber() + currentCell.rowspan()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                currentCell.setBottom(offsets[rows - 1]);
            }
        }
        this.setBottom(offsets[rows - 1]);
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    float cellpadding() {
        return this.cellpadding;
    }

    float cellspacing() {
        return this.cellspacing;
    }
}

