/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.output.pdf;

import java.awt.Font;
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.UserLanguage;
import quadbase.common.util.output.pdf.BaseFont;
import quadbase.common.util.output.pdf.BaseFontHash;
import quadbase.common.util.output.pdf.FontMapper;

public class QbFontMapper
implements FontMapper {
    Hashtable fontMapping;
    BaseFontHash baseFontHash = new BaseFontHash();
    String encoding;
    String fontName;

    public QbFontMapper(Hashtable fontMapping) {
        this.fontMapping = fontMapping;
    }

    @Override
    public BaseFont awtToPdf(Font font) {
        return this.awtToPdf(font, false);
    }

    public BaseFont awtToPdf(Font font, boolean unicode) {
        try {
            String enc;
            BaseFont cache = (BaseFont)this.baseFontHash.get(font, unicode);
            if (cache != null) {
                return cache;
            }
            String key = font.getName();
            key = font.getStyle() == 1 ? key + " BOLD" : (font.getStyle() == 2 ? key + " ITALIC" : (font.getStyle() == 3 ? key + " BOLDITALIC" : key + " PLAIN"));
            String string = enc = unicode ? "Identity-H" : "Cp1252";
            if (this.fontMapping != null && this.fontMapping.containsKey(key)) {
                String fontValue = (String)this.fontMapping.get(key);
                StringTokenizer tokens = new StringTokenizer(fontValue, "&");
                Vector<String> vec = new Vector<String>();
                while (tokens.hasMoreTokens()) {
                    vec.addElement(tokens.nextToken());
                }
                String ttf = null;
                boolean embed = true;
                if (vec.size() == 1) {
                    ttf = (String)vec.elementAt(0);
                } else if (vec.size() == 3) {
                    ttf = (String)vec.elementAt(0);
                    String encStr = (String)vec.elementAt(1);
                    String embedStr = (String)vec.elementAt(2);
                    if (encStr.startsWith("ENC=") && !(encStr = encStr.substring(4)).equals("")) {
                        enc = encStr;
                    }
                    if (embedStr.startsWith("EMBED=") && (embedStr = embedStr.substring(6)).equalsIgnoreCase("FALSE")) {
                        embed = false;
                    }
                }
                if (ttf != null) {
                    BaseFont bf;
                    if (this.isTrueTypeFontFile(ttf)) {
                        if (!ServerMessage.useServer) {
                            if (new FileInfo(this.getTrueTypeFontName(ttf)).exists()) {
                                bf = BaseFont.createFont(ttf, enc, embed);
                                this.baseFontHash.put(font, bf, unicode);
                                return bf;
                            }
                        } else {
                            String fileName = this.getTrueTypeFontName(ttf);
                            if (new FileInfo(fileName).exists()) {
                                DataInputStream din = new ReadDataFile().getInputStream(fileName);
                                byte[] barray = new byte[din.available()];
                                din.read(barray);
                                din.close();
                                BaseFont bf2 = BaseFont.createFont(ttf, enc, embed, true, barray, null);
                                this.baseFontHash.put(font, bf2, unicode);
                                return bf2;
                            }
                        }
                    } else {
                        if (ttf.toLowerCase().endsWith(".afm")) {
                            DataInputStream din = new ReadDataFile().getInputStream(ttf);
                            byte[] barray = new byte[din.available()];
                            din.read(barray);
                            din.close();
                            byte[] parray = null;
                            if (new FileInfo(this.getAFMBaseName(ttf) + ".pfb").exists()) {
                                String pfbName = this.getAFMBaseName(ttf) + ".pfb";
                                DataInputStream pin = new ReadDataFile().getInputStream(pfbName);
                                parray = new byte[pin.available()];
                                pin.read(parray);
                                pin.close();
                            }
                            BaseFont bf3 = BaseFont.createFont(ttf, enc, embed, true, barray, parray);
                            this.baseFontHash.put(font, bf3, unicode);
                            return bf3;
                        }
                        bf = BaseFont.createFont(ttf, enc, false);
                        this.baseFontHash.put(font, bf, unicode);
                        return bf;
                    }
                }
            }
            BaseFont bfont = this.mapToEnglishFont(font);
            String language = new UserLanguage().getUserLanguage();
            if (language.equalsIgnoreCase("ko")) {
                bfont = this.mapToKoreanFont(font);
            } else if (language.equalsIgnoreCase("ja")) {
                bfont = this.mapToJapaneseFont(font);
            } else if (language.startsWith("zh")) {
                bfont = this.mapToChineseFont(font);
            }
            this.baseFontHash.put(font, bfont, unicode);
            return bfont;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BaseFont mapToEnglishFont(Font font) throws Exception {
        if (font.getName().toLowerCase().startsWith("dialog") || font.getName().toLowerCase().startsWith("sansserif")) {
            if (font.getStyle() == 0) {
                this.fontName = "Helvetica";
            } else if (font.getStyle() == 1) {
                this.fontName = "Helvetica-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Helvetica-Oblique";
            } else if (font.getStyle() == 3) {
                this.fontName = "Helvetica-BoldOblique";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("serif")) {
            if (font.getStyle() == 0) {
                this.fontName = "Times-Roman";
            } else if (font.getStyle() == 1) {
                this.fontName = "Times-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Times-Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "Times-BoldItalic";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("monospaced") || font.getName().toLowerCase().startsWith("dialoginput")) {
            if (font.getStyle() == 0) {
                this.fontName = "Courier";
            } else if (font.getStyle() == 1) {
                this.fontName = "Courier-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Courier-Oblique";
            } else if (font.getStyle() == 3) {
                this.fontName = "Courier-BoldOblique";
            }
            this.encoding = "Cp1252";
        } else if (font.getName().toLowerCase().startsWith("nsimsun")) {
            this.fontName = "STSong-Light";
            this.encoding = "UniGB-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("simsun")) {
            this.fontName = "MSung-Light";
            this.encoding = "UniCNS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("simhei")) {
            this.fontName = "MHei-Medium";
            this.encoding = "UniCNS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms gothic") || font.getName().toLowerCase().startsWith("ms pgothic") || font.getName().toLowerCase().startsWith("ms ui gothic")) {
            this.fontName = "HeiseiKakuGo-W5";
            this.encoding = "UniJIS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms mincho") || font.getName().toLowerCase().startsWith("ms pmincho")) {
            this.fontName = "HeiseiMin-W3";
            this.encoding = "UniJIS-UCS2-HW-H";
        } else if (font.getName().toLowerCase().startsWith("batang") || font.getName().toLowerCase().startsWith("dotum") || font.getName().toLowerCase().startsWith("gulim") || font.getName().toLowerCase().startsWith("gungsuh")) {
            this.fontName = "HYGoThic-Medium";
            this.encoding = "UniKS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("dotumche") || font.getName().toLowerCase().startsWith("batangche") || font.getName().toLowerCase().startsWith("gulimche") || font.getName().toLowerCase().startsWith("gungsuhche")) {
            this.fontName = "HYSMyeongJo-Medium";
            this.encoding = "UniKS-UCS2-H";
        } else {
            this.fontName = "Times-Roman";
            if (font.getStyle() == 1) {
                this.fontName = "Times-Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "Times-Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "Times-BoldItalic";
            }
            this.encoding = "Cp1252";
        }
        return BaseFont.createFont(this.fontName, this.encoding, false);
    }

    private BaseFont mapToKoreanFont(Font font) throws Exception {
        if (font.getStyle() == 0) {
            this.fontName = "HYGoThic-Medium";
        } else if (font.getStyle() == 1) {
            this.fontName = "HYGoThic-Medium,Bold";
        } else if (font.getStyle() == 2) {
            this.fontName = "HYGoThic-Medium,Italic";
        } else if (font.getStyle() == 3) {
            this.fontName = "HYGoThic-Medium,BoldItalic";
        }
        this.encoding = "UniKS-UCS2-H";
        return BaseFont.createFont(this.fontName, this.encoding, false);
    }

    private BaseFont mapToJapaneseFont(Font font) throws Exception {
        if (font.getName().toLowerCase().startsWith("ms gothic") || font.getName().toLowerCase().startsWith("ms pgothic") || font.getName().toLowerCase().startsWith("ms ui gothic")) {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiKakuGo-W5";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiKakuGo-W5,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiKakuGo-W5,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiKakuGo-W5,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-H";
        } else if (font.getName().toLowerCase().startsWith("ms mincho") || font.getName().toLowerCase().startsWith("ms pmincho")) {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiMin-W3";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiMin-W3,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiMin-W3,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiMin-W3,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-HW-H";
        } else {
            if (font.getStyle() == 0) {
                this.fontName = "HeiseiKakuGo-W5";
            } else if (font.getStyle() == 1) {
                this.fontName = "HeiseiKakuGo-W5,Bold";
            } else if (font.getStyle() == 2) {
                this.fontName = "HeiseiKakuGo-W5,Italic";
            } else if (font.getStyle() == 3) {
                this.fontName = "HeiseiKakuGo-W5,BoldItalic";
            }
            this.encoding = "UniJIS-UCS2-H";
        }
        return BaseFont.createFont(this.fontName, this.encoding, false);
    }

    private BaseFont mapToChineseFont(Font font) throws Exception {
        if (font.getStyle() == 0) {
            this.fontName = "MHei-Medium";
        } else if (font.getStyle() == 1) {
            this.fontName = "MHei-Medium,Bold";
        } else if (font.getStyle() == 2) {
            this.fontName = "MHei-Medium,Italic";
        } else if (font.getStyle() == 3) {
            this.fontName = "MHei-Medium,BoldItalic";
        }
        this.encoding = "UniCNS-UCS2-H";
        return BaseFont.createFont(this.fontName, this.encoding, false);
    }

    private boolean isTrueTypeFontFile(String name) {
        return name.toLowerCase().endsWith(".ttf") || name.toLowerCase().indexOf(".ttc,") > 0;
    }

    private String getTrueTypeFontName(String name) {
        if (name.toLowerCase().endsWith(".ttc")) {
            return name;
        }
        int index = name.toLowerCase().indexOf(".ttc,");
        if (index > 0) {
            System.out.println(name.substring(0, index + 4));
            return name.substring(0, index + 4);
        }
        return name;
    }

    private String getAFMBaseName(String afm) {
        if (afm == null) {
            return null;
        }
        int index = afm.lastIndexOf(46);
        if (index > -1) {
            return afm.substring(0, index);
        }
        return afm;
    }

    @Override
    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }
}

