/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import quadbase.ChartAPI.QbChart;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard.api.SharedParam;
import quadbase.maps.QbMap;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class ChartInfo {
    public String name = null;
    public int nodeID = -1;
    public int itemID = -1;
    public QbChart chart = null;
    public QbReport report = null;
    public QbMap qbMap = null;
    public String path = null;
    public String chartID = null;
    public Map filterParamList = null;
    public boolean containNonSharedParam = false;

    public ChartInfo(String tmp) {
        this.chartID = tmp;
        int idx = tmp.indexOf("-K-");
        this.filterParamList = new LinkedHashMap();
        if (idx >= 0) {
            String pList = tmp.substring(idx);
            tmp = tmp.substring(0, idx);
            while (pList.startsWith("-K-")) {
                idx = pList.indexOf("-V-");
                String key = pList.substring(3, idx);
                pList = pList.substring(idx + 3);
                idx = pList.indexOf("-K-");
                String value = null;
                if (idx > 0) {
                    value = pList.substring(0, idx);
                    pList = pList.substring(idx);
                } else {
                    value = pList;
                    pList = "";
                }
                this.filterParamList.put(key, value);
            }
        }
        this.chartID = tmp;
        int lastIdx = tmp.lastIndexOf(44);
        this.itemID = Integer.valueOf(tmp.substring(lastIdx + 1));
        this.name = tmp.substring(0, lastIdx);
        lastIdx = this.name.lastIndexOf(44);
        this.nodeID = Integer.valueOf(this.name.substring(lastIdx + 1));
        this.name = this.name.substring(0, lastIdx);
    }

    public String getChartStr() {
        String ret = this.chartID;
        Iterator iterator = this.filterParamList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element;
            Map.Entry entry = element = iterator.next();
            String tmp = (String)entry.getKey();
            Object obj = entry.getValue();
            String val = null;
            if (obj != null && obj instanceof Vector) {
                Vector vec = (Vector)obj;
                for (int i = 0; i < vec.size(); ++i) {
                    val = i == 0 ? (String)vec.elementAt(i) : val + "," + vec.elementAt(i);
                }
                val = val + "-MV";
            } else {
                val = (String)obj;
            }
            ret = ret + "-K-" + tmp + "-V-" + val;
        }
        return ret;
    }

    public void updateSharedParameters(String[] sharedParamsStr, String[] paramName) {
        String chartName = this.name + "," + this.nodeID + "," + this.itemID;
        chartName = QbUtil.urlDecode(chartName);
        if (sharedParamsStr == null || sharedParamsStr[0].equals("")) {
            this.containNonSharedParam = paramName.length != 0;
            return;
        }
        SharedParam[] sharedParams = new SharedParam[sharedParamsStr.length];
        for (int i = 0; i < sharedParamsStr.length; ++i) {
            sharedParams[i] = new SharedParam(sharedParamsStr[i]);
        }
        this.containNonSharedParam = false;
        for (String element : paramName) {
            boolean paramFound = false;
            for (SharedParam sharedParam : sharedParams) {
                for (String spChartName : sharedParam.chartParamList) {
                    if (chartName.equals(spChartName.substring(0, spChartName.indexOf("__")))) {
                        for (String spName : sharedParam.chartParamNameList) {
                            if (!element.equals(spName)) continue;
                            paramFound = true;
                            break;
                        }
                    }
                    if (!paramFound) continue;
                    break;
                }
                if (paramFound) break;
            }
            if (paramFound) continue;
            this.containNonSharedParam = true;
            break;
        }
    }
}

