/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import quadbase.dashboard.api.ChartInfo;
import quadbase.dashboard.api.QbDashboard;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportorganizer.data.IOUtil;
import quadbase.util.internal.QbUtil;

public class LoadDashboard {
    private QbDashboard qbDashboard = null;

    public LoadDashboard(QbDashboard qbDashboard) {
        this.qbDashboard = qbDashboard;
    }

    public boolean load(String filePath) {
        boolean success = false;
        try {
            success = this.loadLocally(filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean loadLocally(String filePath) throws Exception {
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            filePath = quadbase.common.util.internal.QbUtil.convertToHTMLFileName(filePath);
        }
        DataInputStream in = new ReadDataFile().getInputStream(null, filePath, true);
        return this.loadLocally(in);
    }

    public boolean loadLocally(InputStream in) throws Exception {
        DataInputStream din = new DataInputStream(in);
        int version = din.readInt();
        int space = din.readInt();
        int chartLen = din.readInt();
        String[] chartStr = new String[chartLen];
        ChartInfo[] chartInfos = new ChartInfo[chartLen];
        String[] positionStr = new String[chartLen];
        for (int i = 0; i < chartLen; ++i) {
            chartStr[i] = IOUtil.readString((DataInput)din, (boolean)true);
            if (version >= 2) {
                try {
                    chartStr[i] = this.getChartName(chartStr[i]);
                    chartInfos[i] = new ChartInfo(chartStr[i]);
                }
                catch (Exception e) {
                    System.out.println("WARNING: Organizer Folder Path Mismatch");
                }
            }
            positionStr[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setPositionStr(positionStr);
        this.qbDashboard.setChartInfos(chartInfos);
        int sharedLen = din.readInt();
        String[] sharedParamStr = new String[sharedLen];
        for (int i = 0; i < sharedLen; ++i) {
            sharedParamStr[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setSharedParamStr(sharedParamStr);
        int drillLen = din.readInt();
        String[] drillDownStr = new String[drillLen];
        for (int i = 0; i < drillLen; ++i) {
            drillDownStr[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setDrillDownStr(drillDownStr);
        String[] labelProperties = null;
        String[] templateParamType = new String[chartStr.length];
        if (din.available() == 0) {
            labelProperties = new String[]{};
            templateParamType = new String[chartStr.length];
            din.close();
            in.close();
            return true;
        }
        int posCount = din.readInt();
        Hashtable<String, String> templatePositions = new Hashtable<String, String>();
        for (int i = 0; i < posCount; ++i) {
            String pos = IOUtil.readString((DataInput)din, (boolean)true);
            StringTokenizer st = new StringTokenizer(pos, ":");
            String tplName = st.nextToken();
            String position = st.nextToken();
            templatePositions.put(tplName, position);
        }
        this.qbDashboard.setTemplatePositions(templatePositions);
        int labelCount = din.readInt();
        labelProperties = new String[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            labelProperties[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setLabelProperties(labelProperties);
        int tplParamCount = din.readInt();
        templateParamType = new String[tplParamCount];
        for (int i = 0; i < tplParamCount; ++i) {
            templateParamType[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setTemplateParamType(templateParamType);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String dbBackground = IOUtil.readString((DataInput)din, (boolean)true);
        this.qbDashboard.setDbBackground(dbBackground);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        labelCount = din.readInt();
        String[] labelBGImage = new String[labelCount];
        for (int i = 0; i < labelBGImage.length; ++i) {
            labelBGImage[i] = IOUtil.readString((DataInput)din, (boolean)true);
        }
        this.qbDashboard.setLabelBGImage(labelBGImage);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String attrStr = IOUtil.readString((DataInput)din, (boolean)true);
        String[] spExpPanelAttrs = null;
        if (attrStr.equals("none")) {
            spExpPanelAttrs = new String[]{};
        } else {
            spExpPanelAttrs = LoadDashboard.splitString(attrStr, "none", ";");
            this.urlEncodeFirstString(spExpPanelAttrs);
        }
        this.qbDashboard.setSpExpPanelAttrs(spExpPanelAttrs);
        String[] spExpButnAttrs = null;
        attrStr = IOUtil.readString((DataInput)din, (boolean)true);
        if (attrStr.equals("none")) {
            spExpButnAttrs = new String[]{};
        } else {
            spExpButnAttrs = LoadDashboard.splitString(attrStr, "none", ";");
            this.urlEncodeFirstString(spExpButnAttrs);
        }
        this.qbDashboard.setSpExpButnAttrs(spExpButnAttrs);
        attrStr = IOUtil.readString((DataInput)din, (boolean)true);
        String[] spExpIconMap = null;
        if (attrStr.equals("none")) {
            spExpIconMap = new String[]{};
        } else {
            spExpIconMap = LoadDashboard.splitString(attrStr, "none", ";");
            this.urlEncodeFirstString(spExpIconMap);
        }
        this.qbDashboard.setSpExpIconMap(spExpIconMap);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String spDetPanelAttr = this.urlEncodeFirstString(IOUtil.readString((DataInput)din, (boolean)true));
        String spDetParamAttr = this.urlEncodeFirstString(IOUtil.readString((DataInput)din, (boolean)true));
        this.qbDashboard.setSpDetPanelAttr(spDetPanelAttr);
        this.qbDashboard.setSpDetParamAttr(spDetParamAttr);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String previewOptions = IOUtil.readString((DataInput)din, (boolean)true);
        this.qbDashboard.setPreviewOptions(previewOptions);
        Hashtable<String, String> previewOptionProps = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(previewOptions, ";");
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(val, ":");
            String key = st2.nextToken();
            String value = st2.nextToken();
            previewOptionProps.put(key, value);
        }
        this.qbDashboard.setPreviewOptionProps(previewOptionProps);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String folderAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (folderAttrs.equals("none")) {
            folderAttrs = "";
        }
        this.qbDashboard.setFolderAttrs(folderAttrs);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String comboParamAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (comboParamAttrs.equals("none")) {
            comboParamAttrs = "";
        }
        this.qbDashboard.setComboParamAttrs(comboParamAttrs);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String linkAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (linkAttrs.equals("none")) {
            linkAttrs = "";
        }
        this.qbDashboard.setLinkAttrs(linkAttrs);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String zIndexAttr = IOUtil.readString((DataInput)din, (boolean)true);
        if (zIndexAttr.equals("none")) {
            zIndexAttr = "";
        }
        this.qbDashboard.setZIndexAttr(zIndexAttr);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String templateLinkToDB = IOUtil.readString((DataInput)din, (boolean)true);
        if (templateLinkToDB.equals("none")) {
            templateLinkToDB = "";
        }
        this.qbDashboard.setTemplateLinkToDB(templateLinkToDB);
        if (din.available() == 0) {
            din.close();
            in.close();
            return true;
        }
        String alertAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (alertAttrs.equals("none")) {
            alertAttrs = "";
            this.qbDashboard.setAlertObjList(null);
        } else {
            this.qbDashboard.setAlertAttrs(alertAttrs);
        }
        din.close();
        in.close();
        return true;
    }

    public String getChartName(String savedChartName) {
        int loc = savedChartName.indexOf("-NODE-");
        String s = savedChartName;
        if (loc > 0) {
            s = savedChartName.substring(0, loc);
        }
        return s;
    }

    private static String[] splitString(String str, String skipTerm, String delim) {
        if (str == null || str.equals(skipTerm) || str.trim().equals("")) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        int len = st.countTokens();
        String[] sa = new String[len];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = st.nextToken();
        }
        return sa;
    }

    private void urlEncodeFirstString(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.urlEncodeFirstString(array[i]);
        }
    }

    private String urlEncodeFirstString(String s) {
        if (s == null) {
            return s;
        }
        int idx = s.indexOf(58);
        if (idx < 0) {
            return s;
        }
        return QbUtil.urlEncode2IfNecessary(s.substring(0, idx)) + s.substring(idx);
    }
}

