/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.util.Vector;
import quadbase.dashboard.api.ChartInfo;

public class ParamInfo {
    private String paramName;
    private Vector filePaths;
    private Vector paramNameForTemplate;
    private Object defaultValue;
    private int dataType;
    private Vector distinctValues;
    private boolean isSharedParam;
    private boolean isMultiValue;
    private ChartInfo chartInfo;

    public ParamInfo() {
    }

    public ParamInfo(String paramName, Vector templatePaths, Vector templateParamNames, Object defaultValue, int dataType, boolean isShared) {
        this.paramName = paramName;
        this.filePaths = templatePaths;
        this.paramNameForTemplate = templateParamNames;
        this.defaultValue = defaultValue;
        this.dataType = dataType;
        this.isSharedParam = isShared;
    }

    public void addTemplatePath(String templatePath, String templateParamName) {
        if (this.filePaths == null) {
            this.filePaths = new Vector();
            this.paramNameForTemplate = new Vector();
        }
        this.filePaths.add(templatePath);
        this.paramNameForTemplate.add(templateParamName);
    }

    public void removeTemplatePath(String templatePath) {
        if (this.filePaths == null) {
            return;
        }
        for (int i = 0; i < this.filePaths.size(); ++i) {
            if (!templatePath.equals(this.filePaths.elementAt(i))) continue;
            this.filePaths.remove(i);
            this.paramNameForTemplate.remove(i);
            break;
        }
    }

    public String getParamNameFor(String templatePath) {
        if (this.filePaths == null) {
            return null;
        }
        String pName = null;
        for (int i = 0; i < this.filePaths.size(); ++i) {
            if (!templatePath.equals(this.filePaths.elementAt(i))) continue;
            pName = (String)this.paramNameForTemplate.elementAt(i);
            break;
        }
        return pName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("paramName: " + this.paramName + "\n");
        buf.append("isSharedParam: " + this.isSharedParam + "\n");
        buf.append("isMultiValue: " + this.isMultiValue + "\n");
        buf.append("dataType: " + this.dataType + "\n");
        buf.append("defaultValue: " + this.defaultValue + "\n");
        buf.append("templatePath and parameter name:\n");
        for (int i = 0; i < this.filePaths.size(); ++i) {
            String path = (String)this.filePaths.elementAt(i);
            String templateParamName = (String)this.paramNameForTemplate.elementAt(i);
            buf.append("\tpath: " + path + "\n");
            buf.append("\ttemplate parameter name: " + templateParamName + "\n");
        }
        return buf.toString();
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public Vector getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(Vector filePaths) {
        this.filePaths = filePaths;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public Vector getDistinctValues() {
        return this.distinctValues;
    }

    public void setDistinctValues(Vector distinctValues) {
        this.distinctValues = distinctValues;
    }

    public boolean isSharedParam() {
        return this.isSharedParam;
    }

    public boolean isMultiValue() {
        return this.isMultiValue;
    }

    public void setMultiValue(boolean isMultiValue) {
        this.isMultiValue = isMultiValue;
    }

    public void setSharedParam(boolean isSharedParam) {
        this.isSharedParam = isSharedParam;
    }

    public Vector getParamNameForTemplate() {
        return this.paramNameForTemplate;
    }

    public void setParamNameForTemplate(Vector paramNameForTemplate) {
        this.paramNameForTemplate = paramNameForTemplate;
    }

    public ChartInfo getChartInfo() {
        return this.chartInfo;
    }

    public void setChartInfo(ChartInfo chartInfo) throws Exception {
        if (this.isSharedParam) {
            throw new Exception("Can't set chartInfo for shared parameter");
        }
        this.chartInfo = chartInfo;
    }
}

