/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.applet.Applet;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterGrabber;
import quadbase.common.param.Parameters;
import quadbase.common.paramquery.IDistinctValuesProvider;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.IQueryParamValuesProvider;
import quadbase.common.util.ReadSecParamFile;
import quadbase.common.util.SecParamInfoList;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.dashboard.api.AlertAttr;
import quadbase.dashboard.api.ChartInfo;
import quadbase.dashboard.api.LoadDashboard;
import quadbase.dashboard.api.ParamInfo;
import quadbase.dashboard.api.SaveDashboard;
import quadbase.dashboard.api.SharedParam;
import quadbase.dashboard.api.TemplateParamValue;
import quadbase.datasource.DataSource;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.maps.QbMap;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IQbQueryFileInfo;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.reportorganizer.data.OrganizerDataImpl;
import quadbase.reportorganizer.data.OrganizerDataProxy;
import quadbase.reportorganizer.data.Path;
import quadbase.reportorganizer.data.PathImpl;
import quadbase.reportorganizer.data.Util;
import quadbase.util.IInputData;
import quadbase.util.IQueryInParam;
import quadbase.util.internal.QbUtil;

public class QbDashboard
implements IAlertable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ChartInfo[] chartInfos;
    private SharedParam[] sharedParams;
    private int version = 5;
    private String[] positionStr = null;
    private String[] sharedParamStr = null;
    private String[] drillDownStr = null;
    private String[] labelProperties = null;
    private String[] templateParamType = null;
    private Hashtable templatePositions = null;
    private String dbBackground = "";
    private String[] labelBGImage = null;
    private String[] spExpPanelAttrs = null;
    private String[] spExpButnAttrs = null;
    private String[] spExpIconMap = null;
    private String spDetPanelAttr = "";
    private String spDetParamAttr = "";
    private String previewOptions = "";
    private Hashtable previewOptionProps = new Hashtable();
    private String folderAttrs = "";
    private String comboParamAttrs = "";
    private String linkAttrs = "";
    private String zIndexAttr = "";
    private String templateLinkToDB = "";
    private String alertAttrs = "";
    private AlertAttr[] alertObjList = null;
    private String dashboardFileName = "";
    private String userName;
    private String password;
    private OrganizerDataProxy dataProxy;

    public QbDashboard() {
    }

    public QbDashboard(String filePath, String userName, String password) throws Exception {
        this(filePath, userName, password, (OrganizerDataProxy)null, false);
    }

    public QbDashboard(String filePath, String userName, String password, boolean loadTemplates) throws Exception {
        this(filePath, userName, password, (OrganizerDataProxy)null, loadTemplates);
    }

    public QbDashboard(InputStream in, String userName, String password) throws Exception {
        this(in, userName, password, (OrganizerDataProxy)null, false);
    }

    public QbDashboard(InputStream in, String userName, String password, boolean loadTemplates) throws Exception {
        this(in, userName, password, (OrganizerDataProxy)null, loadTemplates);
    }

    public QbDashboard(String filePath, String userName, String password, String eresServerURL, boolean loadTemplates) throws Exception {
        this.dashboardFileName = filePath;
        if (eresServerURL != null) {
            URL webURL = new URL(eresServerURL);
            this.dataProxy = new OrganizerDataProxy(webURL);
        }
        this.userName = userName;
        this.password = password;
        this.load(filePath, loadTemplates, false);
    }

    public QbDashboard(InputStream in, String userName, String password, String eresServerURL, boolean loadTemplates) throws Exception {
        this.userName = userName;
        this.password = password;
        if (eresServerURL != null) {
            URL webURL = new URL(eresServerURL);
            this.dataProxy = new OrganizerDataProxy(webURL);
        }
        this.loadDashboard(in, loadTemplates, false);
    }

    public QbDashboard(InputStream in, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates) throws Exception {
        this.userName = userName;
        this.password = password;
        this.dataProxy = dataProxy;
        this.loadDashboard(in, loadTemplates, false);
    }

    public QbDashboard(String filePath, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates) throws Exception {
        this(filePath, userName, password, dataProxy, loadTemplates, false);
    }

    public QbDashboard(String filePath, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates, boolean useBackupData) throws Exception {
        this.dashboardFileName = filePath;
        this.dataProxy = dataProxy;
        this.userName = userName;
        this.password = password;
        this.load(filePath, loadTemplates, useBackupData);
    }

    private void loadDashboard(InputStream in, boolean loadTemplates, boolean useBackupData) throws Exception {
        this.load(in);
        this.setupSharedParams(this.sharedParamStr);
        if (loadTemplates) {
            this.loadTemplates(useBackupData);
        }
    }

    public void loadTemplates(OrganizerDataProxy proxy, boolean useBackupData) throws Exception {
        this.dataProxy = proxy;
        this.loadTemplates(useBackupData);
    }

    public void loadTemplates(boolean useBackupData) throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            Connection conn = OrganizerDataImpl.getConnection();
            for (int i = 0; i < this.chartInfos.length; ++i) {
                this.createObject(this.chartInfos[i], conn, useBackupData);
                this.updateTemplateParamList(i, this.chartInfos[i]);
            }
        } else {
            this.loadTemplatesFromServer(useBackupData);
        }
    }

    private void loadTemplatesFromServer(boolean useBackupData) throws Exception {
        if (this.dataProxy == null) {
            throw new Exception("Please provide OrganizerDataProxy instance using setDataProxy(...) method");
        }
        for (int i = 0; i < this.chartInfos.length; ++i) {
            this.createObjectFromServer(this.chartInfos[i], useBackupData);
            this.updateTemplateParamList(i, this.chartInfos[i]);
        }
    }

    public void save(int nodeID, OrganizerDataImpl db, String filePath, boolean saveToDB, String remoteAddr) {
        SaveDashboard saveDashboard = new SaveDashboard(this);
        saveDashboard.setDb(db);
        saveDashboard.save(nodeID, filePath, this.userName, saveToDB, remoteAddr);
    }

    public void load(String filePath) throws Exception {
        this.load(filePath, false, false);
    }

    public void load(String filePath, boolean loadTemplates, boolean useBackupData) throws Exception {
        LoadDashboard loadDashboard = new LoadDashboard(this);
        loadDashboard.load(filePath);
        this.setupSharedParams(this.sharedParamStr);
        if (loadTemplates) {
            this.loadTemplates(useBackupData);
        }
    }

    public void load(InputStream in) throws Exception {
        LoadDashboard loadDashboard = new LoadDashboard(this);
        loadDashboard.loadLocally(in);
        this.setupSharedParams(this.sharedParamStr);
    }

    private void setupSharedParams(String[] sharedParamStr) {
        if (sharedParamStr != null) {
            this.sharedParams = new SharedParam[sharedParamStr.length];
            for (int i = 0; i < sharedParamStr.length; ++i) {
                this.sharedParams[i] = new SharedParam(sharedParamStr[i]);
            }
        }
    }

    private void createObject(ChartInfo chartInfo, Connection conn, boolean useBackupData) throws Exception {
        PathImpl pathImpl = new PathImpl(chartInfo.nodeID);
        String ownerID = (String)pathImpl.getValueAt(conn, chartInfo.itemID, 5);
        if (!OrganizerDataImpl.canReadFile((String)this.userName, (int)chartInfo.itemID, (String)ownerID)) {
            System.out.println("CANNOT READ FILE..." + chartInfo.name);
            return;
        }
        String securityLevel = this.getSecurityLevel();
        String path = (String)pathImpl.getValueAt(conn, chartInfo.itemID, 3);
        if (path == null || path.equals("")) {
            path = (String)pathImpl.getValueAt(conn, chartInfo.itemID, 4);
        }
        chartInfo.path = path;
        if (QbDashboard.isChart(path)) {
            if (!useBackupData && OrganizerDataImpl.getListenerManager() != null) {
                Properties props = new Properties();
                props.put("prompt parameter", "false");
                props.put("use backup data", "true");
                chartInfo.chart = new QbChart((Applet)null, path, null, props);
                chartInfo.chart.getChart().sourceData = chartInfo.chart.getChart().getOriginalSourceData();
            } else {
                Properties props = new Properties();
                props.put("prompt parameter", "false");
                props.put("use backup data", useBackupData + "");
                chartInfo.chart = new QbChart((Applet)null, path, null, props);
            }
            if (!useBackupData) {
                chartInfo.chart = this.setSecuredParameterForChart(chartInfo.chart);
            }
        } else if (QbDashboard.isReport(path)) {
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("prompt parameter", "false");
            props.put("use backup data", useBackupData + "");
            if (securityLevel != null) {
                props.put("security level", securityLevel);
            }
            chartInfo.report = new QbReport((Object)null, path, (Object[])null, (Object[])null, props);
            if (!useBackupData) {
                chartInfo.report = this.setSecuredParameterForReport(chartInfo.report);
                chartInfo.report.setSnapToGrid(false);
                chartInfo.report.refreshWithOriginalData();
            }
        } else if (QbDashboard.isMap(path)) {
            chartInfo.qbMap = QbMap.readMap(path, useBackupData);
            if (!useBackupData) {
                chartInfo.qbMap = this.setSecuredParameterForMap(chartInfo.qbMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObjectFromServer(ChartInfo chartInfo, boolean useBackupData) throws Exception {
        String ownerID;
        Path path;
        block19: {
            path = this.dataProxy.getTable(null, null, chartInfo.nodeID);
            ownerID = "";
            try {
                ownerID = (String)path.getValueAt(null, null, chartInfo.itemID, 5);
            }
            catch (Exception e) {
                if (!(e instanceof NullPointerException)) break block19;
                throw new Exception("The Organizer node id=" + chartInfo.nodeID + " might have been removed");
            }
        }
        if (!this.dataProxy.canReadFile(this.userName, chartInfo.itemID, ownerID)) {
            throw new Exception("CANNOT READ FILE..." + chartInfo.name);
        }
        String securityLevel = this.getSecurityLevel();
        String pathStr = (String)path.getValueAt(this.userName, this.password, chartInfo.itemID, 3);
        if (pathStr == null || pathStr.equals("")) {
            pathStr = (String)path.getValueAt(this.userName, this.password, chartInfo.itemID, 4);
        }
        if (pathStr == null) {
            throw new Exception("The template '" + chartInfo.name + "' has been removed from the organizer...");
        }
        chartInfo.path = pathStr;
        if (QbDashboard.isChart(pathStr)) {
            boolean oldState = QbChart.isForExportOnly();
            QbChart.setForExportOnly(true);
            try {
                if (!useBackupData && OrganizerDataImpl.getListenerManager() != null) {
                    Properties props = new Properties();
                    props.put("prompt parameter", "false");
                    props.put("use backup data", "true");
                    chartInfo.chart = new QbChart(ServerMessage.getApplet(), pathStr, null, props);
                    chartInfo.chart.getChart().sourceData = chartInfo.chart.getChart().getOriginalSourceData();
                } else {
                    Properties props = new Properties();
                    props.put("prompt parameter", "false");
                    props.put("use backup data", useBackupData + "");
                    chartInfo.chart = new QbChart(ServerMessage.getApplet(), pathStr, null, props);
                }
            }
            finally {
                QbChart.setForExportOnly(oldState);
            }
            if (!useBackupData) {
                chartInfo.chart = this.setSecuredParameterForChart(chartInfo.chart);
            }
        } else if (QbDashboard.isReport(pathStr)) {
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("prompt parameter", "false");
            props.put("use backup data", useBackupData + "");
            if (securityLevel != null) {
                props.put("security level", securityLevel);
            }
            chartInfo.report = new QbReport((Object)ServerMessage.getApplet(), pathStr, (Object[])null, (Object[])null, props);
            if (!useBackupData) {
                chartInfo.report = this.setSecuredParameterForReport(chartInfo.report);
                chartInfo.report.setSnapToGrid(false);
                chartInfo.report.refreshWithOriginalData();
            }
        } else if (QbDashboard.isMap(pathStr)) {
            chartInfo.qbMap = QbMap.readMap(pathStr, useBackupData);
            if (!useBackupData) {
                chartInfo.qbMap = this.setSecuredParameterForMap(chartInfo.qbMap);
            }
        }
    }

    private QbReport setSecuredParameterForReport(QbReport qbReport) throws Exception {
        if (qbReport.getDataSourceType() != 1 && qbReport.getReportObj().getOriginalSourceData() != 1) {
            return qbReport;
        }
        SecParamInfoList infoList = this.getSecuredParamInfoList();
        if (infoList == null || this.isAdmin()) {
            return qbReport;
        }
        String secLevel = this.getSecurityLevel();
        quadbase.reportdesigner.util.IDatabaseInfo idbInfo = qbReport.getInputData().getDatabaseInfo();
        if (idbInfo instanceof IQueryFileInfo) {
            QueryFileInfo iqfi = (QueryFileInfo)qbReport.getReportObj().dbInfo;
            iqfi = infoList.appendConditionForParamReport(iqfi, secLevel);
            IQbQueryFileInfo rptQueryFileInfo = ReportUtil.cast2(iqfi);
            qbReport.getInputData().setDatabaseInfo(rptQueryFileInfo, true);
        } else {
            quadbase.reportdesigner.ReportAPI.DBInfo dbInfo = new quadbase.reportdesigner.ReportAPI.DBInfo(idbInfo);
            dbInfo = infoList.appendConditions(dbInfo, secLevel);
            qbReport.getInputData().setDatabaseInfo(dbInfo);
        }
        return qbReport;
    }

    private QbChart setSecuredParameterForChart(QbChart qbChart) throws Exception {
        if (qbChart.getChart().sourceData != 1) {
            return qbChart;
        }
        String secLevel = this.getSecurityLevel();
        SecParamInfoList infoList = this.getSecuredParamInfoList();
        if (infoList == null || this.isAdmin()) {
            return qbChart;
        }
        quadbase.util.IDatabaseInfo dbInfo = qbChart.gethInputData().getDatabaseInfo();
        if (dbInfo instanceof quadbase.util.IQueryFileInfo) {
            quadbase.util.IQueryFileInfo iqfi = (quadbase.util.IQueryFileInfo)dbInfo;
            quadbase.util.IQueryFileInfo sqf = null;
            sqf = infoList.appendCondtionForParamChart(iqfi, secLevel);
            qbChart.gethInputData().setDatabaseInfo(sqf, true);
        } else {
            DBInfo dbInfoTemp = new DBInfo(dbInfo);
            infoList.appendConditionsForChart(dbInfoTemp, secLevel);
            qbChart.gethInputData().setDatabaseInfo(dbInfoTemp, true);
        }
        qbChart.refresh();
        return qbChart;
    }

    private QbMap setSecuredParameterForMap(QbMap qbMap) throws Exception {
        String secLevel = this.getSecurityLevel();
        DataSource ds = qbMap.getDataSource();
        ds.setSecuredParameters(true, secLevel);
        qbMap.refresh();
        return qbMap;
    }

    private String getSecurityLevel() throws Exception {
        String secLevel = null;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            secLevel = OrganizerDataImpl.getSecurityLevel((String)OrganizerDataImpl.getUserID((String)this.userName), (boolean)false);
            return secLevel;
        }
        if (this.dataProxy == null) {
            throw new Exception("Can't get security level on the client, dataProxy is null");
        }
        String userID = null;
        String encUserName = Coder.encode(this.userName);
        String encPassword = Coder.encode(this.password);
        userID = this.dataProxy.getUserNameID(encUserName);
        secLevel = this.dataProxy.getSecurityLevel(encUserName, encPassword, userID, false);
        return secLevel;
    }

    private SecParamInfoList getSecuredParamInfoList() {
        SecParamInfoList paramInfoList = null;
        if (!OrganizerDataImpl.isReloadQuickDesignerSecuredParameters() && paramInfoList != null) {
            return paramInfoList;
        }
        String xmlFile = OrganizerDataImpl.getQuickDesignerSecuredParameters();
        if (xmlFile == null) {
            return null;
        }
        try {
            ReadDataFile fileReader = new ReadDataFile();
            DataInputStream in = fileReader.getInputStream(xmlFile);
            ReadSecParamFile readFile = new ReadSecParamFile(in);
            paramInfoList = readFile.createParamInfoList();
            OrganizerDataImpl.setReloadQuickDesignerSecuredParameters((boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return paramInfoList;
    }

    private void updateTemplateParamList(int index, ChartInfo chartInfo) {
        if (chartInfo == null) {
            return;
        }
        if (chartInfo.chart != null) {
            String chartParamType = chartInfo.chartID;
            IInputData inputData = chartInfo.chart.gethInputData();
            if (inputData.getDatabaseInfo() == null || !(inputData.getDatabaseInfo() instanceof IQueryFileInfo)) {
                return;
            }
            IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
            IQueryInParam[] queryParamSet = null;
            if (queryInfo != null) {
                queryParamSet = QbUtil.getInParam(queryInfo);
                String paramStr = "";
                for (int i = 0; i < queryParamSet.length; ++i) {
                    if (i > 0) {
                        paramStr = paramStr + ",";
                    }
                    paramStr = paramStr + QbUtil.urlEncode2(queryParamSet[i].getParamName()) + ":" + queryParamSet[i].getSqlType() + ":" + DataType.getTypeName2(queryParamSet[i].getSqlType());
                    chartInfo.filterParamList.put(queryParamSet[i].getParamName(), queryParamSet[i].getDefaultValue());
                }
                chartParamType = chartParamType + "-_-" + paramStr;
            }
            this.templateParamType[index] = chartParamType + "-_-CHT";
        } else if (chartInfo.report != null) {
            String chartParamType = chartInfo.chartID;
            quadbase.reportdesigner.util.IInputData inputData = chartInfo.report.getInputData();
            if (inputData.getDatabaseInfo() != null && inputData.getDatabaseInfo() instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                quadbase.reportdesigner.util.IQueryFileInfo queryInfo = (quadbase.reportdesigner.util.IQueryFileInfo)inputData.getDatabaseInfo();
                IQueryInParam[] queryParamSet = null;
                if (queryInfo != null) {
                    queryParamSet = QbUtil.getInParam(queryInfo);
                    String paramStr = "";
                    for (int i = 0; i < queryParamSet.length; ++i) {
                        if (i > 0) {
                            paramStr = paramStr + ",";
                        }
                        paramStr = paramStr + "," + QbUtil.urlEncode2(queryParamSet[i].getParamName()) + ":" + queryParamSet[i].getSqlType() + ":" + DataType.getTypeName2(queryParamSet[i].getSqlType());
                        chartInfo.filterParamList.put(queryParamSet[i].getParamName(), queryParamSet[i].getDefaultValue());
                    }
                    chartParamType = chartParamType + "-_-" + paramStr;
                }
                this.templateParamType[index] = chartParamType + "-_-RPT";
            }
        } else if (chartInfo.qbMap != null) {
            String chartParamType = chartInfo.chartID;
            DataSource ds = chartInfo.qbMap.getDataSource();
            if (ds.isParameterized()) {
                ParameterizedDataSource pds = (ParameterizedDataSource)ds;
                IQueryFileInfo queryInfo = pds.getQueryFileInfo();
                IQueryInParam[] queryParamSet = null;
                if (queryInfo != null) {
                    queryParamSet = QbUtil.getInParam(queryInfo);
                    String paramStr = "";
                    for (int i = 0; i < queryParamSet.length; ++i) {
                        if (i > 0) {
                            paramStr = paramStr + ",";
                        }
                        paramStr = paramStr + QbUtil.urlEncode2(queryParamSet[i].getParamName()) + ":" + queryParamSet[i].getSqlType() + ":" + DataType.getTypeName2(queryParamSet[i].getSqlType());
                        chartInfo.filterParamList.put(queryParamSet[i].getParamName(), queryParamSet[i].getDefaultValue());
                    }
                    chartParamType = chartParamType + "-_-" + paramStr;
                }
            }
            this.templateParamType[index] = chartParamType + "-_-MAP";
        }
    }

    public ChartInfo getChartInfoById(String templateInfoID) {
        ChartInfo cinfo = null;
        for (ChartInfo chartInfo : this.chartInfos) {
            if (!chartInfo.chartID.equals(templateInfoID)) continue;
            cinfo = chartInfo;
            break;
        }
        if (cinfo == null) {
            StringTokenizer st = new StringTokenizer(templateInfoID, ",");
            st.nextToken();
            int inNodeID = Integer.parseInt(st.nextToken());
            int inItemID = Integer.parseInt(st.nextToken());
            for (ChartInfo chartInfo : this.chartInfos) {
                if (inNodeID != chartInfo.nodeID || inItemID != chartInfo.itemID) continue;
                cinfo = chartInfo;
                break;
            }
        }
        return cinfo;
    }

    public QbChart[] getTriggeredChart() {
        Vector<QbChart> chartList = new Vector<QbChart>();
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] triggeredAlertIds;
            if (chartInfo.chart == null || (triggeredAlertIds = chartInfo.chart.getTriggeredAlertIds()) == null || triggeredAlertIds.length <= 0) continue;
            chartList.add(chartInfo.chart);
        }
        QbChart[] chartArray = new QbChart[chartList.size()];
        for (int i = 0; i < chartList.size(); ++i) {
            chartArray[i] = (QbChart)chartList.elementAt(i);
        }
        return chartArray;
    }

    public QbReport[] getTriggeredReport() {
        Vector<QbReport> reportList = new Vector<QbReport>();
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] triggeredAlertIds;
            if (chartInfo.report == null || (triggeredAlertIds = chartInfo.report.getTriggeredAlertIds()) == null || triggeredAlertIds.length <= 0) continue;
            reportList.add(chartInfo.report);
        }
        QbReport[] reportArray = new QbReport[reportList.size()];
        for (int i = 0; i < reportList.size(); ++i) {
            reportArray[i] = (QbReport)reportList.elementAt(i);
        }
        return reportArray;
    }

    public QbMap[] getTriggeredMap() {
        Vector<QbMap> mapList = new Vector<QbMap>();
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] triggeredAlertIds;
            if (chartInfo.qbMap == null || (triggeredAlertIds = chartInfo.qbMap.getTriggeredAlertIds()) == null || triggeredAlertIds.length <= 0) continue;
            mapList.add(chartInfo.qbMap);
        }
        QbMap[] mapArray = new QbMap[mapList.size()];
        for (int i = 0; i < mapList.size(); ++i) {
            mapArray[i] = (QbMap)mapList.elementAt(i);
        }
        return mapArray;
    }

    public String generateURL(String httpProtocol, String serverName, int portNum, String servletContext, String dashboardPath, Hashtable sharedParamsValueList, TemplateParamValue[] templateParams) {
        StringBuffer buf = new StringBuffer();
        buf.append(httpProtocol).append("://");
        buf.append(serverName);
        buf.append(":").append(portNum);
        if (servletContext.startsWith("/")) {
            buf.append(servletContext);
        } else {
            buf.append("/").append(servletContext);
        }
        dashboardPath = QbUtil.urlEncode2IfNecessary(dashboardPath);
        buf.append("?OpenFile=").append(dashboardPath);
        if (sharedParamsValueList != null) {
            Enumeration spNameEnum = sharedParamsValueList.keys();
            while (spNameEnum.hasMoreElements()) {
                String spName = (String)spNameEnum.nextElement();
                buf.append("&QueryParamName=").append(spName);
                Object spValue = sharedParamsValueList.get(spName);
                if (spValue instanceof String) {
                    buf.append("&QueryParamSize=1&QueryParamValue=").append(spValue.toString());
                    continue;
                }
                if (!(spValue instanceof Vector)) continue;
                Vector valVect = (Vector)spValue;
                buf.append("&QueryParamSize=").append(valVect.size());
                for (int i = 0; i < valVect.size(); ++i) {
                    buf.append("&QueryParamValue=").append((String)valVect.elementAt(i));
                }
            }
        }
        if (templateParams != null) {
            JSONArray tpJA = new JSONArray();
            for (TemplateParamValue templateParam : templateParams) {
                JSONObject tpJObj = templateParam.toJSONObject();
                tpJA.put((Object)tpJObj);
            }
            buf.append("&TemplateParams=").append(QbUtil.urlEncode2IfNecessary(tpJA.toString()));
        }
        return buf.toString();
    }

    private AlertAttr[] toAlertAttrArray(String encodedAlertAttrJSONStr) {
        String str = encodedAlertAttrJSONStr;
        if (str == null || str.equals("") || str.equals("none")) {
            return new AlertAttr[0];
        }
        str = QbUtil.urlDecode(encodedAlertAttrJSONStr);
        try {
            JSONArray ja = new JSONArray(str);
            AlertAttr[] aa = new AlertAttr[ja.length()];
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jObj = ja.getJSONObject(i);
                aa[i] = new AlertAttr(jObj);
            }
            return aa;
        }
        catch (JSONException je) {
            return new AlertAttr[0];
        }
    }

    public String[] getSharedParamNames() {
        if (this.sharedParams == null) {
            return null;
        }
        String[] spNames = new String[this.sharedParams.length];
        for (int i = 0; i < spNames.length; ++i) {
            spNames[i] = this.sharedParams[i].paramName;
        }
        return spNames;
    }

    public Object getSharedParamDistinctValues(String sharedParamName) {
        if (this.sharedParams == null) {
            return null;
        }
        SharedParam sp = null;
        for (SharedParam sharedParam : this.sharedParams) {
            if (!sharedParam.paramName.equals(sharedParamName)) continue;
            sp = sharedParam;
            break;
        }
        String templateParamStr = "";
        if (sp.chartParamList != null && sp.chartParamList.size() > 0) {
            templateParamStr = (String)sp.chartParamList.elementAt(0);
        }
        int loc = templateParamStr.indexOf("__");
        String templateInfoID = templateParamStr.substring(0, loc);
        String templateParamName = templateParamStr.substring(loc + 2);
        Object valueObj = this.getTemplateParamDistinctValues(templateInfoID, templateParamName);
        return valueObj;
    }

    public void setSharedParamValue(String sharedParamName, Object sharedParamValue) {
        if (this.sharedParams == null) {
            return;
        }
        SharedParam sp = null;
        for (SharedParam sharedParam : this.sharedParams) {
            if (!sharedParam.paramName.equals(sharedParamName)) continue;
            sp = sharedParam;
            break;
        }
        if (sp.chartParamList == null) {
            return;
        }
        for (int i = 0; i < sp.chartParamList.size(); ++i) {
            String templateParamStr = (String)sp.chartParamList.elementAt(i);
            int loc = templateParamStr.indexOf("__");
            String templateInfoID = templateParamStr.substring(0, loc);
            String templateParamName = templateParamStr.substring(loc + 2);
            try {
                this.setTemplateParamValue(templateInfoID, templateParamName, sharedParamValue);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getTemplateParamDistinctValues(String templateInfoID, String templateParamName) {
        ChartInfo chartInfo = null;
        for (ChartInfo chartInfo2 : this.chartInfos) {
            if (!chartInfo2.chartID.equals(templateInfoID)) continue;
            chartInfo = chartInfo2;
            break;
        }
        if (chartInfo == null) {
            return null;
        }
        Object valueObj = null;
        if (chartInfo.chart != null) {
            valueObj = this.getParamValuesForChart(chartInfo.chart, templateParamName);
        } else if (chartInfo.report != null) {
            valueObj = this.getParamValuesForReport(chartInfo.report, templateParamName);
        } else if (chartInfo.qbMap != null) {
            valueObj = this.getParamValuesForMap(chartInfo.qbMap, templateParamName);
        }
        return valueObj;
    }

    public void setTemplateParamValue(String templateInfoID, String templateParamName, Object paramValue) throws Exception {
        ChartInfo chartInfo = null;
        for (ChartInfo chartInfo2 : this.chartInfos) {
            if (!chartInfo2.chartID.equals(templateInfoID)) continue;
            chartInfo = chartInfo2;
            break;
        }
        if (chartInfo == null) {
            return;
        }
        if (chartInfo.chart != null) {
            this.setChartParamValue(chartInfo.chart, templateParamName, paramValue);
        } else if (chartInfo.report != null) {
            this.setReportParamValue(chartInfo.report, templateParamName, paramValue);
        } else if (chartInfo.qbMap != null) {
            this.setMapParamValue(chartInfo.qbMap, templateParamName, paramValue);
        }
    }

    private Object getParamValuesForChart(QbChart chart, String paramName) {
        IInputData inputData = chart.gethInputData();
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
        IQueryInParam[] queryParamSet = null;
        if (queryInfo != null) {
            queryParamSet = QbUtil.getInParam(queryInfo);
        }
        if (queryParamSet == null) {
            return null;
        }
        quadbase.common.util.IQueryInParam queryParam = null;
        for (IQueryInParam element : queryParamSet) {
            if (!element.getParamName().equals(paramName)) continue;
            queryParam = element;
            break;
        }
        if (queryParam == null) {
            return null;
        }
        AbstractList choiceList = null;
        if (queryParam instanceof IQueryParamValuesProvider) {
            choiceList = ((IQueryParamValuesProvider)((Object)queryParam)).getSelectionChoices();
        }
        if (queryParam.isMapToColumn() && choiceList == null) {
            Vector distinctValue;
            if (queryInfo instanceof QbUtil.CQueryFileInfo && ((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo() instanceof IDistinctValuesProvider) {
                IDistinctValuesProvider valuesProvider = (IDistinctValuesProvider)((Object)((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo());
                distinctValue = valuesProvider.getDistinctValues(queryParam.getTableName(), queryParam.getColumnName());
            } else if (queryInfo instanceof QbUtil.CQueryFileInfo && ((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo() instanceof QueryXMLFileInfo) {
                QueryXMLFileInfo xmlFileInfo = (QueryXMLFileInfo)((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo();
                distinctValue = QueryParser.getDistinctValues(xmlFileInfo.getXMLFileQueryInfo(), queryParam.getColumnName(), -1);
            } else {
                distinctValue = QueryParser.getDistinctValues((DBInfoBasic)((Object)queryInfo), queryParam.getTableName(), queryParam.getColumnName());
            }
            if (queryParam instanceof QbUtil.CQueryInParam && ((QbUtil.CQueryInParam)queryParam).getDateFormat() != null) {
                Vector<String> promptVals = new Vector<String>();
                for (int j = 0; j < distinctValue.size(); ++j) {
                    if (distinctValue.get(j) instanceof Date) {
                        promptVals.add(QbDateFormat.getFormattedDateTime((Date)distinctValue.get(j), ((QbUtil.CQueryInParam)queryParam).getDateFormat()));
                        continue;
                    }
                    promptVals.add((String)distinctValue.get(j));
                }
                choiceList = new ArrayList();
                ((ArrayList)choiceList).add(promptVals);
                ((ArrayList)choiceList).add(distinctValue);
            } else if (queryParam instanceof QbUtil.CQueryMultiValueInParam && ((QbUtil.CQueryMultiValueInParam)queryParam).getDateFormat() != null) {
                Vector<String> promptVals = new Vector<String>();
                for (int j = 0; j < distinctValue.size(); ++j) {
                    if (distinctValue.get(j) instanceof Date) {
                        promptVals.add(QbDateFormat.getFormattedDateTime((Date)distinctValue.get(j), ((QbUtil.CQueryMultiValueInParam)queryParam).getDateFormat()));
                        continue;
                    }
                    promptVals.add((String)distinctValue.get(j));
                }
                choiceList = new ArrayList();
                ((ArrayList)choiceList).add(promptVals);
                ((ArrayList)choiceList).add(distinctValue);
            } else {
                choiceList = distinctValue;
            }
            return choiceList;
        }
        return null;
    }

    private Object getParamValuesForReport(QbReport report, String templateParamName) {
        Parameters allPromptParams = ParameterGrabber.getParameters(report.getReportObj(), -1);
        Param param = null;
        for (int i = 0; i < allPromptParams.size(); ++i) {
            if (!allPromptParams.get(i).name().equals(templateParamName)) continue;
            param = allPromptParams.get(i);
            break;
        }
        if (param == null) {
            return null;
        }
        AbstractList choiceList = null;
        if (param instanceof IQueryParamValuesProvider) {
            choiceList = ((IQueryParamValuesProvider)((Object)param)).getSelectionChoices();
        }
        if (choiceList == null) {
            choiceList = param.getSelectionChoices();
        }
        if (param.isMapToColumn()) {
            if (choiceList == null) {
                Vector distinctValue;
                if (param.getQueryFileInfo() instanceof QueryXMLFileInfo) {
                    QueryXMLFileInfo xmlFileInfo = (QueryXMLFileInfo)param.getQueryFileInfo();
                    distinctValue = QueryParser.getDistinctValues(xmlFileInfo.getXMLFileQueryInfo(), param.getColumnName(), -1);
                } else {
                    distinctValue = QueryParser.getDistinctValues((DBInfoBasic)((Object)param.getQueryFileInfo()), param.getTableName(), param.getColumnName());
                }
                if (param.isCustomDateFormat()) {
                    Vector<String> promptVals = new Vector<String>();
                    for (int j = 0; j < distinctValue.size(); ++j) {
                        if (distinctValue.get(j) instanceof Date) {
                            promptVals.add(QbDateFormat.getFormattedDateTime((Date)distinctValue.get(j), param.getDateFormat()));
                            continue;
                        }
                        promptVals.add((String)distinctValue.get(j));
                    }
                    choiceList = new ArrayList();
                    ((ArrayList)choiceList).add(promptVals);
                    ((ArrayList)choiceList).add(distinctValue);
                } else {
                    choiceList = distinctValue;
                }
            }
        } else if (param.getSqlSelect() != null) {
            Vector result = new Vector();
            result = QueryParser.executeSQLSelect((IDatabaseInfo)param.getQueryFileInfo(), param.getSqlSelect(), allPromptParams, false);
            if (result.size() == 1) {
                choiceList = result.elementAt(0);
            } else {
                Vector distinctValue = (Vector)result.elementAt(0);
                Vector sqlConditionValue = (Vector)result.elementAt(1);
                choiceList = new ArrayList();
                ((ArrayList)choiceList).add(distinctValue);
                ((ArrayList)choiceList).add(sqlConditionValue);
            }
        } else {
            choiceList = null;
        }
        return choiceList;
    }

    private Object getParamValuesForMap(QbMap qbMap, String templateParamName) {
        quadbase.common.util.IQueryInParam[] queryInParam = ((ParameterizedDataSource)qbMap.getDataSource()).getInParam();
        quadbase.common.util.IQueryInParam param = null;
        for (quadbase.common.util.IQueryInParam element : queryInParam) {
            if (!element.getParamName().equals(templateParamName)) continue;
            param = element;
            break;
        }
        if (param == null) {
            return null;
        }
        IQueryFileInfo queryInfo = null;
        if (qbMap.getDataSource().isParameterized()) {
            ParameterizedDataSource pds = (ParameterizedDataSource)qbMap.getDataSource();
            queryInfo = pds.getQueryFileInfo();
        }
        Object choiceList = this.getParamChoiceList(param, queryInfo);
        return choiceList;
    }

    private Object getParamChoiceList(quadbase.common.util.IQueryInParam queryInParam, IQueryFileInfo queryInfo) {
        Vector choiceList = null;
        if (queryInParam instanceof IQueryParamValuesProvider) {
            choiceList = ((IQueryParamValuesProvider)((Object)queryInParam)).getSelectionChoices();
        }
        if (queryInParam.isMapToColumn() && choiceList == null) {
            if (queryInfo != null && queryInfo instanceof QbUtil.CQueryFileInfo && ((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo() instanceof IDistinctValuesProvider) {
                IDistinctValuesProvider valuesProvider = (IDistinctValuesProvider)((Object)((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo());
                choiceList = valuesProvider.getDistinctValues(queryInParam.getTableName(), queryInParam.getColumnName());
            } else if (queryInfo != null && queryInfo instanceof QbUtil.CQueryFileInfo && ((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo() instanceof QueryXMLFileInfo) {
                QueryXMLFileInfo xmlFileInfo = (QueryXMLFileInfo)((QbUtil.CQueryFileInfo)queryInfo).getIQueryFileInfo();
                choiceList = QueryParser.getDistinctValues(xmlFileInfo.getXMLFileQueryInfo(), queryInParam.getColumnName(), -1);
            } else {
                choiceList = QueryParser.getDistinctValues((DBInfoBasic)((Object)queryInfo), queryInParam.getTableName(), queryInParam.getColumnName());
            }
        }
        return choiceList;
    }

    private QbChart setChartParamValue(QbChart chart, String paramName, Object paramValue) throws Exception {
        IInputData inputData = chart.gethInputData();
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
        IQueryInParam[] queryParamSet = null;
        if (queryInfo != null) {
            queryParamSet = QbUtil.getInParam(queryInfo);
        }
        if (queryParamSet == null) {
            return null;
        }
        IQueryInParam queryParam = null;
        for (IQueryInParam element : queryParamSet) {
            if (!element.getParamName().equals(paramName)) continue;
            queryParam = element;
            break;
        }
        if (queryParam == null) {
            return null;
        }
        String[] paramValueArray = null;
        if (paramValue instanceof Vector) {
            Vector v = (Vector)paramValue;
            paramValueArray = v.toArray(new String[v.size()]);
        } else {
            paramValueArray = new String[]{paramValue.toString()};
        }
        try {
            String dateFormat = null;
            if (queryParam instanceof ICustomParameterDateFormat) {
                dateFormat = ((ICustomParameterDateFormat)((Object)queryParam)).getDateFormat();
            }
            if (queryParam instanceof IQueryMultiValueInParam) {
                Vector multiVect = queryParam.isMapToColumn() ? QbUtil.getMultiValueObject(queryParam.getSqlType(), paramValueArray, null) : QbUtil.getMultiValueObject(queryParam.getSqlType(), paramValueArray, dateFormat);
                ((IQueryMultiValueInParam)((Object)queryParam)).setValues(multiVect);
            } else {
                String[] temp = paramValueArray;
                if (paramValueArray.length == 3) {
                    if (paramValueArray[2] == null || temp[2].equals("")) {
                        paramValueArray[2] = "2003";
                    }
                    String date = paramValueArray[0] + "/" + paramValueArray[1] + "/" + paramValueArray[2];
                    Object valObj = QbUtil.getValueObject(queryParam.getSqlType(), date, "MM/dd/yyyy");
                    queryParam.setValue(valObj);
                } else {
                    Object valObj = queryParam.isMapToColumn() ? QbUtil.getValueObject(queryParam.getSqlType(), paramValueArray[0], null) : QbUtil.getValueObject(queryParam.getSqlType(), paramValueArray[0], dateFormat);
                    queryParam.setValue(valObj);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Invalid input in " + paramValue);
        }
        chart.refresh();
        return chart;
    }

    private QbReport setReportParamValue(QbReport qbReport, String paramName, Object paramValue) throws Exception {
        String[] pvStrs;
        Report report = qbReport.getReportObj();
        OrderedParameterSet allParams = report.getParametersInSequence();
        Parameters selectedParams = allParams.get(paramName);
        if (selectedParams == null) {
            return qbReport;
        }
        Object[] multiParamValues = new Object[selectedParams.size()];
        if (paramValue instanceof Vector) {
            Vector pvect = (Vector)paramValue;
            pvStrs = pvect.toArray(new String[pvect.size()]);
        } else {
            pvStrs = new String[]{paramValue.toString()};
        }
        for (int i = 0; i < multiParamValues.length; ++i) {
            multiParamValues[i] = pvStrs;
        }
        qbReport.setParameterValues(selectedParams, allParams, multiParamValues, true);
        return qbReport;
    }

    private QbMap setMapParamValue(QbMap qbMap, String paramName, Object paramValue) throws Exception {
        DataSource dataSource = qbMap.getDataSource();
        if (!(dataSource instanceof ParameterizedDataSource)) {
            return qbMap;
        }
        ParameterizedDataSource pds = (ParameterizedDataSource)dataSource;
        HashMap<String, Object> kvMap = new HashMap<String, Object>();
        if (paramValue instanceof Vector) {
            Vector pvVect = (Vector)paramValue;
            Object[] paramValueArray = pvVect.toArray(new Object[pvVect.size()]);
            kvMap.put(paramName, paramValueArray);
        } else {
            kvMap.put(paramName, paramValue);
        }
        pds.setParameters(kvMap);
        qbMap.refresh();
        return qbMap;
    }

    @Override
    public String[] getAllAlertIds() {
        Vector<String> allAlertIdVect = new Vector<String>();
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] aaIds;
            IAlertable alertable = this.getIAlertable(chartInfo);
            if (alertable == null || (aaIds = alertable.getAllAlertIds()) == null) continue;
            for (String aaId : aaIds) {
                allAlertIdVect.add(QbUtil.urlDecode(chartInfo.name) + "/" + aaId);
            }
        }
        if (allAlertIdVect.size() == 0) {
            return null;
        }
        String[] allAlertIds = allAlertIdVect.toArray(new String[allAlertIdVect.size()]);
        return allAlertIds;
    }

    public boolean hasAlert() throws Exception {
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] aaIds;
            IAlertable alertable = this.getIAlertable(chartInfo);
            if (alertable == null) {
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    Connection conn = OrganizerDataImpl.getConnection();
                    this.createObject(chartInfo, conn, true);
                } else {
                    this.createObjectFromServer(chartInfo, true);
                }
            }
            if ((alertable = this.getIAlertable(chartInfo)) == null || (aaIds = alertable.getAllAlertIds()) == null || aaIds.length <= 0) continue;
            return true;
        }
        return false;
    }

    public String[] getWatchedAlertIds() {
        Vector<String> allAlertIdVect = new Vector<String>();
        for (ChartInfo chartInfo : this.chartInfos) {
            int j;
            AlertAttr aa;
            String[] aaIds;
            IAlertable alertable = this.getIAlertable(chartInfo);
            if (alertable == null || (aaIds = alertable.getAllAlertIds()) == null || (aa = this.getAlertAttrFor(chartInfo)) == null) continue;
            boolean[] isWatched = aa.getIsWatched();
            Vector<String> watchedAlertIdList = new Vector<String>();
            block1: for (j = 0; j < isWatched.length; ++j) {
                if (!isWatched[j]) continue;
                String alertID = aa.getAlertIds()[j];
                for (String aaId : aaIds) {
                    if (!aaId.equals(alertID)) continue;
                    watchedAlertIdList.add(alertID);
                    continue block1;
                }
            }
            for (j = 0; j < watchedAlertIdList.size(); ++j) {
                allAlertIdVect.add(QbUtil.urlDecode(chartInfo.name) + "/" + watchedAlertIdList.elementAt(j));
            }
        }
        if (allAlertIdVect.size() == 0) {
            return null;
        }
        String[] allAlertIds = new String[allAlertIdVect.size()];
        for (int i = 0; i < allAlertIdVect.size(); ++i) {
            allAlertIds[i] = (String)allAlertIdVect.elementAt(i);
        }
        return allAlertIds;
    }

    @Override
    public String[] getTriggeredAlertIds() {
        Vector<String> triggeredAlertVect = new Vector<String>();
        for (ChartInfo chartInfo : this.chartInfos) {
            String[] taIds;
            IAlertable alertable = this.getIAlertable(chartInfo);
            if (alertable == null || (taIds = alertable.getTriggeredAlertIds()) == null) continue;
            for (String taId : taIds) {
                triggeredAlertVect.add(QbUtil.urlDecode(chartInfo.name) + "/" + taId);
            }
        }
        if (triggeredAlertVect.size() == 0) {
            return null;
        }
        return triggeredAlertVect.toArray(new String[triggeredAlertVect.size()]);
    }

    public Map getTriggeredAlertDetails() {
        HashMap<String, Vector<String>> result = new HashMap<String, Vector<String>>();
        for (ChartInfo chartInfo : this.chartInfos) {
            Map<String, Vector<String>> alertDetails;
            IAlertable alertable = this.getIAlertable(chartInfo);
            if (alertable == null || (alertDetails = alertable.getTriggeredAlertDetails()) == null) continue;
            for (Map.Entry<String, Vector<String>> entry : alertDetails.entrySet()) {
                result.put(QbUtil.urlDecode(chartInfo.name) + "/" + entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private IAlertable getIAlertable(ChartInfo chartInfo) {
        if (chartInfo.chart != null) {
            return chartInfo.chart;
        }
        if (chartInfo.report != null) {
            return chartInfo.report;
        }
        if (chartInfo.qbMap != null) {
            return chartInfo.qbMap;
        }
        return null;
    }

    public Vector getWatchedTemplates() {
        if (this.alertObjList == null) {
            return null;
        }
        Vector<ChartInfo> templateList = new Vector<ChartInfo>();
        block0: for (AlertAttr element : this.alertObjList) {
            boolean[] isWatched = element.getIsWatched();
            String templateInfoID = null;
            for (boolean element2 : isWatched) {
                if (!element2) continue;
                templateInfoID = element.getTemplateInfoID();
                break;
            }
            if (templateInfoID == null) continue;
            StringTokenizer st = new StringTokenizer(templateInfoID, ",");
            st.nextToken();
            String nodeIDStr = st.nextToken();
            String itemIDStr = st.nextToken();
            int nodeID = Integer.parseInt(nodeIDStr);
            int itemID = Integer.parseInt(itemIDStr);
            for (ChartInfo chartInfo : this.chartInfos) {
                if (nodeID != chartInfo.nodeID || itemID != chartInfo.itemID) continue;
                templateList.add(chartInfo);
                continue block0;
            }
        }
        return templateList;
    }

    public Vector getParameterList() {
        return this.getParameterList(false);
    }

    public Vector getParameterList(boolean loadDistinctValue) {
        Vector<ParamInfo> paramInfoList = new Vector<ParamInfo>();
        if (this.sharedParams != null && this.sharedParams.length > 0) {
            for (SharedParam sharedParam : this.sharedParams) {
                ParamInfo pInfo = new ParamInfo();
                pInfo.setParamName(sharedParam.paramName);
                pInfo.setDataType(sharedParam.sqlType);
                pInfo.setDefaultValue(sharedParam.defaultValue);
                Vector templateParamList = sharedParam.chartParamList;
                Vector<String> templatePaths = new Vector<String>();
                Vector<String> paramNameList = new Vector<String>();
                for (int j = 0; j < templateParamList.size(); ++j) {
                    String templateParamStr = (String)templateParamList.elementAt(j);
                    int loc = templateParamStr.indexOf("__");
                    String templateInfoID = templateParamStr.substring(0, loc);
                    String paramName = templateParamStr.substring(loc + 2);
                    if (j == 0) {
                        boolean isMultiple = this.isTemplateParamMultiValue(templateInfoID, paramName);
                        pInfo.setMultiValue(isMultiple);
                        if (loadDistinctValue) {
                            Object distVals = this.getTemplateParamDistinctValues(templateInfoID, paramName);
                            pInfo.setDistinctValues(this.getDistinctValues(distVals));
                        }
                    }
                    templatePaths.add(this.getFilePath(templateInfoID));
                    paramNameList.add(paramName);
                }
                pInfo.setFilePaths(templatePaths);
                pInfo.setParamNameForTemplate(paramNameList);
                pInfo.setSharedParam(true);
                paramInfoList.add(pInfo);
            }
        }
        for (ChartInfo chartInfo : this.chartInfos) {
            String templateInfoID = chartInfo.name + "," + chartInfo.nodeID + "," + chartInfo.itemID;
            Map paramList = chartInfo.filterParamList;
            for (Map.Entry entry : paramList.entrySet()) {
                String paramName = (String)entry.getKey();
                if (this.isParamShared(templateInfoID, paramName)) continue;
                Object obj = entry.getValue();
                ParamInfo pInfo = new ParamInfo();
                pInfo.setParamName(paramName);
                pInfo.setDataType(this.getTemplateParamDataType(templateInfoID, paramName));
                pInfo.setMultiValue(this.isTemplateParamMultiValue(templateInfoID, paramName));
                pInfo.setDefaultValue(obj);
                Vector<String> filePaths = new Vector<String>();
                Vector<String> paramNameVect = new Vector<String>();
                filePaths.add(chartInfo.path);
                paramNameVect.add(paramName);
                pInfo.setFilePaths(filePaths);
                pInfo.setParamNameForTemplate(paramNameVect);
                pInfo.setSharedParam(false);
                try {
                    pInfo.setChartInfo(chartInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (loadDistinctValue) {
                    Object distVals = this.getTemplateParamDistinctValues(templateInfoID, paramName);
                    pInfo.setDistinctValues(this.getDistinctValues(distVals));
                }
                paramInfoList.add(pInfo);
            }
        }
        return paramInfoList;
    }

    private Vector getDistinctValues(Object distValObj) {
        if (distValObj == null) {
            return null;
        }
        Vector distinctValues = null;
        if (distValObj instanceof Vector) {
            distinctValues = (Vector)distValObj;
        } else if (distValObj instanceof ArrayList) {
            ArrayList al = (ArrayList)distValObj;
            distinctValues = (Vector)al.get(1);
        }
        return distinctValues;
    }

    private String getFilePath(String templateInfoID) {
        String path = null;
        StringTokenizer st = new StringTokenizer(templateInfoID, ",");
        st.nextToken();
        String nodeIDStr = st.nextToken();
        String itemIDStr = st.nextToken();
        int nodeID = Integer.parseInt(nodeIDStr);
        int itemID = Integer.parseInt(itemIDStr);
        for (ChartInfo chartInfo : this.chartInfos) {
            if (nodeID != chartInfo.nodeID || itemID != chartInfo.itemID) continue;
            path = chartInfo.path;
            break;
        }
        return path;
    }

    private AlertAttr getAlertAttrFor(ChartInfo chartInfo) {
        AlertAttr aa = null;
        if (this.alertObjList == null) {
            return null;
        }
        for (AlertAttr element : this.alertObjList) {
            String templateInfoID = element.getTemplateInfoID();
            StringTokenizer st = new StringTokenizer(templateInfoID, ",");
            st.nextToken();
            String nodeIDStr = st.nextToken();
            String itemIDStr = st.nextToken();
            int nodeID = Integer.parseInt(nodeIDStr);
            int itemID = Integer.parseInt(itemIDStr);
            if (chartInfo.nodeID != nodeID || chartInfo.itemID != itemID) continue;
            aa = element;
            break;
        }
        return aa;
    }

    private boolean isParamShared(String templateInfoID, String templateParamName) {
        if (this.sharedParams == null || this.sharedParams.length == 0) {
            return false;
        }
        boolean found = false;
        StringTokenizer st = new StringTokenizer(templateInfoID, ",");
        st.nextToken();
        int inNodeID = Integer.parseInt(st.nextToken());
        int inItemID = Integer.parseInt(st.nextToken());
        for (SharedParam sharedParam : this.sharedParams) {
            Vector templateParamList = sharedParam.chartParamList;
            for (int j = 0; j < templateParamList.size(); ++j) {
                String templateParamStr = (String)templateParamList.elementAt(j);
                int loc = templateParamStr.indexOf("__");
                String tiid = templateParamStr.substring(0, loc);
                st = new StringTokenizer(tiid, ",");
                st.nextToken();
                int nodeID = Integer.parseInt(st.nextToken());
                int itemID = Integer.parseInt(st.nextToken());
                String paramName = templateParamStr.substring(loc + 2);
                if (inNodeID != nodeID || inItemID != itemID || !paramName.equals(templateParamName)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        return found;
    }

    private int getTemplateParamDataType(String templateInfoID, String paramName) {
        quadbase.common.util.IQueryInParam targetParam = this.getTemplateParam(templateInfoID, paramName);
        if (targetParam == null) {
            return -999;
        }
        return targetParam.getSqlType();
    }

    private boolean isTemplateParamMultiValue(String templateInfoID, String paramName) {
        quadbase.common.util.IQueryInParam targetParam = this.getTemplateParam(templateInfoID, paramName);
        if (targetParam == null) {
            return false;
        }
        return targetParam instanceof IQueryMultiValueInParam;
    }

    private quadbase.common.util.IQueryInParam getTemplateParam(String templateInfoID, String paramName) {
        if (this.chartInfos == null) {
            return null;
        }
        ChartInfo chartInfo = this.getChartInfoById(templateInfoID);
        if (chartInfo == null) {
            return null;
        }
        quadbase.common.util.IQueryInParam targetParam = null;
        if (chartInfo.chart != null) {
            targetParam = this.getChartParam(chartInfo.chart, paramName);
        } else if (chartInfo.report != null) {
            targetParam = this.getReportParam(chartInfo.report, paramName);
        } else if (chartInfo.qbMap != null) {
            targetParam = this.getMapParam(chartInfo.qbMap, paramName);
        }
        return targetParam;
    }

    private quadbase.common.util.IQueryInParam getReportParam(QbReport report, String paramName) {
        quadbase.reportdesigner.util.IInputData inputData = report.getInputData();
        if (inputData.getDatabaseInfo() == null || !(inputData.getDatabaseInfo() instanceof quadbase.reportdesigner.util.IQueryFileInfo)) {
            return null;
        }
        quadbase.reportdesigner.util.IQueryFileInfo queryInfo = (quadbase.reportdesigner.util.IQueryFileInfo)inputData.getDatabaseInfo();
        IQueryInParam targetParam = null;
        if (queryInfo != null) {
            IQueryInParam[] queryParamSet;
            for (IQueryInParam element : queryParamSet = QbUtil.getInParam(queryInfo)) {
                if (!element.getParamName().equals(paramName)) continue;
                targetParam = element;
                break;
            }
            return targetParam;
        }
        return null;
    }

    private quadbase.common.util.IQueryInParam getChartParam(QbChart chart, String paramName) {
        IInputData inputData = chart.gethInputData();
        if (inputData.getDatabaseInfo() == null || !(inputData.getDatabaseInfo() instanceof IQueryFileInfo)) {
            return null;
        }
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
        if (queryInfo != null) {
            IQueryInParam[] queryParamSet;
            IQueryInParam targetParam = null;
            for (IQueryInParam element : queryParamSet = QbUtil.getInParam(queryInfo)) {
                if (!element.getParamName().equals(paramName)) continue;
                targetParam = element;
                break;
            }
            return targetParam;
        }
        return null;
    }

    private quadbase.common.util.IQueryInParam getMapParam(QbMap qbMap, String paramName) {
        DataSource ds = qbMap.getDataSource();
        if (!ds.isParameterized()) {
            return null;
        }
        ParameterizedDataSource pds = (ParameterizedDataSource)ds;
        IQueryFileInfo queryInfo = pds.getQueryFileInfo();
        if (queryInfo != null) {
            IQueryInParam[] queryParamSet;
            IQueryInParam targetParam = null;
            for (IQueryInParam element : queryParamSet = QbUtil.getInParam(queryInfo)) {
                if (!element.getParamName().equals(paramName)) continue;
                targetParam = element;
                break;
            }
            return targetParam;
        }
        return null;
    }

    public static boolean isChart(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".CHT") || fileLocation.toUpperCase().endsWith(".QCH") || fileLocation.toUpperCase().endsWith(".TPL") || fileLocation.toUpperCase().endsWith(".PAC") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLChart((String)fileLocation);
    }

    public static boolean isReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".RPT") || fileLocation.toUpperCase().endsWith(".QRP") || fileLocation.toUpperCase().endsWith(".PAK") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLReport((String)fileLocation);
    }

    public static boolean isPakReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".PAK");
    }

    public static boolean isGoogleMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".GXML");
    }

    public static boolean isSvgMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".SXML");
    }

    public static boolean isMap(String fileLocation) {
        return QbDashboard.isGoogleMap(fileLocation) || QbDashboard.isSvgMap(fileLocation);
    }

    public static boolean isDashboard(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".DSB");
    }

    public String getChartName(String savedChartName) {
        int loc = savedChartName.indexOf("-NODE-");
        String s = savedChartName;
        if (loc > 0) {
            s = savedChartName.substring(0, loc);
        }
        return s;
    }

    public ChartInfo[] getChartInfos() {
        return this.chartInfos;
    }

    public String getDashboardFileName() {
        return this.dashboardFileName;
    }

    public void setDashboardFileName(String dashboardFileName) {
        this.dashboardFileName = dashboardFileName;
    }

    public void setChartInfos(ChartInfo[] chartInfos) {
        this.chartInfos = chartInfos;
    }

    public SharedParam[] getSharedParams() {
        return this.sharedParams;
    }

    public void setSharedParams(SharedParam[] sharedParams) {
        this.sharedParams = sharedParams;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String[] getLabelProperties() {
        return this.labelProperties;
    }

    public void setLabelProperties(String[] labelProperties) {
        this.labelProperties = labelProperties;
    }

    public String[] getTemplateParamType() {
        return this.templateParamType;
    }

    public void setTemplateParamType(String[] templateParamType) {
        this.templateParamType = templateParamType;
    }

    public Hashtable getTemplatePositions() {
        return this.templatePositions;
    }

    public void setTemplatePositions(Hashtable templatePositions) {
        this.templatePositions = templatePositions;
    }

    public String getDbBackground() {
        return this.dbBackground;
    }

    public void setDbBackground(String dbBackground) {
        this.dbBackground = dbBackground;
    }

    public String[] getLabelBGImage() {
        return this.labelBGImage;
    }

    public void setLabelBGImage(String[] labelBGImage) {
        this.labelBGImage = labelBGImage;
    }

    public String[] getSpExpPanelAttrs() {
        return this.spExpPanelAttrs;
    }

    public void setSpExpPanelAttrs(String[] spExpPanelAttrs) {
        this.spExpPanelAttrs = spExpPanelAttrs;
    }

    public String[] getSpExpButnAttrs() {
        return this.spExpButnAttrs;
    }

    public void setSpExpButnAttrs(String[] spExpButnAttrs) {
        this.spExpButnAttrs = spExpButnAttrs;
    }

    public String[] getSpExpIconMap() {
        return this.spExpIconMap;
    }

    public void setSpExpIconMap(String[] spExpIconMap) {
        this.spExpIconMap = spExpIconMap;
    }

    public String getSpDetPanelAttr() {
        return this.spDetPanelAttr;
    }

    public void setSpDetPanelAttr(String spDetPanelAttr) {
        this.spDetPanelAttr = spDetPanelAttr;
    }

    public String getSpDetParamAttr() {
        return this.spDetParamAttr;
    }

    public void setSpDetParamAttr(String spDetParamAttr) {
        this.spDetParamAttr = spDetParamAttr;
    }

    public Hashtable getPreviewOptionProps() {
        return this.previewOptionProps;
    }

    public void setPreviewOptionProps(Hashtable previewOptionProps) {
        this.previewOptionProps = previewOptionProps;
    }

    public String getFolderAttrs() {
        return this.folderAttrs;
    }

    public void setFolderAttrs(String folderAttrs) {
        this.folderAttrs = folderAttrs;
    }

    public String getComboParamAttrs() {
        return this.comboParamAttrs;
    }

    public void setComboParamAttrs(String comboParamAttrs) {
        this.comboParamAttrs = comboParamAttrs;
    }

    public String getLinkAttrs() {
        return this.linkAttrs;
    }

    public void setLinkAttrs(String linkAttrs) {
        this.linkAttrs = linkAttrs;
    }

    public String getZIndexAttr() {
        return this.zIndexAttr;
    }

    public void setZIndexAttr(String indexAttr) {
        this.zIndexAttr = indexAttr;
    }

    public String getTemplateLinkToDB() {
        return this.templateLinkToDB;
    }

    public void setTemplateLinkToDB(String templateLinkToDB) {
        this.templateLinkToDB = templateLinkToDB;
    }

    public String getAlertAttrs() {
        return this.alertAttrs;
    }

    public void setAlertAttrs(String alertAttrs) {
        this.alertAttrs = alertAttrs;
        if (alertAttrs != null && alertAttrs.length() > 0) {
            this.alertObjList = this.toAlertAttrArray(alertAttrs);
        }
    }

    public AlertAttr[] getAlertObjList() {
        return this.alertObjList;
    }

    public void setAlertObjList(AlertAttr[] alertObjList) {
        this.alertObjList = alertObjList;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getPositionStr() {
        return this.positionStr;
    }

    public void setPositionStr(String[] positionStr) {
        this.positionStr = positionStr;
    }

    public String[] getSharedParamStr() {
        return this.sharedParamStr;
    }

    public void setSharedParamStr(String[] sharedParamStr) {
        this.sharedParamStr = sharedParamStr;
    }

    public String[] getDrillDownStr() {
        return this.drillDownStr;
    }

    public void setDrillDownStr(String[] drillDownStr) {
        this.drillDownStr = drillDownStr;
    }

    public String getPreviewOptions() {
        return this.previewOptions;
    }

    public void setPreviewOptions(String previewOptions) {
        this.previewOptions = previewOptions;
    }

    public OrganizerDataProxy getDataProxy() {
        return this.dataProxy;
    }

    public void setDataProxy(OrganizerDataProxy dataProxy) {
        this.dataProxy = dataProxy;
    }

    private boolean isAdmin() {
        String user = this.userName;
        if (user == null) {
            return false;
        }
        return OrganizerDataImpl.isAdmin((String)user);
    }
}

