/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.dashboard.api.ChartInfo;
import quadbase.dashboard.api.QbDashboard;
import quadbase.reportorganizer.data.OrganizerDataImpl;
import quadbase.reportorganizer.data.OrganizerNode;
import quadbase.reportorganizer.data.PathImpl;
import quadbase.reportorganizer.data.UrlMap;
import quadbase.reportorganizer.data.Util;

public class SaveDashboard {
    public static final int VERSION = 5;
    private QbDashboard qbDashboard;
    private OrganizerDataImpl db;

    public SaveDashboard(QbDashboard qbDashboard) {
        this.qbDashboard = qbDashboard;
    }

    public boolean save(int nodeID, String filePath, String userName, boolean saveToDB, String removeAddr) {
        return true;
    }

    public boolean saveLocally(int nodeID, String filePath, String userName, boolean saveToDB, String remoteAddr) throws Exception {
        if (this.db == null) {
            System.out.println("Error: Please set OrganizerDataImpl before calling save dashboard");
            return false;
        }
        byte[] dashboardBytes = this.toDashboardBytes();
        String absFileName = "";
        if (saveToDB) {
            int id = this.db.getNewDashboardDataID(null, null, remoteAddr, 3);
            absFileName = OrgUtil.createDashboardDataID(id);
            OrgUtil.setDashboardData(absFileName, dashboardBytes);
        } else {
            absFileName = OrganizerDataImpl.getPath((String)filePath);
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(dashboardBytes, absFileName);
        }
        String dsbURL = null;
        dsbURL = saveToDB ? Util.createURL((UrlMap)this.db.getUrlMapping(null, null), (String)absFileName) : absFileName;
        PathImpl path = new PathImpl(nodeID);
        if (path.isPathExisted(this.db, absFileName)) {
            System.out.println("Save Dashboard Error: File: " + absFileName + " already exists");
            return false;
        }
        int pos = path.getRowCount(null, null);
        int lastSlash = filePath.replaceAll("\\", "/").lastIndexOf(47);
        String fileName = filePath;
        if (lastSlash > 0) {
            fileName = filePath.substring(lastSlash + 1);
        }
        String orgName = filePath.substring(0, fileName.length() - 4);
        Object[] data = path.createRowData(userName, orgName, "", absFileName, dsbURL, pos);
        path.addRow(null, null, data, remoteAddr, 3);
        return true;
    }

    private byte[] toDashboardBytes() throws Exception {
        String[] labelBGSettings;
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        out.writeInt(5);
        out.writeInt(20);
        ChartInfo[] chartInfos = this.qbDashboard.getChartInfos();
        String[] positionStr = this.qbDashboard.getPositionStr();
        out.writeInt(chartInfos.length);
        for (int i = 0; i < chartInfos.length; ++i) {
            IOUtil.writeString(out, this.translateToPath(chartInfos[i].getChartStr()));
            IOUtil.writeString(out, positionStr[i]);
        }
        String[] sharedParamStr = this.qbDashboard.getSharedParamStr();
        if (sharedParamStr == null) {
            out.writeInt(0);
        } else {
            out.writeInt(sharedParamStr.length);
            for (String element : sharedParamStr) {
                IOUtil.writeString(out, element);
            }
        }
        String[] drillDownParamStr = this.qbDashboard.getDrillDownStr();
        if (drillDownParamStr == null) {
            out.writeInt(0);
        } else {
            out.writeInt(drillDownParamStr.length);
            for (String element : drillDownParamStr) {
                IOUtil.writeString(out, element);
            }
        }
        Hashtable templatePositions = this.qbDashboard.getTemplatePositions();
        if (templatePositions != null) {
            out.writeInt(templatePositions.size());
            Enumeration tpEnum = templatePositions.keys();
            while (tpEnum.hasMoreElements()) {
                String templateName = (String)tpEnum.nextElement();
                String pos = (String)templatePositions.get(templateName);
                IOUtil.writeString(out, templateName + ":" + pos);
            }
        } else {
            out.writeInt(0);
        }
        String[] textLabelProp = this.qbDashboard.getLabelProperties();
        if (textLabelProp != null) {
            out.writeInt(textLabelProp.length);
            for (String element : textLabelProp) {
                IOUtil.writeString(out, element);
            }
        } else {
            out.writeInt(0);
        }
        String[] templateParamType = this.qbDashboard.getTemplateParamType();
        if (templateParamType != null) {
            out.writeInt(templateParamType.length);
            for (String element : templateParamType) {
                IOUtil.writeString(out, element);
            }
        } else {
            out.writeInt(0);
        }
        String bgSetting = this.qbDashboard.getDbBackground();
        if (bgSetting != null && !bgSetting.equals("")) {
            IOUtil.writeString(out, bgSetting);
        }
        if ((labelBGSettings = this.qbDashboard.getLabelBGImage()) != null) {
            out.writeInt(labelBGSettings.length);
            for (String labelBGSetting : labelBGSettings) {
                IOUtil.writeString(out, labelBGSetting);
            }
        } else {
            out.writeInt(0);
        }
        String[] spExpPanelAttr = this.qbDashboard.getSpExpPanelAttrs();
        if (spExpPanelAttr == null || spExpPanelAttr.length == 0) {
            IOUtil.writeString(out, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < spExpPanelAttr.length; ++i) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(spExpPanelAttr[i]);
            }
            IOUtil.writeString(out, buf.toString());
        }
        String[] spExpButnAttr = this.qbDashboard.getSpExpButnAttrs();
        if (spExpButnAttr == null || spExpButnAttr.length == 0) {
            IOUtil.writeString(out, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < spExpButnAttr.length; ++i) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(spExpButnAttr[i]);
            }
            IOUtil.writeString(out, buf.toString());
        }
        String[] spExpIconMap = this.qbDashboard.getSpExpIconMap();
        if (spExpIconMap == null || spExpIconMap.length == 0) {
            IOUtil.writeString(out, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < spExpIconMap.length; ++i) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(spExpIconMap[i]);
            }
            IOUtil.writeString(out, buf.toString());
        }
        String spDetPanelAttr = this.qbDashboard.getSpDetPanelAttr();
        if (spDetPanelAttr == null || spDetPanelAttr.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, spDetPanelAttr);
        }
        String spDetParamAttr = this.qbDashboard.getSpDetParamAttr();
        if (spDetParamAttr == null || spDetParamAttr.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, spDetParamAttr);
        }
        String dbOptions = this.qbDashboard.getPreviewOptions();
        if (dbOptions == null || dbOptions.trim().equals("")) {
            IOUtil.writeString(out, "CanResize:false;CanMove:false;ShowToolbar:true;ShowHeader:true;RptSinglePage:false");
        } else {
            IOUtil.writeString(out, dbOptions);
        }
        String folderAttrs = this.qbDashboard.getFolderAttrs();
        if (folderAttrs == null || folderAttrs.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, folderAttrs);
        }
        String comboParamAttrs = this.qbDashboard.getComboParamAttrs();
        if (comboParamAttrs == null || comboParamAttrs.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, comboParamAttrs);
        }
        String linkAttrs = this.qbDashboard.getLinkAttrs();
        if (linkAttrs == null || linkAttrs.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, linkAttrs);
        }
        String zIndexAttr = this.qbDashboard.getZIndexAttr();
        if (zIndexAttr == null || zIndexAttr.trim().equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, zIndexAttr);
        }
        String templateLinkToDB = this.qbDashboard.getTemplateLinkToDB();
        if (templateLinkToDB == null || templateLinkToDB.equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, templateLinkToDB);
        }
        String alertAttrs = this.qbDashboard.getAlertAttrs();
        if (alertAttrs == null || alertAttrs.equals("")) {
            IOUtil.writeString(out, "none");
        } else {
            IOUtil.writeString(out, alertAttrs);
        }
        out.close();
        fstream.close();
        return fstream.toByteArray();
    }

    private String translateToPath(String chartPath) {
        int idx = chartPath.indexOf("-K-");
        String tmp = chartPath;
        String paramList = "";
        if (idx > 0) {
            tmp = chartPath.substring(0, idx);
            paramList = tmp.substring(idx);
        }
        int lastIdx = tmp.lastIndexOf(44);
        int itemID = Integer.valueOf(tmp.substring(lastIdx + 1));
        String name = tmp.substring(0, lastIdx);
        lastIdx = name.lastIndexOf(44);
        int nodeID = Integer.valueOf(name.substring(lastIdx + 1));
        name = name.substring(0, lastIdx);
        String nodeStr = "";
        String itemStr = "";
        try {
            OrganizerNode rootNode = this.db.getRootNode(null, null);
            OrganizerNode nodeObj = rootNode.findChild(nodeID);
            nodeStr = Util.getNodeToString((DefaultMutableTreeNode)nodeObj);
            itemStr = (String)nodeObj.getTable().getValueAt(null, null, itemID, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String val = name + "," + nodeID + "," + itemID + "-NODE-" + nodeStr + "-ITEM-" + itemStr + paramList;
        return val;
    }

    public OrganizerDataImpl getDb() {
        return this.db;
    }

    public void setDb(OrganizerDataImpl db) {
        this.db = db;
    }
}

