/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.api;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateParamValue {
    private String templateInfoID = "";
    private Hashtable paramValueTable;

    public TemplateParamValue() {
        this.paramValueTable = new Hashtable();
    }

    public TemplateParamValue(String templateInfoID, Hashtable paramValueTable) {
        this.templateInfoID = templateInfoID;
        this.paramValueTable = paramValueTable;
    }

    public void addParamValue(String paramName, Object paramValue) {
        Vector vect;
        Object paramObj = this.paramValueTable.get(paramValue);
        if (paramObj == null) {
            this.paramValueTable.put(paramName, paramValue);
        } else if (paramObj instanceof String) {
            Vector<String> vect2 = new Vector<String>();
            String pvStr = (String)paramValue;
            vect2.add(pvStr);
            this.paramValueTable.put(paramName, vect2);
        } else if (paramObj instanceof Vector && !(vect = (Vector)paramObj).contains(paramValue)) {
            vect.add(paramValue);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put("tn", (Object)this.templateInfoID);
            JSONArray paramJA = new JSONArray();
            Enumeration pvEnum = this.paramValueTable.keys();
            while (pvEnum.hasMoreElements()) {
                String paramName = (String)pvEnum.nextElement();
                JSONArray paramValueJA = new JSONArray();
                Object pvObj = this.paramValueTable.get(paramName);
                if (pvObj instanceof Vector) {
                    Vector pvVect = (Vector)pvObj;
                    paramValueJA = new JSONArray((Collection)pvVect);
                } else if (pvObj instanceof String) {
                    paramValueJA.put(pvObj);
                } else {
                    paramValueJA.put((Object)pvObj.toString());
                }
                JSONObject paramJObj = new JSONObject();
                paramJObj.put("pn", (Object)paramName);
                paramJObj.put("pv", (Object)paramValueJA);
                paramJA.put((Object)paramJObj);
            }
            jObj.put("p", (Object)paramJA);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj;
    }

    public String toString() {
        JSONObject jObj = this.toJSONObject();
        return jObj.toString();
    }

    public String getTemplateInfoID() {
        return this.templateInfoID;
    }

    public void setTemplateInfoID(String templateInfoID) {
        this.templateInfoID = templateInfoID;
    }

    public Hashtable getParamValueTable() {
        return this.paramValueTable;
    }

    public void setParamValueTable(Hashtable paramValueTable) {
        this.paramValueTable = paramValueTable;
    }
}

