/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import quadbase.common.paramquery.OurMessageDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard.api.ParamInfo;
import quadbase.dashboard.api.SharedParam;

public class EnterParameterDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JComponent[] paramSelector;
    private Vector paramList;
    private boolean cancelled = true;

    public EnterParameterDialog(Dialog parent, Vector paramList) {
        super(parent, true);
        this.paramList = paramList;
        this.init();
    }

    public void setParameterValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.paramSelector[i] instanceof JTextField) {
                ((JTextField)this.paramSelector[i]).setText(values[i] != null ? values[i].toString() : "");
                continue;
            }
            if (this.paramSelector[i] instanceof JList) {
                this.selectValues((JList)this.paramSelector[i], (Vector)values[i]);
                continue;
            }
            if (!(this.paramSelector[i] instanceof JComboBox)) continue;
            this.selectValue((JComboBox)this.paramSelector[i], values[i]);
        }
    }

    public Object[] getParameterValues() {
        Object[] result = new Object[this.paramSelector.length];
        for (int i = 0; i < this.paramSelector.length; ++i) {
            if (this.paramSelector[i] instanceof JTextField) {
                result[i] = ((JTextField)this.paramSelector[i]).getText();
                continue;
            }
            if (this.paramSelector[i] instanceof JList) {
                Object[] selectedValues = ((JList)this.paramSelector[i]).getSelectedValues();
                Vector<Object> v = new Vector<Object>(selectedValues.length);
                for (Object selectedValue : selectedValues) {
                    v.add(((ValueDescriptionPair)selectedValue).getValue());
                }
                result[i] = v;
                continue;
            }
            if (!(this.paramSelector[i] instanceof JComboBox)) continue;
            Object selectedValue = ((JComboBox)this.paramSelector[i]).getSelectedItem();
            result[i] = ((ValueDescriptionPair)selectedValue).getValue();
        }
        return result;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void init() {
        this.setTitle(LanguageEncoder.getText(LanguageEncoder.getText("Set Parameters")));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel paramPanel = new JPanel(gbl);
        paramPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please enter values")));
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.paramSelector = new JComponent[this.paramList.size()];
        for (int i = 0; i < this.paramList.size(); ++i) {
            JComboBox<ValueDescriptionPair> comboBox;
            ParamInfo paramInfo = (ParamInfo)this.paramList.get(i);
            String name = paramInfo.isSharedParam() ? paramInfo.getParamName() + " (shared)" : QbUtil.urlDecode(paramInfo.getChartInfo().name) + "/" + paramInfo.getParamName();
            gbc.weightx = 0.0;
            gbc.gridy = i;
            gbc.gridx = 0;
            paramPanel.add((Component)new JLabel(name + ":"), gbc);
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            ValueDescriptionPair[] distinctValues = this.convertToValueDescriptionPairs(paramInfo.getDistinctValues());
            if (distinctValues == null) {
                this.paramSelector[i] = new JTextField(paramInfo.getDefaultValue() != null ? paramInfo.getDefaultValue().toString() : "");
                paramPanel.add((Component)this.paramSelector[i], gbc);
                continue;
            }
            if (paramInfo.isMultiValue()) {
                JList<ValueDescriptionPair> list;
                this.paramSelector[i] = list = new JList<ValueDescriptionPair>(distinctValues);
                JScrollPane scrollPane = new JScrollPane(list, 20, 31);
                list.setVisibleRowCount(5);
                this.selectValues(list, SharedParam.tokenizeValues((String)paramInfo.getDefaultValue()));
                paramPanel.add((Component)scrollPane, gbc);
                continue;
            }
            this.paramSelector[i] = comboBox = new JComboBox<ValueDescriptionPair>(distinctValues);
            this.selectValue(comboBox, paramInfo.getDefaultValue());
            paramPanel.add(comboBox, gbc);
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 15, 5));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.add("Center", paramPanel);
        this.add("South", buttonPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.checkErrors()) {
                this.cancelled = false;
                this.setVisible(false);
                this.dispose();
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void selectValues(JList list, Vector values) {
        list.clearSelection();
        if (values == null) {
            return;
        }
        ListModel model = list.getModel();
        Vector<Integer> selectedIndexes = new Vector<Integer>(values.size());
        for (int i = 0; i < model.getSize(); ++i) {
            ValueDescriptionPair pair = (ValueDescriptionPair)model.getElementAt(i);
            Object val = pair.getValue();
            if (val == null || !values.contains(val) && !values.contains(val.toString())) continue;
            selectedIndexes.add(i);
        }
        int[] indexes = new int[selectedIndexes.size()];
        for (int i = 0; i < selectedIndexes.size(); ++i) {
            indexes[i] = (Integer)selectedIndexes.get(i);
        }
        list.setSelectedIndices(indexes);
        if (indexes.length > 0) {
            list.ensureIndexIsVisible(indexes[0]);
        }
    }

    private void selectValue(JComboBox comboBox, Object value) {
        if (value == null) {
            return;
        }
        ComboBoxModel model = comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ValueDescriptionPair pair = (ValueDescriptionPair)model.getElementAt(i);
            Object val = pair.getValue();
            if (val == null || !value.equals(val) && !value.toString().equals(val.toString())) continue;
            comboBox.setSelectedIndex(i);
            return;
        }
    }

    private ValueDescriptionPair[] convertToValueDescriptionPairs(Object vals) {
        ValueDescriptionPair[] result;
        if (vals instanceof Vector) {
            Vector v = (Vector)vals;
            result = new ValueDescriptionPair[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                result[i] = new ValueDescriptionPair(v.get(i), v.get(i));
            }
        } else if (vals instanceof ArrayList) {
            ArrayList list = (ArrayList)vals;
            Vector descriptions = (Vector)list.get(0);
            Vector values = (Vector)list.get(1);
            result = new ValueDescriptionPair[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                result[i] = new ValueDescriptionPair(values.get(i), descriptions.get(i));
            }
        } else {
            result = null;
        }
        return result;
    }

    private boolean checkErrors() {
        String message = "";
        for (int i = 0; i < this.paramSelector.length; ++i) {
            if (this.paramSelector[i] instanceof JList) {
                if (((JList)this.paramSelector[i]).getSelectedValue() != null) continue;
                message = message + "Select at least one value for the '" + ((ParamInfo)this.paramList.get(i)).getParamName() + "'\nparameter.\n\n";
                continue;
            }
            if (!(this.paramSelector[i] instanceof JTextField)) continue;
            ParamInfo paramInfo = (ParamInfo)this.paramList.get(i);
            Object o = null;
            try {
                o = DataType.createObject(((JTextField)this.paramSelector[i]).getText(), DataType.mapType(paramInfo.getDataType()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o != null) continue;
            message = message + "Value for the '" + paramInfo.getParamName() + "' parameter is missing\nor does not match its data type (" + DataType.getTypeName(paramInfo.getDataType()) + ").\n\n";
        }
        if (message.length() > 0) {
            OurMessageDialog.showError(this, true, message);
            return false;
        }
        return true;
    }

    private class ValueDescriptionPair {
        private Object value;
        private Object description;

        public ValueDescriptionPair(Object value, Object description) {
            this.value = value;
            this.description = description;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            if (this.description == null) {
                return "";
            }
            return this.description.toString();
        }
    }
}

