/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.components.AlertAttr;
import quadbase.dashboard3.components.Background;
import quadbase.dashboard3.components.ComboSharedParam;
import quadbase.dashboard3.components.ContainerProps;
import quadbase.dashboard3.components.DashboardAttributes;
import quadbase.dashboard3.components.DashboardOptions;
import quadbase.dashboard3.components.DetSPPanelAttributes;
import quadbase.dashboard3.components.DrillDownInfo;
import quadbase.dashboard3.components.ExpandedSharedParam;
import quadbase.dashboard3.components.FloatOrderAttributes;
import quadbase.dashboard3.components.FolderAttributes;
import quadbase.dashboard3.components.ImageLabel;
import quadbase.dashboard3.components.PseqPanelAttributes;
import quadbase.dashboard3.components.SharedParam;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TextLabel;
import quadbase.dashboard3.components.ZIndexAttr;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportorganizer.data.IOUtil;

public class DashboardLoader {
    private static final String IMAGE_SERVLET_URL = "../servlet/RPTImageGenerator?zippedUrl=";
    Vector<String> realPakFileNames;

    public JSONObject loadDB(String fileName, String userName) throws Exception {
        return this.loadDBAttributes(fileName, userName).toJSONObject();
    }

    public DashboardAttributes loadDBAttributes(String fileName, String userName) throws Exception {
        DashboardAttributes result = this.loadDBAttributesInternal(fileName, userName);
        if (fileName.toLowerCase().endsWith(".dpak")) {
            this.updateImagePaths(result, fileName);
        }
        return result;
    }

    private DashboardAttributes loadDBAttributesInternal(String fileName, String userName) throws Exception {
        if (fileName.startsWith("http://") || fileName.startsWith("https://")) {
            fileName = QbUtil.convertToHTMLFileName(fileName);
        }
        InputStream in = new ReadDataFile().getInputStream(null, fileName, true);
        if (fileName.toLowerCase().endsWith(".dpak")) {
            ZipEntry entry;
            int c;
            ZipInputStream zin = new ZipInputStream(in);
            zin.getNextEntry();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            while ((c = zin.read()) != -1) {
                bout.write(c);
            }
            in = new ByteArrayInputStream(bout.toByteArray());
            this.realPakFileNames = new Vector();
            while ((entry = zin.getNextEntry()) != null) {
                this.realPakFileNames.add(entry.getName());
            }
            zin.close();
        }
        return this.loadLocally(in, userName);
    }

    public DashboardAttributes loadLocally(InputStream in, String userName) throws Exception {
        int i;
        int i2;
        DataInputStream din = new DataInputStream(in);
        DashboardAttributes dbAttr = new DashboardAttributes();
        int version = din.readInt();
        dbAttr.setVersion(version);
        int space = din.readInt();
        dbAttr.setSpace(space);
        int chartLen = din.readInt();
        TemplateInfo[] templateInfos = new TemplateInfo[chartLen];
        for (int i3 = 0; i3 < chartLen; ++i3) {
            String templateSpecStr = IOUtil.readString((DataInput)din, (boolean)true);
            if (version >= 2) {
                try {
                    templateSpecStr = this.convertChartStrBack(templateSpecStr);
                }
                catch (Exception e) {
                    System.out.println("WARNING: Organizer Folder Path Mismatch");
                }
            }
            String positionStr = IOUtil.readString((DataInput)din, (boolean)true);
            templateInfos[i3] = new TemplateInfo(templateSpecStr);
            templateInfos[i3].setGridXY(positionStr);
        }
        dbAttr.setTemplateInfos(templateInfos);
        int sharedLen = din.readInt();
        SharedParam[] sharedParams = new SharedParam[sharedLen];
        for (int i4 = 0; i4 < sharedLen; ++i4) {
            String sharedParamStr = IOUtil.readString((DataInput)din, (boolean)true);
            sharedParams[i4] = new SharedParam(sharedParamStr);
        }
        dbAttr.setSharedParams(sharedParams);
        int drillLen = din.readInt();
        String[] drillDownStr = new String[drillLen];
        DrillDownInfo[] ddInfo = new DrillDownInfo[drillLen];
        for (int i5 = 0; i5 < drillLen; ++i5) {
            drillDownStr[i5] = IOUtil.readString((DataInput)din, (boolean)true);
            ddInfo[i5] = new DrillDownInfo(drillDownStr[i5]);
        }
        dbAttr.setDrilldowns(ddInfo);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        int posCount = din.readInt();
        block5: for (int i6 = 0; i6 < posCount; ++i6) {
            String pos = IOUtil.readString((DataInput)din, (boolean)true);
            StringTokenizer st = new StringTokenizer(pos, ":");
            String templateInfoID = st.nextToken();
            String position = st.nextToken();
            for (TemplateInfo templateInfo : templateInfos) {
                if (!templateInfo.getTemplateID().equals(templateInfoID)) continue;
                templateInfo.setPosition(position);
                continue block5;
            }
        }
        dbAttr.setTemplateInfos(templateInfos);
        int labelCount = din.readInt();
        TextLabel[] textLabels = new TextLabel[labelCount];
        for (int i7 = 0; i7 < labelCount; ++i7) {
            String labelProps = IOUtil.readString((DataInput)din, (boolean)true);
            textLabels[i7] = new TextLabel(labelProps);
        }
        dbAttr.setTextLabels(textLabels);
        int tplParamCount = din.readInt();
        Hashtable<String, Integer> templateIDTable = new Hashtable<String, Integer>();
        for (i2 = 0; i2 < templateInfos.length; ++i2) {
            templateIDTable.put(templateInfos[i2].getTemplateID(), i2);
        }
        for (i2 = 0; i2 < tplParamCount; ++i2) {
            String paramTemplateInfoID;
            Object obj;
            String templateParamType = IOUtil.readString((DataInput)din, (boolean)true);
            int loc = templateParamType.indexOf("-_-");
            if (loc < 0 || (obj = templateIDTable.get(paramTemplateInfoID = templateParamType.substring(0, loc))) == null) continue;
            int idx = (Integer)obj;
            templateInfos[idx].setParamTypeFromSpec(templateParamType);
        }
        dbAttr.setTemplateInfos(templateInfos);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String dbBackground = IOUtil.readString((DataInput)din, (boolean)true);
        Background background = new Background(dbBackground);
        dbAttr.setBackground(background);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        int labelBgCount = din.readInt();
        for (int i8 = 0; i8 < labelBgCount; ++i8) {
            String bgSpec = IOUtil.readString((DataInput)din, (boolean)true);
            String labelId = bgSpec.substring(0, bgSpec.indexOf(58));
            for (TextLabel textLabel : textLabels) {
                if (!textLabel.getId().equals(labelId)) continue;
                textLabel.setLabelBGImageFromSpec(bgSpec);
            }
        }
        dbAttr.setTextLabels(textLabels);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String expSpPanelAttrStr = IOUtil.readString((DataInput)din, (boolean)true);
        String expSpButnAttrStr = IOUtil.readString((DataInput)din, (boolean)true);
        String expSpIconMapStr = IOUtil.readString((DataInput)din, (boolean)true);
        ExpandedSharedParam[] expSpList = this.getExpSpList(expSpPanelAttrStr, expSpButnAttrStr, expSpIconMapStr);
        dbAttr.setExpSpList(expSpList);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String spDetPanelAttr = IOUtil.readString((DataInput)din, (boolean)true);
        String spDetParamAttr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!spDetPanelAttr.equals("none") && !spDetParamAttr.equals("none")) {
            DetSPPanelAttributes detParamPanel = new DetSPPanelAttributes(spDetPanelAttr, spDetParamAttr);
            dbAttr.setDetParamPanel(detParamPanel);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String previewOptions = IOUtil.readString((DataInput)din, (boolean)true);
        DashboardOptions dbOptions = new DashboardOptions(previewOptions);
        dbAttr.setDashboardOptions(dbOptions);
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String folderAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (folderAttrs.equals("none")) {
            folderAttrs = "";
        } else {
            int loc1 = 0;
            int loc2 = folderAttrs.indexOf("-_-");
            Vector<String> vect = new Vector<String>();
            while (loc2 > 0) {
                vect.addElement(folderAttrs.substring(loc1, loc2));
                loc1 = loc2 + 3;
                loc2 = folderAttrs.indexOf("-_-", loc1);
            }
            vect.addElement(folderAttrs.substring(loc1));
            FolderAttributes[] folders = new FolderAttributes[vect.size()];
            for (int i9 = 0; i9 < folders.length; ++i9) {
                folders[i9] = new FolderAttributes((String)vect.elementAt(i9));
            }
            dbAttr.setFolders(folders);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String comboParamAttrs = IOUtil.readString((DataInput)din, (boolean)true);
        if (!comboParamAttrs.equals("none")) {
            StringTokenizer st = new StringTokenizer(comboParamAttrs, "^");
            ComboSharedParam[] comboParams = new ComboSharedParam[st.countTokens()];
            int counter = 0;
            while (st.hasMoreTokens()) {
                String cpAttr = st.nextToken();
                comboParams[counter] = new ComboSharedParam(cpAttr);
                ++counter;
            }
            dbAttr.setComboParams(comboParams);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String linkAttrsStr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!linkAttrsStr.equals("none")) {
            StringTokenizer st = new StringTokenizer(linkAttrsStr, "^");
            DrillDownInfo[] linkAttrs = new DrillDownInfo[st.countTokens()];
            int counter = 0;
            while (st.hasMoreElements()) {
                String laStr = st.nextToken();
                linkAttrs[counter] = new DrillDownInfo(laStr, true);
                linkAttrs[counter].setSamePageDrillDown(true);
                ++counter;
            }
            dbAttr.setLinkAttrs(linkAttrs);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String zIndexAttr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!zIndexAttr.equals("none")) {
            StringTokenizer st = new StringTokenizer(zIndexAttr, ";");
            ZIndexAttr[] zIndexAttrs = new ZIndexAttr[st.countTokens()];
            int counter = 0;
            while (st.hasMoreTokens()) {
                String ziStr = st.nextToken();
                zIndexAttrs[counter] = new ZIndexAttr(ziStr);
                ++counter;
            }
            dbAttr.setZIndexAttrs(zIndexAttrs);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String templateLinkToDB = IOUtil.readString((DataInput)din, (boolean)true);
        if (templateLinkToDB.equals("none")) {
            templateLinkToDB = "";
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String alertAttrStr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!alertAttrStr.equals("none")) {
            this.setupAlertAttr(dbAttr, alertAttrStr);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String pSeqPanelAttr = IOUtil.readString((DataInput)din, (boolean)true);
        String pSeqParamAttr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!pSeqPanelAttr.equals("none") && !pSeqParamAttr.equals("none")) {
            PseqPanelAttributes pseqParamPanel = new PseqPanelAttributes(pSeqPanelAttr, pSeqParamAttr);
            dbAttr.setPseqParamPanel(pseqParamPanel);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        String floatOrderAttr = IOUtil.readString((DataInput)din, (boolean)true);
        if (!floatOrderAttr.equals("none")) {
            FloatOrderAttributes floatOrderAttributes = new FloatOrderAttributes(floatOrderAttr);
            dbAttr.setFloatOrderAttributes(floatOrderAttributes);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        int imgLabelCount = din.readInt();
        ImageLabel[] imgLabels = new ImageLabel[imgLabelCount];
        for (i = 0; i < imgLabels.length; ++i) {
            String imgLabelSpecStr = IOUtil.readString((DataInput)din, (boolean)true);
            imgLabels[i] = new ImageLabel(imgLabelSpecStr);
        }
        dbAttr.setImageLabels(imgLabels);
        drillLen = din.readInt();
        for (i = 0; i < drillLen; ++i) {
            drillDownStr[i] = IOUtil.readString((DataInput)din, (boolean)true);
            JSONObject ddJO = new JSONObject(drillDownStr[i]);
            ddInfo[i] = new DrillDownInfo(ddJO);
            dbAttr.setDrilldowns(ddInfo);
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        for (TemplateInfo templateInfo : templateInfos) {
            String ahfStr = IOUtil.readString((DataInput)din, (boolean)true);
            JSONObject ahfJObj = new JSONObject(ahfStr);
            JSONArray ahfJArray = ahfJObj.optJSONArray("adHocFilters");
            if (ahfJArray == null) continue;
            String tInfoID = ahfJObj.optString("templateInfoID");
            TemplateInfo[] templateInfoArray = templateInfos;
            int n = templateInfoArray.length;
            for (int j = 0; j < n; ++j) {
                TemplateInfo templateInfo2 = templateInfoArray[j];
                String tiid = templateInfo2.getTemplateID();
                if (!tiid.equals(tInfoID)) continue;
                templateInfo2.setAdHocFilters(ahfJArray, true);
            }
        }
        if (din.available() == 0) {
            din.close();
            in.close();
            return dbAttr;
        }
        for (TemplateInfo templateInfo : templateInfos) {
            String propStr = IOUtil.readString((DataInput)din, (boolean)true);
            if (propStr.equals("") || propStr.equals("none")) continue;
            ContainerProps containerProps = new ContainerProps(propStr);
            String tInfoID = containerProps.getTemplateInfoID();
            for (TemplateInfo templateInfo2 : templateInfos) {
                String tiid = templateInfo2.getTemplateID();
                if (!tiid.equals(tInfoID)) continue;
                templateInfo2.setContainerProps(containerProps);
            }
        }
        din.close();
        in.close();
        return dbAttr;
    }

    private String convertChartStrBack(String chartStr) {
        String str = "";
        int loc = chartStr.indexOf("-NODE-");
        if (loc > 0) {
            int kLoc = chartStr.indexOf("-K-", loc);
            if (kLoc > 0) {
                str = chartStr.substring(0, loc);
                str = str + chartStr.substring(kLoc);
            } else {
                str = chartStr.substring(0, loc);
            }
        } else {
            str = chartStr;
        }
        return str;
    }

    private ExpandedSharedParam[] getExpSpList(String expSpPanelStr, String expSpButnStr, String expSpIconMapStr) {
        if (expSpPanelStr == null || expSpPanelStr.equals("none")) {
            return null;
        }
        String[] panelAttr = DashboardLoader.splitString(expSpPanelStr, "none", ";");
        String[] butnAttr = DashboardLoader.splitString(expSpButnStr, "none", ";");
        String[] iconMapStr = DashboardLoader.splitString(expSpIconMapStr, "none", ";");
        ExpandedSharedParam[] expSpList = new ExpandedSharedParam[panelAttr.length];
        int currButnIndex = 0;
        int currIconMapIndex = 0;
        for (int i = 0; i < panelAttr.length; ++i) {
            int loc = panelAttr[i].indexOf(58);
            String spName = panelAttr[i].substring(0, loc);
            String butnAttrStr = "";
            for (int j = currButnIndex; j < butnAttr.length; ++j) {
                int loc2 = butnAttr[j].indexOf(58);
                String butnSpName = butnAttr[j].substring(0, loc2);
                if (!butnSpName.equals(spName)) continue;
                butnAttrStr = butnAttr[j];
                currButnIndex = j + 1;
                break;
            }
            if (butnAttrStr.equals("")) {
                System.out.println("Error: Button attribute for '" + spName + "(" + currButnIndex + ")' is not found");
                return null;
            }
            String mapStr = "";
            for (int j = currIconMapIndex; j < iconMapStr.length; ++j) {
                int loc2 = iconMapStr[j].indexOf(58);
                String imSpName = iconMapStr[j].substring(0, loc2);
                if (!imSpName.equals(spName)) continue;
                mapStr = iconMapStr[j];
                currIconMapIndex = j + 1;
                break;
            }
            if (mapStr.equals("")) {
                mapStr = "none";
            }
            expSpList[i] = new ExpandedSharedParam(panelAttr[i], butnAttrStr, mapStr);
        }
        return expSpList;
    }

    private void setupAlertAttr(DashboardAttributes da, String alertAttrStr) {
        String str = DashboardUtil.decodeString(alertAttrStr);
        try {
            TemplateInfo[] templateInfos = da.getTemplateInfos();
            JSONArray aaJArray = new JSONArray(str);
            block2: for (int i = 0; i < aaJArray.length(); ++i) {
                JSONObject aaJObj = aaJArray.getJSONObject(i);
                AlertAttr aa = new AlertAttr(aaJObj);
                String templateInfoID = aa.getTemplateInfoID();
                for (TemplateInfo templateInfo : templateInfos) {
                    String tinfoID = templateInfo.getName() + "," + templateInfo.getNodeID() + "," + templateInfo.getItemID();
                    if (!(tinfoID = DashboardUtil.decodeString(tinfoID)).equals(templateInfoID = DashboardUtil.decodeString(templateInfoID))) continue;
                    templateInfo.setAlertAttr(aa);
                    continue block2;
                }
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static String[] splitString(String str, String skipTerm, String delim) {
        if (str == null || str.equals(skipTerm) || str.trim().equals("")) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delim);
        int len = st.countTokens();
        String[] sa = new String[len];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = st.nextToken();
        }
        return sa;
    }

    private void updateImagePaths(DashboardAttributes dbAttr, String filePath) {
        int i;
        Background background = dbAttr.getBackground();
        if (background != null) {
            background.setBgImgURL(this.getZippedImagePath(background.getBgImgURL(), filePath));
        }
        TextLabel[] textLabels = dbAttr.getTextLabels();
        for (int i2 = 0; textLabels != null && i2 < textLabels.length; ++i2) {
            textLabels[i2].setBgImageURL(this.getZippedImagePath(textLabels[i2].getBgImageURL(), filePath));
        }
        ExpandedSharedParam[] expSp = dbAttr.getExpSpList();
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            expSp[i].getPanelAttr().setBgImageURL(this.getZippedImagePath(expSp[i].getPanelAttr().getBgImageURL(), filePath));
        }
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            Vector<String[]> butnImageMap = expSp[i].getButnImageMap();
            for (int j = 0; butnImageMap != null && j < butnImageMap.size(); ++j) {
                String[] pair = butnImageMap.elementAt(j);
                if (pair.equals("none")) continue;
                pair[1] = this.getZippedImagePath(pair[1], filePath);
            }
        }
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            expSp[i].getButnAttr().setBgImageURL(this.getZippedImagePath(expSp[i].getButnAttr().getBgImageURL(), filePath));
        }
        DetSPPanelAttributes detParamPanel = dbAttr.getDetParamPanel();
        if (detParamPanel != null) {
            detParamPanel.setBgImageURL(this.getZippedImagePath(detParamPanel.getBgImageURL(), filePath));
        }
        ComboSharedParam[] combo = dbAttr.getComboParams();
        for (int i3 = 0; combo != null && i3 < combo.length; ++i3) {
            combo[i3].setBgImageURL(this.getZippedImagePath(combo[i3].getBgImageURL(), filePath));
        }
    }

    private String getZippedImagePath(String oldPath, String mainFilePath) {
        if (oldPath == null || oldPath.length() == 0 || oldPath.equals("none")) {
            return oldPath;
        }
        String newPath = "images/" + QbUtil.getFileNameForPak(oldPath);
        return "../servlet/RPTImageGenerator?zippedUrl=zip:" + mainFilePath + '?' + newPath;
    }
}

