/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.api;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.OrgUtil;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.components.AlertAttr;
import quadbase.dashboard3.components.ComboSharedParam;
import quadbase.dashboard3.components.DashboardAttributes;
import quadbase.dashboard3.components.DashboardOptions;
import quadbase.dashboard3.components.DetSPPanelAttributes;
import quadbase.dashboard3.components.DrillDownInfo;
import quadbase.dashboard3.components.ExpandedSharedParam;
import quadbase.dashboard3.components.FloatOrderAttributes;
import quadbase.dashboard3.components.FolderAttributes;
import quadbase.dashboard3.components.ImageLabel;
import quadbase.dashboard3.components.PseqPanelAttributes;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TextLabel;
import quadbase.dashboard3.components.ZIndexAttr;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportorganizer.data.DashboardDataTable;
import quadbase.reportorganizer.data.OrganizerDataImpl;
import quadbase.reportorganizer.data.OrganizerNode;
import quadbase.reportorganizer.data.PathImpl;
import quadbase.reportorganizer.data.UrlMap;
import quadbase.reportorganizer.data.UserPermission;
import quadbase.reportorganizer.data.Util;

public class DashboardSaver {
    public static final int VERSION = 6;
    public static final String JSON_KEY_SUCCESS = "success";
    public static final String JSON_KEY_MESSAGE = "message";
    public static final String JSON_KEY_NODEID = "nodeID";
    public static final String JSON_KEY_ITEMID = "itemID";
    public static final String JSON_KEY_FILEPATH = "filePath";
    public static final String FILE_EXTENSION = ".dsb";
    private int nodeID;
    private int itemID;
    private String filePath;
    private String fileName;
    private boolean saveToDB;
    private OrganizerDataImpl db;
    private boolean overwrite;
    private String remoteAddr;
    private String userName;
    private DashboardAttributes dashboardAttr;

    public DashboardSaver() {
    }

    public DashboardSaver(int nodeID, int itemID, String filePath, String fileName, String dashboardData, boolean saveToDB, OrganizerDataImpl db, boolean overWrite, String remoteAddr, String userName) {
        this.nodeID = nodeID;
        this.itemID = itemID;
        this.filePath = filePath;
        this.fileName = fileName;
        this.saveToDB = saveToDB;
        this.db = db;
        this.overwrite = overWrite;
        this.remoteAddr = remoteAddr;
        this.userName = userName;
        this.setupDashboardAttr(dashboardData);
    }

    private void setupDashboardAttr(String dashboardData) {
        try {
            JSONObject dbJObj = new JSONObject(dashboardData);
            this.dashboardAttr = new DashboardAttributes(dbJObj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String saveDashboard() {
        JSONObject msgJO = new JSONObject();
        try {
            if (this.overwrite) {
                boolean isWriteable = this.canWrite(this.userName, this.itemID);
                if (!isWriteable) {
                    msgJO.put(JSON_KEY_SUCCESS, false);
                    msgJO.put(JSON_KEY_MESSAGE, (Object)"The file is not writeable");
                    return msgJO.toString();
                }
                return this.doOverwrite();
            }
            return this.doSave();
        }
        catch (Exception e) {
            try {
                msgJO.put(JSON_KEY_SUCCESS, false);
                msgJO.put(JSON_KEY_MESSAGE, (Object)e.getMessage());
            }
            catch (JSONException je) {
                je.printStackTrace();
            }
            e.printStackTrace();
            return msgJO.toString();
        }
    }

    private String doSave() throws Exception {
        JSONObject msgJO = new JSONObject();
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        this.saveDashboard(fstream, this.dashboardAttr);
        String absFileName = "";
        if (this.saveToDB) {
            int id = this.db.getNewDashboardDataID(null, null, this.remoteAddr, 3);
            absFileName = OrgUtil.createDashboardDataID(id);
            OrgUtil.setDashboardData(absFileName, fstream.toByteArray());
        } else {
            this.filePath = this.filePath.replace('\\', '/').trim();
            if (!this.filePath.endsWith("/")) {
                this.filePath = this.filePath + "/";
            }
            String userFileName = this.getUniqueFileName(this.fileName);
            absFileName = OrganizerDataImpl.getPath((String)(this.filePath + userFileName + FILE_EXTENSION));
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(null, fstream.toByteArray(), absFileName);
        }
        int itemID = this.addToOrganizer(absFileName, this.fileName);
        msgJO.put(JSON_KEY_SUCCESS, true);
        msgJO.put(JSON_KEY_ITEMID, itemID);
        msgJO.put(JSON_KEY_FILEPATH, (Object)absFileName);
        return msgJO.toString();
    }

    private String doOverwrite() throws Exception {
        JSONObject msgJO = new JSONObject();
        if (this.itemID < 0) {
            msgJO.put(JSON_KEY_SUCCESS, false);
            msgJO.put(JSON_KEY_MESSAGE, (Object)"The Item ID is not specified or lost");
            return msgJO.toString();
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        this.saveDashboard(fstream, this.dashboardAttr);
        PathImpl path = new PathImpl(this.nodeID);
        String origFilePath = (String)path.getValueAt(null, null, this.itemID, 3);
        boolean origSaveToDB = OrgUtil.isDashboardData(origFilePath);
        String absFileName = "";
        if (this.saveToDB) {
            if (origSaveToDB) {
                absFileName = origFilePath;
                OrgUtil.setDashboardData(absFileName, fstream.toByteArray());
            } else {
                int id = this.db.getNewDashboardDataID(null, null, this.remoteAddr, 3);
                absFileName = OrgUtil.createDashboardDataID(id);
                OrgUtil.setDashboardData(absFileName, fstream.toByteArray());
                this.db.deleteFile(origFilePath);
                this.itemID = this.updateDashboardOrgPath(this.nodeID, this.itemID, absFileName, this.saveToDB);
            }
        } else if (origSaveToDB) {
            this.filePath = this.filePath.replace('\\', '/').trim();
            if (!this.filePath.endsWith("/")) {
                this.filePath = this.filePath + "/";
            }
            String userFileName = this.getUniqueFileName(this.fileName);
            absFileName = OrganizerDataImpl.getPath((String)(this.filePath + userFileName + FILE_EXTENSION));
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(null, fstream.toByteArray(), absFileName);
            this.deleteDashboardFromDB(origFilePath);
            this.itemID = this.updateDashboardOrgPath(this.nodeID, this.itemID, absFileName, this.saveToDB);
        } else {
            absFileName = origFilePath;
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(null, fstream.toByteArray(), origFilePath);
        }
        msgJO.put(JSON_KEY_SUCCESS, true);
        msgJO.put(JSON_KEY_ITEMID, this.itemID);
        msgJO.put(JSON_KEY_FILEPATH, (Object)absFileName);
        return msgJO.toString();
    }

    private String getUniqueFileName(String displayFileName) {
        return displayFileName + "_" + this.userName + "_" + System.currentTimeMillis();
    }

    private int addToOrganizer(String dashboardFilePath, String dashboardName) throws Exception {
        String dashboardURL = "";
        dashboardURL = this.saveToDB ? dashboardFilePath : Util.createURL((UrlMap)this.db.getUrlMapping(null, null), (String)dashboardFilePath);
        PathImpl path = new PathImpl(this.nodeID);
        int pos = path.getRowCount(null, null);
        Object[] data = path.createRowData(this.getUserName(), dashboardName, "Dashboard", dashboardFilePath, dashboardURL, pos, "Insert Dashboard to Organizer", this.remoteAddr, 3);
        if (this.saveToDB) {
            data[1] = "DSB File";
        }
        path.addRow(null, null, data, this.remoteAddr, 3);
        int itemID = (Integer)data[7];
        return itemID;
    }

    private int updateDashboardOrgPath(int pNodeID, int pItemID, String fileAbsPath, boolean pSaveToDB) {
        try {
            String dashboardURL = "";
            dashboardURL = pSaveToDB ? fileAbsPath : Util.createURL((UrlMap)this.db.getUrlMapping(null, null), (String)fileAbsPath);
            if (pItemID == -1) {
                return -1;
            }
            String userName = this.getUserName();
            PathImpl pathObj = new PathImpl(pNodeID);
            pathObj.setValueAt(userName, null, (Object)dashboardURL, pItemID, 4, this.remoteAddr, 3);
            pathObj.setValueAt(userName, null, (Object)fileAbsPath, pItemID, 3, this.remoteAddr, 3);
            return pItemID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void deleteDashboardFromDB(String dashboardPath) {
        int id = -1;
        if (!OrgUtil.isDashboardData(dashboardPath)) {
            return;
        }
        id = OrgUtil.getDashboardDataID(dashboardPath);
        if (id < 0) {
            return;
        }
        try {
            DashboardDataTable.remove((int)id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveDashboard(OutputStream out, DashboardAttributes da) throws Exception {
        Object[] tl;
        Object[] ddInfo;
        int n;
        TemplateInfo[] templateInfos;
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(6);
        dout.writeInt(da.getSpace());
        dout.writeInt(da.getTemplateInfos().length);
        TemplateInfo[] templateInfoArray = templateInfos = da.getTemplateInfos();
        int n2 = templateInfoArray.length;
        for (n = 0; n < n2; ++n) {
            TemplateInfo templateInfo = templateInfoArray[n];
            IOUtil.writeString(dout, this.translateToPath(templateInfo.getSelectedChartString()));
            IOUtil.writeString(dout, templateInfo.getGridPosition());
        }
        if (da.getSharedParams() == null && da.getSharedParams().length == 0) {
            dout.writeInt(0);
        } else {
            dout.writeInt(da.getSharedParams().length);
            for (int i = 0; i < da.getSharedParams().length; ++i) {
                IOUtil.writeString(dout, da.getSharedParams()[i].toString());
            }
        }
        if (da.getDrilldowns() == null) {
            dout.writeInt(0);
        } else {
            ddInfo = da.getDrilldowns();
            dout.writeInt(ddInfo.length);
            DrillDownInfo[] drillDownInfoArray = ddInfo;
            n = drillDownInfoArray.length;
            for (int templateInfo = 0; templateInfo < n; ++templateInfo) {
                DrillDownInfo element2 = drillDownInfoArray[templateInfo];
                String ddStr = element2.toString();
                IOUtil.writeString(dout, ddStr);
            }
        }
        if (templateInfos != null) {
            dout.writeInt(templateInfos.length);
            ddInfo = templateInfos;
            n2 = ddInfo.length;
            for (n = 0; n < n2; ++n) {
                Object templateInfo = ddInfo[n];
                IOUtil.writeString(dout, ((TemplateInfo)templateInfo).getPositionString());
            }
        } else {
            dout.writeInt(0);
        }
        if (da.getTextLabels() != null) {
            tl = da.getTextLabels();
            dout.writeInt(tl.length);
            TextLabel[] textLabelArray = tl;
            n = textLabelArray.length;
            for (int templateInfo = 0; templateInfo < n; ++templateInfo) {
                Object element = textLabelArray[templateInfo];
                IOUtil.writeString(dout, ((TextLabel)element).getTextSpecString());
            }
        } else {
            dout.writeInt(0);
        }
        if (templateInfos != null) {
            dout.writeInt(templateInfos.length);
            for (TemplateInfo templateInfo : templateInfos) {
                IOUtil.writeString(dout, templateInfo.getParamTypeString());
            }
        } else {
            dout.writeInt(0);
        }
        if (da.getBackground() != null) {
            IOUtil.writeString(dout, da.getBackground().toString());
        }
        if (da.getTextLabels() != null) {
            tl = da.getTextLabels();
            dout.writeInt(tl.length);
            for (Object element : tl) {
                IOUtil.writeString(dout, ((TextLabel)element).getBGSpecString());
            }
        } else {
            dout.writeInt(0);
        }
        ExpandedSharedParam[] expSpList = da.getExpSpList();
        String spExpPanelStr = this.getExpSPPanelAttrStr(expSpList);
        IOUtil.writeString(dout, spExpPanelStr);
        String spExpButnStr = this.getExpSPButnAttrStr(expSpList);
        IOUtil.writeString(dout, spExpButnStr);
        String spExpIconMapStr = this.getExpSPIconMapStr(expSpList);
        IOUtil.writeString(dout, spExpIconMapStr);
        DetSPPanelAttributes detParamPanel = da.getDetParamPanel();
        if (detParamPanel == null) {
            IOUtil.writeString(dout, "none");
            IOUtil.writeString(dout, "none");
        } else {
            String detSPPanelStr = detParamPanel.getPanelSpecString();
            String detSPParamStr = detParamPanel.getParamSpecString();
            IOUtil.writeString(dout, detSPPanelStr);
            IOUtil.writeString(dout, detSPParamStr);
        }
        DashboardOptions dbOptions = da.getDashboardOptions();
        String dbOptionStr = "CanResize:false;CanMove:false;ShowToolbar:true;ShowHeader:true;RptSinglePage:false";
        if (dbOptions != null) {
            dbOptionStr = dbOptions.toSpecString();
        }
        IOUtil.writeString(dout, dbOptionStr);
        FolderAttributes[] folders = da.getFolders();
        if (folders == null || folders.length == 0) {
            IOUtil.writeString(dout, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < folders.length; ++i) {
                if (i > 0) {
                    buf.append("-_-");
                }
                buf.append(folders[i].toSpecString());
            }
            IOUtil.writeString(dout, buf.toString());
        }
        ComboSharedParam[] comboParams = da.getComboParams();
        if (comboParams == null || comboParams.length == 0) {
            IOUtil.writeString(dout, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < comboParams.length; ++i) {
                if (i > 0) {
                    buf.append("^");
                }
                buf.append(comboParams[i].toSpecString());
            }
            IOUtil.writeString(dout, buf.toString());
        }
        DrillDownInfo[] linkAttrs = da.getLinkAttrs();
        if (linkAttrs == null || linkAttrs.length == 0) {
            IOUtil.writeString(dout, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < linkAttrs.length; ++i) {
                if (i > 0) {
                    buf.append("^");
                }
                buf.append(linkAttrs[i].toString());
            }
            IOUtil.writeString(dout, buf.toString());
        }
        ZIndexAttr[] zIndexAttrs = da.getZIndexAttrs();
        if (zIndexAttrs == null || zIndexAttrs.length == 0) {
            IOUtil.writeString(dout, "none");
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < zIndexAttrs.length; ++i) {
                if (i > 0) {
                    buf.append(";");
                }
                buf.append(zIndexAttrs[i].toSpecString());
            }
            IOUtil.writeString(dout, buf.toString());
        }
        IOUtil.writeString(dout, "none");
        IOUtil.writeString(dout, this.getAlertAttrStr(da.getTemplateInfos()));
        PseqPanelAttributes pseqParamPanel = da.getPseqParamPanel();
        if (pseqParamPanel == null) {
            IOUtil.writeString(dout, "none");
            IOUtil.writeString(dout, "none");
        } else {
            String pseqPanelStr = pseqParamPanel.getPanelSpecString();
            String pseqParamStr = pseqParamPanel.getParamSpecString();
            IOUtil.writeString(dout, pseqPanelStr);
            IOUtil.writeString(dout, pseqParamStr);
        }
        FloatOrderAttributes floatOrderAttributes = da.getFloatOrderAttributes();
        if (floatOrderAttributes == null) {
            IOUtil.writeString(dout, "none");
        } else {
            String floatOrderAttributesString = floatOrderAttributes.getFloatOrderAttributesString();
            IOUtil.writeString(dout, floatOrderAttributesString);
        }
        if (da.getImageLabels() == null) {
            dout.writeInt(0);
        } else {
            dout.writeInt(da.getImageLabels().length);
            ImageLabel[] imgLabels = da.getImageLabels();
            for (ImageLabel imageLabel : imgLabels) {
                IOUtil.writeString(dout, imageLabel.toSpecString());
            }
        }
        DrillDownInfo[] ddInfo2 = da.getDrilldowns();
        if (ddInfo2 == null || ddInfo2.length == 0) {
            dout.writeInt(0);
        } else {
            dout.writeInt(ddInfo2.length);
            for (DrillDownInfo drillDownInfo : ddInfo2) {
                JSONObject ddInfoJO = drillDownInfo.toJSONObject();
                IOUtil.writeString(dout, ddInfoJO.toString());
            }
        }
        for (TemplateInfo templateInfo : templateInfos) {
            IOUtil.writeString(dout, templateInfo.getAdHocFiltersString());
        }
        for (TemplateInfo templateInfo : templateInfos) {
            IOUtil.writeString(dout, templateInfo.getContainerPropsString());
        }
        IOUtil.writeString(dout, da.toJSONString());
        dout.flush();
        out.close();
        return "";
    }

    private String translateToPath(String chartPath) {
        int idx = chartPath.indexOf("-K-");
        String paramList = "";
        String chartInfoID = "";
        if (idx > 0) {
            chartInfoID = chartPath.substring(0, idx);
            paramList = chartPath.substring(idx);
        } else {
            chartInfoID = chartPath;
        }
        int lastIdx = chartInfoID.lastIndexOf(44);
        int itemID = Integer.valueOf(chartInfoID.substring(lastIdx + 1));
        String name = chartInfoID.substring(0, lastIdx);
        lastIdx = name.lastIndexOf(44);
        int nodeID = Integer.valueOf(name.substring(lastIdx + 1));
        name = name.substring(0, lastIdx);
        String nodeStr = "";
        String itemStr = "";
        try {
            OrganizerNode rootNode = this.db.getRootNode(null, null);
            OrganizerNode nodeObj = rootNode.findChild(nodeID);
            nodeStr = Util.getNodeToString((DefaultMutableTreeNode)nodeObj);
            itemStr = (String)nodeObj.getTable().getValueAt(null, null, itemID, 0);
        }
        catch (Exception rootNode) {
            // empty catch block
        }
        String val = name + "," + nodeID + "," + itemID + "-NODE-" + nodeStr + "-ITEM-" + itemStr + paramList;
        return val;
    }

    private String getExpSPPanelAttrStr(ExpandedSharedParam[] expSpList) {
        if (expSpList == null || expSpList.length == 0) {
            return "none";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < expSpList.length; ++i) {
            if (i == 0) {
                buf.append(expSpList[i].getPanelSpecString());
                continue;
            }
            buf.append(";" + expSpList[i].getPanelSpecString());
        }
        return buf.toString();
    }

    private String getExpSPButnAttrStr(ExpandedSharedParam[] expSpList) {
        if (expSpList == null || expSpList.length == 0) {
            return "none";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < expSpList.length; ++i) {
            if (i == 0) {
                buf.append(expSpList[i].getButnSpecString());
                continue;
            }
            buf.append(";" + expSpList[i].getButnSpecString());
        }
        return buf.toString();
    }

    private String getExpSPIconMapStr(ExpandedSharedParam[] expSpList) {
        if (expSpList == null || expSpList.length == 0) {
            return "none";
        }
        int mapCounter = 0;
        StringBuffer buf = new StringBuffer();
        for (ExpandedSharedParam element : expSpList) {
            String mapStr = element.getButnImageMapString();
            if (mapStr == null || mapStr.equals("")) continue;
            if (mapCounter == 0) {
                buf.append(mapStr);
            } else {
                buf.append(";" + mapStr);
            }
            ++mapCounter;
        }
        if (mapCounter == 0) {
            return "none";
        }
        return buf.toString();
    }

    private String getAlertAttrStr(TemplateInfo[] templateInfos) {
        JSONArray alertAttrList = new JSONArray();
        for (TemplateInfo templateInfo : templateInfos) {
            AlertAttr aa = templateInfo.getAlertAttr();
            if (aa == null) continue;
            JSONObject alertAttrJObj = aa.toJSONObject();
            alertAttrList.put((Object)alertAttrJObj);
        }
        if (alertAttrList.length() == 0) {
            return "none";
        }
        String aaStr = alertAttrList.toString();
        aaStr = DashboardUtil.encodeString(aaStr);
        return aaStr;
    }

    private boolean canWrite(String userName, int itemID) throws Exception {
        if (OrganizerDataImpl.isAdmin((String)userName)) {
            return true;
        }
        UserPermission userPerm = this.db.getFilePermission(itemID, userName);
        if (userPerm == null) {
            return false;
        }
        return userPerm.canModify;
    }

    public static String getJSONMsgString(boolean success, String msg) {
        return DashboardSaver.getJSONMessage(success, msg).toString();
    }

    public static JSONObject getJSONMessage(boolean success, String msg) {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(JSON_KEY_SUCCESS, success);
            jObj.put(JSON_KEY_MESSAGE, (Object)msg);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public int getItemID() {
        return this.itemID;
    }

    public void setItemID(int itemID) {
        this.itemID = itemID;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isSaveToDB() {
        return this.saveToDB;
    }

    public void setSaveToDB(boolean saveToDB) {
        this.saveToDB = saveToDB;
    }

    public OrganizerDataImpl getDb() {
        return this.db;
    }

    public void setDb(OrganizerDataImpl db) {
        this.db = db;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

