/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.api;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportorganizer.data.Util;

public class DashboardUtil {
    public static int getInteger(String str, int failValue) {
        int val = failValue;
        try {
            val = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static int getIntFromPX(String pxStr) {
        if (pxStr == null || pxStr.length() == 0) {
            return 0;
        }
        int loc = pxStr.toLowerCase().indexOf("px");
        if (loc < 0) {
            return DashboardUtil.getInteger(pxStr, 0);
        }
        String s = pxStr.substring(0, loc);
        return DashboardUtil.getInteger(s, 0);
    }

    public static int[] convertToColorRGB(String rgbStr) {
        int loc2;
        int[] rgb = new int[]{255, 255, 255};
        if (rgbStr.equals("transparent")) {
            return null;
        }
        int loc1 = rgbStr.indexOf(40);
        String val = rgbStr.substring(loc1 + 1, loc2 = rgbStr.indexOf(41));
        StringTokenizer st = new StringTokenizer(val, ", ");
        if (st.countTokens() < 3) {
            return rgb;
        }
        rgb[0] = DashboardUtil.getInteger(st.nextToken(), 0);
        rgb[1] = DashboardUtil.getInteger(st.nextToken(), 0);
        rgb[2] = DashboardUtil.getInteger(st.nextToken(), 0);
        return rgb;
    }

    public static String convertToColorStr(int[] rgb) {
        if (rgb == null) {
            return "transparent";
        }
        String colorStr = "rgb(";
        colorStr = colorStr + rgb[0] + "," + rgb[1] + "," + rgb[2];
        colorStr = colorStr + ")";
        return colorStr;
    }

    public static JSONArray convertToColorJSONArray(int[] rgb) {
        JSONArray ja = new JSONArray();
        for (int i = 0; rgb != null && i < rgb.length; ++i) {
            ja.put(rgb[i]);
        }
        return ja;
    }

    public static int[] convertToColorRGB(JSONArray jo) {
        int[] rgb = new int[3];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = jo.optInt(i);
        }
        return rgb;
    }

    public static String encodeString(String str) {
        return QbUtil.encodeURIComponent(str);
    }

    public static String decodeString(String str) {
        return QbUtil.urlDecode(str);
    }

    public static boolean isSelected(String item, Vector list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!item.equalsIgnoreCase((String)list.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public static Vector tokenizeValues(String str) {
        return DashboardUtil.tokenizeValues(str, -108, null);
    }

    public static Vector tokenizeValues(String str, int dataType, String custDateFormat) {
        Vector<String> vec = new Vector<String>();
        if (str == null) {
            return vec;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            if (dataType != -108) {
                Object nextToken = st.nextToken();
                try {
                    nextToken = DataType.createObject((String)nextToken, dataType, custDateFormat);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vec.addElement((String)nextToken);
                continue;
            }
            vec.addElement(st.nextToken());
        }
        return vec;
    }

    public static boolean isChart(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".CHT") || fileLocation.toUpperCase().endsWith(".QCH") || fileLocation.toUpperCase().endsWith(".TPL") || fileLocation.toUpperCase().endsWith(".PAC") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLChart((String)fileLocation);
    }

    public static boolean isReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".RPT") || fileLocation.toUpperCase().endsWith(".QRP") || fileLocation.toUpperCase().endsWith(".PAK") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLReport((String)fileLocation);
    }

    public static boolean isPakReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".PAK");
    }

    public static boolean isGoogleMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".gxml") || fileLocation.endsWith(".gpak");
    }

    public static boolean isPakGoogleMap(String fileLocation) {
        return DashboardUtil.isGoogleMap(fileLocation) && fileLocation.toLowerCase().endsWith(".gpak");
    }

    public static boolean isSvgMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".sxml") || fileLocation.endsWith(".spak");
    }

    public static boolean isPakSvgMap(String fileLocation) {
        return DashboardUtil.isSvgMap(fileLocation) && fileLocation.toLowerCase().endsWith(".spak");
    }

    public static boolean isMap(String fileLocation) {
        return DashboardUtil.isGoogleMap(fileLocation) || DashboardUtil.isSvgMap(fileLocation);
    }

    public static boolean isDashboard(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".DSB");
    }

    public static boolean isTemplateInfoIDEqual(String id1, String id2) {
        if (id1.equals(id2)) {
            return true;
        }
        StringTokenizer st1 = new StringTokenizer(id1, ",");
        StringTokenizer st2 = new StringTokenizer(id2, ",");
        String nodeID1 = "";
        String nodeID2 = "";
        String itemID1 = "";
        String itemID2 = "";
        if (st1.countTokens() != 3) {
            st1 = new StringTokenizer(DashboardUtil.decodeString(id1), ",");
        }
        st1.nextToken();
        nodeID1 = st1.nextToken().trim();
        itemID1 = st1.nextToken().trim();
        if (st2.countTokens() != 3) {
            st2 = new StringTokenizer(DashboardUtil.decodeString(id2), ",");
        }
        st2.nextToken();
        nodeID2 = st2.nextToken().trim();
        itemID2 = st2.nextToken().trim();
        return nodeID1.equals(nodeID2) && itemID1.equals(itemID2);
    }
}

