/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.api;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.SecParamInfoList;
import quadbase.common.util.internal.Coder;
import quadbase.dashboard3.api.DashboardLoader;
import quadbase.dashboard3.api.DashboardSaver;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.api.ParamInfo;
import quadbase.dashboard3.components.AlertAttr;
import quadbase.dashboard3.components.DashboardAttributes;
import quadbase.dashboard3.components.SharedParam;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TemplateParam;
import quadbase.dashboard3.components.TemplateParamForShare;
import quadbase.datasource.DataSource;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.maps.QbMap;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.IDatabaseInfo;
import quadbase.reportdesigner.util.IQbQueryFileInfo;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.reportorganizer.data.OrganizerDataImpl;
import quadbase.reportorganizer.data.OrganizerDataProxy;
import quadbase.reportorganizer.data.Path;
import quadbase.reportorganizer.data.PathImpl;
import quadbase.reportorganizer.data.Util;
import quadbase.util.IInputData;
import quadbase.util.IQueryInParam;
import quadbase.util.SimpleQueryFileInfo;
import quadbase.util.internal.QbUtil;

public class QbDashboard
extends DashboardAttributes
implements IAlertable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String userName = null;
    private SecParamInfoList secParamInfoList;
    private String dashboardFileName = "";
    private String password;
    private OrganizerDataProxy dataProxy;

    public QbDashboard() {
    }

    public QbDashboard(DashboardAttributes da) {
        this(da, null);
    }

    public QbDashboard(String filePath, String userName, String password) throws Exception {
        this(filePath, userName, password, (OrganizerDataProxy)null, false);
    }

    public QbDashboard(String filePath, String userName, String password, boolean loadTemplates) throws Exception {
        this(filePath, userName, password, (OrganizerDataProxy)null, loadTemplates);
    }

    public QbDashboard(InputStream in, String userName, String password) throws Exception {
        this(in, userName, password, (OrganizerDataProxy)null, false);
    }

    public QbDashboard(InputStream in, String userName, String password, boolean loadTemplates) throws Exception {
        this(in, userName, password, (OrganizerDataProxy)null, loadTemplates);
    }

    public QbDashboard(String filePath, String userName, String password, String eresServerURL, boolean loadTemplates) throws Exception {
        this.dashboardFileName = filePath;
        if (eresServerURL != null) {
            URL webURL = new URL(eresServerURL);
            this.dataProxy = new OrganizerDataProxy(webURL);
        }
        this.userName = userName;
        this.password = password;
        this.load(filePath, loadTemplates, false);
    }

    public QbDashboard(InputStream in, String userName, String password, String eresServerURL, boolean loadTemplates) throws Exception {
        this.userName = userName;
        this.password = password;
        if (eresServerURL != null) {
            URL webURL = new URL(eresServerURL);
            this.dataProxy = new OrganizerDataProxy(webURL);
        }
        this.load(in, loadTemplates, false);
    }

    public QbDashboard(InputStream in, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates) throws Exception {
        this.userName = userName;
        this.password = password;
        this.dataProxy = dataProxy;
        this.load(in, loadTemplates, false);
    }

    public QbDashboard(String filePath, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates) throws Exception {
        this(filePath, userName, password, dataProxy, loadTemplates, false);
    }

    public QbDashboard(String filePath, String userName, String password, OrganizerDataProxy dataProxy, boolean loadTemplates, boolean useBackupData) throws Exception {
        this.dashboardFileName = filePath;
        this.dataProxy = dataProxy;
        this.userName = userName;
        this.password = password;
        this.load(filePath, loadTemplates, false);
    }

    public QbDashboard(String filePath, String userName, OrganizerDataProxy dataProxy, SecParamInfoList infoList) throws Exception {
        this.userName = userName;
        this.dataProxy = dataProxy;
        this.secParamInfoList = infoList;
        this.load(filePath, false, false);
    }

    public QbDashboard(DashboardAttributes dashboardAttrs, String userName) {
        super(dashboardAttrs);
        this.userName = userName;
    }

    public QbDashboard(JSONObject daJObj, String userName) {
        super(daJObj);
        this.userName = userName;
    }

    private void load(InputStream in, boolean loadTemplates, boolean useBackupData) throws Exception {
        this.load(in);
        if (loadTemplates) {
            this.loadTemplates(useBackupData);
        }
    }

    public void loadTemplates(OrganizerDataProxy proxy, boolean useBackupData) throws Exception {
        this.dataProxy = proxy;
        this.loadTemplates(useBackupData);
    }

    public void loadTemplates(boolean useBackupData) throws Exception {
        TemplateInfo[] templateInfos = this.getTemplateInfos();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            Connection conn = OrganizerDataImpl.getConnection();
            for (TemplateInfo templateInfo : templateInfos) {
                this.createObject(templateInfo, conn, useBackupData);
                this.updateTemplateParamList(templateInfo);
            }
        } else {
            this.loadTemplatesFromServer(useBackupData);
        }
    }

    private void loadTemplatesFromServer(boolean useBackupData) throws Exception {
        TemplateInfo[] templateInfos;
        if (this.dataProxy == null) {
            throw new Exception("Please provide OrganizerDataProxy instance using setDataProxy(...) method");
        }
        for (TemplateInfo templateInfo : templateInfos = this.getTemplateInfos()) {
            this.createObjectFromServer(templateInfo, useBackupData);
            this.updateTemplateParamList(templateInfo);
        }
    }

    public void load(String filePath) throws Exception {
        this.load(filePath, false, false);
    }

    public void load(String filePath, boolean loadTemplates, boolean useBackupData) throws Exception {
        DashboardLoader dbLoader = new DashboardLoader();
        JSONObject daJObj = dbLoader.loadDB(filePath, this.userName);
        this.loadDashboardFromJSON(daJObj);
        if (loadTemplates) {
            this.loadTemplates(useBackupData);
        }
    }

    public void load(InputStream in) throws Exception {
        DashboardLoader dbLoader = new DashboardLoader();
        JSONObject daJObj = dbLoader.loadLocally(in, this.userName).toJSONObject();
        this.loadDashboardFromJSON(daJObj);
    }

    public void loadTemplates() {
        TemplateInfo[] templateInfos = this.getTemplateInfos();
        if (templateInfos == null) {
            return;
        }
        for (TemplateInfo templateInfo : templateInfos) {
            try {
                this.loadOneTemplate(templateInfo, this.userName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadOneTemplate(TemplateInfo templateInfo, String userName) throws Exception {
        Connection conn;
        PathImpl pathImpl;
        String ownerID;
        String userID = OrganizerDataImpl.getUserID((String)userName);
        int nodeID = templateInfo.getNodeID();
        int itemID = templateInfo.getItemID();
        if (!OrganizerDataImpl.canReadFile((String)userID, (int)itemID, (String)(ownerID = (String)(pathImpl = new PathImpl(nodeID)).getValueAt(conn = OrganizerDataImpl.getConnection(), itemID, 5)))) {
            System.out.println("Cannot read file nodeID=" + nodeID + ", itemID=" + itemID);
            return;
        }
        String path = (String)pathImpl.getValueAt(conn, itemID, 3);
        if (path == null || path.equals("")) {
            path = (String)pathImpl.getValueAt(conn, itemID, 4);
        }
        templateInfo.setPath(path);
        if (path == null || path.equals("")) {
            System.out.println("File Path is empty for nodeID=" + nodeID + ", itemID=" + itemID);
            return;
        }
        String nodePath = OrganizerDataImpl.getNodePath((int)nodeID);
        templateInfo.setNodePath(nodePath);
        if (DashboardUtil.isChart(path)) {
            QbChart qbChart = new QbChart((Applet)null, path, true);
            qbChart = this.setSecuredParameterForChart(userID, qbChart);
            templateInfo.setChart(qbChart);
        } else if (DashboardUtil.isReport(path)) {
            String securityLevel = OrganizerDataImpl.getSecurityLevel((String)userID, (boolean)false);
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("prompt parameter", "false");
            if (securityLevel != null) {
                props.put("security level", securityLevel);
            }
            QbReport report = new QbReport((Object)null, path, (Object[])null, (Object[])null, props);
            report = this.setSecuredParameterForReport(userID, report);
            report.refreshWithOriginalData();
            templateInfo.setReport(report);
        } else if (DashboardUtil.isMap(path)) {
            QbMap map = QbMap.readMap(path);
            map = this.setSecuredParameterForMap(userID, map);
            templateInfo.setMap(map);
        }
    }

    public void save(String filePath) {
        DashboardSaver dbSaver = new DashboardSaver();
        if (!filePath.toLowerCase().endsWith(".dsb")) {
            filePath = filePath + ".dsb";
        }
        String absFileName = OrganizerDataImpl.getPath((String)filePath);
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        try {
            dbSaver.saveDashboard(fstream, this);
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(null, fstream.toByteArray(), absFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(int nodeID, int itemID, String filePath, String fileName, String dashboardData, boolean saveToDB, OrganizerDataImpl db, boolean overWrite, boolean updatePath, String remoteAddr, String userName) {
        DashboardSaver dbSaver = new DashboardSaver(nodeID, itemID, filePath, fileName, dashboardData, saveToDB, db, overWrite, remoteAddr, userName);
        String msg = dbSaver.saveDashboard();
        try {
            JSONObject resultJObj = new JSONObject(msg);
            boolean success = resultJObj.optBoolean("success");
            String message = resultJObj.optString("message");
            if (!success) {
                System.out.println(message);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private QbChart setSecuredParameterForChart(String userID, QbChart qbChart) throws Exception {
        if (qbChart.getChart().sourceData != 1) {
            return qbChart;
        }
        if (this.secParamInfoList == null || this.isAdmin()) {
            return qbChart;
        }
        String secLevel = OrganizerDataImpl.getSecurityLevel((String)userID, (boolean)false);
        quadbase.util.IDatabaseInfo dbInfo = qbChart.gethInputData().getDatabaseInfo();
        if (dbInfo instanceof quadbase.util.IQueryFileInfo) {
            quadbase.util.IQueryFileInfo iqfi = (quadbase.util.IQueryFileInfo)dbInfo;
            SimpleQueryFileInfo sqf = null;
            sqf = (SimpleQueryFileInfo)this.secParamInfoList.appendCondtionForParamChart(iqfi, secLevel);
            qbChart.gethInputData().setDatabaseInfo(sqf, true);
        } else {
            DBInfo dbInfoTemp = new DBInfo(dbInfo);
            this.secParamInfoList.appendConditionsForChart(dbInfoTemp, secLevel);
            qbChart.gethInputData().setDatabaseInfo(dbInfoTemp, true);
        }
        qbChart.refresh();
        return qbChart;
    }

    private QbReport setSecuredParameterForReport(String userID, QbReport qbReport) throws Exception {
        if (qbReport.getDataSourceType() != 1) {
            return qbReport;
        }
        if (this.secParamInfoList == null || this.isAdmin()) {
            return qbReport;
        }
        String secLevel = OrganizerDataImpl.getSecurityLevel((String)userID, (boolean)false);
        IDatabaseInfo idbInfo = qbReport.getInputData().getDatabaseInfo();
        if (idbInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
            QueryFileInfo iqfi = (QueryFileInfo)qbReport.getReportObj().dbInfo;
            iqfi = this.secParamInfoList.appendConditionForParamReport(iqfi, secLevel);
            IQbQueryFileInfo rptQueryFileInfo = ReportUtil.cast2(iqfi);
            qbReport.getInputData().setDatabaseInfo(rptQueryFileInfo, true);
        } else {
            quadbase.reportdesigner.ReportAPI.DBInfo dbInfo = new quadbase.reportdesigner.ReportAPI.DBInfo(idbInfo);
            dbInfo = this.secParamInfoList.appendConditions(dbInfo, secLevel);
            qbReport.getInputData().setDatabaseInfo(dbInfo);
        }
        return qbReport;
    }

    private void createObject(TemplateInfo templateInfo, Connection conn, boolean useBackupData) throws Exception {
        PathImpl pathImpl;
        String ownerID;
        int nodeID = templateInfo.getNodeID();
        int itemID = templateInfo.getItemID();
        if (!OrganizerDataImpl.canReadFile((String)this.userName, (int)itemID, (String)(ownerID = (String)(pathImpl = new PathImpl(nodeID)).getValueAt(conn, itemID, 5)))) {
            System.out.println("CANNOT READ FILE..." + templateInfo.getName());
            return;
        }
        String securityLevel = this.getSecurityLevel();
        String path = (String)pathImpl.getValueAt(conn, itemID, 3);
        if (path == null || path.equals("")) {
            path = (String)pathImpl.getValueAt(conn, itemID, 4);
        }
        templateInfo.setPath(path);
        if (QbDashboard.isChart(path)) {
            QbChart chart = null;
            if (!useBackupData && OrganizerDataImpl.getListenerManager() != null) {
                Properties props = new Properties();
                props.put("prompt parameter", "false");
                props.put("use backup data", "true");
                chart = new QbChart((Applet)null, path, null, props);
                chart.getChart().sourceData = chart.getChart().getOriginalSourceData();
            } else {
                Properties props = new Properties();
                props.put("prompt parameter", "false");
                props.put("use backup data", useBackupData + "");
                chart = new QbChart((Applet)null, path, null, props);
            }
            if (!useBackupData) {
                chart = this.setSecuredParameterForChart(this.userName, chart);
            }
            templateInfo.setChart(chart);
        } else if (QbDashboard.isReport(path)) {
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("prompt parameter", "false");
            props.put("use backup data", useBackupData + "");
            if (securityLevel != null) {
                props.put("security level", securityLevel);
            }
            QbReport report = new QbReport((Object)null, path, (Object[])null, (Object[])null, props);
            if (!useBackupData) {
                report = this.setSecuredParameterForReport(this.userName, report);
                report.setSnapToGrid(false);
                report.refreshWithOriginalData();
            }
            templateInfo.setReport(report);
        } else if (QbDashboard.isMap(path)) {
            QbMap qbMap = QbMap.readMap(path, useBackupData);
            if (!useBackupData) {
                qbMap = this.setSecuredParameterForMap(this.userName, qbMap);
            }
            templateInfo.setMap(qbMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObjectFromServer(TemplateInfo templateInfo, boolean useBackupData) throws Exception {
        String ownerID;
        Path path;
        int itemID;
        block19: {
            int nodeID = templateInfo.getNodeID();
            itemID = templateInfo.getItemID();
            path = this.dataProxy.getTable(null, null, nodeID);
            ownerID = "";
            try {
                ownerID = (String)path.getValueAt(null, null, itemID, 5);
            }
            catch (Exception e) {
                if (!(e instanceof NullPointerException)) break block19;
                throw new Exception("The Organizer node id=" + nodeID + " might have been removed");
            }
        }
        if (!this.dataProxy.canReadFile(this.userName, itemID, ownerID)) {
            throw new Exception("CANNOT READ FILE..." + templateInfo.getName());
        }
        String securityLevel = this.getSecurityLevel();
        String pathStr = (String)path.getValueAt(this.userName, this.password, itemID, 3);
        if (pathStr == null || pathStr.equals("")) {
            pathStr = (String)path.getValueAt(this.userName, this.password, itemID, 4);
        }
        if (pathStr == null) {
            throw new Exception("The template '" + templateInfo.getName() + "' has been removed from the organizer...");
        }
        templateInfo.setPath(pathStr);
        if (QbDashboard.isChart(pathStr)) {
            boolean oldState = QbChart.isForExportOnly();
            QbChart.setForExportOnly(true);
            try {
                QbChart chart = null;
                if (!useBackupData && OrganizerDataImpl.getListenerManager() != null) {
                    Properties props = new Properties();
                    props.put("prompt parameter", "false");
                    props.put("use backup data", "true");
                    chart = new QbChart(ServerMessage.getApplet(), pathStr, null, props);
                    chart.getChart().sourceData = chart.getChart().getOriginalSourceData();
                } else {
                    Properties props = new Properties();
                    props.put("prompt parameter", "false");
                    props.put("use backup data", useBackupData + "");
                    chart = new QbChart(ServerMessage.getApplet(), pathStr, null, props);
                }
                if (!useBackupData) {
                    this.setSecuredParameterForChart(this.userName, chart);
                    templateInfo.setChart(chart);
                }
                templateInfo.setChart(chart);
            }
            finally {
                QbChart.setForExportOnly(oldState);
            }
        } else if (QbDashboard.isReport(pathStr)) {
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("prompt parameter", "false");
            props.put("use backup data", useBackupData + "");
            if (securityLevel != null) {
                props.put("security level", securityLevel);
            }
            QbReport report = new QbReport((Object)ServerMessage.getApplet(), pathStr, (Object[])null, (Object[])null, props);
            if (!useBackupData) {
                report = this.setSecuredParameterForReport(this.userName, report);
                report.setSnapToGrid(false);
                report.refreshWithOriginalData();
            }
            templateInfo.setReport(report);
        } else if (QbDashboard.isMap(pathStr)) {
            QbMap map = QbMap.readMap(pathStr, useBackupData);
            if (!useBackupData) {
                map = this.setSecuredParameterForMap(this.userName, map);
            }
            templateInfo.setMap(map);
        }
    }

    public static boolean isChart(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".CHT") || fileLocation.toUpperCase().endsWith(".QCH") || fileLocation.toUpperCase().endsWith(".TPL") || fileLocation.toUpperCase().endsWith(".PAC") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLChart((String)fileLocation);
    }

    public static boolean isReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".RPT") || fileLocation.toUpperCase().endsWith(".QRP") || fileLocation.toUpperCase().endsWith(".PAK") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLReport((String)fileLocation);
    }

    public static boolean isPakReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".PAK");
    }

    public static boolean isGoogleMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".GXML");
    }

    public static boolean isSvgMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".SXML");
    }

    public static boolean isMap(String fileLocation) {
        return QbDashboard.isGoogleMap(fileLocation) || QbDashboard.isSvgMap(fileLocation);
    }

    public static boolean isDashboard(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".DSB");
    }

    private void updateTemplateParamList(TemplateInfo templateInfo) {
        block15: {
            DataSource ds;
            TemplateParam[] templateParams;
            block16: {
                block14: {
                    if (templateInfo == null) {
                        return;
                    }
                    templateParams = templateInfo.getParams();
                    if (templateInfo.getChart() == null) break block14;
                    IInputData inputData = templateInfo.getChart().gethInputData();
                    if (inputData.getDatabaseInfo() == null || !(inputData.getDatabaseInfo() instanceof IQueryFileInfo)) {
                        return;
                    }
                    IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)inputData.getDatabaseInfo());
                    IQueryInParam[] queryParamSet = null;
                    if (queryInfo == null) break block15;
                    queryParamSet = QbUtil.getInParam(queryInfo);
                    for (int i = 0; i < queryParamSet.length; ++i) {
                        String paramName = queryParamSet[i].getParamName();
                        int j = 0;
                        while (i < templateParams.length) {
                            if (paramName.equals(templateParams[j].getName())) {
                                templateParams[j].setSqlType(queryParamSet[i].getSqlType());
                                templateParams[j].setDefaultValue(queryParamSet[i].getDefaultValue());
                            }
                            ++j;
                        }
                    }
                    break block15;
                }
                if (templateInfo.getReport() == null) break block16;
                quadbase.reportdesigner.util.IInputData inputData = templateInfo.getReport().getInputData();
                if (inputData.getDatabaseInfo() == null || !(inputData.getDatabaseInfo() instanceof quadbase.reportdesigner.util.IQueryFileInfo)) break block15;
                quadbase.reportdesigner.util.IQueryFileInfo queryInfo = (quadbase.reportdesigner.util.IQueryFileInfo)inputData.getDatabaseInfo();
                IQueryInParam[] queryParamSet = null;
                if (queryInfo != null) {
                    queryParamSet = QbUtil.getInParam(queryInfo);
                    for (int i = 0; i < queryParamSet.length; ++i) {
                        String paramName = queryParamSet[i].getParamName();
                        int j = 0;
                        while (i < templateParams.length) {
                            if (paramName.equals(templateParams[j].getName())) {
                                templateParams[j].setSqlType(queryParamSet[i].getSqlType());
                                templateParams[j].setDefaultValue(queryParamSet[i].getDefaultValue());
                            }
                            ++j;
                        }
                    }
                }
                break block15;
            }
            if (templateInfo.getMap() != null && (ds = templateInfo.getMap().getDataSource()).isParameterized()) {
                ParameterizedDataSource pds = (ParameterizedDataSource)ds;
                IQueryFileInfo queryInfo = pds.getQueryFileInfo();
                IQueryInParam[] queryParamSet = null;
                if (queryInfo != null) {
                    queryParamSet = QbUtil.getInParam(queryInfo);
                    for (int i = 0; i < queryParamSet.length; ++i) {
                        String paramName = queryParamSet[i].getParamName();
                        int j = 0;
                        while (i < templateParams.length) {
                            if (paramName.equals(templateParams[j].getName())) {
                                templateParams[j].setSqlType(queryParamSet[i].getSqlType());
                                templateParams[j].setDefaultValue(queryParamSet[i].getDefaultValue());
                            }
                            ++j;
                        }
                    }
                }
            }
        }
    }

    private String getSecurityLevel() throws Exception {
        String secLevel = null;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            secLevel = OrganizerDataImpl.getSecurityLevel((String)OrganizerDataImpl.getUserID((String)this.userName), (boolean)false);
            return secLevel;
        }
        if (this.dataProxy == null) {
            throw new Exception("Can't get security level on the client, dataProxy is null");
        }
        String userID = null;
        String encUserName = Coder.encode(this.userName);
        String encPassword = Coder.encode(this.password);
        userID = OrganizerDataImpl.isAdmin((String)this.userName) ? this.dataProxy.getUserNameID(null) : this.dataProxy.getUserNameID(encUserName);
        secLevel = this.dataProxy.getSecurityLevel(encUserName, encPassword, userID, false);
        return secLevel;
    }

    private QbMap setSecuredParameterForMap(String userID, QbMap qbMap) throws Exception {
        String secLevel = OrganizerDataImpl.getSecurityLevel((String)userID, (boolean)false);
        DataSource ds = qbMap.getDataSource();
        ds.setSecuredParameters(true, secLevel);
        qbMap.refresh();
        return qbMap;
    }

    @Override
    public String[] getAllAlertIds() {
        TemplateInfo[] templateInfos = this.getTemplateInfos();
        Vector<String> allAlertIdVect = new Vector<String>();
        for (TemplateInfo templateInfo : templateInfos) {
            String[] aaIds;
            IAlertable alertable = this.getIAlertable(templateInfo);
            if (alertable == null || (aaIds = alertable.getAllAlertIds()) == null) continue;
            for (String aaId : aaIds) {
                allAlertIdVect.add(DashboardUtil.decodeString(templateInfo.getName()) + "/" + aaId);
            }
        }
        if (allAlertIdVect.size() == 0) {
            return null;
        }
        String[] allAlertIds = allAlertIdVect.toArray(new String[allAlertIdVect.size()]);
        return allAlertIds;
    }

    @Override
    public String[] getTriggeredAlertIds() {
        TemplateInfo[] templateInfos = this.getTemplateInfos();
        Vector<String> triggeredAlertVect = new Vector<String>();
        for (TemplateInfo templateInfo : templateInfos) {
            String[] taIds;
            IAlertable alertable = this.getIAlertable(templateInfo);
            if (alertable == null || (taIds = alertable.getTriggeredAlertIds()) == null) continue;
            for (String taId : taIds) {
                triggeredAlertVect.add(DashboardUtil.decodeString(templateInfo.getName()) + "/" + taId);
            }
        }
        if (triggeredAlertVect.size() == 0) {
            return null;
        }
        return triggeredAlertVect.toArray(new String[triggeredAlertVect.size()]);
    }

    public Vector<TemplateInfo> getWatchedTemplates() {
        Vector<TemplateInfo> templateList = new Vector<TemplateInfo>();
        TemplateInfo[] tInfos = this.getTemplateInfos();
        for (int i = 0; i < tInfos.length; ++i) {
            AlertAttr aa = tInfos[i].getAlertAttr();
            if (aa == null) continue;
            boolean[] isWatched = aa.getIsWatched();
            boolean found = false;
            for (boolean element : isWatched) {
                if (!isWatched[i]) continue;
                found = true;
                break;
            }
            if (!found) continue;
            templateList.add(tInfos[i]);
        }
        return templateList;
    }

    public Vector<ParamInfo> getParameterList() {
        TemplateInfo[] tInfos;
        Vector<ParamInfo> paramInfoList = new Vector<ParamInfo>();
        SharedParam[] sharedParams = this.getSharedParams();
        if (sharedParams != null && sharedParams.length > 0) {
            for (SharedParam sharedParam : sharedParams) {
                ParamInfo pInfo = new ParamInfo();
                pInfo.setParamName(sharedParam.getParamName());
                pInfo.setDataType(sharedParam.getSqlType());
                pInfo.setDefaultValue(sharedParam.getDefaultValue());
                Vector<TemplateParamForShare> templateParamList = sharedParam.getTemplateParamList();
                Vector<String> templatePaths = new Vector<String>();
                Vector<String> paramNameList = new Vector<String>();
                for (int j = 0; j < templateParamList.size(); ++j) {
                    TemplateParamForShare tpfs = templateParamList.elementAt(j);
                    templatePaths.add(this.getFilePath(tpfs.getTemplateInfoID()));
                    paramNameList.add(tpfs.getParamName());
                }
                pInfo.setFilePaths(templatePaths);
                pInfo.setParamNameForTemplate(paramNameList);
                pInfo.setSharedParam(true);
                paramInfoList.add(pInfo);
            }
        }
        for (TemplateInfo tInfo : tInfos = this.getTemplateInfos()) {
            String templateInfoID = tInfo.getName() + "," + tInfo.getNodeID() + "," + tInfo.getItemID();
            TemplateParam[] paramList = tInfo.getParams();
            for (int j = 0; paramList != null && j < paramList.length; ++j) {
                if (this.isParamShared(templateInfoID, paramList[j].getName())) continue;
                ParamInfo pInfo = new ParamInfo();
                pInfo.setParamName(paramList[j].getName());
                pInfo.setDataType(paramList[j].getSqlType());
                pInfo.setDefaultValue(paramList[j].getDefaultValue());
                Vector<String> filePaths = new Vector<String>();
                Vector<String> paramNameVect = new Vector<String>();
                filePaths.add(tInfo.getPath());
                paramNameVect.add(paramList[j].getName());
                pInfo.setFilePaths(filePaths);
                pInfo.setParamNameForTemplate(paramNameVect);
                pInfo.setSharedParam(false);
                paramInfoList.add(pInfo);
            }
        }
        return paramInfoList;
    }

    private String getFilePath(String templateInfoID) {
        TemplateInfo[] tInfo = this.getTemplateInfos();
        String path = null;
        StringTokenizer st = new StringTokenizer(templateInfoID, ",");
        String nodeIDStr = st.nextToken();
        String itemIDStr = st.nextToken();
        int nodeID = Integer.parseInt(nodeIDStr);
        int itemID = Integer.parseInt(itemIDStr);
        for (TemplateInfo element : tInfo) {
            if (nodeID != element.getNodeID() || itemID != element.getItemID()) continue;
            path = element.getPath();
            break;
        }
        return path;
    }

    private boolean isParamShared(String templateInfoID, String templateParamName) {
        SharedParam[] sharedParams = this.getSharedParams();
        if (sharedParams == null || sharedParams.length == 0) {
            return false;
        }
        boolean found = false;
        for (SharedParam sharedParam : sharedParams) {
            Vector<TemplateParamForShare> templateParamList = sharedParam.getTemplateParamList();
            for (int j = 0; j < templateParamList.size(); ++j) {
                TemplateParamForShare tpfs = templateParamList.elementAt(j);
                if (!tpfs.getTemplateInfoID().equals(templateInfoID) || !tpfs.getParamName().equals(templateParamName)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        return found;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public SecParamInfoList getSecParamInfoList() {
        return this.secParamInfoList;
    }

    public void setSecParamInfoList(SecParamInfoList secParamInfoList) {
        this.secParamInfoList = secParamInfoList;
    }

    public Map getTriggeredAlertDetails() {
        TemplateInfo[] templateInfos;
        HashMap<String, Vector<String>> result = new HashMap<String, Vector<String>>();
        for (TemplateInfo templateInfo : templateInfos = this.getTemplateInfos()) {
            Map<String, Vector<String>> alertDetails;
            IAlertable alertable = this.getIAlertable(templateInfo);
            if (alertable == null || (alertDetails = alertable.getTriggeredAlertDetails()) == null) continue;
            Iterator<Map.Entry<String, Vector<String>>> iterator = alertDetails.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Vector<String>> element;
                Map.Entry<String, Vector<String>> entry = element = iterator.next();
                result.put(DashboardUtil.decodeString(templateInfo.getName()) + "/" + entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private IAlertable getIAlertable(TemplateInfo templateInfo) {
        if (templateInfo.getChart() != null) {
            return templateInfo.getChart();
        }
        if (templateInfo.getReport() != null) {
            return templateInfo.getReport();
        }
        if (templateInfo.getMap() != null) {
            return templateInfo.getMap();
        }
        return null;
    }

    private boolean isAdmin() {
        String user = this.userName;
        if (user == null) {
            return false;
        }
        return OrganizerDataImpl.isAdmin((String)user);
    }
}

