/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdHocFilter {
    public static final String ATTR_NAME_FIELDNAME = "fieldName";
    public static final String ATTR_NAME_DATATYPE = "dataType";
    public static final String ATTR_NAME_OPERATOR = "operator";
    public static final String ATTR_NAME_ARGUMENTS = "arguments";
    private String fieldName;
    private String realFieldName;
    private String operator;
    private int dataType;
    private String[] arguments;
    private static Hashtable<String, String> operatorMap = null;

    public AdHocFilter(JSONObject jObj) {
        this.setAttrFromJSON(jObj);
    }

    private void setAttrFromJSON(JSONObject jObj) {
        this.fieldName = jObj.optString(ATTR_NAME_FIELDNAME);
        this.dataType = jObj.optInt(ATTR_NAME_DATATYPE);
        this.operator = jObj.optString(ATTR_NAME_OPERATOR);
        JSONArray argJA = jObj.optJSONArray(ATTR_NAME_ARGUMENTS);
        this.arguments = new String[argJA.length()];
        for (int i = 0; i < argJA.length(); ++i) {
            this.arguments[i] = argJA.optString(i);
        }
    }

    public String getSQLCondition(boolean isAccessDB) {
        if (operatorMap == null) {
            AdHocFilter.setOperatorMap();
        }
        String condition = "";
        if (this.operator.equalsIgnoreCase("between")) {
            condition = this.dataType == 8 ? (isAccessDB ? this.realFieldName + " BETWEEN #" + this.arguments[0] + "# AND #" + this.arguments[1] + "#" : this.realFieldName + " BETWEEN '" + this.arguments[0] + "' AND '" + this.arguments[1] + "'") : this.realFieldName + " BETWEEN '" + this.arguments[0] + "' AND '" + this.arguments[1] + "'";
        } else if (this.operator.equalsIgnoreCase("startsWith")) {
            condition = this.realFieldName + " LIKE '" + this.arguments[0] + "%'";
        } else if (this.operator.equalsIgnoreCase("endsWith")) {
            condition = this.realFieldName + " LIKE '%" + this.arguments[0] + "'";
        } else if (this.operator.equalsIgnoreCase("notStartsWith")) {
            condition = this.realFieldName + " NOT LIKE '" + this.arguments[0] + "%'";
        } else if (this.operator.equalsIgnoreCase("notendsWith")) {
            condition = this.realFieldName + " NOT LIKE '%" + this.arguments[0] + "'";
        } else if (this.operator.equalsIgnoreCase("contains")) {
            condition = this.realFieldName + " LIKE '%" + this.arguments[0] + "%'";
        } else if (this.operator.equalsIgnoreCase("notContains")) {
            condition = this.realFieldName + " NOT LIKE '%" + this.arguments[0] + "'";
        } else {
            String sqlOp = operatorMap.get(this.operator.toLowerCase());
            condition = this.dataType == 7 ? this.realFieldName + " " + sqlOp + " '" + this.arguments[0] + "'" : (this.dataType == 8 ? (isAccessDB ? this.realFieldName + " " + sqlOp + "#" + this.arguments[0] + "#" : this.realFieldName + " " + sqlOp + " '" + this.arguments[0] + "'") : this.realFieldName + " " + sqlOp + " " + this.arguments[0]);
        }
        return condition;
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_FIELDNAME, (Object)this.fieldName);
            jObj.put(ATTR_NAME_DATATYPE, this.dataType);
            jObj.put(ATTR_NAME_OPERATOR, (Object)this.operator);
            JSONArray ja = new JSONArray();
            for (String argument : this.arguments) {
                ja.put((Object)argument);
            }
            jObj.put(ATTR_NAME_ARGUMENTS, (Object)ja);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    private static void setOperatorMap() {
        String[] opNames = new String[]{"lt", "le", "eq", "ge", "gt", "ne", "within", "equals", "notequals"};
        String[] sqlOp = new String[]{"<", "<=", "=", ">=", ">", "<>", " IN ", "=", "<>"};
        operatorMap = new Hashtable();
        for (int i = 0; i < opNames.length; ++i) {
            operatorMap.put(opNames[i], sqlOp[i]);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public String getRealFieldName() {
        return this.realFieldName;
    }

    public void setRealFieldName(String realFieldName) {
        this.realFieldName = realFieldName;
    }
}

