/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class AlertAttr {
    public static final String JSON_KEY_TEMPLATEINFOID = "templateInfoID";
    public static final String JSON_KEY_ALERTLIST = "alertList";
    public static final String JSON_KEY_ALERTID = "alertId";
    public static final String JSON_KEY_ISWATCHED = "isWatched";
    public static final String JSON_KEY_ISTRIGGERED = "isTriggered";
    private String templateInfoID;
    private String[] alertIds;
    private boolean[] isWatched;
    private boolean[] isTriggered;

    public AlertAttr(String templateInfoID, String[] alertIds) {
        this.templateInfoID = templateInfoID;
        if (alertIds == null) {
            this.alertIds = new String[0];
            this.isWatched = new boolean[0];
            this.isTriggered = new boolean[0];
        } else {
            this.alertIds = new String[alertIds.length];
            this.isWatched = new boolean[alertIds.length];
            this.isTriggered = new boolean[alertIds.length];
            for (int i = 0; i < alertIds.length; ++i) {
                this.alertIds[i] = alertIds[i];
                this.isWatched[i] = false;
                this.isTriggered[i] = false;
            }
        }
    }

    public AlertAttr(JSONObject alertAttrJObj) {
        this.setAttributesFromJSON(alertAttrJObj);
    }

    public AlertAttr(String encodedAlertAttrStr) {
        String str = DashboardUtil.decodeString(encodedAlertAttrStr);
        try {
            JSONObject jObj = new JSONObject(str);
            this.setAttributesFromJSON(jObj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void setAttributesFromJSON(JSONObject jObj) {
        this.templateInfoID = jObj.optString(JSON_KEY_TEMPLATEINFOID);
        JSONArray alertJArray = jObj.optJSONArray(JSON_KEY_ALERTLIST);
        if (alertJArray == null) {
            return;
        }
        this.alertIds = new String[alertJArray.length()];
        this.isWatched = new boolean[this.alertIds.length];
        this.isTriggered = new boolean[this.alertIds.length];
        for (int i = 0; i < alertJArray.length(); ++i) {
            JSONObject alertJO = alertJArray.optJSONObject(i);
            if (alertJO == null) continue;
            this.alertIds[i] = alertJO.optString(JSON_KEY_ALERTID);
            this.isWatched[i] = alertJO.optBoolean(JSON_KEY_ISWATCHED);
            this.isTriggered[i] = alertJO.optBoolean(JSON_KEY_ISTRIGGERED);
        }
    }

    public void updateAlertIdList(String[] allAlertIds) {
        if (allAlertIds == null) {
            this.alertIds = new String[0];
            this.isWatched = new boolean[0];
            return;
        }
        boolean[] newIsWatched = new boolean[allAlertIds.length];
        boolean[] newIsTriggered = new boolean[allAlertIds.length];
        block0: for (int i = 0; i < allAlertIds.length; ++i) {
            for (int j = 0; j < this.alertIds.length; ++j) {
                if (this.alertIds[j] != allAlertIds[i]) continue;
                newIsWatched[i] = this.isWatched[j];
                newIsTriggered[i] = this.isTriggered[j];
                continue block0;
            }
        }
    }

    public void updateTriggeredList(String[] triggeredIds) {
        int i;
        for (i = 0; i < this.isTriggered.length; ++i) {
            this.isTriggered[i] = false;
        }
        if (triggeredIds == null || triggeredIds.length == 0) {
            return;
        }
        block1: for (i = 0; i < this.alertIds.length; ++i) {
            for (String triggeredId : triggeredIds) {
                if (!this.alertIds[i].equals(triggeredId)) continue;
                this.isTriggered[i] = true;
                continue block1;
            }
        }
    }

    public String[] getWatchedAlertIds() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.isWatched.length; ++i) {
            if (!this.isWatched[i]) continue;
            v.add(this.alertIds[i]);
        }
        String[] aaIds = v.toArray(new String[v.size()]);
        return aaIds;
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(JSON_KEY_TEMPLATEINFOID, (Object)this.templateInfoID);
            if (this.alertIds == null) {
                return jObj;
            }
            JSONArray alertListJA = new JSONArray();
            for (int i = 0; i < this.alertIds.length; ++i) {
                JSONObject jo = new JSONObject();
                jo.put(JSON_KEY_ALERTID, (Object)this.alertIds[i]);
                jo.put(JSON_KEY_ISWATCHED, this.isWatched[i]);
                jo.put(JSON_KEY_ISTRIGGERED, this.isTriggered[i]);
                alertListJA.put((Object)jo);
            }
            jObj.put(JSON_KEY_ALERTLIST, (Object)alertListJA);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String toString() {
        JSONObject jObj = this.toJSONObject();
        String str = jObj.toString();
        return DashboardUtil.encodeString(str);
    }

    public String getTemplateInfoID() {
        return this.templateInfoID;
    }

    public void setTemplateInfoID(String templateInfoID) {
        this.templateInfoID = templateInfoID;
    }

    public String[] getAlertIds() {
        return this.alertIds;
    }

    public void setAlertIds(String[] alertIds) {
        this.alertIds = alertIds;
    }

    public boolean[] getIsWatched() {
        return this.isWatched;
    }

    public void setIsWatched(boolean[] isWatched) {
        this.isWatched = isWatched;
    }

    public boolean[] getIsTriggered() {
        return this.isTriggered;
    }

    public void setIsTriggered(boolean[] isTriggered) {
        this.isTriggered = isTriggered;
    }
}

