/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Background {
    public static final String ATTR_NAME_BGCOLOR = "backgroundColor";
    public static final String ATTR_NAME_USEBGIMAGE = "useBGImage";
    public static final String ATTR_NAME_BGIMGURL = "bgImageURL";
    public static final String ATTR_NAME_BGPOSITION = "bgPosition";
    public static final String ATTR_NAME_BGREPEAT = "bgRepeat";
    private int[] bgColor;
    private boolean useBGImage = false;
    private String bgImgURL;
    private String bgPosition;
    private String bgRepeat;
    private String bgAttachment;

    public Background(String bgStyle) {
        this.parseBGStyle(bgStyle);
    }

    public Background(JSONObject bgJObj) {
        this.bgColor = new int[3];
        JSONArray bgColorJA = bgJObj.optJSONArray(ATTR_NAME_BGCOLOR);
        if (bgColorJA == null) {
            this.bgColor = new int[]{255, 255, 255};
        } else {
            for (int i = 0; i < this.bgColor.length && i < bgColorJA.length(); ++i) {
                this.bgColor[i] = bgColorJA.optInt(i);
            }
        }
        this.useBGImage = bgJObj.optBoolean(ATTR_NAME_USEBGIMAGE, false);
        if (this.useBGImage) {
            this.bgImgURL = bgJObj.optString(ATTR_NAME_BGIMGURL);
            this.bgPosition = bgJObj.optString(ATTR_NAME_BGPOSITION);
            this.bgRepeat = bgJObj.optString(ATTR_NAME_BGREPEAT);
        }
    }

    private void parseBGStyle(String bgStyle) {
        StringTokenizer st = new StringTokenizer(bgStyle, ";");
        this.useBGImage = false;
        while (st.hasMoreTokens()) {
            String attrToken = st.nextToken().trim();
            if (attrToken.length() == 0) continue;
            int loc = attrToken.indexOf(58);
            String attrName = attrToken.substring(0, loc).trim().toLowerCase();
            String attrValue = "";
            if (loc < attrToken.length()) {
                attrValue = attrToken.substring(loc + 1).trim();
            }
            if (attrName.equals("background")) continue;
            if (attrName.equals("background-image")) {
                int loc2;
                this.bgImgURL = attrValue;
                if (this.bgImgURL != "" && this.bgImgURL.toLowerCase().startsWith("url")) {
                    loc = this.bgImgURL.indexOf(40);
                    loc2 = this.bgImgURL.lastIndexOf(41);
                    this.bgImgURL = this.bgImgURL.substring(loc + 1, loc2).trim();
                }
                if (this.bgImgURL.startsWith("'")) {
                    loc2 = this.bgImgURL.lastIndexOf(39);
                    this.bgImgURL = this.bgImgURL.substring(1, loc2);
                }
                this.useBGImage = this.bgImgURL != "";
                continue;
            }
            if (attrName.equals("background-repeat")) {
                this.bgRepeat = attrValue;
                continue;
            }
            if (attrName.equals("background-color")) {
                this.setBGColor(attrValue);
                continue;
            }
            if (attrName.equals("background-position")) {
                this.bgPosition = attrValue;
                continue;
            }
            if (!attrName.equals("background-attachment")) continue;
            this.bgAttachment = attrValue;
        }
    }

    private void setBGColor(String bgColorRGB) {
        this.bgColor = new int[]{255, 255, 255};
        if (bgColorRGB != "") {
            if (bgColorRGB.toLowerCase().startsWith("rgb")) {
                int loc2;
                int loc1 = bgColorRGB.indexOf(40);
                String cs = bgColorRGB.substring(loc1 + 1, loc2 = bgColorRGB.indexOf(41));
                StringTokenizer stcs = new StringTokenizer(cs, ", ");
                if (stcs.countTokens() == 3) {
                    this.bgColor[0] = Integer.parseInt(stcs.nextToken());
                    this.bgColor[1] = Integer.parseInt(stcs.nextToken());
                    this.bgColor[2] = Integer.parseInt(stcs.nextToken());
                }
            } else if (bgColorRGB.startsWith("#") && bgColorRGB.length() == 7) {
                this.bgColor[0] = Integer.decode("#" + bgColorRGB.substring(1, 3));
                this.bgColor[1] = Integer.decode("#" + bgColorRGB.substring(3, 5));
                this.bgColor[2] = Integer.decode("#" + bgColorRGB.substring(5, 7));
            }
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_BGIMGURL, (Object)this.bgImgURL);
            jObj.put(ATTR_NAME_BGREPEAT, (Object)this.bgRepeat);
            JSONArray bgColorJA = new JSONArray();
            for (int element : this.bgColor) {
                bgColorJA.put(element);
            }
            jObj.put(ATTR_NAME_BGCOLOR, (Object)bgColorJA);
            jObj.put(ATTR_NAME_BGPOSITION, (Object)this.bgPosition);
            jObj.put(ATTR_NAME_USEBGIMAGE, this.useBGImage);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toStyleString() {
        StringBuffer buf = new StringBuffer();
        String bgColorStr = "rgb(" + this.bgColor[0] + "," + this.bgColor[1] + "," + this.bgColor[2] + ")";
        buf.append("background-color:" + bgColorStr + ";");
        if (this.useBGImage) {
            buf.append("background-image:url(" + this.bgImgURL + ");");
            buf.append("background-repeat:" + this.bgRepeat + ";");
            buf.append("background-position:" + this.bgPosition + ";");
            buf.append("background-attachment:" + this.bgAttachment);
        }
        return buf.toString();
    }

    public String toString() {
        return this.toStyleString();
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isUseBGImage() {
        return this.useBGImage;
    }

    public void setUseBGImage(boolean useBGImage) {
        this.useBGImage = useBGImage;
    }

    public String getBgImgURL() {
        return this.bgImgURL;
    }

    public void setBgImgURL(String bgImgURL) {
        this.bgImgURL = bgImgURL;
    }

    public String getBgPosition() {
        return this.bgPosition;
    }

    public void setBgPosition(String bgPosition) {
        this.bgPosition = bgPosition;
    }

    public String getBgRepeat() {
        return this.bgRepeat;
    }

    public void setBgRepeat(String bgRepeat) {
        this.bgRepeat = bgRepeat;
    }
}

