/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class ComboSharedParam {
    public static final String ATTR_NAME_NAME = "name";
    public static final String ATTR_NAME_PROMPTNAME = "promptName";
    public static final String ATTR_NAME_DATATYPE = "dataType";
    public static final String ATTR_NAME_PANELATTR = "panelAttr";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_BACKGROUND = "background";
    public static final String ATTR_NAME_BACKGROUND_IMAGE = "background-image";
    public static final String ATTR_NAME_BGCOLOR = "bgColor";
    public static final String ATTR_NAME_OPACITY = "opacity";
    public static final String ATTR_NAME_ISTRANSPARENT = "isTransparent";
    public static final String ATTR_NAME_USEBGIMAGE = "useBGImage";
    public static final String ATTR_NAME_BGIMAGEURL = "bgImageURL";
    public static final String ATTR_NAME_BGPOSITION = "bgPosition";
    public static final String ATTR_NAME_BGREPEAT = "bgRepeat";
    public static final String ATTR_NAME_BORDER = "border";
    public static final String ATTR_NAME_BORDER_COLOR = "color";
    public static final String ATTR_NAME_BORDER_THICKNESS = "thickness";
    public static final String ATTR_NAME_BORDER_STYLE = "style";
    public static final String ATTR_NAME_BORDER_PADDING = "padding";
    public static final String ATTR_NAME_SHOWHEADER = "showHeader";
    public static final String ATTR_NAME_DIRECTION = "direction";
    public static final String ATTR_NAME_FONT = "font";
    public static final String ATTR_NAME_FONTCOLOR = "color";
    public static final String ATTR_NAME_FONTALIGN = "align";
    public static final String ATTR_NAME_FONTNAME = "fontName";
    public static final String ATTR_NAME_FONTSIZE = "fontSize";
    public static final String ATTR_NAME_HTMLFONTSTYLE = "fontStyle";
    public static final String ATTR_NAME_HTMLFONTWEIGHT = "fontWeight";
    public static final String ATTR_NAME_ALLOWCUSTOMRANGE = "allowCustomRange";
    public static final String ATTR_NAME_ADDOKBUTN = "addOKButn";
    public static final String ATTR_NAME_OKBUTNTEXT = "okButnText";
    public static final String ATTR_NAME_OPTIONLIST = "optionList";
    private String name;
    private String promptName;
    private Vector<ComboOption> optionList;
    private int width;
    private int height;
    private int top;
    private int left;
    private int borderThickness;
    private int borderPadding;
    private String borderStyle;
    private int[] borderColor;
    private int[] bgColor;
    private int opacity;
    private boolean isTransparent;
    private boolean useBGImage;
    private String bgImageURL;
    private String bgRepeat;
    private String bgPosition;
    private boolean showHeader;
    private String direction;
    private String fontName;
    private String fontStyle;
    private String fontWeight;
    private String fontAlign;
    private int fontSize;
    private int[] fontColor;
    private String dataType;
    private boolean allowCustomRange = true;
    private boolean addOKButn = false;
    private String okButnText = "OK";

    public ComboSharedParam(String specStr) {
        this.setAttrFromSpecString(specStr);
    }

    public ComboSharedParam(JSONObject jObj) {
        this.setAttrFromJSONObject(jObj);
    }

    private void setAttrFromSpecString(String specStr) {
        StringTokenizer st = new StringTokenizer(specStr, ";");
        while (st.hasMoreTokens()) {
            String key;
            String attrStr = st.nextToken();
            StringTokenizer attrST = new StringTokenizer(attrStr, ":");
            String val = "";
            if (attrStr.startsWith(ATTR_NAME_BACKGROUND_IMAGE)) {
                key = attrST.nextToken();
                while (attrST.hasMoreTokens()) {
                    val = val + attrST.nextToken() + (attrST.hasMoreTokens() ? ":" : "");
                }
            } else {
                if (attrST.countTokens() != 2) continue;
                key = attrST.nextToken();
                if (attrST.hasMoreTokens()) {
                    val = attrST.nextToken();
                }
            }
            if (key.equals(ATTR_NAME_NAME)) {
                this.name = val;
                continue;
            }
            if (key.equals("promptText")) {
                this.promptName = DashboardUtil.decodeString(val);
                continue;
            }
            if (key.equals(ATTR_NAME_DATATYPE)) {
                this.dataType = val;
                continue;
            }
            if (key.equals(ATTR_NAME_OPTIONLIST)) {
                this.optionList = new Vector();
                StringTokenizer optionST = new StringTokenizer(val, ",");
                while (optionST.hasMoreTokens()) {
                    String optStr = optionST.nextToken();
                    optStr = DashboardUtil.decodeString(optStr);
                    ComboOption co = new ComboOption(optStr);
                    this.optionList.addElement(co);
                }
                continue;
            }
            if (key.equals(ATTR_NAME_TOP)) {
                this.top = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_LEFT)) {
                this.left = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_HEIGHT)) {
                this.height = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_WIDTH)) {
                this.width = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals("border-width")) {
                this.borderThickness = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals("border-style")) {
                this.borderStyle = val;
                continue;
            }
            if (key.equals("border-color")) {
                this.borderColor = DashboardUtil.convertToColorRGB(val);
                continue;
            }
            if (key.equals("background-color")) {
                this.bgColor = DashboardUtil.convertToColorRGB(val);
                continue;
            }
            if (key.equals(ATTR_NAME_BACKGROUND_IMAGE)) {
                this.bgImageURL = val;
                continue;
            }
            if (key.equals("background-position")) {
                this.bgPosition = val;
                continue;
            }
            if (key.equals("background-repeat")) {
                this.bgRepeat = val;
                continue;
            }
            if (key.equals(ATTR_NAME_OPACITY)) {
                this.opacity = DashboardUtil.getInteger(val, 100);
                continue;
            }
            if (key.equals("font-family")) {
                this.fontName = val;
                continue;
            }
            if (key.equals("font-size")) {
                this.fontSize = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals("font-style")) {
                this.fontStyle = val;
                continue;
            }
            if (key.equals("font-weight")) {
                this.fontWeight = val;
                continue;
            }
            if (key.equals("color")) {
                this.fontColor = DashboardUtil.convertToColorRGB(val);
                continue;
            }
            if (key.equals("text-align")) {
                this.fontAlign = val;
                continue;
            }
            if (key.equals(ATTR_NAME_ALLOWCUSTOMRANGE)) {
                this.allowCustomRange = val.equalsIgnoreCase("true");
                continue;
            }
            if (key.equals(ATTR_NAME_ADDOKBUTN)) {
                this.addOKButn = val.equalsIgnoreCase("true");
                continue;
            }
            if (!key.equals(ATTR_NAME_OKBUTNTEXT)) continue;
            this.okButnText = DashboardUtil.decodeString(val);
        }
    }

    private void setAttrFromJSONObject(JSONObject jObj) {
        JSONObject fontJObj;
        this.name = jObj.optString(ATTR_NAME_NAME);
        this.promptName = jObj.optString(ATTR_NAME_PROMPTNAME);
        this.dataType = jObj.optString(ATTR_NAME_DATATYPE);
        JSONObject panelAttrJObj = jObj.optJSONObject(ATTR_NAME_PANELATTR);
        JSONObject sizeJObj = panelAttrJObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJObj.optInt(ATTR_NAME_WIDTH);
        this.height = sizeJObj.optInt(ATTR_NAME_HEIGHT);
        JSONObject posJObj = panelAttrJObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = posJObj.optInt(ATTR_NAME_TOP);
        this.left = posJObj.optInt(ATTR_NAME_LEFT);
        JSONObject bgJObj = panelAttrJObj.optJSONObject(ATTR_NAME_BACKGROUND);
        JSONArray bgColorJA = bgJObj.optJSONArray(ATTR_NAME_BGCOLOR);
        this.bgColor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.bgColor[i] = bgColorJA.optInt(i);
        }
        this.opacity = bgJObj.optInt(ATTR_NAME_OPACITY);
        this.isTransparent = bgJObj.optBoolean(ATTR_NAME_ISTRANSPARENT);
        this.useBGImage = bgJObj.optBoolean(ATTR_NAME_USEBGIMAGE);
        this.bgImageURL = bgJObj.optString(ATTR_NAME_BGIMAGEURL);
        this.bgPosition = bgJObj.optString(ATTR_NAME_BGPOSITION);
        this.bgRepeat = bgJObj.optString(ATTR_NAME_BGREPEAT);
        JSONObject borderJObj = panelAttrJObj.optJSONObject(ATTR_NAME_BORDER);
        if (borderJObj != null) {
            JSONArray bdrColorJA = borderJObj.optJSONArray("color");
            this.borderColor = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.borderColor[i] = bdrColorJA.optInt(i);
            }
            this.borderStyle = borderJObj.optString(ATTR_NAME_BORDER_STYLE);
            this.borderThickness = borderJObj.optInt(ATTR_NAME_BORDER_THICKNESS);
            this.borderPadding = borderJObj.optInt(ATTR_NAME_BORDER_PADDING);
        }
        if ((fontJObj = panelAttrJObj.optJSONObject(ATTR_NAME_FONT)) != null) {
            this.fontName = fontJObj.optString(ATTR_NAME_FONTNAME);
            this.fontStyle = fontJObj.optString(ATTR_NAME_HTMLFONTSTYLE);
            this.fontWeight = fontJObj.optString(ATTR_NAME_HTMLFONTWEIGHT);
            this.fontSize = fontJObj.optInt(ATTR_NAME_FONTSIZE);
            this.fontAlign = fontJObj.optString(ATTR_NAME_FONTALIGN);
            JSONArray fcJA = fontJObj.optJSONArray("color");
            this.fontColor = DashboardUtil.convertToColorRGB(fcJA);
        }
        this.showHeader = panelAttrJObj.optBoolean(ATTR_NAME_SHOWHEADER, false);
        this.direction = panelAttrJObj.optString(ATTR_NAME_DIRECTION, "horizontal");
        JSONArray optionListJA = jObj.optJSONArray(ATTR_NAME_OPTIONLIST);
        this.optionList = new Vector();
        if (optionListJA != null) {
            for (int i = 0; i < optionListJA.length(); ++i) {
                ComboOption co = new ComboOption(optionListJA.optJSONObject(i));
                this.optionList.addElement(co);
            }
        }
        this.allowCustomRange = jObj.optBoolean(ATTR_NAME_ALLOWCUSTOMRANGE);
        this.addOKButn = jObj.optBoolean(ATTR_NAME_ADDOKBUTN);
        this.okButnText = jObj.optString(ATTR_NAME_OKBUTNTEXT);
    }

    public String toSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name:" + this.name + ";");
        buf.append("dataType:" + this.dataType + ";");
        buf.append("promptText:" + DashboardUtil.encodeString(this.promptName) + ";");
        StringBuffer optionListBuf = new StringBuffer();
        for (int i = 0; i < this.optionList.size(); ++i) {
            if (i > 0) {
                optionListBuf.append(",");
            }
            ComboOption co = this.optionList.elementAt(i);
            String coString = co.toSpecString();
            optionListBuf.append(DashboardUtil.encodeString(coString));
        }
        buf.append("optionList:" + optionListBuf.toString() + ";");
        buf.append("top:" + this.top + "px;");
        buf.append("left:" + this.left + "px;");
        buf.append("width:" + this.width + "px;");
        buf.append("height:" + this.height + "px;");
        buf.append("font-family:" + this.fontName + ";");
        buf.append("font-style:" + this.fontStyle + ";");
        buf.append("font-weight:" + this.fontWeight + ";");
        buf.append("color:" + DashboardUtil.convertToColorStr(this.fontColor) + ";");
        buf.append("font-size:" + this.fontSize + "px;");
        buf.append("text-align:" + this.fontAlign + ";");
        buf.append("border-width:" + this.borderThickness + "px;");
        buf.append("border-style:" + this.borderStyle + ";");
        buf.append("border-color:" + DashboardUtil.convertToColorStr(this.borderColor) + ";");
        buf.append("background-color:" + DashboardUtil.convertToColorStr(this.bgColor) + ";");
        buf.append("opacity:" + this.opacity + ";");
        buf.append("background-image:" + this.bgImageURL + ";");
        buf.append("background-position:" + this.bgPosition + ";");
        buf.append("background-repeat:" + this.bgRepeat + ";");
        buf.append("allowCustomRange:" + this.allowCustomRange + ";");
        buf.append("addOKButn:" + this.addOKButn + ";");
        buf.append("okButnText:" + DashboardUtil.encodeString(this.okButnText) + ";");
        return buf.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_NAME, (Object)this.name);
            jObj.put(ATTR_NAME_PROMPTNAME, (Object)this.promptName);
            jObj.put(ATTR_NAME_DATATYPE, (Object)this.dataType);
            jObj.put(ATTR_NAME_ALLOWCUSTOMRANGE, this.allowCustomRange);
            jObj.put(ATTR_NAME_ADDOKBUTN, this.addOKButn);
            jObj.put(ATTR_NAME_OKBUTNTEXT, (Object)this.okButnText);
            JSONArray optionListJA = new JSONArray();
            for (int i = 0; i < this.optionList.size(); ++i) {
                ComboOption co = this.optionList.elementAt(i);
                JSONObject coJO = co.toJSONObject();
                optionListJA.put((Object)coJO);
            }
            jObj.put(ATTR_NAME_OPTIONLIST, (Object)optionListJA);
            JSONObject panelAttrJObj = new JSONObject();
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = DashboardUtil.convertToColorJSONArray(this.bgColor);
            bgJO.put(ATTR_NAME_BGCOLOR, (Object)bgColorJA);
            bgJO.put(ATTR_NAME_BGIMAGEURL, (Object)this.bgImageURL);
            bgJO.put(ATTR_NAME_BGPOSITION, (Object)this.bgPosition);
            bgJO.put(ATTR_NAME_BGREPEAT, (Object)this.bgRepeat);
            this.isTransparent = this.opacity == 0;
            bgJO.put(ATTR_NAME_ISTRANSPARENT, this.isTransparent);
            bgJO.put(ATTR_NAME_OPACITY, this.opacity);
            this.useBGImage = this.bgImageURL != null && !this.bgImageURL.equals("");
            bgJO.put(ATTR_NAME_USEBGIMAGE, this.useBGImage);
            panelAttrJObj.put(ATTR_NAME_BACKGROUND, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            JSONArray borderColorJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            borderJO.put("color", (Object)borderColorJA);
            borderJO.put(ATTR_NAME_BORDER_THICKNESS, this.borderThickness);
            borderJO.put(ATTR_NAME_BORDER_STYLE, (Object)this.borderStyle);
            borderJO.put(ATTR_NAME_BORDER_PADDING, this.borderPadding);
            panelAttrJObj.put(ATTR_NAME_BORDER, (Object)borderJO);
            JSONObject fontJO = new JSONObject();
            JSONArray fontColorJA = DashboardUtil.convertToColorJSONArray(this.fontColor);
            fontJO.put("color", (Object)fontColorJA);
            fontJO.put(ATTR_NAME_FONTNAME, (Object)this.fontName);
            fontJO.put(ATTR_NAME_HTMLFONTSTYLE, (Object)this.fontStyle);
            fontJO.put(ATTR_NAME_HTMLFONTWEIGHT, (Object)this.fontWeight);
            fontJO.put(ATTR_NAME_FONTSIZE, this.fontSize);
            fontJO.put(ATTR_NAME_FONTALIGN, (Object)this.fontAlign);
            panelAttrJObj.put(ATTR_NAME_FONT, (Object)fontJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put(ATTR_NAME_WIDTH, this.width);
            sizeJO.put(ATTR_NAME_HEIGHT, this.height);
            panelAttrJObj.put(ATTR_NAME_SIZE, (Object)sizeJO);
            JSONObject posJO = new JSONObject();
            posJO.put(ATTR_NAME_TOP, this.top);
            posJO.put(ATTR_NAME_LEFT, this.left);
            panelAttrJObj.put(ATTR_NAME_POSITION, (Object)posJO);
            panelAttrJObj.put(ATTR_NAME_SHOWHEADER, this.showHeader);
            panelAttrJObj.put(ATTR_NAME_DIRECTION, (Object)this.direction);
            jObj.put(ATTR_NAME_PANELATTR, (Object)panelAttrJObj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String getBgImageURL() {
        return this.bgImageURL;
    }

    public void setBgImageURL(String bgImageURL) {
        this.bgImageURL = bgImageURL;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPromptName() {
        return this.promptName;
    }

    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    public Vector<ComboOption> getOptionList() {
        return this.optionList;
    }

    public void setOptionList(Vector<ComboOption> optionList) {
        this.optionList = optionList;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int borderThickness) {
        this.borderThickness = borderThickness;
    }

    public int getBorderPadding() {
        return this.borderPadding;
    }

    public void setBorderPadding(int borderPadding) {
        this.borderPadding = borderPadding;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void setTransparent(boolean isTransparent) {
        this.isTransparent = isTransparent;
    }

    public boolean isUseBGImage() {
        return this.useBGImage;
    }

    public void setUseBGImage(boolean useBGImage) {
        this.useBGImage = useBGImage;
    }

    public String getBgRepeat() {
        return this.bgRepeat;
    }

    public void setBgRepeat(String bgRepeat) {
        this.bgRepeat = bgRepeat;
    }

    public String getBgPosition() {
        return this.bgPosition;
    }

    public void setBgPosition(String bgPosition) {
        this.bgPosition = bgPosition;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String fontAlign) {
        this.fontAlign = fontAlign;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int[] getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int[] fontColor) {
        this.fontColor = fontColor;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean isAllowCustomRange() {
        return this.allowCustomRange;
    }

    public void setAllowCustomRange(boolean allowCustomRange) {
        this.allowCustomRange = allowCustomRange;
    }

    public boolean isAddOKButn() {
        return this.addOKButn;
    }

    public void setAddOKButn(boolean addOKButn) {
        this.addOKButn = addOKButn;
    }

    public String getOkButnText() {
        return this.okButnText;
    }

    public void setOkButnText(String okButnText) {
        this.okButnText = okButnText;
    }

    public class ComboOption {
        private String name;
        private String firstParamName;
        private String secParamName;
        private String firstFormula;
        private String secFormula;
        private static final String JSON_KEY_NAME = "name";
        private static final String JSON_KEY_FIRST = "first";
        private static final String JSON_KEY_SECOND = "second";
        private static final String JSON_KEY_PARAMNAME = "name";
        private static final String JSON_KEY_FORMULA = "formula";

        public ComboOption(String specStr) {
            this.setAttrFromSpecString(specStr);
        }

        public ComboOption(JSONObject comboOptionJO) {
            this.setAttrFromJSONObject(comboOptionJO);
        }

        private void setAttrFromSpecString(String specStr) {
            StringTokenizer st = new StringTokenizer(specStr, ";");
            while (st.hasMoreTokens()) {
                String attrStr = st.nextToken();
                StringTokenizer attrST = new StringTokenizer(attrStr, "=");
                if (attrST.countTokens() < 2) continue;
                String key = attrST.nextToken();
                String val = attrST.nextToken();
                if (key.equals("name")) {
                    this.name = val;
                    continue;
                }
                if (key.equals("firstParamName")) {
                    this.firstParamName = val;
                    continue;
                }
                if (key.equals("secondParamName")) {
                    this.secParamName = val;
                    continue;
                }
                if (key.equals("startFormula")) {
                    this.firstFormula = DashboardUtil.decodeString(val);
                    continue;
                }
                if (!key.equals("endFormula")) continue;
                this.secFormula = DashboardUtil.decodeString(val);
            }
        }

        private void setAttrFromJSONObject(JSONObject jObj) {
            this.name = jObj.optString("name");
            JSONObject firstJO = jObj.optJSONObject(JSON_KEY_FIRST);
            this.firstParamName = firstJO.optString("name");
            this.firstFormula = firstJO.optString(JSON_KEY_FORMULA);
            JSONObject secJO = jObj.optJSONObject(JSON_KEY_SECOND);
            this.secParamName = secJO.optString("name");
            this.secFormula = secJO.optString(JSON_KEY_FORMULA);
        }

        public JSONObject toJSONObject() {
            JSONObject jObj = new JSONObject();
            try {
                jObj.put("name", (Object)this.name);
                JSONObject firstJO = new JSONObject();
                firstJO.put("name", (Object)this.firstParamName);
                firstJO.put(JSON_KEY_FORMULA, (Object)this.firstFormula);
                jObj.put(JSON_KEY_FIRST, (Object)firstJO);
                JSONObject secondJO = new JSONObject();
                secondJO.put("name", (Object)this.secParamName);
                secondJO.put(JSON_KEY_FORMULA, (Object)this.secFormula);
                jObj.put(JSON_KEY_SECOND, (Object)secondJO);
            }
            catch (JSONException e) {
                jObj = new JSONObject();
            }
            return jObj;
        }

        public String toSpecString() {
            StringBuffer buf = new StringBuffer();
            if (this.firstParamName == null || this.secParamName == null) {
                return null;
            }
            buf.append("name=" + this.name + ";");
            buf.append("firstParamName=" + this.firstParamName + ";");
            buf.append("secondParamName=" + this.secParamName + ";");
            buf.append("startFormula=" + DashboardUtil.encodeString(this.firstFormula) + ";");
            buf.append("endFormula=" + DashboardUtil.encodeString(this.secFormula));
            return buf.toString();
        }
    }
}

