/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class ContainerProps {
    public static final String JSON_KEY_HEADERFONT = "headerFont";
    public static final String JSON_KEY_HEADERBG = "headerBG";
    public static final String JSON_KEY_BORDER = "border";
    public static final String JSON_KEY_ALIAS = "alias";
    public static final String JSON_KEY_HASSHADING = "hasShading";
    public static final String JSON_KEY_DESCRIPTION = "description";
    public static final String JSON_KEY_FONTNAME = "fontName";
    public static final String JSON_KEY_FONTSTYLE = "fontStyle";
    public static final String JSON_KEY_FONTWEIGHT = "fontWeight";
    public static final String JSON_KEY_FONTALIGN = "align";
    public static final String JSON_KEY_FONTCOLOR = "color";
    public static final String JSON_KEY_GRADIENTSTYLE = "gradientStyle";
    public static final String JSON_KEY_STARTCOLOR = "startColor";
    public static final String JSON_KEY_ENDCOLOR = "endColor";
    public static final String JSON_KEY_BORDERWIDTH = "width";
    public static final String JSON_KEY_BORDERCOLOR = "color";
    public static final String JSON_KEY_BORDERSTYLE = "style";
    public static final String JSON_KEY_TEMPLATEINFOID = "templateInfoID";
    private String fontName;
    private String fontStyle;
    private String fontWeight;
    private String fontAlign;
    private int[] fontColor;
    private String alias;
    private String description;
    private int gradientStyle;
    private int[] startColor;
    private int[] endColor;
    private int borderWidth;
    private String borderStyle;
    private int[] borderColor;
    private boolean hasShading;
    private String templateInfoID;

    public ContainerProps(String jsonStr) {
        try {
            JSONObject jObj = new JSONObject(jsonStr);
            this.setAttrFromJSON(jObj);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public ContainerProps(String templateInfoID, JSONObject propJObj) {
        this.templateInfoID = templateInfoID;
        this.setAttrFromJSON(propJObj);
    }

    private void setAttrFromJSON(JSONObject jObj) {
        JSONObject fontJO = jObj.optJSONObject(JSON_KEY_HEADERFONT);
        this.fontName = fontJO.optString(JSON_KEY_FONTNAME);
        this.fontStyle = fontJO.optString(JSON_KEY_FONTSTYLE);
        this.fontAlign = fontJO.optString(JSON_KEY_FONTALIGN);
        this.fontWeight = fontJO.optString(JSON_KEY_FONTWEIGHT);
        JSONArray fontColorJA = fontJO.optJSONArray("color");
        this.fontColor = DashboardUtil.convertToColorRGB(fontColorJA);
        JSONObject bgJO = jObj.optJSONObject(JSON_KEY_HEADERBG);
        this.gradientStyle = bgJO.optInt(JSON_KEY_GRADIENTSTYLE);
        JSONArray startColorJA = bgJO.optJSONArray(JSON_KEY_STARTCOLOR);
        this.startColor = DashboardUtil.convertToColorRGB(startColorJA);
        JSONArray endColorJA = bgJO.optJSONArray(JSON_KEY_ENDCOLOR);
        this.endColor = DashboardUtil.convertToColorRGB(endColorJA);
        JSONObject borderJO = jObj.optJSONObject(JSON_KEY_BORDER);
        this.borderWidth = borderJO.optInt(JSON_KEY_BORDERWIDTH);
        this.borderStyle = borderJO.optString(JSON_KEY_BORDERSTYLE);
        JSONArray borderColorJA = borderJO.optJSONArray("color");
        this.borderColor = DashboardUtil.convertToColorRGB(borderColorJA);
        this.alias = jObj.optString(JSON_KEY_ALIAS);
        this.description = jObj.optString(JSON_KEY_DESCRIPTION);
        this.hasShading = jObj.optBoolean(JSON_KEY_HASSHADING);
        if (this.templateInfoID == null) {
            this.templateInfoID = jObj.optString(JSON_KEY_TEMPLATEINFOID, null);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            if (this.templateInfoID != null) {
                jObj.put(JSON_KEY_TEMPLATEINFOID, (Object)this.templateInfoID);
            }
            JSONObject fontJO = new JSONObject();
            fontJO.put(JSON_KEY_FONTNAME, (Object)this.fontName);
            fontJO.put(JSON_KEY_FONTSTYLE, (Object)this.fontStyle);
            fontJO.put(JSON_KEY_FONTALIGN, (Object)this.fontAlign);
            JSONArray fontColorJA = DashboardUtil.convertToColorJSONArray(this.fontColor);
            fontJO.put("color", (Object)fontColorJA);
            jObj.put(JSON_KEY_HEADERFONT, (Object)fontJO);
            JSONObject bgJO = new JSONObject();
            bgJO.put(JSON_KEY_GRADIENTSTYLE, this.gradientStyle);
            JSONArray startColorJA = DashboardUtil.convertToColorJSONArray(this.startColor);
            bgJO.put(JSON_KEY_STARTCOLOR, (Object)startColorJA);
            JSONArray endColorJA = DashboardUtil.convertToColorJSONArray(this.endColor);
            bgJO.put(JSON_KEY_ENDCOLOR, (Object)endColorJA);
            jObj.put(JSON_KEY_HEADERBG, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            borderJO.put(JSON_KEY_BORDERWIDTH, this.borderWidth);
            borderJO.put(JSON_KEY_BORDERSTYLE, (Object)this.borderStyle);
            JSONArray borderColorJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            borderJO.put("color", (Object)borderColorJA);
            jObj.put(JSON_KEY_BORDER, (Object)borderJO);
            jObj.put(JSON_KEY_ALIAS, (Object)this.alias);
            jObj.put(JSON_KEY_DESCRIPTION, (Object)this.description);
            jObj.put(JSON_KEY_HASSHADING, this.hasShading);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj;
    }

    public String toString() {
        JSONObject jObj = this.toJSONObject();
        return jObj.toString();
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String fontAlign) {
        this.fontAlign = fontAlign;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getGradientStyle() {
        return this.gradientStyle;
    }

    public void setGradientStyle(int gradientStyle) {
        this.gradientStyle = gradientStyle;
    }

    public int[] getStartColor() {
        return this.startColor;
    }

    public void setStartColor(int[] startColor) {
        this.startColor = startColor;
    }

    public int[] getEndColor() {
        return this.endColor;
    }

    public void setEndColor(int[] endColor) {
        this.endColor = endColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isHasShading() {
        return this.hasShading;
    }

    public void setShowShadding(boolean hasShading) {
        this.hasShading = hasShading;
    }

    public String getTemplateInfoID() {
        return this.templateInfoID;
    }

    public void setTemplateInfoID(String templateInfoID) {
        this.templateInfoID = templateInfoID;
    }
}

