/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.components.Background;
import quadbase.dashboard3.components.ComboSharedParam;
import quadbase.dashboard3.components.DashboardOptions;
import quadbase.dashboard3.components.DetSPPanelAttributes;
import quadbase.dashboard3.components.DrillDownInfo;
import quadbase.dashboard3.components.ExpandedSharedParam;
import quadbase.dashboard3.components.FloatOrderAttributes;
import quadbase.dashboard3.components.FolderAttributes;
import quadbase.dashboard3.components.ImageLabel;
import quadbase.dashboard3.components.PseqPanelAttributes;
import quadbase.dashboard3.components.SharedParam;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TextLabel;
import quadbase.dashboard3.components.ZIndexAttr;

public class DashboardAttributes {
    public static final String ATTR_NAME_VERSION = "version";
    public static final String ATTR_NAME_TEMPLATELIST = "templateList";
    public static final String ATTR_NAME_BACKGROUND = "background";
    public static final String ATTR_NAME_TEXTLABELS = "textLabels";
    public static final String ATTR_NAME_IMAGELABELS = "imageLabels";
    public static final String ATTR_NAME_SHAREDPARAMS = "sharedParams";
    public static final String ATTR_NAME_DASHBOARDOPTIONS = "dashboardOptions";
    public static final String ATTR_NAME_EXPSPLIST = "expSpList";
    public static final String ATTR_NAME_DETPARAMPANEL = "detParamPanel";
    public static final String ATTR_NAME_PSEQ_PARAM_PANEL = "pseqParamPanel";
    public static final String ATTR_NAME_FLOAT_ORDER_ATTRIBUTES = "floatOrderAttributes";
    public static final String ATTR_NAME_COMBOPARAMS = "comboParams";
    public static final String ATTR_NAME_FOLDERS = "folders";
    public static final String ATTR_NAME_DRILLDOWNS = "drilldowns";
    public static final String ATTR_NAME_LINKATTRS = "linkAttrs";
    public static final String ATTR_NAME_ZINDEXATTRS = "zIndexAttrs";
    public static final int VERSION = 6;
    int version = 6;
    private int space = 20;
    private TemplateInfo[] templateInfos;
    private Background background;
    private TextLabel[] textLabels;
    private ImageLabel[] imageLabels;
    private SharedParam[] sharedParams;
    private DashboardOptions dashboardOptions;
    private ExpandedSharedParam[] expSpList;
    private DetSPPanelAttributes detParamPanel;
    private PseqPanelAttributes pSeqParamPanel;
    private FloatOrderAttributes floatOrderAttributes;
    private ComboSharedParam[] comboParams;
    private FolderAttributes[] folders;
    private DrillDownInfo[] drilldowns;
    private DrillDownInfo[] linkAttrs;
    private ZIndexAttr[] zIndexAttrs;

    public DashboardAttributes() {
    }

    public DashboardAttributes(DashboardAttributes da) {
        this.templateInfos = da.getTemplateInfos();
        this.background = da.getBackground();
        this.textLabels = da.getTextLabels();
        this.imageLabels = da.getImageLabels();
        this.sharedParams = da.getSharedParams();
        this.dashboardOptions = da.getDashboardOptions();
        this.expSpList = da.getExpSpList();
        this.detParamPanel = da.getDetParamPanel();
        this.pSeqParamPanel = da.getPseqParamPanel();
        this.comboParams = da.getComboParams();
        this.folders = da.getFolders();
        this.drilldowns = da.getDrilldowns();
        this.linkAttrs = da.getLinkAttrs();
        this.zIndexAttrs = da.getZIndexAttrs();
    }

    public DashboardAttributes(JSONObject jObj) {
        this.loadDashboardFromJSON(jObj);
    }

    protected void loadDashboardFromJSON(JSONObject jObj) {
        JSONArray zIndexAttrJA;
        JSONArray linkAttrJA;
        JSONArray ddInfoJA;
        JSONArray comboSpJA;
        JSONObject pseqParamPanelJObj;
        JSONObject detParamPanelJObj;
        JSONArray expSpJA;
        JSONArray spJA;
        JSONArray imageLabelJA;
        this.version = jObj.optInt(ATTR_NAME_VERSION, 6);
        JSONArray templateListJA = jObj.optJSONArray(ATTR_NAME_TEMPLATELIST);
        this.templateInfos = new TemplateInfo[templateListJA.length()];
        for (int i = 0; i < templateListJA.length(); ++i) {
            JSONObject templateJO = templateListJA.optJSONObject(i);
            this.templateInfos[i] = new TemplateInfo(templateJO);
        }
        JSONObject dbBGJO = jObj.optJSONObject(ATTR_NAME_BACKGROUND);
        this.background = new Background(dbBGJO);
        JSONArray textLabelJA = jObj.optJSONArray(ATTR_NAME_TEXTLABELS);
        if (textLabelJA != null) {
            this.textLabels = new TextLabel[textLabelJA.length()];
            for (int i = 0; i < textLabelJA.length(); ++i) {
                this.textLabels[i] = new TextLabel(textLabelJA.optJSONObject(i));
            }
        } else {
            this.textLabels = new TextLabel[0];
        }
        if ((imageLabelJA = jObj.optJSONArray(ATTR_NAME_IMAGELABELS)) != null) {
            this.imageLabels = new ImageLabel[imageLabelJA.length()];
            for (int i = 0; i < imageLabelJA.length(); ++i) {
                this.imageLabels[i] = new ImageLabel(imageLabelJA.optJSONObject(i));
            }
        } else {
            this.imageLabels = new ImageLabel[0];
        }
        if ((spJA = jObj.optJSONArray(ATTR_NAME_SHAREDPARAMS)) != null) {
            this.sharedParams = new SharedParam[spJA.length()];
            for (int i = 0; i < spJA.length(); ++i) {
                this.sharedParams[i] = new SharedParam(spJA.optJSONObject(i));
            }
        }
        if ((expSpJA = jObj.optJSONArray(ATTR_NAME_EXPSPLIST)) != null && expSpJA.length() > 0) {
            this.expSpList = new ExpandedSharedParam[expSpJA.length()];
            for (int i = 0; i < expSpJA.length(); ++i) {
                JSONObject expSpObj = expSpJA.optJSONObject(i);
                if (expSpObj == null) continue;
                this.expSpList[i] = new ExpandedSharedParam(expSpObj);
            }
        }
        if ((detParamPanelJObj = jObj.optJSONObject(ATTR_NAME_DETPARAMPANEL)) != null) {
            this.detParamPanel = new DetSPPanelAttributes(detParamPanelJObj);
        }
        if ((pseqParamPanelJObj = jObj.optJSONObject(ATTR_NAME_FLOAT_ORDER_ATTRIBUTES)) != null) {
            this.pSeqParamPanel = new PseqPanelAttributes(pseqParamPanelJObj);
        }
        if ((comboSpJA = jObj.optJSONArray(ATTR_NAME_COMBOPARAMS)) != null && comboSpJA.length() > 0) {
            this.comboParams = new ComboSharedParam[comboSpJA.length()];
            for (int i = 0; i < comboSpJA.length(); ++i) {
                JSONObject comboSpJO = comboSpJA.optJSONObject(i);
                if (comboSpJO == null) continue;
                this.comboParams[i] = new ComboSharedParam(comboSpJO);
            }
        }
        JSONObject dbOptJO = jObj.optJSONObject(ATTR_NAME_DASHBOARDOPTIONS);
        this.dashboardOptions = new DashboardOptions(dbOptJO);
        JSONArray folderJA = jObj.optJSONArray(ATTR_NAME_FOLDERS);
        if (folderJA != null && folderJA.length() > 0) {
            this.folders = new FolderAttributes[folderJA.length()];
            for (int i = 0; i < folderJA.length(); ++i) {
                JSONObject folderJO = folderJA.optJSONObject(i);
                if (folderJO == null) continue;
                this.folders[i] = new FolderAttributes(folderJO);
            }
        }
        if ((ddInfoJA = jObj.optJSONArray(ATTR_NAME_DRILLDOWNS)) != null && ddInfoJA.length() > 0) {
            this.drilldowns = new DrillDownInfo[ddInfoJA.length()];
            for (int i = 0; i < ddInfoJA.length(); ++i) {
                JSONObject ddInfoJO = ddInfoJA.optJSONObject(i);
                if (ddInfoJO == null) continue;
                this.drilldowns[i] = new DrillDownInfo(ddInfoJO);
            }
        }
        if ((linkAttrJA = jObj.optJSONArray(ATTR_NAME_LINKATTRS)) != null && linkAttrJA.length() > 0) {
            this.linkAttrs = new DrillDownInfo[linkAttrJA.length()];
            for (int i = 0; i < linkAttrJA.length(); ++i) {
                JSONObject laJO = linkAttrJA.optJSONObject(i);
                if (laJO == null) continue;
                this.linkAttrs[i] = new DrillDownInfo(laJO);
            }
        }
        if ((zIndexAttrJA = jObj.optJSONArray(ATTR_NAME_ZINDEXATTRS)) != null && zIndexAttrJA.length() > 0) {
            this.zIndexAttrs = new ZIndexAttr[zIndexAttrJA.length()];
            for (int i = 0; i < zIndexAttrJA.length(); ++i) {
                JSONObject ziJO = zIndexAttrJA.optJSONObject(i);
                if (ziJO == null) continue;
                this.zIndexAttrs[i] = new ZIndexAttr(ziJO);
            }
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            JSONArray linkAttrsJA;
            JSONArray ddInfoJA;
            JSONArray folderJA;
            jObj.put(ATTR_NAME_VERSION, this.version);
            jObj.put(ATTR_NAME_BACKGROUND, (Object)this.background.toJSONObject());
            JSONArray templateJA = new JSONArray();
            for (TemplateInfo templateInfo : this.templateInfos) {
                templateJA.put((Object)templateInfo.toJSONObject());
            }
            jObj.put(ATTR_NAME_TEMPLATELIST, (Object)templateJA);
            JSONArray imageLabelJA = new JSONArray();
            for (int i = 0; this.imageLabels != null && i < this.imageLabels.length; ++i) {
                imageLabelJA.put((Object)this.imageLabels[i].toJSONObject());
            }
            jObj.put(ATTR_NAME_IMAGELABELS, (Object)imageLabelJA);
            JSONArray textLabelJA = new JSONArray();
            for (TextLabel textLabel : this.textLabels) {
                textLabelJA.put((Object)textLabel.toJSONObject());
            }
            jObj.put(ATTR_NAME_TEXTLABELS, (Object)textLabelJA);
            if (this.sharedParams != null && this.sharedParams.length > 0) {
                JSONArray spJA = new JSONArray();
                for (SharedParam sharedParam : this.sharedParams) {
                    spJA.put((Object)sharedParam.toJSONObject());
                }
                jObj.put(ATTR_NAME_SHAREDPARAMS, (Object)spJA);
            }
            if (this.expSpList != null && this.expSpList.length > 0) {
                JSONArray expSpJA = new JSONArray();
                for (ExpandedSharedParam element : this.expSpList) {
                    expSpJA.put((Object)element.toJSONObject());
                }
                jObj.put(ATTR_NAME_EXPSPLIST, (Object)expSpJA);
            }
            if (this.detParamPanel != null) {
                JSONObject detSPPanelJObj = this.detParamPanel.toJSONObject();
                jObj.put(ATTR_NAME_DETPARAMPANEL, (Object)detSPPanelJObj);
            }
            if (this.pSeqParamPanel != null) {
                JSONObject pSeqPanelJObj = this.pSeqParamPanel.toJSONObject();
                jObj.put(ATTR_NAME_PSEQ_PARAM_PANEL, (Object)pSeqPanelJObj);
            }
            if (this.floatOrderAttributes != null) {
                JSONObject floatOrderAttributesJObj = this.floatOrderAttributes.toJSONObject();
                jObj.put(ATTR_NAME_FLOAT_ORDER_ATTRIBUTES, (Object)floatOrderAttributesJObj);
            }
            if (this.comboParams != null) {
                JSONArray comboSpJA = new JSONArray();
                for (ComboSharedParam comboParam : this.comboParams) {
                    comboSpJA.put((Object)comboParam.toJSONObject());
                }
                jObj.put(ATTR_NAME_COMBOPARAMS, (Object)comboSpJA);
            }
            if (this.dashboardOptions != null) {
                jObj.put(ATTR_NAME_DASHBOARDOPTIONS, (Object)this.dashboardOptions.toJSONObject());
            }
            if (this.folders != null) {
                folderJA = new JSONArray();
                for (FolderAttributes folder : this.folders) {
                    folderJA.put((Object)folder.toJSONObject());
                }
                jObj.put(ATTR_NAME_FOLDERS, (Object)folderJA);
            } else {
                folderJA = new JSONArray();
                jObj.put(ATTR_NAME_FOLDERS, (Object)folderJA);
            }
            if (this.drilldowns != null) {
                ddInfoJA = new JSONArray();
                for (DrillDownInfo drilldown : this.drilldowns) {
                    ddInfoJA.put((Object)drilldown.toJSONObject());
                }
                jObj.put(ATTR_NAME_DRILLDOWNS, (Object)ddInfoJA);
            } else {
                ddInfoJA = new JSONArray();
                jObj.put(ATTR_NAME_DRILLDOWNS, (Object)ddInfoJA);
            }
            if (this.linkAttrs != null) {
                linkAttrsJA = new JSONArray();
                for (DrillDownInfo linkAttr : this.linkAttrs) {
                    linkAttrsJA.put((Object)linkAttr.toJSONObject());
                }
                jObj.put(ATTR_NAME_LINKATTRS, (Object)linkAttrsJA);
            } else {
                linkAttrsJA = new JSONArray();
                jObj.put(ATTR_NAME_LINKATTRS, (Object)linkAttrsJA);
            }
            JSONArray ziAttrJA = new JSONArray();
            if (this.zIndexAttrs != null) {
                for (ZIndexAttr zIndexAttr : this.zIndexAttrs) {
                    ziAttrJA.put((Object)zIndexAttr.toJSONObject());
                }
            }
            jObj.put(ATTR_NAME_ZINDEXATTRS, (Object)ziAttrJA);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toJSONString() {
        JSONObject jObj = this.toJSONObject();
        return jObj.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public TemplateInfo[] getTemplateInfos() {
        return this.templateInfos;
    }

    public void setTemplateInfos(TemplateInfo[] templateInfos) {
        this.templateInfos = templateInfos;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public TextLabel[] getTextLabels() {
        return this.textLabels;
    }

    public void setTextLabels(TextLabel[] textLabels) {
        this.textLabels = textLabels;
    }

    public ImageLabel[] getImageLabels() {
        return this.imageLabels;
    }

    public void setImageLabels(ImageLabel[] imageLabels) {
        this.imageLabels = imageLabels;
    }

    public SharedParam[] getSharedParams() {
        return this.sharedParams;
    }

    public void setSharedParams(SharedParam[] sharedParams) {
        this.sharedParams = sharedParams;
    }

    public DashboardOptions getDashboardOptions() {
        return this.dashboardOptions;
    }

    public void setDashboardOptions(DashboardOptions dashboardOptions) {
        this.dashboardOptions = dashboardOptions;
    }

    public ExpandedSharedParam[] getExpSpList() {
        return this.expSpList;
    }

    public void setExpSpList(ExpandedSharedParam[] expSpList) {
        this.expSpList = expSpList;
    }

    public DetSPPanelAttributes getDetParamPanel() {
        return this.detParamPanel;
    }

    public void setDetParamPanel(DetSPPanelAttributes detParamPanel) {
        this.detParamPanel = detParamPanel;
    }

    public ComboSharedParam[] getComboParams() {
        return this.comboParams;
    }

    public void setComboParams(ComboSharedParam[] comboParams) {
        this.comboParams = comboParams;
    }

    public FolderAttributes[] getFolders() {
        return this.folders;
    }

    public void setFolders(FolderAttributes[] folders) {
        this.folders = folders;
    }

    public DrillDownInfo[] getDrilldowns() {
        return this.drilldowns;
    }

    public void setDrilldowns(DrillDownInfo[] drilldowns) {
        ArrayList<DrillDownInfo> verifiedDrilldowns = new ArrayList<DrillDownInfo>();
        for (DrillDownInfo drillDownInfo : drilldowns) {
            String srcTemplateInfoID = drillDownInfo.getSrcTemplateInfoID();
            if (this.getTemplateInfoByID(srcTemplateInfoID) == null) continue;
            verifiedDrilldowns.add(drillDownInfo);
        }
        this.drilldowns = verifiedDrilldowns.toArray(new DrillDownInfo[0]);
    }

    public DrillDownInfo[] getLinkAttrs() {
        return this.linkAttrs;
    }

    public void setLinkAttrs(DrillDownInfo[] linkAttrs) {
        ArrayList<DrillDownInfo> verifiedDrilldowns = new ArrayList<DrillDownInfo>();
        for (DrillDownInfo drillDownInfo : linkAttrs) {
            String srcTemplateInfoID = drillDownInfo.getSrcTemplateInfoID();
            if (this.getTemplateInfoByID(srcTemplateInfoID) == null) continue;
            verifiedDrilldowns.add(drillDownInfo);
        }
        this.linkAttrs = verifiedDrilldowns.toArray(new DrillDownInfo[0]);
    }

    public ZIndexAttr[] getZIndexAttrs() {
        return this.zIndexAttrs;
    }

    public void setZIndexAttrs(ZIndexAttr[] indexAttrs) {
        this.zIndexAttrs = indexAttrs;
    }

    public TemplateInfo getTemplateInfoByID(String templateId) {
        if (this.templateInfos == null) {
            return null;
        }
        for (TemplateInfo templateInfo : this.templateInfos) {
            if (!templateInfo.getTemplateID().equals(templateId)) continue;
            return templateInfo;
        }
        return null;
    }

    public PseqPanelAttributes getPseqParamPanel() {
        return this.pSeqParamPanel;
    }

    public void setPseqParamPanel(PseqPanelAttributes pSeqParamPanel) {
        this.pSeqParamPanel = pSeqParamPanel;
    }

    public FloatOrderAttributes getFloatOrderAttributes() {
        return this.floatOrderAttributes;
    }

    public void setFloatOrderAttributes(FloatOrderAttributes floatOrderAttributes) {
        this.floatOrderAttributes = floatOrderAttributes;
    }
}

