/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public class DashboardOptions {
    public static final String ATTR_NAME_CANRESIZE = "CanResize";
    public static final String ATTR_NAME_CANMOVE = "CanMove";
    public static final String ATTR_NAME_SHOWTOOLBAR = "ShowToolbar";
    public static final String ATTR_NAME_SHOWHEADER = "ShowHeader";
    public static final String ATTR_NAME_HEADERSPACEOPTION = "HeaderSpaceOption";
    public static final String ATTR_NAME_RPTSINGLEPAGE = "RptSinglePage";
    public static final String ATTR_NAME_USEORIGSIZE = "UseOrigSize";
    public static final String ATTR_NAME_USEORIGMARGIN = "UseOrigMargin";
    public static final String ATTR_NAME_CUSTMARGIN = "CustMargin";
    public static final String ATTR_NAME_SNAPTOGRID = "SnapToGrid";
    public static final String ATTR_NAME_FLASHCHART = "FlashChart";
    public static final String ATTR_NAME_FLASHCHARTANIM = "FlashChartAnim";
    public static final String ATTR_NAME_RPTEXPANDCOLLAPSE = "RptExpandCollapse";
    public static final String ATTR_NAME_RPTEXPANDCOLLAPSEANIM = "RptExpandCollapseAnim";
    public static final String ATTR_NAME_AUTOREFRESH = "AutoRefresh";
    public static final String ATTR_NAME_REFRESHINTERVAL = "RefreshInterval";
    public static final String ATTR_NAME_SHOWBORDERFORDASHBOARDCOMPONENTS = "ShowBorderForDashboardComponents";
    public static final String ATTR_NAME_TRANSPARENTBACKGROUNDFORREPORTSCHARTS = "TransparentBackgroundForReportsCharts";
    public static final String ATTR_NAME_MAXIMIZEONDOUBLETAP = "MaximizeOnDoubleTap";
    private boolean canResize = true;
    private boolean canMove = true;
    private boolean showToolbar = true;
    private boolean showHeader = true;
    private String headerSpaceOption = "moveUp";
    private boolean rptSinglePage = false;
    private boolean useOrigSize = true;
    private boolean useOrigMargin = true;
    private double custMargin = 0.2;
    private boolean snapToGrid = true;
    private boolean flashChart = false;
    private boolean flashChartAnim = false;
    private boolean rptExpandCollapse = false;
    private boolean rptExpandCollapseAnim = false;
    private boolean autorefresh = false;
    private int refreshInterval = 60;
    private boolean showBorderForDashboardComponents = true;
    private boolean transparentBackgroundforReportCharts = false;
    private boolean maximizeOnDoubleTap = true;

    public DashboardOptions(String specStr) {
        this.parseSpecString(specStr);
    }

    public DashboardOptions(JSONObject jObj) {
        this.setAttrFromJSONObject(jObj);
    }

    private void parseSpecString(String str) {
        StringTokenizer st = new StringTokenizer(str, ";");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            StringTokenizer pairSt = new StringTokenizer(pair, ":");
            String key = pairSt.nextToken();
            String value = "";
            if (pairSt.hasMoreTokens()) {
                value = pairSt.nextToken();
            }
            boolean boolValue = value.equalsIgnoreCase("true");
            if (key.equalsIgnoreCase(ATTR_NAME_CANMOVE)) {
                this.canMove = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_CANRESIZE)) {
                this.canResize = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_SHOWHEADER)) {
                this.showHeader = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_HEADERSPACEOPTION)) {
                this.headerSpaceOption = value;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_SHOWTOOLBAR)) {
                this.showToolbar = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_RPTSINGLEPAGE)) {
                this.rptSinglePage = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_USEORIGMARGIN)) {
                this.useOrigMargin = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_CUSTMARGIN)) {
                this.custMargin = Double.parseDouble(value);
                continue;
            }
            if (key.equals(ATTR_NAME_USEORIGSIZE)) {
                this.useOrigSize = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_SNAPTOGRID)) {
                this.snapToGrid = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_FLASHCHART)) {
                this.flashChart = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_FLASHCHARTANIM)) {
                this.flashChartAnim = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_RPTEXPANDCOLLAPSE)) {
                this.rptExpandCollapse = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_RPTEXPANDCOLLAPSEANIM)) {
                this.rptExpandCollapseAnim = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_AUTOREFRESH)) {
                this.autorefresh = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_REFRESHINTERVAL)) {
                this.refreshInterval = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_SHOWBORDERFORDASHBOARDCOMPONENTS)) {
                this.showBorderForDashboardComponents = boolValue;
                continue;
            }
            if (key.equalsIgnoreCase(ATTR_NAME_TRANSPARENTBACKGROUNDFORREPORTSCHARTS)) {
                this.transparentBackgroundforReportCharts = boolValue;
                continue;
            }
            if (!key.equalsIgnoreCase(ATTR_NAME_MAXIMIZEONDOUBLETAP)) continue;
            this.maximizeOnDoubleTap = boolValue;
        }
    }

    private void setAttrFromJSONObject(JSONObject jObj) {
        this.canMove = jObj.optBoolean(this.lower(ATTR_NAME_CANMOVE));
        this.canResize = jObj.optBoolean(this.lower(ATTR_NAME_CANRESIZE));
        this.flashChart = jObj.optBoolean(this.lower(ATTR_NAME_FLASHCHART));
        this.flashChartAnim = jObj.optBoolean(this.lower(ATTR_NAME_FLASHCHARTANIM));
        this.rptSinglePage = jObj.optBoolean(this.lower(ATTR_NAME_RPTSINGLEPAGE));
        this.showHeader = jObj.optBoolean(this.lower(ATTR_NAME_SHOWHEADER));
        this.headerSpaceOption = jObj.optString(this.lower(ATTR_NAME_HEADERSPACEOPTION));
        this.showToolbar = jObj.optBoolean(this.lower(ATTR_NAME_SHOWTOOLBAR));
        this.snapToGrid = jObj.optBoolean(this.lower(ATTR_NAME_SNAPTOGRID));
        this.useOrigMargin = jObj.optBoolean(this.lower(ATTR_NAME_USEORIGMARGIN));
        this.custMargin = jObj.optDouble(this.lower(ATTR_NAME_CUSTMARGIN), -1.0);
        this.useOrigSize = jObj.optBoolean(this.lower(ATTR_NAME_USEORIGSIZE));
        this.rptExpandCollapse = jObj.optBoolean(this.lower(ATTR_NAME_RPTEXPANDCOLLAPSE));
        this.rptExpandCollapseAnim = jObj.optBoolean(this.lower(ATTR_NAME_RPTEXPANDCOLLAPSEANIM));
        this.autorefresh = jObj.optBoolean(this.lower(ATTR_NAME_AUTOREFRESH));
        this.refreshInterval = jObj.optInt(this.lower(ATTR_NAME_REFRESHINTERVAL));
        this.showBorderForDashboardComponents = jObj.optBoolean(this.lower(ATTR_NAME_SHOWBORDERFORDASHBOARDCOMPONENTS));
        this.transparentBackgroundforReportCharts = jObj.optBoolean(this.lower(ATTR_NAME_TRANSPARENTBACKGROUNDFORREPORTSCHARTS));
        this.maximizeOnDoubleTap = jObj.optBoolean(this.lower(ATTR_NAME_MAXIMIZEONDOUBLETAP));
    }

    public String toSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CanMove:" + this.canMove);
        buf.append(";CanResize:" + this.canResize);
        buf.append(";ShowHeader:" + this.showHeader);
        buf.append(";HeaderSpaceOption:" + this.headerSpaceOption);
        buf.append(";ShowToolbar:" + this.showToolbar);
        buf.append(";RptSinglePage:" + this.rptSinglePage);
        buf.append(";UseOrigMargin:" + this.useOrigMargin);
        buf.append(";CustMargin:" + this.custMargin);
        buf.append(";UseOrigSize:" + this.useOrigSize);
        buf.append(";SnapToGrid:" + this.snapToGrid);
        buf.append(";FlashChart:" + this.flashChart);
        buf.append(";FlashChartAnim:" + this.flashChartAnim);
        buf.append(";RptExpandCollapse:" + this.rptExpandCollapse);
        buf.append(";RptExpandCollapseAnim:" + this.rptExpandCollapseAnim);
        buf.append(";AutoRefresh:" + this.autorefresh);
        buf.append(";RefreshInterval:" + this.refreshInterval);
        buf.append(";ShowBorderForDashboardComponents:" + this.showBorderForDashboardComponents);
        buf.append(";TransparentBackgroundForReportsCharts:" + this.transparentBackgroundforReportCharts);
        buf.append(";MaximizeOnDoubleTap:" + this.maximizeOnDoubleTap);
        return buf.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(this.lower(ATTR_NAME_CANMOVE), this.canMove);
            jObj.put(this.lower(ATTR_NAME_CANRESIZE), this.canResize);
            jObj.put(this.lower(ATTR_NAME_SHOWHEADER), this.showHeader);
            jObj.put(this.lower(ATTR_NAME_HEADERSPACEOPTION), (Object)this.headerSpaceOption);
            jObj.put(this.lower(ATTR_NAME_SHOWTOOLBAR), this.showToolbar);
            jObj.put(this.lower(ATTR_NAME_RPTSINGLEPAGE), this.rptSinglePage);
            jObj.put(this.lower(ATTR_NAME_USEORIGSIZE), this.useOrigMargin);
            jObj.put(this.lower(ATTR_NAME_CUSTMARGIN), this.custMargin);
            jObj.put(this.lower(ATTR_NAME_USEORIGSIZE), this.useOrigSize);
            jObj.put(this.lower(ATTR_NAME_SNAPTOGRID), this.snapToGrid);
            jObj.put(this.lower(ATTR_NAME_FLASHCHART), this.flashChart);
            jObj.put(this.lower(ATTR_NAME_FLASHCHARTANIM), this.flashChartAnim);
            jObj.put(this.lower(ATTR_NAME_RPTEXPANDCOLLAPSE), this.rptExpandCollapse);
            jObj.put(this.lower(ATTR_NAME_RPTEXPANDCOLLAPSEANIM), this.rptExpandCollapseAnim);
            jObj.put(this.lower(ATTR_NAME_AUTOREFRESH), this.autorefresh);
            jObj.put(this.lower(ATTR_NAME_REFRESHINTERVAL), this.refreshInterval);
            jObj.put(this.lower(ATTR_NAME_SHOWBORDERFORDASHBOARDCOMPONENTS), this.showBorderForDashboardComponents);
            jObj.put(this.lower(ATTR_NAME_TRANSPARENTBACKGROUNDFORREPORTSCHARTS), this.transparentBackgroundforReportCharts);
            jObj.put(this.lower(ATTR_NAME_MAXIMIZEONDOUBLETAP), this.maximizeOnDoubleTap);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    private String lower(String str) {
        String s = str.substring(0, 1).toLowerCase() + str.substring(1);
        return s;
    }

    public boolean isCanResize() {
        return this.canResize;
    }

    public void setCanResize(boolean canResize) {
        this.canResize = canResize;
    }

    public boolean isCanMove() {
        return this.canMove;
    }

    public void setCanMove(boolean canMove) {
        this.canMove = canMove;
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean showToolbar) {
        this.showToolbar = showToolbar;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean isRptSinglePage() {
        return this.rptSinglePage;
    }

    public void setRptSinglePage(boolean rptSinglePage) {
        this.rptSinglePage = rptSinglePage;
    }

    public boolean isUseOrigSize() {
        return this.useOrigSize;
    }

    public void setUseOrigSize(boolean useOrigSize) {
        this.useOrigSize = useOrigSize;
    }

    public boolean isUseOrigMargin() {
        return this.useOrigMargin;
    }

    public void setUseOrigMargin(boolean useOrigMargin) {
        this.useOrigMargin = useOrigMargin;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public boolean isFlashChart() {
        return this.flashChart;
    }

    public void setFlashChart(boolean flashChart) {
        this.flashChart = flashChart;
    }

    public boolean isFlashChartAnim() {
        return this.flashChartAnim;
    }

    public void setFlashChartAnim(boolean flashChartAnim) {
        this.flashChartAnim = flashChartAnim;
    }

    public String getHeaderSpaceOption() {
        return this.headerSpaceOption;
    }

    public void setHeaderSpaceOption(String headerSpaceOption) {
        this.headerSpaceOption = headerSpaceOption;
    }

    public double getCustMargin() {
        return this.custMargin;
    }

    public void setCustMargin(double custMargin) {
        this.custMargin = custMargin;
    }

    public boolean isRptExpandCollapse() {
        return this.rptExpandCollapse;
    }

    public void setRptExpandCollapse(boolean rptExpandCollapse) {
        this.rptExpandCollapse = rptExpandCollapse;
    }

    public boolean isRptExpandCollapseAnim() {
        return this.rptExpandCollapseAnim;
    }

    public void setRptExpandCollapseAnim(boolean rptExpandCollapseAnim) {
        this.rptExpandCollapseAnim = rptExpandCollapseAnim;
    }
}

