/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard3.api.DashboardUtil;

public class DetSPPanelAttributes {
    public static final String ATTR_NAME_PANELATTR = "panelAttr";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_BACKGROUND = "background";
    public static final String ATTR_NAME_BGCOLOR = "bgColor";
    public static final String ATTR_NAME_OPACITY = "opacity";
    public static final String ATTR_NAME_ISTRANSPARENT = "isTransparent";
    public static final String ATTR_NAME_USEBGIMAGE = "useBGImage";
    public static final String ATTR_NAME_BGIMAGEURL = "bgImageURL";
    public static final String ATTR_NAME_BGPOSITION = "bgPosition";
    public static final String ATTR_NAME_BGREPEAT = "bgRepeat";
    public static final String ATTR_NAME_BORDER = "border";
    public static final String ATTR_NAME_BORDER_COLOR = "color";
    public static final String ATTR_NAME_BORDER_THICKNESS = "thickness";
    public static final String ATTR_NAME_BORDER_STYLE = "style";
    public static final String ATTR_NAME_BORDER_PADDING = "padding";
    public static final String ATTR_NAME_OKBUTN = "okButn";
    public static final String ATTR_NAME_OKBUTNENABLED = "enabled";
    public static final String ATTR_NAME_OKBUTNTEXT = "text";
    public static final String ATTR_NAME_OKBUTNTOP = "top";
    public static final String ATTR_NAME_OKBUTNLEFT = "left";
    public static final String ATTR_NAME_OKBUTNWIDTH = "width";
    public static final String ATTR_NAME_OKBUTNHEIGHT = "height";
    public static final String ATTR_NAME_SHOWHEADER = "showHeader";
    public static final String ATTR_NAME_DIRECTION = "direction";
    public static final String ATTR_NAME_FONT = "font";
    public static final String ATTR_NAME_FONTCOLOR = "color";
    public static final String ATTR_NAME_FONTALIGN = "align";
    public static final String ATTR_NAME_FONTNAME = "fontName";
    public static final String ATTR_NAME_FONTSIZE = "fontSize";
    public static final String ATTR_NAME_HTMLFONTSTYLE = "fontStyle";
    public static final String ATTR_NAME_HTMLFONTWEIGHT = "fontWeight";
    public static final String ATTR_NAME_PARAMATTRLIST = "paramAttrList";
    private int width;
    private int height;
    private int top;
    private int left;
    private int borderThickness;
    private int borderPadding;
    private String borderStyle;
    private int[] borderColor;
    private int[] bgColor;
    private int opacity;
    private boolean isTransparent;
    private boolean useBGImage;
    private String bgImageURL;
    private String bgRepeat;
    private String bgPosition;
    private boolean okButnEnabled;
    private String okButnText = "OK";
    private int okButnTop;
    private int okButnLeft;
    private int okButnWidth;
    private int okButnHeight;
    private boolean showHeader;
    private String direction;
    private String fontName;
    private String fontStyle;
    private String fontWeight;
    private String fontAlign;
    private int fontSize;
    private int[] fontColor;
    private String innerHTML;
    private DetSPParamAttributes[] paramAttrList;

    public DetSPPanelAttributes(String panelSpecStr, String paramSpecStr) {
        this.setPanelAttrFromString(panelSpecStr);
        this.setParamAttrFromString(paramSpecStr);
    }

    public DetSPPanelAttributes(JSONObject jObj) {
        this.setPanelAttrFromJSONObject(jObj);
    }

    public void setPanelAttrFromString(String panelSpecStr) {
        StringTokenizer st = new StringTokenizer(panelSpecStr, ",");
        int numOfTokens = st.countTokens();
        if (numOfTokens < 13) {
            System.out.println("Detached Shared Parameter panel attribute not match: " + panelSpecStr);
            return;
        }
        String panelWidth = st.nextToken();
        this.width = DashboardUtil.getIntFromPX(panelWidth);
        String panelHeight = st.nextToken();
        this.height = DashboardUtil.getIntFromPX(panelHeight);
        String panelTop = st.nextToken();
        this.top = DashboardUtil.getIntFromPX(panelTop);
        String panelLeft = st.nextToken();
        this.left = DashboardUtil.getIntFromPX(panelLeft);
        String borderWidth = st.nextToken();
        this.borderThickness = DashboardUtil.getIntFromPX(borderWidth);
        this.borderStyle = st.nextToken();
        String borderColorStr = st.nextToken();
        borderColorStr = DashboardUtil.decodeString(borderColorStr);
        this.borderColor = DashboardUtil.convertToColorRGB(borderColorStr);
        String bgColorStr = st.nextToken();
        bgColorStr = DashboardUtil.decodeString(bgColorStr);
        this.bgColor = DashboardUtil.convertToColorRGB(bgColorStr);
        String bgOpacityStr = st.nextToken();
        String bgImage = "none";
        try {
            this.opacity = Integer.parseInt(bgOpacityStr);
            bgImage = st.nextToken();
        }
        catch (Exception e) {
            bgImage = bgOpacityStr;
            this.opacity = 100;
        }
        if (bgImage.equals("none")) {
            this.bgImageURL = "";
        } else {
            int loc2;
            int loc1 = bgImage.indexOf(40);
            String tmp = bgImage.substring(loc1 + 1, loc2 = bgImage.lastIndexOf(41)).trim();
            if (tmp.startsWith("'")) {
                tmp = tmp.replace('\'', ' ').trim();
            }
            this.bgImageURL = DashboardUtil.decodeString(tmp);
        }
        if (this.bgImageURL != null && this.bgImageURL.length() > 0) {
            if (this.bgImageURL.startsWith("\"")) {
                this.bgImageURL = this.bgImageURL.replace('\"', ' ').trim();
            }
            this.useBGImage = true;
        }
        this.bgRepeat = st.nextToken();
        this.bgPosition = st.nextToken();
        this.innerHTML = st.nextToken();
        this.innerHTML = DashboardUtil.decodeString(this.innerHTML);
        this.direction = "horizontal";
        if (numOfTokens >= 15) {
            st.nextToken();
            this.direction = st.nextToken();
        } else {
            this.direction = st.nextToken();
        }
        if (st.hasMoreElements()) {
            String okButnStr = st.nextToken();
            okButnStr = DashboardUtil.decodeString(okButnStr);
            try {
                JSONObject jObj = new JSONObject(okButnStr);
                this.updateOKButnAttr(jObj);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void setParamAttrFromString(String paramSpecStr) {
        StringTokenizer st = new StringTokenizer(paramSpecStr, ";");
        Vector<DetSPParamAttributes> vect = new Vector<DetSPParamAttributes>();
        while (st.hasMoreTokens()) {
            String specStr = st.nextToken();
            DetSPParamAttributes detSPParamAttr = new DetSPParamAttributes(specStr);
            vect.add(detSPParamAttr);
        }
        this.paramAttrList = new DetSPParamAttributes[vect.size()];
        for (int i = 0; i < vect.size(); ++i) {
            this.paramAttrList[i] = (DetSPParamAttributes)vect.elementAt(i);
        }
        String fontStr = this.paramAttrList[0].getFontStr();
        this.setPanelFontAttr(fontStr);
    }

    private void setPanelFontAttr(String fontStr) {
        String fontSizeStr;
        StringTokenizer st = new StringTokenizer(fontStr, ";");
        Hashtable<String, String> prop = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            StringTokenizer pairST = new StringTokenizer(pair, ":");
            String key = pairST.nextToken().trim();
            String val = pairST.nextToken();
            prop.put(key, val);
        }
        this.fontAlign = (String)prop.get("text-align");
        if (this.fontAlign == null) {
            this.fontAlign = "left";
        }
        this.fontName = (String)prop.get("font-family");
        if (this.fontName == null) {
            this.fontName = "Arial";
        }
        this.fontStyle = (String)prop.get("font-style");
        if (this.fontStyle == null) {
            this.fontStyle = "plain";
        }
        this.fontSize = (fontSizeStr = (String)prop.get("font-size")) == null ? 12 : DashboardUtil.getIntFromPX(fontSizeStr);
        String fontColorStr = (String)prop.get("color");
        this.fontColor = fontColorStr == null ? new int[]{0, 0, 0} : DashboardUtil.convertToColorRGB(fontColorStr);
        this.fontWeight = (String)prop.get("font-weight");
        if (this.fontWeight == null) {
            this.fontWeight = "normal";
        }
    }

    public void setPanelAttrFromJSONObject(JSONObject jObj) {
        JSONObject okButnJObj;
        JSONObject fontJObj;
        JSONObject panelAttrJObj = jObj.optJSONObject(ATTR_NAME_PANELATTR);
        JSONObject sizeJObj = panelAttrJObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJObj.optInt("width");
        this.height = sizeJObj.optInt("height");
        JSONObject posJObj = panelAttrJObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = posJObj.optInt("top");
        this.left = posJObj.optInt("left");
        JSONObject bgJObj = panelAttrJObj.optJSONObject(ATTR_NAME_BACKGROUND);
        JSONArray bgColorJA = bgJObj.optJSONArray(ATTR_NAME_BGCOLOR);
        this.bgColor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.bgColor[i] = bgColorJA.optInt(i);
        }
        this.opacity = bgJObj.optInt(ATTR_NAME_OPACITY);
        this.isTransparent = bgJObj.optBoolean(ATTR_NAME_ISTRANSPARENT);
        this.useBGImage = bgJObj.optBoolean(ATTR_NAME_USEBGIMAGE);
        this.bgImageURL = bgJObj.optString(ATTR_NAME_BGIMAGEURL);
        this.bgPosition = bgJObj.optString(ATTR_NAME_BGPOSITION);
        this.bgRepeat = bgJObj.optString(ATTR_NAME_BGREPEAT);
        JSONObject borderJObj = panelAttrJObj.optJSONObject(ATTR_NAME_BORDER);
        if (borderJObj != null) {
            JSONArray bdrColorJA = borderJObj.optJSONArray("color");
            this.borderColor = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.borderColor[i] = bdrColorJA.optInt(i);
            }
            this.borderStyle = borderJObj.optString(ATTR_NAME_BORDER_STYLE);
            this.borderThickness = borderJObj.optInt(ATTR_NAME_BORDER_THICKNESS);
            this.borderPadding = borderJObj.optInt(ATTR_NAME_BORDER_PADDING);
        }
        if ((fontJObj = panelAttrJObj.optJSONObject(ATTR_NAME_FONT)) != null) {
            this.fontName = fontJObj.optString(ATTR_NAME_FONTNAME);
            this.fontStyle = fontJObj.optString(ATTR_NAME_HTMLFONTSTYLE);
            this.fontWeight = fontJObj.optString(ATTR_NAME_HTMLFONTWEIGHT);
            this.fontSize = fontJObj.optInt(ATTR_NAME_FONTSIZE);
            this.fontAlign = fontJObj.optString(ATTR_NAME_FONTALIGN);
            JSONArray fcJA = fontJObj.optJSONArray("color");
            this.fontColor = DashboardUtil.convertToColorRGB(fcJA);
        }
        this.showHeader = panelAttrJObj.optBoolean(ATTR_NAME_SHOWHEADER, false);
        this.direction = panelAttrJObj.optString(ATTR_NAME_DIRECTION, "horizontal");
        StringBuffer fontStrBuf = new StringBuffer();
        fontStrBuf.append("font-family:" + this.fontName + ";");
        fontStrBuf.append("font-style:" + this.fontStyle + ";");
        fontStrBuf.append("font-weight:" + this.fontWeight + ";");
        fontStrBuf.append("font-size:" + this.fontSize + "px;");
        fontStrBuf.append("text-align:" + this.fontAlign + ";");
        fontStrBuf.append("color:" + DashboardUtil.convertToColorStr(this.fontColor));
        String fontStr = fontStrBuf.toString();
        JSONArray paramAttrJA = jObj.optJSONArray(ATTR_NAME_PARAMATTRLIST);
        if (paramAttrJA != null) {
            this.paramAttrList = new DetSPParamAttributes[paramAttrJA.length()];
            for (int i = 0; i < paramAttrJA.length(); ++i) {
                this.paramAttrList[i] = new DetSPParamAttributes(paramAttrJA.optJSONObject(i));
                this.paramAttrList[i].setFontStr(fontStr);
            }
        }
        if ((okButnJObj = jObj.optJSONObject(ATTR_NAME_OKBUTN)) != null) {
            this.updateOKButnAttr(okButnJObj);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            JSONObject panelAttrJObj = new JSONObject();
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = DashboardUtil.convertToColorJSONArray(this.bgColor);
            bgJO.put(ATTR_NAME_BGCOLOR, (Object)bgColorJA);
            bgJO.put(ATTR_NAME_BGIMAGEURL, (Object)this.bgImageURL);
            bgJO.put(ATTR_NAME_BGPOSITION, (Object)this.bgPosition);
            bgJO.put(ATTR_NAME_BGREPEAT, (Object)this.bgRepeat);
            boolean isTransparent = this.opacity == 0;
            bgJO.put(ATTR_NAME_ISTRANSPARENT, isTransparent);
            bgJO.put(ATTR_NAME_OPACITY, this.opacity);
            boolean useBGImage = !this.bgImageURL.equals("") || !this.innerHTML.equals("none");
            bgJO.put(ATTR_NAME_USEBGIMAGE, useBGImage);
            panelAttrJObj.put(ATTR_NAME_BACKGROUND, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            JSONArray borderColorJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            borderJO.put("color", (Object)borderColorJA);
            borderJO.put(ATTR_NAME_BORDER_THICKNESS, this.borderThickness);
            borderJO.put(ATTR_NAME_BORDER_STYLE, (Object)this.borderStyle);
            borderJO.put(ATTR_NAME_BORDER_PADDING, this.borderPadding);
            panelAttrJObj.put(ATTR_NAME_BORDER, (Object)borderJO);
            JSONObject fontJO = new JSONObject();
            JSONArray fontColorJA = DashboardUtil.convertToColorJSONArray(this.fontColor);
            fontJO.put("color", (Object)fontColorJA);
            fontJO.put(ATTR_NAME_FONTNAME, (Object)this.fontName);
            fontJO.put(ATTR_NAME_HTMLFONTSTYLE, (Object)this.fontStyle);
            fontJO.put(ATTR_NAME_HTMLFONTWEIGHT, (Object)this.fontWeight);
            fontJO.put(ATTR_NAME_FONTSIZE, this.fontSize);
            fontJO.put(ATTR_NAME_FONTALIGN, (Object)this.fontAlign);
            panelAttrJObj.put(ATTR_NAME_FONT, (Object)fontJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put("width", this.width);
            sizeJO.put("height", this.height);
            panelAttrJObj.put(ATTR_NAME_SIZE, (Object)sizeJO);
            JSONObject posJO = new JSONObject();
            posJO.put("top", this.top);
            posJO.put("left", this.left);
            panelAttrJObj.put(ATTR_NAME_POSITION, (Object)posJO);
            JSONObject okButnJO = this.getOKButnJSONObject();
            panelAttrJObj.put(ATTR_NAME_OKBUTN, (Object)okButnJO);
            panelAttrJObj.put(ATTR_NAME_SHOWHEADER, this.showHeader);
            panelAttrJObj.put(ATTR_NAME_DIRECTION, (Object)this.direction);
            jObj.put(ATTR_NAME_PANELATTR, (Object)panelAttrJObj);
            JSONArray paramAttrListJA = new JSONArray();
            for (DetSPParamAttributes element : this.paramAttrList) {
                paramAttrListJA.put((Object)element.toJSONObject());
            }
            jObj.put(ATTR_NAME_PARAMATTRLIST, (Object)paramAttrListJA);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String getPanelSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.width + "px,");
        buf.append(this.height + "px,");
        buf.append(this.top + "px,");
        buf.append(this.left + "px,");
        buf.append(this.borderThickness + "px,");
        buf.append(this.borderStyle + ",");
        String borderColorStr = DashboardUtil.convertToColorStr(this.borderColor);
        borderColorStr = DashboardUtil.encodeString(borderColorStr);
        buf.append(borderColorStr + ",");
        String bgColorStr = DashboardUtil.convertToColorStr(this.bgColor);
        bgColorStr = DashboardUtil.encodeString(bgColorStr);
        buf.append(bgColorStr + ",");
        buf.append(this.opacity + ",");
        String bgImageStr = this.bgImageURL != null && this.bgImageURL.length() > 0 ? "url('" + QbUtil.encodeURIComponent(this.bgImageURL) + "')" : "none";
        buf.append(bgImageStr + ",");
        buf.append(this.bgRepeat + ",");
        buf.append(this.bgPosition + ",");
        if (this.innerHTML == null || this.innerHTML.equals("")) {
            this.innerHTML = "none";
        }
        buf.append(this.innerHTML + ",");
        buf.append("false,horizontal");
        JSONObject okButnJO = this.getOKButnJSONObject();
        String okButnStr = okButnJO.toString();
        okButnStr = DashboardUtil.encodeString(okButnStr);
        buf.append("," + okButnStr);
        return buf.toString();
    }

    public String getParamSpecString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.paramAttrList.length; ++i) {
            String specStr = this.paramAttrList[i].toSpecString();
            if (i > 0) {
                buf.append(";");
            }
            buf.append(specStr);
        }
        return buf.toString();
    }

    private void updateOKButnAttr(JSONObject okButnJObj) {
        this.okButnEnabled = okButnJObj.optBoolean(ATTR_NAME_OKBUTNENABLED);
        this.okButnText = okButnJObj.optString(ATTR_NAME_OKBUTNTEXT);
        this.okButnTop = okButnJObj.optInt("top");
        this.okButnLeft = okButnJObj.optInt("left");
        this.okButnWidth = okButnJObj.optInt("width");
        this.okButnHeight = okButnJObj.optInt("height");
    }

    private JSONObject getOKButnJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_OKBUTNENABLED, this.okButnEnabled);
            jObj.put(ATTR_NAME_OKBUTNTEXT, (Object)this.okButnText);
            jObj.put("width", this.okButnWidth);
            jObj.put("height", this.okButnHeight);
            jObj.put("top", this.okButnTop);
            jObj.put("left", this.okButnLeft);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj;
    }

    public String getBgImageURL() {
        return this.bgImageURL;
    }

    public void setBgImageURL(String bgImageURL) {
        this.bgImageURL = bgImageURL;
    }

    public boolean isOKButnEnabled() {
        return this.okButnEnabled;
    }

    public void setOKButnEnabled(boolean addOKButn) {
        this.okButnEnabled = addOKButn;
    }

    public String getOkButnText() {
        return this.okButnText;
    }

    public void setOkButnText(String okButnText) {
        this.okButnText = okButnText;
    }

    public int getOkButnTop() {
        return this.okButnTop;
    }

    public void setOkButnTop(int okButnTop) {
        this.okButnTop = okButnTop;
    }

    public int getOkButnLeft() {
        return this.okButnLeft;
    }

    public void setOkButnLeft(int okButnLeft) {
        this.okButnLeft = okButnLeft;
    }

    public int getOkButnWidth() {
        return this.okButnWidth;
    }

    public void setOkButnWidth(int okButnWidth) {
        this.okButnWidth = okButnWidth;
    }

    public int getOkButnHeight() {
        return this.okButnHeight;
    }

    public void setOkButnHeight(int okButnHeight) {
        this.okButnHeight = okButnHeight;
    }

    public class DetSPParamAttributes {
        private String paramName;
        private int width;
        private int height;
        private int top;
        private int left;
        private String fontStr;
        private String borderStr;
        private static final String JSON_KEY_SIZE = "size";
        private static final String JSON_KEY_WIDTH = "width";
        private static final String JSON_KEY_HEIGHT = "height";
        private static final String JSON_KEY_POSITION = "position";
        private static final String JSON_KEY_TOP = "top";
        private static final String JSON_KEY_LEFT = "left";
        private static final String JSON_KEY_PARAMNAME = "paramName";

        public DetSPParamAttributes(String specStr) {
            this.setAttrFromString(specStr);
        }

        public DetSPParamAttributes(JSONObject jObj) {
            this.setAttrFromJSON(jObj);
        }

        private void setAttrFromString(String specStr) {
            String fontWeight;
            String fontColor;
            String fontSize;
            String fontStyle;
            String fontFamily;
            StringTokenizer specST = new StringTokenizer(specStr, ":");
            this.paramName = specST.nextToken();
            String attr = specST.nextToken();
            attr = DashboardUtil.decodeString(attr);
            Hashtable<String, String> prop = new Hashtable<String, String>();
            StringTokenizer stAttr = new StringTokenizer(attr, ";");
            while (stAttr.hasMoreTokens()) {
                String pair = stAttr.nextToken();
                StringTokenizer pairST = new StringTokenizer(pair, ":");
                String key = pairST.nextToken().trim();
                String val = pairST.nextToken();
                prop.put(key, val);
            }
            String topStr = (String)prop.get("top");
            this.top = DashboardUtil.getIntFromPX(topStr);
            String leftStr = (String)prop.get("left");
            this.left = DashboardUtil.getIntFromPX(leftStr);
            String widthStr = (String)prop.get("width");
            this.width = DashboardUtil.getIntFromPX(widthStr);
            String heightStr = (String)prop.get("height");
            this.height = DashboardUtil.getIntFromPX(heightStr);
            this.borderStr = (String)prop.get(DetSPPanelAttributes.ATTR_NAME_BORDER);
            String textAlign = (String)prop.get("text-align");
            if (textAlign == null) {
                textAlign = "left";
            }
            if ((fontFamily = (String)prop.get("font-family")) == null) {
                fontFamily = "Arial";
            }
            if ((fontStyle = (String)prop.get("font-style")) == null) {
                fontStyle = "plain";
            }
            if ((fontSize = (String)prop.get("font-size")) == null) {
                fontSize = "12px";
            }
            if ((fontColor = (String)prop.get("color")) == null) {
                fontColor = "rgb(0,0,0)";
            }
            if ((fontWeight = (String)prop.get("font-weight")) == null) {
                fontWeight = "normal";
            }
            this.fontStr = "font-family:" + fontFamily + "; font-style:" + fontStyle + "; font-size:" + fontSize + "; color:" + fontColor + "; font-weight:" + fontWeight + "; text-align:" + textAlign;
        }

        private void setAttrFromJSON(JSONObject jObj) {
            JSONObject positionJO;
            JSONObject sizeJO = jObj.optJSONObject("size");
            if (sizeJO != null) {
                this.width = sizeJO.optInt("width");
                this.height = sizeJO.optInt("height");
            }
            if ((positionJO = jObj.optJSONObject("position")) != null) {
                this.top = positionJO.optInt("top");
                this.left = positionJO.optInt("left");
            }
            this.paramName = jObj.optString(JSON_KEY_PARAMNAME);
            this.fontStr = "";
        }

        public JSONObject toJSONObject() {
            JSONObject jObj = new JSONObject();
            try {
                JSONObject sizeJO = new JSONObject();
                sizeJO.put("width", this.width);
                sizeJO.put("height", this.height);
                jObj.put("size", (Object)sizeJO);
                JSONObject positionJO = new JSONObject();
                positionJO.put("top", this.top);
                positionJO.put("left", this.left);
                jObj.put("position", (Object)positionJO);
                jObj.put(JSON_KEY_PARAMNAME, (Object)this.paramName);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jObj;
        }

        public String toSpecString() {
            if (this.fontStr == null || this.fontStr.equals("")) {
                System.out.println("Internal Error: DetSPParamAttributes.toSpecString: missing 'fontStr'");
                this.fontStr = "";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("position:absolute;");
            buf.append("top:" + this.top + "px;");
            buf.append("left:" + this.left + "px;");
            buf.append("width:" + this.width + "px;");
            buf.append("height:" + this.height + "px;");
            buf.append("border:" + this.borderStr + ";");
            buf.append(this.fontStr);
            String attr = buf.toString();
            attr = DashboardUtil.encodeString(attr);
            return this.paramName + ":" + attr;
        }

        public void setFontStr(String fontStr) {
            this.fontStr = fontStr;
        }

        public String getFontStr() {
            return this.fontStr;
        }
    }
}

