/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class DrillDownInfo {
    public static final int CHARTTYPE = 0;
    public static final int REPORTTYPE = 1;
    public static final int DASHBOARDTYPE = 2;
    public static final int MAPTYPE = 4;
    public static final int EASYREPORTTYPE = 6;
    public static final String ATTR_NAME_ID = "id";
    public static final String ATTR_NAME_NAME = "name";
    public static final String ATTR_NAME_SRCTEMPLATEINFOID = "srcTemplateInfoID";
    public static final String ATTR_NAME_DESTTEMPLATEINFOID = "destTemplateInfoID";
    public static final String ATTR_NAME_DESTTYPE = "destType";
    public static final String ATTR_NAME_DESTPATH = "destPath";
    public static final String ATTR_NAME_PARAMMAP = "paramMap";
    public static final String ATTR_NAME_DRILLPARAMNAME = "drillParamName";
    public static final String ATTR_NAME_DRILLPARAMVALUE = "drillParamValue";
    public static final String ATTR_NAME_DESTPARAMNAME = "destParamName";
    public static final String ATTR_NAME_MAPTOCHART = "mapToColumn";
    public static final String ATTR_NAME_MAPTOPARAMNAME = "mapToName";
    public static final String ATTR_NAME_MAPTOCOLINDEX = "colIndex";
    public static final String ATTR_NAME_SRCDATATYPE = "srcDataType";
    public static final String ATTR_NAME_DESTDATATYPE = "destDataType";
    public static final String ATTR_NAME_SAMEPAGEDRILLDOWN = "samePageDrillDown";
    public static final String ATTR_NAME_SAME_PAGE_SRCPARAMNAME = "mapToName";
    public static final String ATTR_NAME_SAME_PAGE_DESTPARAMNAME = "destParamName";
    private int id;
    private String name = "";
    private String srcTemplateInfoID = "";
    private String destTemplateInfoID = "";
    private String destTypeName;
    private int destType;
    private String destPath = "";
    private Vector<String> drillParamName;
    private Vector<String> drillParamValue;
    private boolean[] mapToChart;
    private String[] mapToParam;
    private int[] colIndex;
    private int[] srcDataType;
    private int[] destDataType;
    private boolean samePageDrillDown = false;

    public DrillDownInfo(String str) {
        this(str, false);
    }

    public DrillDownInfo(String str, boolean samePageDrillDown) {
        this.samePageDrillDown = samePageDrillDown;
        if (samePageDrillDown) {
            this.setSamePageDrillDownInfo(str);
        } else {
            this.setDrillDownInfo(str);
        }
    }

    public DrillDownInfo(JSONObject jObj) {
        boolean isSamePageDD;
        this.samePageDrillDown = isSamePageDD = jObj.optBoolean(ATTR_NAME_SAMEPAGEDRILLDOWN, false);
        if (isSamePageDD) {
            this.setSamePageDrillDownInfo(jObj);
        } else {
            this.setDrillDownInfo(jObj);
        }
    }

    public DrillDownInfo(JSONObject jObj, boolean samePageDrillDown) {
        if (samePageDrillDown) {
            this.setSamePageDrillDownInfo(jObj);
        } else {
            this.setDrillDownInfo(jObj);
        }
    }

    private void setDrillDownInfo(String str) {
        this.drillParamName = new Vector();
        this.drillParamValue = new Vector();
        if (str == null || str.equals("")) {
            return;
        }
        int idx = str.indexOf("-_-");
        this.srcTemplateInfoID = str.substring(0, idx);
        str = str.substring(idx + 3);
        idx = str.indexOf("-_-");
        this.destTemplateInfoID = str.substring(0, idx);
        str = str.substring(idx + 3);
        idx = str.indexOf("-_-");
        this.destTypeName = str.substring(0, idx);
        if (this.destTypeName.equals("CHT")) {
            this.destType = 0;
        } else if (this.destTypeName.equals("RPT")) {
            this.destType = 1;
        } else if (this.destTypeName.equals("DB")) {
            this.destType = 2;
        } else if (this.destTypeName.equals("GOOGLEMAP") || this.destTypeName.equals("SVGMAP")) {
            this.destType = 4;
        } else if (this.destTypeName.equals("EASYREPORT")) {
            this.destType = 6;
        }
        str = str.substring(idx + 3);
        idx = str.indexOf("-_-");
        if (idx < 0) {
            this.destPath = str;
            this.drillParamName = new Vector();
            this.drillParamValue = new Vector();
            this.mapToChart = new boolean[0];
            this.mapToParam = new String[0];
            this.colIndex = new int[0];
            this.destDataType = new int[0];
            this.srcDataType = new int[0];
            return;
        }
        this.destPath = str.substring(0, idx);
        str = str.substring(idx + 3);
        idx = str.indexOf("-_-");
        while (idx >= 0) {
            this.drillParamName.addElement(str.substring(0, idx));
            str = str.substring(idx + 3);
            idx = str.indexOf("-_-");
            if (idx == -1) {
                this.drillParamValue.addElement(str);
                continue;
            }
            this.drillParamValue.addElement(str.substring(0, idx));
            str = str.substring(idx + 3);
            idx = str.indexOf("-_-");
        }
        this.mapToChart = new boolean[this.drillParamValue.size()];
        this.mapToParam = new String[this.drillParamValue.size()];
        this.colIndex = new int[this.drillParamValue.size()];
        this.destDataType = new int[this.drillParamValue.size()];
        this.srcDataType = new int[this.drillParamValue.size()];
        for (int i = 0; i < this.drillParamValue.size(); ++i) {
            String tt = this.drillParamValue.elementAt(i);
            this.mapToChart[i] = tt.startsWith("Chart:");
            tt = tt.substring(tt.indexOf(58) + 1);
            if (this.mapToChart[i]) {
                int commaLoc = tt.indexOf(44);
                int subScoreLoc = tt.lastIndexOf("__");
                this.mapToParam[i] = tt.substring(0, commaLoc);
                String colIndexStr = tt.substring(commaLoc + 1, subScoreLoc);
                this.colIndex[i] = Integer.parseInt(colIndexStr);
                String typeStr = tt.substring(subScoreLoc + 2);
                this.srcDataType[i] = Integer.parseInt(typeStr);
                this.destDataType[i] = this.srcDataType[i];
                continue;
            }
            int subScoreLoc = tt.lastIndexOf("__");
            String typeStr = tt.substring(subScoreLoc + 2);
            this.mapToParam[i] = tt.substring(0, subScoreLoc);
            this.srcDataType[i] = Integer.parseInt(typeStr);
            this.destDataType[i] = this.srcDataType[i];
            this.colIndex[i] = -1;
        }
    }

    private void setDrillDownInfo(JSONObject jObj) {
        this.id = jObj.optInt(ATTR_NAME_ID);
        this.name = jObj.optString(ATTR_NAME_NAME, "");
        this.srcTemplateInfoID = jObj.optString(ATTR_NAME_SRCTEMPLATEINFOID);
        this.destTemplateInfoID = jObj.optString(ATTR_NAME_DESTTEMPLATEINFOID);
        this.destTypeName = jObj.optString(ATTR_NAME_DESTTYPE);
        this.destPath = jObj.optString(ATTR_NAME_DESTPATH);
        if (this.destTypeName.equals("CHT")) {
            this.destType = 0;
        } else if (this.destTypeName.equals("RPT")) {
            this.destType = 1;
        } else if (this.destTypeName.equals("DB")) {
            this.destType = 2;
        } else if (this.destTypeName.equals("GOOGLEMAP") || this.destTypeName.equals("SVGMAP")) {
            this.destType = 4;
        } else if (this.destTypeName.equals("EASYREPORT")) {
            this.destType = 6;
        }
        JSONArray paramMapJA = jObj.optJSONArray(ATTR_NAME_PARAMMAP);
        this.drillParamName = new Vector();
        this.drillParamValue = new Vector();
        if (paramMapJA == null || paramMapJA.length() == 0) {
            this.mapToChart = new boolean[0];
            this.mapToParam = new String[0];
            return;
        }
        int len = paramMapJA.length();
        this.mapToChart = new boolean[len];
        this.mapToParam = new String[len];
        this.colIndex = new int[len];
        this.srcDataType = new int[len];
        this.destDataType = new int[len];
        for (int i = 0; i < paramMapJA.length(); ++i) {
            JSONObject pmJO = paramMapJA.optJSONObject(i);
            String destParamName = pmJO.optString("destParamName");
            this.mapToChart[i] = pmJO.optBoolean(ATTR_NAME_MAPTOCHART);
            this.mapToParam[i] = pmJO.optString("mapToName");
            this.colIndex[i] = pmJO.optInt(ATTR_NAME_MAPTOCOLINDEX);
            this.srcDataType[i] = pmJO.optInt(ATTR_NAME_SRCDATATYPE);
            this.destDataType[i] = pmJO.optInt(ATTR_NAME_DESTDATATYPE);
            this.drillParamName.add(destParamName);
            String paramValueStr = "";
            paramValueStr = this.mapToChart[i] ? "Chart:" + this.mapToParam[i] + "," + this.colIndex[i] + "__" + this.srcDataType[i] : "Shared:" + this.mapToParam[i] + "__" + this.srcDataType[i];
            this.drillParamValue.add(paramValueStr);
        }
    }

    private void setSamePageDrillDownInfo(String str) {
        StringTokenizer st = new StringTokenizer(str, ";");
        while (st.hasMoreTokens()) {
            String tempStr = st.nextToken();
            StringTokenizer pairST = new StringTokenizer(tempStr, ":");
            String key = pairST.nextToken();
            String val = pairST.nextToken();
            if (key.equals("srcTemplateID")) {
                this.srcTemplateInfoID = val;
                continue;
            }
            if (key.equals("destTemplateID")) {
                this.destTemplateInfoID = val;
                continue;
            }
            if (!key.equals("paramMapping")) continue;
            Vector<String>[] v2 = this.getParamMap(val);
            this.drillParamName = v2[1];
            Vector<String> temp = v2[0];
            this.mapToParam = new String[temp.size()];
            for (int i = 0; i < temp.size(); ++i) {
                this.mapToParam[i] = temp.elementAt(i);
            }
        }
        this.mapToChart = new boolean[this.mapToParam.length];
        for (int i = 0; i < this.mapToChart.length; ++i) {
            this.mapToChart[i] = true;
        }
    }

    private void setSamePageDrillDownInfo(JSONObject jObj) {
        this.srcTemplateInfoID = jObj.optString(ATTR_NAME_SRCTEMPLATEINFOID);
        this.destTemplateInfoID = jObj.optString(ATTR_NAME_DESTTEMPLATEINFOID);
        JSONArray pmJA = jObj.optJSONArray(ATTR_NAME_PARAMMAP);
        int len = pmJA.length();
        this.drillParamName = new Vector();
        this.mapToChart = new boolean[len];
        this.mapToParam = new String[len];
        this.colIndex = new int[len];
        this.srcDataType = new int[len];
        for (int i = 0; i < pmJA.length(); ++i) {
            String srcParamName;
            JSONObject pmJO = pmJA.optJSONObject(i);
            if (pmJO == null) continue;
            String destParamName = pmJO.optString("destParamName");
            this.drillParamName.add(destParamName);
            this.mapToParam[i] = srcParamName = pmJO.optString("mapToName");
            this.mapToChart[i] = pmJO.optBoolean(ATTR_NAME_MAPTOCHART, true);
        }
    }

    private Vector<String>[] getParamMap(String urlEncodedStr) {
        Vector[] result = new Vector[]{new Vector(), new Vector()};
        String paramStr = DashboardUtil.decodeString(urlEncodedStr);
        StringTokenizer pmST = new StringTokenizer(paramStr, ",");
        while (pmST.hasMoreTokens()) {
            String pmStr = pmST.nextToken();
            pmStr = DashboardUtil.decodeString(pmStr);
            StringTokenizer pmStrST = new StringTokenizer(pmStr, ";");
            while (pmStrST.hasMoreTokens()) {
                String attr = pmStrST.nextToken();
                StringTokenizer pairST = new StringTokenizer(attr, ":");
                if (pairST.countTokens() != 2) continue;
                String key = pairST.nextToken();
                String val = pairST.nextToken();
                if (key.equals("srcParamName")) {
                    result[0].add(val);
                    continue;
                }
                if (!key.equals("destParamName")) continue;
                result[1].add(val);
            }
        }
        return result;
    }

    public String toString() {
        if (this.samePageDrillDown) {
            return this.getSamePageDrillDownString();
        }
        String isCHTStr = "CHT";
        if (this.destType == 1) {
            isCHTStr = "RPT";
        } else if (this.destType == 2) {
            isCHTStr = "DB";
        } else if (this.destType == 4) {
            isCHTStr = "MAP";
        } else if (this.destType == 6) {
            isCHTStr = "EASYREPORT";
        }
        String paramStr = "";
        for (int i = 0; i < this.drillParamName.size(); ++i) {
            paramStr = paramStr + "-_-" + this.drillParamName.elementAt(i) + "-_-" + this.drillParamValue.elementAt(i);
        }
        String s = this.srcTemplateInfoID + "-_-" + this.destTemplateInfoID + "-_-" + isCHTStr + "-_-" + this.destPath + paramStr;
        return s;
    }

    private String getSamePageDrillDownString() {
        StringBuffer buf = new StringBuffer();
        buf.append("srcTemplateID:" + this.srcTemplateInfoID + ";");
        buf.append("destTemplateID:" + this.destTemplateInfoID + ";");
        StringBuffer pmBuf = new StringBuffer();
        for (int i = 0; i < this.drillParamName.size(); ++i) {
            if (i > 0) {
                pmBuf.append(",");
            }
            String paramStr = "srcParamName:" + this.mapToParam[i] + ";destParamName:" + this.drillParamName.elementAt(i).toString();
            paramStr = DashboardUtil.encodeString(paramStr);
            pmBuf.append(paramStr);
        }
        String paramStr = DashboardUtil.encodeString(pmBuf.toString());
        buf.append("paramMapping:" + paramStr);
        return buf.toString();
    }

    public JSONObject toJSONObject() {
        if (this.samePageDrillDown) {
            return this.getJSONObjectForSamePageDrillDown();
        }
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_ID, this.id);
            jObj.put(ATTR_NAME_NAME, (Object)this.name);
            jObj.put(ATTR_NAME_SRCTEMPLATEINFOID, (Object)this.srcTemplateInfoID);
            jObj.put(ATTR_NAME_DESTTEMPLATEINFOID, (Object)this.destTemplateInfoID);
            jObj.put(ATTR_NAME_DESTTYPE, (Object)this.destTypeName);
            jObj.put(ATTR_NAME_DESTPATH, (Object)this.destPath);
            jObj.put(ATTR_NAME_SAMEPAGEDRILLDOWN, false);
            JSONArray paramMapJA = new JSONArray();
            for (int i = 0; i < this.drillParamName.size(); ++i) {
                JSONObject pmJO = new JSONObject();
                pmJO.put("destParamName", (Object)this.drillParamName.elementAt(i).toString());
                pmJO.put(ATTR_NAME_MAPTOCHART, this.mapToChart[i]);
                pmJO.put("mapToName", (Object)this.mapToParam[i]);
                pmJO.put(ATTR_NAME_SRCDATATYPE, this.srcDataType[i]);
                pmJO.put(ATTR_NAME_DESTDATATYPE, this.destDataType[i]);
                paramMapJA.put((Object)pmJO);
            }
            jObj.put(ATTR_NAME_PARAMMAP, (Object)paramMapJA);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    private JSONObject getJSONObjectForSamePageDrillDown() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_SRCTEMPLATEINFOID, (Object)this.srcTemplateInfoID);
            jObj.put(ATTR_NAME_DESTTEMPLATEINFOID, (Object)this.destTemplateInfoID);
            jObj.put(ATTR_NAME_SAMEPAGEDRILLDOWN, true);
            JSONArray pmJA = new JSONArray();
            for (int i = 0; i < this.drillParamName.size(); ++i) {
                JSONObject pmJO = new JSONObject();
                pmJO.put("destParamName", (Object)this.drillParamName.elementAt(i).toString());
                pmJO.put("mapToName", (Object)this.mapToParam[i]);
                pmJA.put((Object)pmJO);
            }
            jObj.put(ATTR_NAME_PARAMMAP, (Object)pmJA);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getSrcDataType() {
        return this.srcDataType;
    }

    public void setSrcDataType(int[] srcDataType) {
        this.srcDataType = srcDataType;
    }

    public int[] getDestDataType() {
        return this.destDataType;
    }

    public void setDestDataType(int[] destDataType) {
        this.destDataType = destDataType;
    }

    public String getSrcTemplateInfoID() {
        return this.srcTemplateInfoID;
    }

    public void setSrcTemplateInfoID(String srcTemplateInfoID) {
        this.srcTemplateInfoID = srcTemplateInfoID;
    }

    public String getDestTemplateInfoID() {
        return this.destTemplateInfoID;
    }

    public void setDestTemplateInfoID(String destTemplateInfoID) {
        this.destTemplateInfoID = destTemplateInfoID;
    }

    public int getDestType() {
        return this.destType;
    }

    public void setDestType(int destType) {
        this.destType = destType;
    }

    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public boolean isSamePageDrillDown() {
        return this.samePageDrillDown;
    }

    public void setSamePageDrillDown(boolean samePageDrillDown) {
        this.samePageDrillDown = samePageDrillDown;
    }

    public boolean[] getMapToChart() {
        return this.mapToChart;
    }

    public void setMapToChart(boolean[] mapToChart) {
        this.mapToChart = mapToChart;
    }

    public String[] getMapToParam() {
        return this.mapToParam;
    }

    public void setMapToParam(String[] mapToParam) {
        this.mapToParam = mapToParam;
    }

    public Vector getDrillParamName() {
        return this.drillParamName;
    }

    public void setDrillParamName(Vector drillParamName) {
        this.drillParamName = drillParamName;
    }

    public Vector getDrillParamValue() {
        return this.drillParamValue;
    }

    public void setDrillParamValue(Vector drillParamValue) {
        this.drillParamValue = drillParamValue;
    }

    public int[] getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int[] colIndex) {
        this.colIndex = colIndex;
    }

    public int[] getMapToDataType() {
        return this.srcDataType;
    }

    public void setMapToDataType(int[] mapToDataType) {
        this.srcDataType = mapToDataType;
    }

    public String getDestTypeName() {
        return this.destTypeName;
    }

    public void setDestTypeName(String destTypeName) {
        this.destTypeName = destTypeName;
    }
}

