/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class ExpSPButnAttributes {
    public static final String BACKGROUND = "background";
    public static final String BGCOLOR = "bgColor";
    public static final String BGIMAGEURL = "bgImageURL";
    public static final String BGPOSITION = "bgPosition";
    public static final String BGREPEAT = "bgRepeat";
    public static final String ISTRANSPARENT = "isTransparent";
    public static final String OPACITY = "opacity";
    public static final String USEBGIMAGE = "useBGImage";
    public static final String FONT = "font";
    public static final String FONTCOLOR = "color";
    public static final String FONTALIGN = "align";
    public static final String FONTNAME = "fontName";
    public static final String FONTSIZE = "fontSize";
    public static final String HTMLFONTSTYLE = "fontStyle";
    public static final String HTMLFONTWEIGHT = "fontWeight";
    public static final String PADDING = "padding";
    public static final String SHOWBORDER = "showBorder";
    public static final String SHOWSHADE = "showShade";
    public static final String SHOWROUNDCORNER = "showRoundCorner";
    public static final String SIZE = "size";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String USERADIO = "useRadio";
    public static final String ADDOKBUTN = "addOKButn";
    public static final String OKBUTNTEXT = "okButnText";
    private String spName;
    private int width;
    private int height;
    private int padding;
    private boolean showRoundCorner;
    private boolean showBorder;
    private boolean showShade;
    private String fontName;
    private String fontStyle;
    private String fontAlign;
    private int fontSize;
    private int[] fontColor;
    private boolean useImage;
    private String bgImageURL;
    private String bgPosition;
    private String bgRepeat;
    private int[] bgColor;
    private String direction;
    private boolean useRadio;
    private int opacity;
    private boolean addOKButn;
    private String okButnText;

    public ExpSPButnAttributes(String specStr) {
        this.setAttrFromSpecString(specStr);
    }

    public ExpSPButnAttributes(JSONObject butnAttrObj) {
        this.setAttrFromJSONObject(butnAttrObj);
    }

    private void setAttrFromSpecString(String specStr) {
        int loc = specStr.indexOf(58);
        if (loc < 0) {
            System.out.println("Coding error: please set the shared param name for expSP-Button");
            return;
        }
        this.spName = specStr.substring(0, loc);
        String butnAttr = specStr.substring(loc + 1);
        if (butnAttr.equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(butnAttr, ",");
        if (st.countTokens() < 17) {
            System.out.println("Error when parsing the button attributes");
            return;
        }
        this.width = DashboardUtil.getInteger(st.nextToken(), 100);
        this.height = DashboardUtil.getInteger(st.nextToken(), 50);
        this.padding = DashboardUtil.getInteger(st.nextToken(), 10);
        this.showRoundCorner = st.nextToken().equals("true");
        this.showBorder = st.nextToken().equals("true");
        this.showShade = st.nextToken().equals("true");
        this.fontName = st.nextToken();
        this.fontStyle = st.nextToken();
        this.fontAlign = st.nextToken();
        this.fontSize = DashboardUtil.getInteger(st.nextToken(), 12);
        String fontColorStr = DashboardUtil.decodeString(st.nextToken());
        this.fontColor = DashboardUtil.convertToColorRGB(fontColorStr);
        boolean useImage = st.nextToken().equals("true");
        this.bgImageURL = DashboardUtil.decodeString(st.nextToken());
        if (this.bgImageURL.equals("none") || !useImage) {
            this.bgImageURL = "";
        }
        this.bgPosition = st.nextToken();
        this.bgRepeat = st.nextToken();
        String bgColorStr = st.nextToken();
        bgColorStr = DashboardUtil.decodeString(bgColorStr);
        this.bgColor = DashboardUtil.convertToColorRGB(bgColorStr);
        this.direction = st.nextToken();
        this.useRadio = false;
        String opacityStr = "100";
        if (st.hasMoreElements()) {
            this.useRadio = st.nextToken().equals("true");
        }
        if (st.hasMoreElements()) {
            opacityStr = st.nextToken();
        }
        this.opacity = DashboardUtil.getInteger(opacityStr, 100);
        if (st.hasMoreTokens()) {
            this.addOKButn = st.nextToken().equals("true");
        }
        if (st.hasMoreElements()) {
            this.okButnText = DashboardUtil.decodeString(st.nextToken());
        }
        this.fontName = DashboardUtil.decodeString(this.fontName);
        this.bgImageURL = DashboardUtil.decodeString(this.bgImageURL);
    }

    private void setAttrFromJSONObject(JSONObject butnAttrObj) {
        JSONObject sizeJO;
        JSONObject fontJO;
        JSONObject bgJO = butnAttrObj.optJSONObject(BACKGROUND);
        if (bgJO != null) {
            JSONArray bgColorJA = bgJO.optJSONArray(BGCOLOR);
            this.bgColor = DashboardUtil.convertToColorRGB(bgColorJA);
            this.bgImageURL = bgJO.optString(BGIMAGEURL);
            this.bgPosition = bgJO.optString(BGPOSITION);
            this.bgRepeat = bgJO.optString(BGREPEAT);
            this.opacity = bgJO.optInt(OPACITY);
        }
        if ((fontJO = butnAttrObj.optJSONObject(FONT)) != null) {
            JSONArray fontColorJA = fontJO.optJSONArray(FONTCOLOR);
            this.fontColor = DashboardUtil.convertToColorRGB(fontColorJA);
            this.fontName = fontJO.optString(FONTNAME);
            this.fontSize = fontJO.optInt(FONTSIZE);
            this.fontAlign = fontJO.optString(FONTALIGN);
            String htmlFontStyle = fontJO.optString(HTMLFONTSTYLE);
            String htmlFontWeight = fontJO.optString(HTMLFONTWEIGHT);
            this.fontStyle = htmlFontStyle == null || htmlFontStyle.equalsIgnoreCase("normal") ? (htmlFontWeight == null || htmlFontWeight.equalsIgnoreCase("normal") ? "plain" : "bold") : (htmlFontWeight == null || htmlFontWeight.equalsIgnoreCase("normal") ? "italic" : "bold-italic");
        }
        if ((sizeJO = butnAttrObj.optJSONObject(SIZE)) != null) {
            this.width = sizeJO.optInt(WIDTH);
            this.height = sizeJO.optInt(HEIGHT);
        }
        this.padding = butnAttrObj.optInt(PADDING);
        this.showBorder = butnAttrObj.optBoolean(SHOWBORDER);
        this.showRoundCorner = butnAttrObj.optBoolean(SHOWROUNDCORNER);
        this.showShade = butnAttrObj.optBoolean(SHOWSHADE);
        this.useRadio = butnAttrObj.optBoolean(USERADIO);
        this.addOKButn = butnAttrObj.optBoolean(ADDOKBUTN);
        this.okButnText = butnAttrObj.optString(OKBUTNTEXT);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = DashboardUtil.convertToColorJSONArray(this.bgColor);
            bgJO.put(BGCOLOR, (Object)bgColorJA);
            bgJO.put(BGIMAGEURL, (Object)this.bgImageURL);
            bgJO.put(BGPOSITION, (Object)this.bgPosition);
            bgJO.put(BGREPEAT, (Object)this.bgRepeat);
            bgJO.put(OPACITY, this.opacity);
            bgJO.put(USEBGIMAGE, this.bgImageURL != null && !this.bgImageURL.equals(""));
            jObj.put(BACKGROUND, (Object)bgJO);
            JSONObject fontJO = new JSONObject();
            fontJO.put(FONTNAME, (Object)this.fontName);
            fontJO.put(FONTALIGN, (Object)this.fontAlign);
            fontJO.put(FONTSIZE, this.fontSize);
            fontJO.put(FONTCOLOR, (Object)DashboardUtil.convertToColorJSONArray(this.fontColor));
            String htmlFontStyle = "plain";
            String htmlFontWeight = "normal";
            if (!this.fontStyle.equalsIgnoreCase("plain")) {
                if (this.fontStyle.equalsIgnoreCase("bold")) {
                    htmlFontWeight = "bold";
                } else if (this.fontStyle.equalsIgnoreCase("italic")) {
                    htmlFontStyle = "italic";
                } else if (this.fontStyle.equalsIgnoreCase("bold-italic")) {
                    htmlFontWeight = "bold";
                    htmlFontStyle = "italic";
                }
            }
            fontJO.put(HTMLFONTSTYLE, (Object)htmlFontStyle);
            fontJO.put(HTMLFONTWEIGHT, (Object)htmlFontWeight);
            jObj.put(FONT, (Object)fontJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put(WIDTH, this.width);
            sizeJO.put(HEIGHT, this.height);
            jObj.put(SIZE, (Object)sizeJO);
            jObj.put(PADDING, this.padding);
            jObj.put(SHOWBORDER, this.showBorder);
            jObj.put(SHOWROUNDCORNER, this.showRoundCorner);
            jObj.put(SHOWSHADE, this.showShade);
            jObj.put(USERADIO, this.useRadio);
            jObj.put(ADDOKBUTN, this.addOKButn);
            jObj.put(OKBUTNTEXT, (Object)this.okButnText);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String toSpecString() {
        if (this.spName == null || this.spName.equals("")) {
            System.out.println("ExpSPButnAttributes.toSpecString(): Coding error: please set the 'spName' for expSP-Button");
            return "";
        }
        if (this.direction == null || this.direction.equals("")) {
            System.out.println("ExpSPButnAttributes.toSpecString(): Coding error: please set 'direction' for expSP-Button");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.spName + ":");
        buf.append(this.width + ",");
        buf.append(this.height + ",");
        buf.append(this.padding + ",");
        buf.append(this.showRoundCorner + ",");
        buf.append(this.showBorder + ",");
        buf.append(this.showShade + ",");
        String fontNameStr = DashboardUtil.encodeString(this.fontName);
        buf.append(fontNameStr + ",");
        buf.append(this.fontStyle + ",");
        buf.append(this.fontAlign + ",");
        buf.append(this.fontSize + ",");
        String fontColorStr = DashboardUtil.convertToColorStr(this.fontColor);
        fontColorStr = DashboardUtil.encodeString(fontColorStr);
        buf.append(fontColorStr + ",");
        boolean useImage = this.bgImageURL != null && !this.bgImageURL.equals("none") && !this.bgImageURL.equals("");
        buf.append(useImage + ",");
        String bgImageURLStr = this.bgImageURL;
        if (bgImageURLStr == null || bgImageURLStr.equals("")) {
            bgImageURLStr = "none";
        }
        bgImageURLStr = DashboardUtil.encodeString(bgImageURLStr);
        buf.append(bgImageURLStr + ",");
        buf.append(this.bgPosition + ",");
        buf.append(this.bgRepeat + ",");
        String bgColorStr = DashboardUtil.convertToColorStr(this.bgColor);
        bgColorStr = DashboardUtil.encodeString(bgColorStr);
        buf.append(bgColorStr + ",");
        buf.append(this.direction + ",");
        buf.append(this.useRadio + ",");
        buf.append(this.opacity + ",");
        buf.append(this.addOKButn + ",");
        buf.append(DashboardUtil.encodeString(this.okButnText));
        return buf.toString();
    }

    public String getSpName() {
        return this.spName;
    }

    public void setSpName(String spName) {
        this.spName = spName;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public boolean isShowRoundCorner() {
        return this.showRoundCorner;
    }

    public void setShowRoundCorner(boolean showRoundCorner) {
        this.showRoundCorner = showRoundCorner;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public boolean isShowShade() {
        return this.showShade;
    }

    public void setShowShade(boolean showShade) {
        this.showShade = showShade;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String fontAlign) {
        this.fontAlign = fontAlign;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int[] getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int[] fontColor) {
        this.fontColor = fontColor;
    }

    public boolean isUseImage() {
        return this.useImage;
    }

    public void setUseImage(boolean useImage) {
        this.useImage = useImage;
    }

    public String getBgImageURL() {
        return this.bgImageURL;
    }

    public void setBgImageURL(String bgImageURL) {
        this.bgImageURL = bgImageURL;
    }

    public String getBgPosition() {
        return this.bgPosition;
    }

    public void setBgPosition(String bgPosition) {
        this.bgPosition = bgPosition;
    }

    public String getBgRepeat() {
        return this.bgRepeat;
    }

    public void setBgRepeat(String bgRepeat) {
        this.bgRepeat = bgRepeat;
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public boolean isUseRadio() {
        return this.useRadio;
    }

    public void setUseRadio(boolean useRadio) {
        this.useRadio = useRadio;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public boolean isAddOKButn() {
        return this.addOKButn;
    }

    public void setAddOKButn(boolean addOKButn) {
        this.addOKButn = addOKButn;
    }

    public String getOkButnText() {
        return this.okButnText;
    }

    public void setOkButnText(String okButnText) {
        this.okButnText = okButnText;
    }
}

