/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class ExpSPPanelAttributes {
    public static final String BACKGROUND = "background";
    public static final String BGCOLOR = "bgColor";
    public static final String BGIMAGEURL = "bgImageURL";
    public static final String BGPOSITION = "bgPosition";
    public static final String BGREPEAT = "bgRepeat";
    public static final String ISTRANSPARENT = "isTransparent";
    public static final String OPACITY = "opacity";
    public static final String USEBGIMAGE = "useBGImage";
    public static final String BORDER = "border";
    public static final String BORDERCOLOR = "color";
    public static final String PADDING = "padding";
    public static final String BORDERSTYLE = "style";
    public static final String BORDERTHICKNESS = "thickness";
    public static final String SIZE = "size";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String POSITION = "position";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String SHOWHEADER = "showHeader";
    private String expSPPanelAttrStr;
    private int width;
    private int height;
    private int top;
    private int left;
    private int borderWidth;
    private String borderStyle;
    private int padding;
    private int[] borderColor;
    private int[] bgColor;
    private int opacity;
    private String bgImageURL;
    private String bgPosition;
    private String bgRepeat;
    private String innerHTML;
    private boolean showHeader;
    private String spName = "";

    public ExpSPPanelAttributes(String expSPPanelAttrStr) {
        this.expSPPanelAttrStr = expSPPanelAttrStr;
        this.parseAttrString(expSPPanelAttrStr);
    }

    public ExpSPPanelAttributes(JSONObject panelAttrObj) {
        this.setAttrFromJSON(panelAttrObj);
    }

    private void parseAttrString(String panelAttr) {
        int loc = panelAttr.indexOf(58);
        this.spName = panelAttr.substring(0, loc);
        String specStr = panelAttr.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(specStr, ",");
        if (st.countTokens() < 13) {
            System.out.println("Expanded Shared Parameter panel attribute not match: " + panelAttr);
            return;
        }
        String panelWidth = st.nextToken();
        this.width = DashboardUtil.getIntFromPX(panelWidth);
        String panelHeight = st.nextToken();
        this.height = DashboardUtil.getIntFromPX(panelHeight);
        String panelTop = st.nextToken();
        this.top = DashboardUtil.getIntFromPX(panelTop);
        String panelLeft = st.nextToken();
        this.left = DashboardUtil.getIntFromPX(panelLeft);
        String borderWidthStr = st.nextToken();
        this.borderWidth = DashboardUtil.getIntFromPX(borderWidthStr);
        this.borderStyle = st.nextToken();
        String borderColorStr = st.nextToken();
        borderColorStr = DashboardUtil.decodeString(borderColorStr);
        this.borderColor = DashboardUtil.convertToColorRGB(borderColorStr);
        String bgColorStr = st.nextToken();
        bgColorStr = DashboardUtil.decodeString(bgColorStr);
        this.bgColor = DashboardUtil.convertToColorRGB(bgColorStr);
        String bgOpacity = st.nextToken();
        this.opacity = DashboardUtil.getInteger(bgOpacity, 100);
        this.bgImageURL = st.nextToken();
        if (this.bgImageURL.equalsIgnoreCase("none")) {
            this.bgImageURL = "";
        }
        this.bgRepeat = st.nextToken();
        this.bgPosition = st.nextToken();
        this.innerHTML = st.nextToken();
        this.showHeader = true;
        if (st.hasMoreTokens()) {
            this.showHeader = st.nextToken().equalsIgnoreCase("YES");
        }
    }

    private void setAttrFromJSON(JSONObject panelAttrJObj) {
        JSONObject posJObj = panelAttrJObj.optJSONObject(POSITION);
        this.top = posJObj.optInt(TOP);
        this.left = posJObj.optInt(LEFT);
        JSONObject sizeObj = panelAttrJObj.optJSONObject(SIZE);
        this.width = sizeObj.optInt(WIDTH);
        this.height = sizeObj.optInt(HEIGHT);
        this.showHeader = panelAttrJObj.optBoolean(SHOWHEADER);
        JSONObject bgJObj = panelAttrJObj.optJSONObject(BACKGROUND);
        this.bgColor = new int[3];
        if (bgJObj != null) {
            JSONArray bgColorJA = bgJObj.optJSONArray(BGCOLOR);
            for (int i = 0; i < bgColorJA.length(); ++i) {
                this.bgColor[i] = bgColorJA.optInt(i);
            }
            this.bgImageURL = bgJObj.optString(BGIMAGEURL);
            this.bgPosition = bgJObj.optString(BGPOSITION);
            this.bgRepeat = bgJObj.optString(BGREPEAT);
            boolean isTransparent = bgJObj.optBoolean(ISTRANSPARENT);
            this.opacity = bgJObj.optInt(OPACITY);
            boolean useBGImage = bgJObj.optBoolean(USEBGIMAGE);
            if (!useBGImage) {
                this.bgImageURL = "";
            }
            if (isTransparent) {
                this.opacity = 0;
            }
        }
        JSONObject borderJObj = panelAttrJObj.optJSONObject(BORDER);
        this.borderColor = new int[3];
        if (borderJObj != null) {
            JSONArray bdrColorJA = borderJObj.optJSONArray(BORDERCOLOR);
            for (int i = 0; i < bdrColorJA.length(); ++i) {
                this.borderColor[i] = bdrColorJA.optInt(i);
            }
            this.padding = borderJObj.optInt(PADDING);
            this.borderStyle = borderJObj.optString(BORDERSTYLE);
            this.borderWidth = borderJObj.optInt(BORDERTHICKNESS);
        }
        this.innerHTML = "none";
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = DashboardUtil.convertToColorJSONArray(this.bgColor);
            bgJO.put(BGCOLOR, (Object)bgColorJA);
            bgJO.put(BGIMAGEURL, (Object)this.bgImageURL);
            bgJO.put(BGPOSITION, (Object)this.bgPosition);
            bgJO.put(BGREPEAT, (Object)this.bgRepeat);
            boolean isTransparent = this.opacity == 0;
            bgJO.put(ISTRANSPARENT, isTransparent);
            bgJO.put(OPACITY, this.opacity);
            boolean useBGImage = !this.bgImageURL.equals("") || !this.innerHTML.equals("none");
            bgJO.put(USEBGIMAGE, useBGImage);
            jObj.put(BACKGROUND, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            JSONArray borderColorJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            borderJO.put(BORDERCOLOR, (Object)borderColorJA);
            borderJO.put(BORDERTHICKNESS, this.borderWidth);
            borderJO.put(BORDERSTYLE, (Object)this.borderStyle);
            borderJO.put(PADDING, this.padding);
            jObj.put(BORDER, (Object)borderJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put(WIDTH, this.width);
            sizeJO.put(HEIGHT, this.height);
            jObj.put(SIZE, (Object)sizeJO);
            JSONObject posJO = new JSONObject();
            posJO.put(TOP, this.top);
            posJO.put(LEFT, this.left);
            jObj.put(POSITION, (Object)posJO);
            jObj.put(SHOWHEADER, this.showHeader);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toSpecString() {
        if (this.spName == null || this.spName.equals("")) {
            System.out.println("Coding error: please set the shared param name for expSP-Panel");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.spName + ":");
        buf.append(this.width + "px,");
        buf.append(this.height + "px,");
        buf.append(this.top + "px,");
        buf.append(this.left + "px,");
        buf.append(this.borderWidth + "px,");
        buf.append(this.borderStyle + ",");
        String borderColorStr = DashboardUtil.convertToColorStr(this.borderColor);
        String bgColorStr = DashboardUtil.convertToColorStr(this.bgColor);
        String encodeBGImgURL = this.bgImageURL;
        String encodeInnerHTML = this.innerHTML;
        try {
            borderColorStr = URLEncoder.encode(borderColorStr, "UTF-8");
            bgColorStr = URLEncoder.encode(bgColorStr, "UTF-8");
            encodeBGImgURL = URLEncoder.encode(this.bgImageURL, "UTF-8");
            if (encodeBGImgURL == null || encodeBGImgURL.equals("")) {
                encodeBGImgURL = "none";
            }
            if (this.innerHTML == null || this.innerHTML.equals("")) {
                this.innerHTML = "none";
            }
            encodeInnerHTML = URLEncoder.encode(this.innerHTML, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append(borderColorStr + ",");
        buf.append(bgColorStr + ",");
        buf.append(this.opacity + ",");
        buf.append(encodeBGImgURL + ",");
        buf.append(this.bgRepeat + ",");
        buf.append(this.bgPosition + ",");
        buf.append(encodeInnerHTML + ",");
        buf.append(this.showHeader);
        return buf.toString();
    }

    public String getExpSPPanelAttrStr() {
        return this.expSPPanelAttrStr;
    }

    public void setExpSPPanelAttrStr(String expSPPanelAttrStr) {
        this.expSPPanelAttrStr = expSPPanelAttrStr;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public String getBgImageURL() {
        return this.bgImageURL;
    }

    public void setBgImageURL(String bgImageURL) {
        this.bgImageURL = bgImageURL;
    }

    public String getBgPosition() {
        return this.bgPosition;
    }

    public void setBgPosition(String bgPosition) {
        this.bgPosition = bgPosition;
    }

    public String getBgRepeat() {
        return this.bgRepeat;
    }

    public void setBgRepeat(String bgRepeat) {
        this.bgRepeat = bgRepeat;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }

    public void setInnerHTML(String innerHTML) {
        this.innerHTML = innerHTML;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public String getSpName() {
        return this.spName;
    }

    public void setSpName(String spName) {
        this.spName = spName;
    }
}

