/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.components.ExpSPButnAttributes;
import quadbase.dashboard3.components.ExpSPPanelAttributes;

public class ExpandedSharedParam {
    public static final String PANELATTR = "panelAttr";
    public static final String BUTNATTR = "buttonAttr";
    public static final String PARAMNAME = "paramName";
    public static final String BUTNIMAGEMAP = "butnImageMap";
    public static final String DIRECTION = "direction";
    public static final String PARAMVALUE = "paramValue";
    public static final String IMAGEURL = "imgURL";
    private ExpSPPanelAttributes panelAttr;
    private ExpSPButnAttributes butnAttr;
    private String direction = "horizontal";
    private String paramName;
    private Vector<String[]> butnImageMap = new Vector();

    public ExpandedSharedParam(String panelAttrStr, String butnAttrStr, String butnImgMapStr) {
        this.setAttrFromStrings(panelAttrStr, butnAttrStr, butnImgMapStr);
    }

    public ExpandedSharedParam(JSONObject expSpObj) {
        this.setAttrFromJSONObject(expSpObj);
    }

    private void setAttrFromStrings(String panelAttrStr, String butnAttrStr, String butnImgMapStr) {
        this.panelAttr = new ExpSPPanelAttributes(panelAttrStr);
        this.butnAttr = new ExpSPButnAttributes(butnAttrStr);
        this.setButnImageMapFromStr(butnImgMapStr);
        this.paramName = this.panelAttr.getSpName();
        this.direction = this.butnAttr.getDirection();
    }

    private void setButnImageMapFromStr(String butnImgMapStr) {
        int loc = butnImgMapStr.indexOf(58);
        String mapStr = "";
        if (loc > 0) {
            mapStr = butnImgMapStr.substring(loc + 1);
        }
        DashboardUtil.encodeString(mapStr);
        StringTokenizer st = new StringTokenizer(mapStr, ",");
        while (st.hasMoreTokens()) {
            String[] mapPair = new String[2];
            String str = st.nextToken();
            StringTokenizer mapST = new StringTokenizer(str, "^");
            mapPair[0] = mapST.nextToken();
            mapPair[1] = DashboardUtil.decodeString(mapST.nextToken());
            this.butnImageMap.addElement(mapPair);
        }
    }

    private void setAttrFromJSONObject(JSONObject expSpObj) {
        this.direction = expSpObj.optString(DIRECTION);
        this.paramName = expSpObj.optString(PARAMNAME);
        JSONObject panelJO = expSpObj.optJSONObject(PANELATTR);
        this.panelAttr = new ExpSPPanelAttributes(panelJO);
        this.panelAttr.setSpName(this.paramName);
        JSONObject butnJO = expSpObj.optJSONObject(BUTNATTR);
        this.butnAttr = new ExpSPButnAttributes(butnJO);
        this.butnAttr.setSpName(this.paramName);
        this.butnAttr.setDirection(this.direction);
        JSONArray mapJA = expSpObj.optJSONArray(BUTNIMAGEMAP);
        this.setButnImageMapFromJSONArray(mapJA);
    }

    private void setButnImageMapFromJSONArray(JSONArray mapJArray) {
        for (int i = 0; i < mapJArray.length(); ++i) {
            JSONObject mapJO = mapJArray.optJSONObject(i);
            String[] mapPair = new String[]{mapJO.optString(PARAMVALUE), mapJO.optString(IMAGEURL)};
            this.butnImageMap.addElement(mapPair);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(PARAMNAME, (Object)this.paramName);
            jObj.put(DIRECTION, (Object)this.direction);
            jObj.put(PANELATTR, (Object)this.panelAttr.toJSONObject());
            jObj.put(BUTNATTR, (Object)this.butnAttr.toJSONObject());
            JSONArray imageMapJA = this.getButnImageMapJSONArray();
            jObj.put(BUTNIMAGEMAP, (Object)imageMapJA);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    private JSONArray getButnImageMapJSONArray() {
        JSONArray ja = new JSONArray();
        if (this.butnImageMap == null || this.butnImageMap.size() == 0) {
            return ja;
        }
        try {
            for (int i = 0; i < this.butnImageMap.size(); ++i) {
                String[] mapPair = this.butnImageMap.elementAt(i);
                JSONObject jo = new JSONObject();
                jo.put(PARAMVALUE, (Object)mapPair[0]);
                jo.put(IMAGEURL, (Object)mapPair[1]);
                ja.put((Object)jo);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ja;
    }

    public String getPanelSpecString() {
        return this.panelAttr.toSpecString();
    }

    public String getButnSpecString() {
        return this.butnAttr.toSpecString();
    }

    public String getButnImageMapString() {
        if (this.butnImageMap == null || this.butnImageMap.size() == 0) {
            return this.paramName + ":_$_none_$_^_$_none_$_";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.paramName + ":");
        for (int i = 0; i < this.butnImageMap.size(); ++i) {
            String[] mapPair = this.butnImageMap.elementAt(i);
            String mapStr = mapPair[0] + "^" + DashboardUtil.encodeString(mapPair[1]);
            if (i == 0) {
                buf.append(mapStr);
                continue;
            }
            buf.append("," + mapStr);
        }
        return buf.toString();
    }

    public ExpSPPanelAttributes getPanelAttr() {
        return this.panelAttr;
    }

    public void setPanelAttr(ExpSPPanelAttributes panelAttr) {
        this.panelAttr = panelAttr;
    }

    public ExpSPButnAttributes getButnAttr() {
        return this.butnAttr;
    }

    public void setButnAttr(ExpSPButnAttributes butnAttr) {
        this.butnAttr = butnAttr;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public Vector<String[]> getButnImageMap() {
        return this.butnImageMap;
    }

    public void setButnImageMap(Vector<String[]> butnImageMap) {
        this.butnImageMap = butnImageMap;
    }
}

