/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.components.FolderTabStyle;

public class FolderAttributes {
    public static final String ATTR_NAME_JSON_ID = "id";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_TABATTR = "tabAttr";
    public static final String ATTR_NAME_MAXTABNAMELENGTH = "maxTabNameLength";
    public static final String ATTR_NAME_TABWIDTH = "tabWidth";
    public static final String ATTR_NAME_SPACING = "spacing";
    public static final String ATTR_NAME_PADDING = "padding";
    public static final String ATTR_NAME_OUTBOUNDSTYLE = "outBoundStyle";
    public static final String ATTR_NAME_TABSTYLE = "tabStyle";
    public static final String ATTR_NAME_ACTIVE = "active";
    public static final String ATTR_NAME_INACTIVE = "inactive";
    public static final String ATTR_NAME_TEMPLATELIST = "templateList";
    public static final String ATTR_NAME_ACTIVETEMPLATEINDEX = "activeTemplateIndex";
    public static final String ATTR_NAME_SPEC_FOLDERID = "folderID";
    public static final String ATTR_NAME_SPEC_FOLDERLEFT = "folderLeft";
    public static final String ATTR_NAME_SPEC_FOLDERTOP = "folderTop";
    public static final String ATTR_NAME_SPEC_FOLDERWIDTH = "folderWidth";
    public static final String ATTR_NAME_SPEC_FOLDERHEIGHT = "folderHeight";
    private String[] templateList;
    private String folderID;
    private int top;
    private int left;
    private int width;
    private int height;
    private int maxTabNameLength;
    private int tabWidth;
    private int spacing;
    private int padding;
    private String outBoundStyle = "tile";
    private int tabStyle = 1;
    private FolderTabStyle activeTabStyle;
    private FolderTabStyle inactiveTabStyle;

    public FolderAttributes(String specStr) {
        this.setAttrFromSpecString(specStr);
    }

    public FolderAttributes(JSONObject jObj) {
        this.setAttrFromJSONObject(jObj);
    }

    private void setAttrFromSpecString(String specStr) {
        StringTokenizer st = new StringTokenizer(specStr, ";");
        while (st.hasMoreTokens()) {
            String attr = st.nextToken();
            StringTokenizer attrST = new StringTokenizer(attr, ":");
            if (attrST.countTokens() != 2) continue;
            String key = attrST.nextToken();
            String val = attrST.nextToken();
            if (key.equals(ATTR_NAME_SPEC_FOLDERID)) {
                this.folderID = val;
                continue;
            }
            if (key.equals(ATTR_NAME_SPEC_FOLDERTOP)) {
                this.top = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_SPEC_FOLDERLEFT)) {
                this.left = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_SPEC_FOLDERWIDTH)) {
                this.width = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_SPEC_FOLDERHEIGHT)) {
                this.height = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_MAXTABNAMELENGTH)) {
                this.maxTabNameLength = DashboardUtil.getInteger(val, 10);
                continue;
            }
            if (key.equals(ATTR_NAME_TABWIDTH)) {
                this.tabWidth = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_PADDING)) {
                this.padding = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_SPACING)) {
                this.spacing = DashboardUtil.getIntFromPX(val);
                continue;
            }
            if (key.equals(ATTR_NAME_OUTBOUNDSTYLE)) {
                this.outBoundStyle = val;
                continue;
            }
            if (key.equals(ATTR_NAME_TABSTYLE)) {
                this.tabStyle = DashboardUtil.getInteger(val, 1);
                continue;
            }
            if (!key.equals(ATTR_NAME_TEMPLATELIST)) continue;
            this.setTemplateListFromSpecString(val);
        }
        this.activeTabStyle = new FolderTabStyle(specStr, true);
        this.inactiveTabStyle = new FolderTabStyle(specStr, false);
    }

    private void setAttrFromJSONObject(JSONObject jObj) {
        JSONObject inactiveJO;
        this.folderID = jObj.optString(ATTR_NAME_JSON_ID);
        JSONArray templateListJA = jObj.optJSONArray(ATTR_NAME_TEMPLATELIST);
        this.templateList = new String[templateListJA.length()];
        for (int i = 0; i < templateListJA.length(); ++i) {
            this.templateList[i] = templateListJA.optString(i);
        }
        JSONObject positionJO = jObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = positionJO.optInt(ATTR_NAME_TOP);
        this.left = positionJO.optInt(ATTR_NAME_LEFT);
        JSONObject sizeJO = jObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJO.optInt(ATTR_NAME_WIDTH);
        this.height = sizeJO.optInt(ATTR_NAME_HEIGHT);
        JSONObject tabAttrJO = jObj.optJSONObject(ATTR_NAME_TABATTR);
        this.tabWidth = tabAttrJO.optInt(ATTR_NAME_WIDTH);
        this.maxTabNameLength = tabAttrJO.optInt(ATTR_NAME_MAXTABNAMELENGTH);
        this.spacing = tabAttrJO.optInt(ATTR_NAME_SPACING);
        this.outBoundStyle = tabAttrJO.optString(ATTR_NAME_OUTBOUNDSTYLE);
        this.tabStyle = tabAttrJO.optInt(ATTR_NAME_TABSTYLE);
        JSONObject activeJO = jObj.optJSONObject(ATTR_NAME_ACTIVE);
        if (activeJO != null) {
            this.activeTabStyle = new FolderTabStyle(activeJO, true);
        }
        if ((inactiveJO = jObj.optJSONObject(ATTR_NAME_INACTIVE)) != null) {
            this.inactiveTabStyle = new FolderTabStyle(inactiveJO, false);
        }
    }

    private void setTemplateListFromSpecString(String specStr) {
        StringTokenizer st = new StringTokenizer(specStr, "^");
        Vector<String> vect = new Vector<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s == null || s.length() <= 0) continue;
            vect.add(s);
        }
        this.templateList = new String[vect.size()];
        for (int i = 0; i < vect.size(); ++i) {
            this.templateList[i] = (String)vect.elementAt(i);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_ACTIVETEMPLATEINDEX, 0);
            JSONArray templateJA = new JSONArray();
            for (String element : this.templateList) {
                templateJA.put((Object)element);
            }
            jObj.put(ATTR_NAME_TEMPLATELIST, (Object)templateJA);
            JSONObject posJO = new JSONObject();
            posJO.put(ATTR_NAME_TOP, this.top);
            posJO.put(ATTR_NAME_LEFT, this.left);
            jObj.put(ATTR_NAME_POSITION, (Object)posJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put(ATTR_NAME_WIDTH, this.width);
            sizeJO.put(ATTR_NAME_HEIGHT, this.height);
            jObj.put(ATTR_NAME_SIZE, (Object)sizeJO);
            JSONObject tabAttrJO = new JSONObject();
            tabAttrJO.put(ATTR_NAME_MAXTABNAMELENGTH, this.maxTabNameLength);
            tabAttrJO.put(ATTR_NAME_WIDTH, this.tabWidth);
            tabAttrJO.put(ATTR_NAME_SPACING, this.spacing);
            tabAttrJO.put(ATTR_NAME_PADDING, this.padding);
            tabAttrJO.put(ATTR_NAME_OUTBOUNDSTYLE, (Object)this.outBoundStyle);
            tabAttrJO.put(ATTR_NAME_TABSTYLE, this.tabStyle);
            jObj.put(ATTR_NAME_TABATTR, (Object)tabAttrJO);
            JSONObject activeJO = this.activeTabStyle.toJSONObject();
            jObj.put(ATTR_NAME_ACTIVE, (Object)activeJO);
            JSONObject inactiveJO = this.inactiveTabStyle.toJSONObject();
            jObj.put(ATTR_NAME_INACTIVE, (Object)inactiveJO);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String toSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append("folderID:" + this.folderID + ";");
        buf.append("folderTop:" + this.top + "px;");
        buf.append("folderLeft:" + this.left + "px;");
        buf.append("folderWidth:" + this.width + "px;");
        buf.append("folderHeight:" + this.height + "px;");
        StringBuffer templateListBuf = new StringBuffer();
        for (int i = 0; i < this.templateList.length; ++i) {
            if (i > 0) {
                templateListBuf.append("^");
            }
            templateListBuf.append(this.templateList[i]);
        }
        buf.append("templateList:" + templateListBuf.toString() + ";");
        buf.append("tabWidth:" + this.tabWidth + "px;");
        buf.append("maxTabNameLength:" + this.maxTabNameLength + ";");
        buf.append("padding:" + this.padding + "px;");
        buf.append("spacing:" + this.spacing + "px;");
        buf.append("outBoundStyle:" + this.outBoundStyle + ";");
        buf.append("tabStyle:" + this.tabStyle + ";");
        String activeSpec = this.activeTabStyle.toSpecString();
        buf.append(activeSpec + ";");
        String inactiveSpec = this.inactiveTabStyle.toSpecString();
        buf.append(inactiveSpec);
        return buf.toString();
    }

    public String[] getTemplateList() {
        return this.templateList;
    }

    public void setTemplateList(String[] templateList) {
        this.templateList = templateList;
    }

    public String getFolderID() {
        return this.folderID;
    }

    public void setFolderID(String folderID) {
        this.folderID = folderID;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMaxTabNameLength() {
        return this.maxTabNameLength;
    }

    public void setMaxTabNameLength(int maxTabNameLength) {
        this.maxTabNameLength = maxTabNameLength;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public String getOutBoundStyle() {
        return this.outBoundStyle;
    }

    public void setOutBoundStyle(String outBoundStyle) {
        this.outBoundStyle = outBoundStyle;
    }

    public int getTabStyle() {
        return this.tabStyle;
    }

    public void setTabStyle(int tabStyle) {
        this.tabStyle = tabStyle;
    }

    public FolderTabStyle getActiveTabStyle() {
        return this.activeTabStyle;
    }

    public void setActiveTabStyle(FolderTabStyle activeTabStyle) {
        this.activeTabStyle = activeTabStyle;
    }

    public FolderTabStyle getInactiveTabStyle() {
        return this.inactiveTabStyle;
    }

    public void setInactiveTabStyle(FolderTabStyle inactiveTabStyle) {
        this.inactiveTabStyle = inactiveTabStyle;
    }
}

