/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class FolderTabStyle {
    public static final String ATTR_NAME_FONT = "font";
    public static final String ATTR_NAME_BACKGROUND = "background";
    public static final String ATTR_NAME_BORDER = "border";
    public static final String ATTR_NAME_FONTNAME = "fontName";
    public static final String ATTR_NAME_FONTSTYLE = "fontStyle";
    public static final String ATTR_NAME_FONTWEIGHT = "fontWeight";
    public static final String ATTR_NAME_FONTALIGN = "align";
    public static final String ATTR_NAME_FONTCOLOR = "color";
    public static final String ATTR_NAME_BGCOLOR = "bgColor";
    public static final String ATTR_NAME_BGOPACITY = "opacity";
    public static final String ATTR_NAME_BORDERWIDTH = "borderWidth";
    public static final String ATTR_NAME_BORDERCOLOR = "color";
    private String fontName;
    private String fontStyle;
    private String fontWeight;
    private String align;
    private int[] fontColor;
    private int[] bgColor;
    private int opacity;
    private int[] borderColor;
    private int borderWidth;
    private boolean isActive;

    public FolderTabStyle(String specStr, boolean isActive) {
        this.isActive = isActive;
        this.setAttrFromSpecString(specStr);
    }

    public FolderTabStyle(JSONObject jObj, boolean isActive) {
        this.isActive = isActive;
        this.setAttrFromJSONObject(jObj);
    }

    private void setAttrFromSpecString(String specStr) {
        StringTokenizer st = new StringTokenizer(specStr, ";");
        if (this.isActive) {
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer pairST = new StringTokenizer(pair, ":");
                if (pairST.countTokens() < 2) continue;
                String key = pairST.nextToken();
                String val = pairST.nextToken();
                if (key.equals("fontFamily")) {
                    this.fontName = val;
                    continue;
                }
                if (key.equals(ATTR_NAME_FONTSTYLE)) {
                    String fontStyleStr = val;
                    this.fontWeight = "normal";
                    this.fontStyle = "plain";
                    if (fontStyleStr.toLowerCase().indexOf("bold") >= 0) {
                        this.fontWeight = "bold";
                    }
                    if (fontStyleStr.toLowerCase().indexOf("italic") < 0) continue;
                    this.fontStyle = "italic";
                    continue;
                }
                if (key.equals("textAlign")) {
                    this.align = val;
                    continue;
                }
                if (key.equals("textColor")) {
                    this.fontColor = DashboardUtil.convertToColorRGB(val);
                    continue;
                }
                if (key.equals("activeBGColor")) {
                    this.bgColor = DashboardUtil.convertToColorRGB(val);
                    continue;
                }
                if (key.equals("activeBGOpacity")) {
                    this.opacity = DashboardUtil.getInteger(val, 100);
                    continue;
                }
                if (key.equals("borderThickness")) {
                    this.borderWidth = DashboardUtil.getInteger(val, 1);
                    continue;
                }
                if (!key.equals("borderColor")) continue;
                this.borderColor = DashboardUtil.convertToColorRGB(val);
            }
        } else {
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer pairST = new StringTokenizer(pair, ":");
                if (pairST.countTokens() < 2) continue;
                String key = pairST.nextToken();
                String val = pairST.nextToken();
                if (key.equals("inactiveFontFamily")) {
                    this.fontName = val;
                    continue;
                }
                if (key.equals("inactiveFontStyle")) {
                    String fontStyleStr = val;
                    this.fontWeight = "normal";
                    this.fontStyle = "plain";
                    if (fontStyleStr.toLowerCase().indexOf("bold") >= 0) {
                        this.fontWeight = "bold";
                    }
                    if (fontStyleStr.toLowerCase().indexOf("italic") < 0) continue;
                    this.fontStyle = "italic";
                    continue;
                }
                if (key.equals("inactiveTextAlign")) {
                    this.align = val;
                    continue;
                }
                if (key.equals("inactiveTextColor")) {
                    this.fontColor = DashboardUtil.convertToColorRGB(val);
                    continue;
                }
                if (key.equals("inactiveBGColor")) {
                    this.bgColor = DashboardUtil.convertToColorRGB(val);
                    continue;
                }
                if (key.equals("inactiveBGOpacity")) {
                    this.opacity = DashboardUtil.getInteger(val, 100);
                    continue;
                }
                if (key.equals("inactiveBorderThickness")) {
                    this.borderWidth = DashboardUtil.getInteger(val, 1);
                    continue;
                }
                if (!key.equals("inactiveBorderColor")) continue;
                this.borderColor = DashboardUtil.convertToColorRGB(val);
            }
        }
    }

    private void setAttrFromJSONObject(JSONObject jObj) {
        JSONObject borderJO;
        JSONObject bgJO;
        JSONObject fontJO = jObj.optJSONObject(ATTR_NAME_FONT);
        if (fontJO != null) {
            this.fontName = fontJO.optString(ATTR_NAME_FONTNAME);
            this.fontStyle = fontJO.optString(ATTR_NAME_FONTSTYLE);
            this.fontWeight = fontJO.optString(ATTR_NAME_FONTWEIGHT);
            this.align = fontJO.optString(ATTR_NAME_FONTALIGN);
            JSONArray fontColorJA = fontJO.optJSONArray("color");
            this.fontColor = DashboardUtil.convertToColorRGB(fontColorJA);
        }
        if ((bgJO = jObj.optJSONObject(ATTR_NAME_BACKGROUND)) != null) {
            JSONArray bgColorJA = bgJO.optJSONArray(ATTR_NAME_BGCOLOR);
            this.bgColor = DashboardUtil.convertToColorRGB(bgColorJA);
            this.opacity = bgJO.optInt(ATTR_NAME_BGOPACITY);
        }
        if ((borderJO = jObj.optJSONObject(ATTR_NAME_BORDER)) != null) {
            JSONArray borderColorJA = borderJO.optJSONArray("color");
            this.borderColor = DashboardUtil.convertToColorRGB(borderColorJA);
            this.borderWidth = borderJO.optInt(ATTR_NAME_BORDERWIDTH);
        }
    }

    public String toSpecString() {
        StringBuffer buf = new StringBuffer();
        if (this.isActive) {
            buf.append("fontFamily:" + this.fontName + ";");
            String fontStyleStr = "normal";
            if (this.fontWeight.equals("normal")) {
                if (!this.fontStyle.equals("plain") && this.fontStyle.equals("italic")) {
                    fontStyleStr = "italic";
                }
            } else if (this.fontWeight.equals("bold")) {
                if (this.fontStyle.equals("plain")) {
                    fontStyleStr = "bold";
                } else if (this.fontStyle.equals("italic")) {
                    fontStyleStr = "bold-italic";
                }
            }
            buf.append("fontStyle:" + fontStyleStr + ";");
            buf.append("textAlign:" + this.align + ";");
            buf.append("textColor:" + DashboardUtil.convertToColorStr(this.fontColor) + ";");
            buf.append("activeBGColor:" + DashboardUtil.convertToColorStr(this.bgColor) + ";");
            buf.append("activeBGOpacity:" + this.opacity + ";");
            buf.append("borderThickness:" + this.borderWidth + ";");
            buf.append("borderColor:" + DashboardUtil.convertToColorStr(this.borderColor));
        } else {
            buf.append("inactiveFontFamily:" + this.fontName + ";");
            String fontStyleStr = "normal";
            if (this.fontWeight.equals("normal")) {
                if (!this.fontStyle.equals("plain") && this.fontStyle.equals("italic")) {
                    fontStyleStr = "italic";
                }
            } else if (this.fontWeight.equals("bold")) {
                if (this.fontStyle.equals("plain")) {
                    fontStyleStr = "bold";
                } else if (this.fontStyle.equals("italic")) {
                    fontStyleStr = "bold-italic";
                }
            }
            buf.append("inactiveFontStyle:" + fontStyleStr + ";");
            buf.append("inactiveTextAlign:" + this.align + ";");
            buf.append("inactiveTextColor:" + DashboardUtil.convertToColorStr(this.fontColor) + ";");
            buf.append("inactiveBGColor:" + DashboardUtil.convertToColorStr(this.bgColor) + ";");
            buf.append("inactiveBGOpacity:" + this.opacity + ";");
            buf.append("inactiveBorderThickness:" + this.borderWidth + ";");
            buf.append("inactiveBorderColor:" + DashboardUtil.convertToColorStr(this.borderColor));
        }
        return buf.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            JSONObject fontJO = new JSONObject();
            fontJO.put(ATTR_NAME_FONTNAME, (Object)this.fontName);
            fontJO.put(ATTR_NAME_FONTSTYLE, (Object)this.fontStyle);
            fontJO.put(ATTR_NAME_FONTWEIGHT, (Object)this.fontWeight);
            fontJO.put(ATTR_NAME_FONTALIGN, (Object)this.align);
            JSONArray fontColorJA = DashboardUtil.convertToColorJSONArray(this.fontColor);
            fontJO.put("color", (Object)fontColorJA);
            jObj.put(ATTR_NAME_FONT, (Object)fontJO);
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = DashboardUtil.convertToColorJSONArray(this.bgColor);
            bgJO.put(ATTR_NAME_BGCOLOR, (Object)bgColorJA);
            bgJO.put(ATTR_NAME_BGOPACITY, this.opacity);
            jObj.put(ATTR_NAME_BACKGROUND, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            JSONArray borderColorJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            borderJO.put("color", (Object)borderColorJA);
            borderJO.put(ATTR_NAME_BORDERWIDTH, this.borderWidth);
            jObj.put(ATTR_NAME_BORDER, (Object)borderJO);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public int[] getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int[] fontColor) {
        this.fontColor = fontColor;
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

