/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.dashboard3.api.DashboardUtil;

public class ImageLabel {
    public static final String ATTR_NAME_ID = "id";
    public static final String ATTR_NAME_URL = "url";
    public static final String ATTR_NAME_HYPERLINK = "hyperLink";
    public static final String ATTR_NAME_DESCRIPTION = "description";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_OPACITY = "opacity";
    public static final String ATTR_NAME_BORDERWIDTH = "borderWidth";
    public static final String ATTR_NAME_BORDERSTYLE = "borderStyle";
    public static final String ATTR_NAME_BORDERCOLOR = "borderColor";
    public static final String ATTR_NAME_NEWWINDOW = "newWindow";
    private String id;
    private String url;
    private String hyperLink;
    private String description;
    private int width;
    private int height;
    private int top;
    private int left;
    private int opacity;
    private String borderWidth;
    private String borderStyle;
    private int[] borderColor;
    private boolean newWindow;

    public ImageLabel(JSONObject jObj) {
        this.setAttrFromJSON(jObj);
    }

    public ImageLabel(String jsonString) {
        try {
            JSONObject jObj = new JSONObject(jsonString);
            this.setAttrFromJSON(jObj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setAttrFromJSON(JSONObject jObj) {
        this.id = jObj.optString(ATTR_NAME_ID);
        this.url = jObj.optString(ATTR_NAME_URL);
        this.hyperLink = jObj.optString(ATTR_NAME_HYPERLINK);
        this.description = jObj.optString(ATTR_NAME_DESCRIPTION);
        JSONObject sizeJObj = jObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJObj.optInt(ATTR_NAME_WIDTH);
        this.height = sizeJObj.optInt(ATTR_NAME_HEIGHT);
        JSONObject posJObj = jObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = posJObj.optInt(ATTR_NAME_TOP);
        this.left = posJObj.optInt(ATTR_NAME_LEFT);
        this.opacity = jObj.optInt(ATTR_NAME_OPACITY);
        this.borderWidth = jObj.optString(ATTR_NAME_BORDERWIDTH, "0px");
        this.borderStyle = jObj.optString(ATTR_NAME_BORDERSTYLE, "solid");
        JSONArray bcJA = jObj.optJSONArray(ATTR_NAME_BORDERCOLOR);
        this.borderColor = bcJA == null ? new int[]{127, 127, 127} : DashboardUtil.convertToColorRGB(bcJA);
        this.newWindow = jObj.optBoolean(ATTR_NAME_NEWWINDOW);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_ID, (Object)this.id);
            jObj.put(ATTR_NAME_URL, (Object)this.url);
            jObj.put(ATTR_NAME_HYPERLINK, (Object)this.hyperLink);
            jObj.put(ATTR_NAME_DESCRIPTION, (Object)this.description);
            JSONObject sizeJObj = new JSONObject();
            sizeJObj.put(ATTR_NAME_WIDTH, this.width);
            sizeJObj.put(ATTR_NAME_HEIGHT, this.height);
            jObj.put(ATTR_NAME_SIZE, (Object)sizeJObj);
            JSONObject posJObj = new JSONObject();
            posJObj.put(ATTR_NAME_TOP, this.top);
            posJObj.put(ATTR_NAME_LEFT, this.left);
            jObj.put(ATTR_NAME_POSITION, (Object)posJObj);
            jObj.put(ATTR_NAME_OPACITY, this.opacity);
            jObj.put(ATTR_NAME_BORDERWIDTH, (Object)this.borderWidth);
            jObj.put(ATTR_NAME_BORDERSTYLE, (Object)this.borderStyle);
            JSONArray bcJA = DashboardUtil.convertToColorJSONArray(this.borderColor);
            jObj.put(ATTR_NAME_BORDERCOLOR, (Object)bcJA);
            jObj.put(ATTR_NAME_NEWWINDOW, this.newWindow);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toSpecString() {
        JSONObject jObj = this.toJSONObject();
        return jObj.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHyperLink() {
        return this.hyperLink;
    }

    public void setHyperLink(String hyperLink) {
        this.hyperLink = hyperLink;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public String getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }
}

