/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.DataType;
import quadbase.dashboard3.api.DashboardUtil;
import quadbase.dashboard3.components.TemplateParamForShare;

public class SharedParam {
    public static final String ATTR_NAME_DEFAULTVALUE = "defaultValue";
    public static final String ATTR_NAME_PARAMNAME = "paramName";
    public static final String ATTR_NAME_PARAMVALUEPROVIDER = "paramValueProvider";
    public static final String ATTR_NAME_PROMPTNAME = "promptName";
    public static final String ATTR_NAME_TEMPLATEPARAMLIST = "templateParamList";
    public static final String ATTR_NAME_SQLTYPE = "sqlType";
    private String paramName = null;
    private String promptName = null;
    private String defaultValue = null;
    private int sqlType = -1000;
    private Vector<TemplateParamForShare> templateParamList = null;
    private TemplateParamForShare paramValueProvider = null;

    public SharedParam(JSONObject jObj) {
        this.getSharedParamFromJSON(jObj);
    }

    public SharedParam(String tmp) {
        this.getSharedParamFromSpecString(tmp);
    }

    private void getSharedParamFromSpecString(String tmp) {
        int idx = tmp.indexOf("-_-");
        this.paramName = tmp.substring(0, idx);
        tmp = tmp.substring(idx + 3);
        idx = tmp.indexOf("-_-");
        this.promptName = tmp.substring(0, idx);
        tmp = tmp.substring(idx + 3);
        idx = tmp.indexOf("-_-");
        this.defaultValue = tmp.substring(0, idx);
        try {
            this.defaultValue = URLDecoder.decode(this.defaultValue, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmp = tmp.substring(idx + 3);
        idx = tmp.indexOf("-_-");
        while (idx >= 0) {
            String tmp2 = tmp.substring(0, idx);
            TemplateParamForShare tpfs = new TemplateParamForShare(tmp2);
            if (this.templateParamList == null) {
                this.templateParamList = new Vector();
            }
            this.templateParamList.add(tpfs);
            tmp = tmp.substring(idx + 3);
            idx = tmp.indexOf("-_-");
        }
        if (this.templateParamList == null) {
            this.templateParamList = new Vector();
        }
        int segCounter = 0;
        idx = tmp.indexOf("__");
        while (idx >= 0) {
            ++segCounter;
            idx = tmp.indexOf("__", idx + 2);
        }
        String paramStr = tmp;
        if (++segCounter == 4) {
            idx = tmp.lastIndexOf("__");
            paramStr = tmp.substring(0, idx);
        }
        TemplateParamForShare tpfs = new TemplateParamForShare(paramStr);
        if (this.templateParamList == null) {
            this.templateParamList = new Vector();
        }
        this.templateParamList.add(tpfs);
        idx = tmp.lastIndexOf("__");
        String dataTypeStr = tmp.substring(idx + 2);
        try {
            this.sqlType = Integer.parseInt(dataTypeStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.paramValueProvider = this.templateParamList.elementAt(0);
    }

    private void getSharedParamFromJSON(JSONObject jObj) {
        this.promptName = jObj.optString(ATTR_NAME_PROMPTNAME);
        this.paramName = jObj.optString(ATTR_NAME_PARAMNAME);
        this.defaultValue = jObj.optString(ATTR_NAME_DEFAULTVALUE);
        JSONObject joParamProv = jObj.optJSONObject(ATTR_NAME_PARAMVALUEPROVIDER);
        this.paramValueProvider = new TemplateParamForShare(joParamProv);
        this.sqlType = this.paramValueProvider.getSqlType();
        JSONArray jArray = jObj.optJSONArray(ATTR_NAME_TEMPLATEPARAMLIST);
        this.templateParamList = new Vector();
        for (int i = 0; i < jArray.length(); ++i) {
            JSONObject paramJO = jArray.optJSONObject(i);
            if (paramJO == null) continue;
            TemplateParamForShare tpfs = new TemplateParamForShare(paramJO);
            this.templateParamList.add(tpfs);
        }
    }

    public void setParamValueProvider(TemplateParamForShare paramForShare) {
        this.paramValueProvider = paramForShare;
    }

    public Vector<TemplateParamForShare> getTemplateParamList() {
        return this.templateParamList;
    }

    public Object getValueObject() throws Exception {
        this.defaultValue = this.defaultValue.replace('+', ' ');
        int dataType = DataType.mapType(this.sqlType);
        return DataType.createObject(this.defaultValue, dataType, null);
    }

    public Vector<String> getValueStrings() throws Exception {
        StringTokenizer st = new StringTokenizer(this.defaultValue, ",");
        Vector<String> vect = new Vector<String>();
        while (st.hasMoreTokens()) {
            vect.addElement(st.nextToken());
        }
        return vect;
    }

    public Vector<Object> getValueObjects() throws Exception {
        StringTokenizer st = new StringTokenizer(this.defaultValue, ",");
        Vector<Object> vec2 = new Vector<Object>();
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            val = val.replace('+', ' ');
            int dataType = DataType.mapType(this.sqlType);
            vec2.addElement(DataType.createObject(val, dataType, null));
        }
        return vec2;
    }

    public boolean containsTemplateParam(String templateInfoID, String paramName) {
        for (int i = 0; i < this.templateParamList.size(); ++i) {
            TemplateParamForShare tpfs = this.templateParamList.elementAt(i);
            if (!DashboardUtil.isTemplateInfoIDEqual(tpfs.getTemplateInfoID(), templateInfoID) || !tpfs.getParamName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.paramName + "-_-");
        buf.append(this.promptName + "-_-");
        buf.append(this.defaultValue);
        for (int i = 0; i < this.templateParamList.size(); ++i) {
            TemplateParamForShare tpfs = this.templateParamList.elementAt(i);
            buf.append("-_-" + tpfs.toSpecString());
        }
        buf.append("__" + this.sqlType);
        return buf.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_PARAMNAME, (Object)this.paramName);
            jObj.put(ATTR_NAME_PROMPTNAME, (Object)this.promptName);
            jObj.put(ATTR_NAME_DEFAULTVALUE, (Object)this.defaultValue);
            jObj.put(ATTR_NAME_SQLTYPE, this.sqlType);
            jObj.put(ATTR_NAME_PARAMVALUEPROVIDER, (Object)this.paramValueProvider.toJSONObject());
            JSONArray ja = new JSONArray();
            for (int i = 0; i < this.templateParamList.size(); ++i) {
                TemplateParamForShare tpfs = this.templateParamList.elementAt(i);
                ja.put((Object)tpfs.toJSONObject());
            }
            jObj.put(ATTR_NAME_TEMPLATEPARAMLIST, (Object)ja);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getPromptName() {
        return this.promptName;
    }

    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public TemplateParamForShare getParamValueProvider() {
        return this.paramValueProvider;
    }

    public void setTemplateParamList(Vector<TemplateParamForShare> templateParamList) {
        this.templateParamList = templateParamList;
    }
}

