/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.ChartAPI.QbChart;
import quadbase.common.param.Param;
import quadbase.common.param.Parameters;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.DataType;
import quadbase.dashboard3.components.AdHocFilter;
import quadbase.dashboard3.components.AlertAttr;
import quadbase.dashboard3.components.ContainerProps;
import quadbase.dashboard3.components.TemplateParam;
import quadbase.maps.QbMap;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class TemplateInfo {
    public static final int CHART_TYPE = 0;
    public static final int REPORT_TYPE = 1;
    public static final int MAP_TYPE = 2;
    public static final int NO_TYPE = -1;
    public static final String ATTR_NAME_SERIALNUM = "serialNum";
    public static final String ATTR_NAME_TEMPLATEINFOID = "templateInfoID";
    public static final String ATTR_NAME_NAME = "name";
    public static final String ATTR_NAME_NODEID = "nodeID";
    public static final String ATTR_NAME_ITEMID = "itemID";
    public static final String ATTR_NAME_TYPE = "type";
    public static final String ATTR_NAME_ALIAS = "alias";
    public static final String ATTR_NAME_ISQD = "isQD";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_GRIDPOSITION = "gridPosition";
    public static final String ATTR_NAME_GRIDPOSX = "gridPosX";
    public static final String ATTR_NAME_GRIDPOSY = "gridPosY";
    public static final String ATTR_NAME_DESCRIPTION = "description";
    public static final String ATTR_NAME_PARAMLIST = "params";
    public static final String ATTR_NAME_ADHOCFILTERS = "adHocFilters";
    public static final String ATTR_NAME_ADHOCFILTERALLOWED = "adHocFilterAllowed";
    public static final String ATTR_NAME_ALERTATTR = "alertAttr";
    public static final String ATTR_NAME_CONTAINERPROPS = "properties";
    public static final String ATTR_NAME_NODEPATH = "nodePath";
    public static final String PARAM_KEY = "paramName";
    public static final String PARAM_VALUE = "paramValues";
    public static final String PARAM_ISMULTIPLE = "isMultiple";
    public static final String PARAM_SQLTYPE = "sqlType";
    public static final String QD_CHART_EXT = "qch";
    public static final String QD_REPORT_EXT = "qrp";
    private int serialNum;
    private String name;
    private int nodeID;
    private int itemID;
    private QbChart chart;
    private QbReport report;
    private QbMap map;
    private String path;
    private int type;
    private boolean isQD;
    private boolean adHocFilterAllowed;
    private int top;
    private int left;
    private int gridPosX;
    private int gridPosY;
    private int width;
    private int height;
    private String description;
    private TemplateParam[] params;
    private AdHocFilter[] adHocFilters;
    private AlertAttr alertAttr;
    private ContainerProps containerProps;
    private String nodePath;

    public TemplateInfo(String selectedChartStr) {
        String tmp = new String(selectedChartStr);
        int idx = tmp.indexOf("-K-");
        String templateID = tmp;
        if (idx >= 0) {
            templateID = tmp.substring(0, idx);
            String pList = tmp.substring(idx);
            tmp = tmp.substring(0, idx);
            Vector<TemplateParam> pVect = new Vector<TemplateParam>();
            while (pList.startsWith("-K-")) {
                idx = pList.indexOf("-K-", 3);
                if (idx < 0) {
                    idx = pList.length();
                }
                String paramStr = pList.substring(0, idx);
                TemplateParam tp = new TemplateParam(paramStr);
                pVect.add(tp);
                if (idx == pList.length()) break;
                pList = pList.substring(idx);
            }
            this.params = new TemplateParam[pVect.size()];
            for (int i = 0; i < pVect.size(); ++i) {
                this.params[i] = (TemplateParam)pVect.elementAt(i);
            }
        }
        StringTokenizer st = new StringTokenizer(templateID, ",");
        this.name = st.nextToken();
        this.nodeID = Integer.parseInt(st.nextToken());
        this.itemID = Integer.parseInt(st.nextToken());
        this.type = -1;
    }

    public TemplateInfo(JSONObject jObj) {
        this.setAttrFromJSONObject(jObj);
    }

    private void setAttrFromJSONObject(JSONObject jObj) {
        JSONObject contPropsJObj;
        JSONObject alertAttrJObj;
        this.serialNum = jObj.optInt(ATTR_NAME_SERIALNUM);
        this.name = jObj.optString(ATTR_NAME_NAME);
        this.nodeID = jObj.optInt(ATTR_NAME_NODEID);
        this.itemID = jObj.optInt(ATTR_NAME_ITEMID);
        this.nodePath = jObj.optString(ATTR_NAME_NODEPATH);
        this.type = jObj.optInt(ATTR_NAME_TYPE);
        this.isQD = jObj.optBoolean(ATTR_NAME_ISQD);
        JSONObject posJO = jObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = posJO.optInt(ATTR_NAME_TOP);
        this.left = posJO.optInt(ATTR_NAME_LEFT);
        JSONObject gridPosJO = jObj.optJSONObject(ATTR_NAME_GRIDPOSITION);
        if (gridPosJO != null) {
            this.gridPosX = gridPosJO.optInt(ATTR_NAME_GRIDPOSX);
            this.gridPosY = gridPosJO.optInt(ATTR_NAME_GRIDPOSY);
        }
        JSONObject sizeJO = jObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJO.optInt(ATTR_NAME_WIDTH);
        this.height = sizeJO.optInt(ATTR_NAME_HEIGHT);
        this.description = jObj.optString(ATTR_NAME_DESCRIPTION, "");
        JSONArray paramListJA = jObj.optJSONArray(ATTR_NAME_PARAMLIST);
        if (paramListJA != null) {
            this.params = new TemplateParam[paramListJA.length()];
            for (int i = 0; i < paramListJA.length(); ++i) {
                JSONObject paramJO = paramListJA.optJSONObject(i);
                this.params[i] = new TemplateParam(paramJO);
            }
        } else {
            this.params = null;
        }
        this.gridPosX = jObj.optInt(ATTR_NAME_GRIDPOSX);
        this.gridPosY = jObj.optInt(ATTR_NAME_GRIDPOSY);
        JSONArray adHocFilterJA = jObj.optJSONArray(ATTR_NAME_ADHOCFILTERS);
        if (adHocFilterJA != null) {
            this.adHocFilters = new AdHocFilter[adHocFilterJA.length()];
            for (int i = 0; i < adHocFilterJA.length(); ++i) {
                JSONObject ahfJObj = adHocFilterJA.optJSONObject(i);
                if (ahfJObj == null) continue;
                this.adHocFilters[i] = new AdHocFilter(ahfJObj);
            }
        }
        if ((alertAttrJObj = jObj.optJSONObject(ATTR_NAME_ALERTATTR)) != null) {
            this.alertAttr = new AlertAttr(alertAttrJObj);
        }
        if ((contPropsJObj = jObj.optJSONObject(ATTR_NAME_CONTAINERPROPS)) != null) {
            this.containerProps = new ContainerProps(this.getTemplateID(), contPropsJObj);
        }
    }

    public String getTemplateID() {
        return this.name + "," + this.nodeID + "," + this.itemID;
    }

    public void updateAlerts() {
        String[] allAlertIds = null;
        String[] triggeredAlertIds = null;
        if (this.chart != null) {
            allAlertIds = this.chart.getAllAlertIds();
            triggeredAlertIds = this.chart.getTriggeredAlertIds();
        } else if (this.report != null) {
            allAlertIds = this.report.getAllAlertIds();
            triggeredAlertIds = this.report.getTriggeredAlertIds();
        } else if (this.map != null) {
            allAlertIds = this.map.getAllAlertIds();
            triggeredAlertIds = this.map.getTriggeredAlertIds();
        } else {
            return;
        }
        this.updateAlert(allAlertIds, triggeredAlertIds);
    }

    public void updateAlert(String[] allAlertIds, String[] triggeredAlertIds) {
        int i;
        if (allAlertIds == null) {
            this.setAlertAttr(null);
            allAlertIds = new String[]{};
        }
        if (triggeredAlertIds == null) {
            triggeredAlertIds = new String[]{};
        }
        boolean[] isTriggered = new boolean[allAlertIds.length];
        for (i = 0; i < isTriggered.length; ++i) {
            isTriggered[i] = false;
        }
        block1: for (i = 0; i < allAlertIds.length; ++i) {
            for (String triggeredAlertId : triggeredAlertIds) {
                if (!allAlertIds[i].equals(triggeredAlertId)) continue;
                isTriggered[i] = true;
                continue block1;
            }
        }
        if (this.alertAttr == null) {
            this.alertAttr = new AlertAttr(this.getTemplateID(), allAlertIds);
            this.alertAttr.setIsTriggered(isTriggered);
            this.setAlertAttr(this.alertAttr);
        } else {
            String[] prevAllAlertIds = this.alertAttr.getAlertIds();
            boolean[] prevIsWatched = this.alertAttr.getIsWatched();
            boolean[] isWatched_new = new boolean[allAlertIds.length];
            block3: for (int i2 = 0; i2 < allAlertIds.length; ++i2) {
                for (int j = 0; j < prevAllAlertIds.length; ++j) {
                    if (!prevAllAlertIds[j].equals(allAlertIds[i2])) continue;
                    isWatched_new[i2] = prevIsWatched[j];
                    continue block3;
                }
            }
            this.alertAttr.setAlertIds(allAlertIds);
            this.alertAttr.setIsWatched(isWatched_new);
            this.alertAttr.setIsTriggered(isTriggered);
        }
    }

    public void setTemplateParams(IQueryInParam[] queryInParams) {
        if (queryInParams == null) {
            this.params = null;
            return;
        }
        this.params = new TemplateParam[queryInParams.length];
        for (int i = 0; i < queryInParams.length; ++i) {
            this.params[i] = new TemplateParam(queryInParams[i]);
        }
    }

    public void setTemplateParams(Parameters parameters) {
        if (parameters == null) {
            this.params = null;
            return;
        }
        this.params = new TemplateParam[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Param p = parameters.get(i);
            this.params[i] = new TemplateParam(p);
        }
    }

    public Object getTemplateParamValue(String templateParamName) {
        if (this.params == null) {
            return null;
        }
        TemplateParam tp = null;
        for (TemplateParam param : this.params) {
            if (!param.getName().equals(templateParamName)) continue;
            tp = param;
            break;
        }
        if (tp == null) {
            return null;
        }
        Object valueObj = tp.getValue();
        if (valueObj == null) {
            valueObj = tp.getDefaultValue();
        }
        return valueObj;
    }

    public void setTemplateParamValue(String paramName, Object paramValue) {
        if (this.params == null) {
            return;
        }
        for (TemplateParam param : this.params) {
            if (!param.getName().equals(paramName)) continue;
            param.setValue(paramValue);
            break;
        }
    }

    public void setGridXY(String gridPosSpec) {
        if (gridPosSpec == null || gridPosSpec.equals("")) {
            return;
        }
        int loc = gridPosSpec.indexOf(44);
        if (loc < 0) {
            return;
        }
        this.gridPosX = Integer.parseInt(gridPosSpec.substring(0, loc));
        this.gridPosY = Integer.parseInt(gridPosSpec.substring(loc + 1));
    }

    public void setPosition(String positionSpec) {
        StringTokenizer st = new StringTokenizer(positionSpec, "^");
        if (st.countTokens() < 5) {
            System.out.println("Error: the template position attribute missed some fields:" + positionSpec);
            return;
        }
        this.top = this.getPxValue(st.nextToken());
        this.left = this.getPxValue(st.nextToken());
        this.width = this.getPxValue(st.nextToken());
        this.height = this.getPxValue(st.nextToken());
    }

    private int getPxValue(String pxStr) {
        String tmp = pxStr.toLowerCase().replaceAll("px", "");
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_SERIALNUM, this.serialNum);
            jObj.put(ATTR_NAME_NAME, (Object)this.name);
            jObj.put(ATTR_NAME_NODEID, this.nodeID);
            jObj.put(ATTR_NAME_ITEMID, this.itemID);
            jObj.put(ATTR_NAME_NODEPATH, (Object)this.nodePath);
            jObj.put(ATTR_NAME_TYPE, this.type);
            jObj.put(ATTR_NAME_ISQD, this.isQD);
            jObj.put(ATTR_NAME_ADHOCFILTERALLOWED, this.adHocFilterAllowed);
            JSONObject posJO = new JSONObject();
            posJO.put(ATTR_NAME_TOP, this.top);
            posJO.put(ATTR_NAME_LEFT, this.left);
            jObj.put(ATTR_NAME_POSITION, (Object)posJO);
            JSONObject sizeJO = new JSONObject();
            sizeJO.put(ATTR_NAME_WIDTH, this.width);
            sizeJO.put(ATTR_NAME_HEIGHT, this.height);
            jObj.put(ATTR_NAME_SIZE, (Object)sizeJO);
            JSONObject gridJO = new JSONObject();
            gridJO.put(ATTR_NAME_GRIDPOSX, this.gridPosX);
            gridJO.put(ATTR_NAME_GRIDPOSY, this.gridPosY);
            jObj.put(ATTR_NAME_GRIDPOSITION, (Object)gridJO);
            jObj.put(ATTR_NAME_DESCRIPTION, (Object)this.description);
            if (this.params != null && this.params.length > 0) {
                JSONArray paramListJArray = new JSONArray();
                for (TemplateParam param : this.params) {
                    JSONObject paramJObj = param.toJSONObject();
                    paramListJArray.put((Object)paramJObj);
                }
                jObj.put(ATTR_NAME_PARAMLIST, (Object)paramListJArray);
            }
            if (this.adHocFilters != null) {
                JSONArray ahfJArray = new JSONArray();
                for (AdHocFilter adHocFilter : this.adHocFilters) {
                    JSONObject ahfJObj = adHocFilter.toJSONObject();
                    ahfJArray.put((Object)ahfJObj);
                }
                jObj.put(ATTR_NAME_ADHOCFILTERS, (Object)ahfJArray);
            }
            if (this.alertAttr != null) {
                jObj.put(ATTR_NAME_ALERTATTR, (Object)this.alertAttr.toJSONObject());
            }
            if (this.containerProps != null) {
                jObj.put(ATTR_NAME_CONTAINERPROPS, (Object)this.containerProps.toJSONObject());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String getSelectedChartString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name + "," + this.nodeID + "," + this.itemID);
        if (this.params != null && this.params.length > 0) {
            for (TemplateParam param : this.params) {
                buf.append(param.toSpecString());
            }
        }
        return buf.toString();
    }

    public String getGridPosition() {
        return this.gridPosX + "," + this.gridPosY;
    }

    public String getPositionString() {
        String str = this.getTemplateID() + ":";
        str = str + this.top + "px^" + this.left + "px^" + this.width + "px^" + this.height + "px^false";
        return str;
    }

    public void setParamTypeFromSpec(String paramTypeSpec) {
        int loc = paramTypeSpec.indexOf("-_-");
        if (loc < 0) {
            int lastDoc = this.path.lastIndexOf(46);
            String ext = this.path.substring(lastDoc + 1).toUpperCase();
            if (ext.equals("CHT") || ext.equals("QCH") || ext.equals("TPL") || ext.equals("PAC")) {
                this.type = 0;
            } else if (ext.equals("RPT") || ext.equals("QRP") || ext.equals("PAK")) {
                this.type = 1;
            } else if (ext.equals("GXML") || ext.equals("SXML")) {
                this.type = 2;
            }
            return;
        }
        String tid = paramTypeSpec.substring(0, loc);
        if (!tid.equals(this.getTemplateID())) {
            return;
        }
        String part2 = paramTypeSpec.substring(loc + 3);
        loc = part2.indexOf("-_-");
        String typeStr = "";
        if (loc < 0) {
            typeStr = part2;
        } else {
            String paramStr = part2.substring(0, loc);
            typeStr = part2.substring(loc + 3);
            StringTokenizer st = new StringTokenizer(paramStr, ",");
            while (st.hasMoreTokens()) {
                String paramTypeStr = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(paramTypeStr, ":");
                String paramName = st2.nextToken();
                String dataTypeID = st2.nextToken();
                int sqlType = Integer.parseInt(dataTypeID);
                for (int i = 0; this.params != null && i < this.params.length; ++i) {
                    if (!this.params[i].getName().equals(paramName)) continue;
                    this.params[i].setSqlType(sqlType);
                }
            }
        }
        this.type = typeStr.equals("CHT") ? 0 : (typeStr.equals("RPT") ? 1 : (typeStr.equals("MAP") ? 2 : -1));
    }

    public String getParamTypeString() {
        String typeStr = "CHT";
        switch (this.type) {
            case 0: {
                typeStr = "CHT";
                break;
            }
            case 1: {
                typeStr = "RPT";
                break;
            }
            case 2: {
                typeStr = "MAP";
            }
        }
        String templateID = this.getTemplateID();
        if (this.params == null || this.params.length == 0) {
            return templateID + "-_-" + typeStr;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(templateID + "-_-");
        for (int i = 0; i < this.params.length; ++i) {
            String paramStr = i > 0 ? "," : "";
            String sqlTypeStr = DataType.getTypeName2(this.params[i].getSqlType());
            paramStr = paramStr + this.params[i].getName() + ":" + this.params[i].getSqlType() + ":" + sqlTypeStr;
            buf.append(paramStr);
        }
        buf.append("-_-" + typeStr);
        return buf.toString();
    }

    public String getAdHocFiltersString() {
        JSONObject jObj = new JSONObject();
        try {
            String templateInfoID = this.getTemplateID();
            jObj.put(ATTR_NAME_TEMPLATEINFOID, (Object)templateInfoID);
            if (this.adHocFilters != null) {
                JSONArray ahfJA = new JSONArray();
                for (AdHocFilter adHocFilter : this.adHocFilters) {
                    ahfJA.put((Object)adHocFilter.toJSONObject());
                }
                jObj.put(ATTR_NAME_ADHOCFILTERS, (Object)ahfJA);
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj.toString();
    }

    public String getContainerPropsString() {
        if (this.containerProps == null) {
            return "none";
        }
        String templateInfoID = this.getTemplateID();
        this.containerProps.setTemplateInfoID(templateInfoID);
        return this.containerProps.toString();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public int getItemID() {
        return this.itemID;
    }

    public void setItemID(int itemID) {
        this.itemID = itemID;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.isQD = path.endsWith(QD_CHART_EXT) || path.endsWith(QD_REPORT_EXT);
        this.path = path;
    }

    public TemplateParam[] getParams() {
        return this.params;
    }

    public void setParams(TemplateParam[] params) {
        this.params = params;
    }

    public QbChart getChart() {
        return this.chart;
    }

    public void setChart(QbChart chart) {
        this.chart = chart;
        this.type = 0;
    }

    public QbReport getReport() {
        return this.report;
    }

    public void setReport(QbReport report) {
        this.report = report;
        this.type = 1;
    }

    public QbMap getMap() {
        return this.map;
    }

    public void setMap(QbMap map) {
        this.map = map;
        this.type = 2;
    }

    public boolean isQD() {
        if (this.path != null) {
            this.isQD = this.path.endsWith(QD_CHART_EXT) || this.path.endsWith(QD_REPORT_EXT);
        }
        return this.isQD;
    }

    public void setQD(boolean isQD) {
    }

    public int getGridPosX() {
        return this.gridPosX;
    }

    public void setGridPosX(int gridPosX) {
        this.gridPosX = gridPosX;
    }

    public int getGridPosY() {
        return this.gridPosY;
    }

    public void setGridPosY(int gridPosY) {
        this.gridPosY = gridPosY;
    }

    public int getSerialNum() {
        return this.serialNum;
    }

    public void setSerialNum(int serialNum) {
        this.serialNum = serialNum;
    }

    public AdHocFilter[] getAdHocFilters() {
        return this.adHocFilters;
    }

    public void setAdHocFilters(AdHocFilter[] adHocFilters) {
        this.adHocFilters = adHocFilters;
    }

    public void setAdHocFilters(JSONArray adHocFiltersJArray, boolean resetToDefault) {
        this.adHocFilters = new AdHocFilter[adHocFiltersJArray.length()];
        for (int i = 0; i < adHocFiltersJArray.length(); ++i) {
            JSONObject ahfJObj = adHocFiltersJArray.optJSONObject(i);
            if (ahfJObj == null) continue;
            this.adHocFilters[i] = new AdHocFilter(ahfJObj);
            if (!resetToDefault) continue;
            this.adHocFilters[i].setOperator("");
            this.adHocFilters[i].setArguments(new String[]{"All"});
        }
    }

    public boolean isAdHocFilterAllowed() {
        return this.adHocFilterAllowed;
    }

    public void setAdHocFilterAllowed(boolean adHocFilterAllowed) {
        this.adHocFilterAllowed = adHocFilterAllowed;
    }

    public AlertAttr getAlertAttr() {
        return this.alertAttr;
    }

    public void setAlertAttr(AlertAttr alertAttr) {
        this.alertAttr = alertAttr;
    }

    public ContainerProps getContainerProps() {
        return this.containerProps;
    }

    public void setContainerProps(ContainerProps containerProps) {
        this.containerProps = containerProps;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }
}

