/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.param.Param;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;

public class TemplateParam {
    public static final String ATTR_NAME_NAME = "name";
    public static final String ATTR_NAME_PROMPTNAME = "promptName";
    public static final String ATTR_NAME_ISMULTIPLE = "isMultiple";
    public static final String ATTR_NAME_SQLTYPE = "sqlType";
    public static final String ATTR_NAME_DEFAULTVALUE = "defaultValue";
    public static final String ATTR_NAME_VALUE = "value";
    private String name;
    private String promptName;
    private boolean isMultiple;
    private int sqlType;
    private Object defaultValue;
    private Object value;

    public TemplateParam() {
    }

    public TemplateParam(String specString) {
        this.setTemplateParam(specString);
    }

    public TemplateParam(IQueryInParam queryInParam) {
        this.name = queryInParam.getParamName();
        this.promptName = queryInParam.getPromptName();
        this.sqlType = queryInParam.getSqlType();
        this.defaultValue = queryInParam.getDefaultValue();
        this.isMultiple = queryInParam instanceof IQueryMultiValueInParam;
        this.value = this.isMultiple ? ((IQueryMultiValueInParam)queryInParam).getValues() : queryInParam.getValue();
    }

    public TemplateParam(Param param) {
        this.name = param.name();
        this.promptName = param.getPromptName();
        this.sqlType = param.getSqlType();
        this.defaultValue = param.getDefaultValue();
        this.isMultiple = param.multiValue();
        this.value = this.isMultiple ? param.getValues() : param.getValue();
    }

    public TemplateParam(JSONObject jObj) {
        this.setTemplateParam(jObj);
    }

    private void setTemplateParam(String specString) {
        int idx = specString.indexOf("-K-");
        int idx2 = specString.indexOf("-V-");
        this.promptName = this.name = specString.substring(idx + 3, idx2);
        String valueStr = specString.substring(idx2 + 3);
        this.isMultiple = valueStr.endsWith("-MV");
        if (this.isMultiple) {
            valueStr = valueStr.substring(0, valueStr.length() - 3);
            StringTokenizer st = new StringTokenizer(valueStr, ",");
            Vector<String> vect = new Vector<String>();
            while (st.hasMoreTokens()) {
                vect.add(st.nextToken());
            }
            this.value = vect;
        } else {
            this.value = valueStr;
        }
    }

    private void setTemplateParam(JSONObject jObj) {
        int i;
        if (jObj == null) {
            return;
        }
        this.name = jObj.optString(ATTR_NAME_NAME);
        this.promptName = jObj.optString(ATTR_NAME_PROMPTNAME);
        this.isMultiple = jObj.optBoolean(ATTR_NAME_ISMULTIPLE);
        this.sqlType = jObj.optInt(ATTR_NAME_SQLTYPE);
        try {
            JSONArray defaultJA = jObj.getJSONArray(ATTR_NAME_DEFAULTVALUE);
            Vector<Object> dv = new Vector<Object>();
            for (i = 0; i < defaultJA.length(); ++i) {
                dv.add(defaultJA.get(i));
            }
            this.defaultValue = dv;
        }
        catch (JSONException e) {
            this.defaultValue = jObj.opt(ATTR_NAME_DEFAULTVALUE);
        }
        if (this.isMultiple) {
            JSONArray vJA = jObj.optJSONArray(ATTR_NAME_VALUE);
            Vector<Object> v = new Vector<Object>();
            for (i = 0; i < vJA.length(); ++i) {
                Object obj = vJA.opt(i);
                if (obj == null) continue;
                v.add(obj);
            }
            this.value = v;
        } else {
            this.value = jObj.optString(ATTR_NAME_VALUE);
        }
        if (this.promptName == null || this.promptName.length() == 0) {
            this.promptName = this.name;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            int i;
            jObj.put(ATTR_NAME_NAME, (Object)this.name);
            jObj.put(ATTR_NAME_PROMPTNAME, (Object)this.promptName);
            jObj.put(ATTR_NAME_ISMULTIPLE, this.isMultiple);
            jObj.put(ATTR_NAME_SQLTYPE, this.sqlType);
            if (this.defaultValue != null) {
                if (this.defaultValue instanceof Vector) {
                    Vector defVect = (Vector)this.defaultValue;
                    JSONArray defValJA = new JSONArray();
                    for (i = 0; i < defVect.size(); ++i) {
                        defValJA.put(defVect.elementAt(i));
                    }
                    jObj.put(ATTR_NAME_DEFAULTVALUE, (Object)defValJA);
                } else {
                    jObj.put(ATTR_NAME_DEFAULTVALUE, (Object)this.defaultValue.toString());
                }
            }
            if (this.isMultiple) {
                if (this.value != null) {
                    Vector valVect = (Vector)this.value;
                    JSONArray valJA = new JSONArray();
                    for (i = 0; i < valVect.size(); ++i) {
                        valJA.put(valVect.elementAt(i));
                    }
                    jObj.put(ATTR_NAME_VALUE, (Object)valJA);
                }
            } else if (this.value != null) {
                jObj.put(ATTR_NAME_VALUE, (Object)this.value.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toSpecString() {
        Object valueObj = this.getValue();
        String valStr = "";
        if (valueObj != null && valueObj instanceof Vector) {
            StringBuffer b2 = new StringBuffer();
            Vector vec = (Vector)valueObj;
            for (int j = 0; j < vec.size(); ++j) {
                if (j == 0) {
                    b2.append(vec.elementAt(j));
                    continue;
                }
                b2.append("," + vec.elementAt(j));
            }
            b2.append("-MV");
            valStr = b2.toString();
        } else {
            valStr = valueObj.toString();
        }
        return "-K-" + this.getName() + "-V-" + valStr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPromptName() {
        return this.promptName;
    }

    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.isMultiple && value instanceof String) {
            Vector<Object> v = new Vector<Object>();
            v.add(value);
            this.value = v;
        } else if (!this.isMultiple && value instanceof Vector) {
            Vector v = (Vector)value;
            this.value = v.elementAt(0).toString();
        } else {
            this.value = value;
        }
    }
}

