/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import org.json.JSONException;
import org.json.JSONObject;

public class TemplateParamForShare {
    public static final String ATTR_NAME_TEMPLATEINFOID = "templateInfoID";
    public static final String ATTR_NAME_PARAMNAME = "paramName";
    public static final String ATTR_NAME_SQLTYPE = "sqlType";
    private String templateInfoID;
    private String paramName;
    private int sqlType;

    public TemplateParamForShare(String templateInfoID, String paramName, int sqlType) {
        this.templateInfoID = templateInfoID;
        this.paramName = paramName;
        this.sqlType = sqlType;
    }

    public TemplateParamForShare(String templateParamSeg) {
        this.parseSpecString(templateParamSeg);
    }

    public TemplateParamForShare(JSONObject templateParamJObj) {
        this.parseJSONObject(templateParamJObj);
    }

    private void parseSpecString(String templateParamSeg) {
        int loc = templateParamSeg.indexOf(44);
        int loc1 = templateParamSeg.indexOf("__", (loc = templateParamSeg.indexOf(",", loc + 1)) + 1);
        int loc2 = templateParamSeg.indexOf("__", loc1 + 2);
        if (loc2 < 0) {
            loc2 = templateParamSeg.length() - 1;
        }
        this.templateInfoID = templateParamSeg.substring(0, loc1);
        this.paramName = templateParamSeg.substring(loc1 + 2, loc2);
        loc = loc2;
        this.sqlType = (loc2 = templateParamSeg.indexOf("__", loc + 2)) < 0 ? Integer.parseInt(templateParamSeg.substring(loc + 2)) : Integer.parseInt(templateParamSeg.substring(loc + 2, loc2));
    }

    private void parseJSONObject(JSONObject jObj) {
        this.templateInfoID = jObj.optString(ATTR_NAME_TEMPLATEINFOID);
        this.paramName = jObj.optString(ATTR_NAME_PARAMNAME);
        this.sqlType = jObj.optInt(ATTR_NAME_SQLTYPE);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_TEMPLATEINFOID, (Object)this.templateInfoID);
            jObj.put(ATTR_NAME_PARAMNAME, (Object)this.paramName);
            jObj.put(ATTR_NAME_SQLTYPE, this.sqlType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String toSpecString() {
        String s = this.templateInfoID + "__" + this.paramName + "__" + this.sqlType;
        return s;
    }

    public String getTemplateInfoID() {
        return this.templateInfoID;
    }

    public void setTemplateInfoID(String templateInfoID) {
        this.templateInfoID = templateInfoID;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }
}

