/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard3.api.DashboardUtil;

public class TextLabel {
    public static final String ATTR_NAME_ID = "id";
    public static final String ATTR_NAME_HTML = "html";
    public static final String ATTR_NAME_POSITION = "position";
    public static final String ATTR_NAME_TOP = "top";
    public static final String ATTR_NAME_LEFT = "left";
    public static final String ATTR_NAME_SIZE = "size";
    public static final String ATTR_NAME_WIDTH = "width";
    public static final String ATTR_NAME_HEIGHT = "height";
    public static final String ATTR_NAME_BACKGROUND = "background";
    public static final String ATTR_NAME_BGCOLOR = "bgColor";
    public static final String ATTR_NAME_OPACITY = "opacity";
    public static final String ATTR_NAME_ISTRANSPARENT = "isTransparent";
    public static final String ATTR_NAME_USEBGIMAGE = "useBGImage";
    public static final String ATTR_NAME_BGIMAGEURL = "bgImageURL";
    public static final String ATTR_NAME_BGPOSITION = "bgPosition";
    public static final String ATTR_NAME_BGREPEAT = "bgRepeat";
    public static final String ATTR_NAME_BORDER = "border";
    public static final String ATTR_NAME_BORDER_COLOR = "color";
    public static final String ATTR_NAME_BORDER_THICKNESS = "thickness";
    public static final String ATTR_NAME_BORDER_STYLE = "style";
    public static final String ATTR_NAME_BORDER_PADDING = "padding";
    private String id;
    private String html;
    private int top;
    private int left;
    private int width;
    private int height;
    private int[] bgColor;
    private double opacity;
    private boolean isTransparent;
    private boolean useBGImage;
    private String bgImageURL;
    private String bgPosition;
    private String bgRepeat;
    private int[] borderColor;
    private int borderThickness;
    private String borderStyle;
    private int borderPadding;
    private String fontWeight;
    private String fontStyle;
    private String fontSize;
    private String fontFamily;
    private String fontAlign;
    private String fontColor;

    public TextLabel(JSONObject jObj) {
        this.setAttrFromJSON(jObj);
    }

    public TextLabel(String textLabelSpec) {
        this.setLabelAttrFromSpec(textLabelSpec);
    }

    public TextLabel(String textLabelSpec, String bgSpec) {
        this.setLabelAttrFromSpec(textLabelSpec);
        this.setLabelBGImageFromSpec(bgSpec);
    }

    private void setAttrFromJSON(JSONObject jObj) {
        this.id = jObj.optString(ATTR_NAME_ID);
        this.html = jObj.optString(ATTR_NAME_HTML);
        JSONObject sizeJObj = jObj.optJSONObject(ATTR_NAME_SIZE);
        this.width = sizeJObj.optInt(ATTR_NAME_WIDTH);
        this.height = sizeJObj.optInt(ATTR_NAME_HEIGHT);
        JSONObject posJObj = jObj.optJSONObject(ATTR_NAME_POSITION);
        this.top = posJObj.optInt(ATTR_NAME_TOP);
        this.left = posJObj.optInt(ATTR_NAME_LEFT);
        JSONObject bgJObj = jObj.optJSONObject(ATTR_NAME_BACKGROUND);
        JSONArray bgColorJA = bgJObj.optJSONArray(ATTR_NAME_BGCOLOR);
        this.bgColor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.bgColor[i] = bgColorJA.optInt(i);
        }
        this.opacity = bgJObj.optDouble(ATTR_NAME_OPACITY);
        this.isTransparent = bgJObj.optBoolean(ATTR_NAME_ISTRANSPARENT);
        this.useBGImage = bgJObj.optBoolean(ATTR_NAME_USEBGIMAGE);
        this.bgImageURL = bgJObj.optString(ATTR_NAME_BGIMAGEURL);
        this.bgPosition = bgJObj.optString(ATTR_NAME_BGPOSITION);
        this.bgRepeat = bgJObj.optString(ATTR_NAME_BGREPEAT);
        JSONObject borderJObj = jObj.optJSONObject(ATTR_NAME_BORDER);
        if (borderJObj != null) {
            JSONArray bdrColorJA = borderJObj.optJSONArray(ATTR_NAME_BORDER_COLOR);
            this.borderColor = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.borderColor[i] = bdrColorJA.optInt(i);
            }
            this.borderStyle = borderJObj.optString(ATTR_NAME_BORDER_STYLE);
            this.borderThickness = borderJObj.optInt(ATTR_NAME_BORDER_THICKNESS);
            this.borderPadding = borderJObj.optInt(ATTR_NAME_BORDER_PADDING);
        }
        this.fontFamily = "Arial";
        this.fontStyle = "plain";
        this.fontWeight = "normal";
        this.fontSize = "12px";
        this.fontAlign = ATTR_NAME_LEFT;
        this.fontColor = "rgb(0,0,0)";
    }

    private void setLabelAttrFromSpec(String specStr) {
        StringTokenizer colorST;
        StringTokenizer propTok = new StringTokenizer(specStr, ":");
        if (propTok.countTokens() < 6) {
            System.out.println("Text Label parse Error (Missing properties): " + specStr);
            return;
        }
        this.id = propTok.nextToken();
        this.html = propTok.nextToken();
        try {
            this.html = URLDecoder.decode(this.html, "UTF-8");
            this.html = this.html.substring(1, this.html.length() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String posStr = propTok.nextToken();
        String fontStr = propTok.nextToken();
        String bgStr = propTok.nextToken();
        String borderStr = propTok.nextToken();
        StringTokenizer st = new StringTokenizer(posStr, "^");
        this.top = 0;
        this.left = 0;
        this.width = 200;
        this.height = 50;
        if (st.countTokens() != 4) {
            System.out.println("Text Label parse Error, Position data missing: " + posStr);
        } else {
            String divTop = st.nextToken();
            this.top = DashboardUtil.getIntFromPX(divTop);
            String divLeft = st.nextToken();
            this.left = DashboardUtil.getIntFromPX(divLeft);
            String divWidth = st.nextToken();
            this.width = DashboardUtil.getIntFromPX(divWidth);
            String divHeight = st.nextToken();
            this.height = DashboardUtil.getIntFromPX(divHeight);
        }
        st = new StringTokenizer(fontStr, "^");
        this.fontFamily = "Arial";
        this.fontStyle = "plain";
        this.fontWeight = "normal";
        this.fontSize = "12px";
        this.fontAlign = ATTR_NAME_LEFT;
        this.fontColor = "rgb(0,0,0)";
        if (st.countTokens() != 6) {
            System.out.println("Text Label parse Error, Font data missing: " + fontStr);
        } else {
            this.fontFamily = st.nextToken();
            this.fontStyle = st.nextToken();
            this.fontWeight = st.nextToken();
            this.fontSize = st.nextToken();
            this.fontAlign = st.nextToken();
            this.fontColor = st.nextToken();
        }
        this.bgColor = new int[]{255, 255, 255};
        this.opacity = 1.0;
        st = new StringTokenizer(bgStr, "^");
        if (st.countTokens() != 2) {
            System.out.println("Text Label parse Error, BGColor data missing: " + bgStr);
        } else {
            String bgColorStr = st.nextToken();
            boolean isTransparent = false;
            int loc1 = bgColorStr.indexOf(40);
            int loc2 = bgColorStr.indexOf(41);
            if (bgColorStr.equalsIgnoreCase("transparent") || loc1 < 0 || loc2 < 0) {
                this.bgColor = new int[]{255, 255, 255};
                isTransparent = true;
            } else {
                bgColorStr = bgColorStr.substring(loc1 + 1, loc2);
                colorST = new StringTokenizer(bgColorStr, ",");
                this.bgColor[0] = Integer.parseInt(colorST.nextToken().trim());
                this.bgColor[1] = Integer.parseInt(colorST.nextToken().trim());
                this.bgColor[2] = Integer.parseInt(colorST.nextToken().trim());
            }
            String opacityStr = st.nextToken();
            if (!opacityStr.equals("undefined")) {
                this.opacity = Double.parseDouble(opacityStr);
            }
            if (isTransparent && !this.useBGImage) {
                this.opacity = 0.0;
            }
        }
        borderStr = borderStr.replaceAll(", ", ",");
        StringTokenizer borderST = new StringTokenizer(borderStr, " ");
        if (borderST.countTokens() >= 3) {
            this.borderThickness = DashboardUtil.getIntFromPX(borderST.nextToken());
            this.borderStyle = borderST.nextToken();
            String borderColorStr = borderST.nextToken();
            int loc1 = borderColorStr.indexOf(40);
            int loc2 = borderColorStr.indexOf(41);
            borderColorStr = borderColorStr.substring(loc1 + 1, loc2);
            colorST = new StringTokenizer(borderColorStr, ",");
            this.borderColor = new int[3];
            this.borderColor[0] = Integer.parseInt(colorST.nextToken().trim());
            this.borderColor[1] = Integer.parseInt(colorST.nextToken().trim());
            this.borderColor[2] = Integer.parseInt(colorST.nextToken().trim());
        }
    }

    public void setLabelBGImageFromSpec(String bgSpec) {
        StringTokenizer bgImgST = new StringTokenizer(bgSpec, ":");
        if (bgImgST.countTokens() < 4) {
            this.bgImageURL = "";
            this.bgPosition = "center";
            this.bgRepeat = "repeat";
        }
        bgImgST.nextToken();
        String bgImg = bgImgST.nextToken();
        this.bgPosition = bgImgST.nextToken();
        this.bgRepeat = bgImgST.nextToken();
        String fixedBG = bgImgST.nextToken();
        if (fixedBG.equals("none")) {
            if (bgImg.equals("none")) {
                this.bgImageURL = "";
            } else {
                int loc2;
                int loc1 = bgImg.indexOf(40);
                String tmp = bgImg.substring(loc1 + 1, loc2 = bgImg.lastIndexOf(41)).trim();
                if (tmp.startsWith("'")) {
                    tmp = tmp.replace('\'', ' ').trim();
                }
                this.bgImageURL = DashboardUtil.decodeString(tmp);
            }
        } else {
            int loc2;
            this.bgPosition = "fixed";
            int loc1 = fixedBG.indexOf(40);
            String tmp = fixedBG.substring(loc1 + 1, loc2 = fixedBG.lastIndexOf(41));
            if (tmp.indexOf(39) > 0) {
                tmp = tmp.replace('\'', ' ').trim();
            }
            this.bgImageURL = DashboardUtil.decodeString(tmp);
        }
        if (this.bgImageURL != null && this.bgImageURL.length() > 0) {
            if (this.bgImageURL.startsWith("\"")) {
                this.bgImageURL = this.bgImageURL.replace('\"', ' ').trim();
            }
            this.useBGImage = true;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(ATTR_NAME_ID, (Object)this.id);
            jObj.put(ATTR_NAME_HTML, (Object)this.html);
            JSONObject sizeJObj = new JSONObject();
            sizeJObj.put(ATTR_NAME_WIDTH, this.width);
            sizeJObj.put(ATTR_NAME_HEIGHT, this.height);
            jObj.put(ATTR_NAME_SIZE, (Object)sizeJObj);
            JSONObject posJObj = new JSONObject();
            posJObj.put(ATTR_NAME_TOP, this.top);
            posJObj.put(ATTR_NAME_LEFT, this.left);
            jObj.put(ATTR_NAME_POSITION, (Object)posJObj);
            JSONObject bgJO = new JSONObject();
            JSONArray bgColorJA = new JSONArray();
            for (int element : this.bgColor) {
                bgColorJA.put(element);
            }
            bgJO.put(ATTR_NAME_BGCOLOR, (Object)bgColorJA);
            bgJO.put(ATTR_NAME_OPACITY, this.opacity);
            bgJO.put(ATTR_NAME_ISTRANSPARENT, this.isTransparent);
            bgJO.put(ATTR_NAME_USEBGIMAGE, this.useBGImage);
            bgJO.put(ATTR_NAME_BGIMAGEURL, (Object)this.bgImageURL);
            bgJO.put(ATTR_NAME_BGPOSITION, (Object)this.bgPosition);
            bgJO.put(ATTR_NAME_BGREPEAT, (Object)this.bgRepeat);
            jObj.put(ATTR_NAME_BACKGROUND, (Object)bgJO);
            JSONObject borderJO = new JSONObject();
            JSONArray borderColorJA = new JSONArray();
            for (int element : this.borderColor) {
                borderColorJA.put(element);
            }
            borderJO.put(ATTR_NAME_BORDER_COLOR, (Object)borderColorJA);
            borderJO.put(ATTR_NAME_BORDER_THICKNESS, this.borderThickness);
            borderJO.put(ATTR_NAME_BORDER_STYLE, (Object)this.borderStyle);
            borderJO.put(ATTR_NAME_BORDER_PADDING, this.borderPadding);
            jObj.put(ATTR_NAME_BORDER, (Object)borderJO);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    public String getTextSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.id + ":[");
        buf.append(DashboardUtil.encodeString(this.html));
        buf.append("]:");
        buf.append(this.top + "px^" + this.left + "px^" + this.width + "px^" + this.height + "px:");
        buf.append(this.fontFamily + "^" + this.fontStyle + "^" + this.fontWeight + "^" + this.fontSize + "^" + this.fontAlign + "^" + this.fontColor + ":");
        String bgColorStr = "rgb(" + this.bgColor[0] + "," + this.bgColor[1] + "," + this.bgColor[2] + ")";
        if (this.opacity == 0.0) {
            bgColorStr = "transparent";
        }
        buf.append(bgColorStr + "^" + this.opacity + ":");
        String bdrColorStr = "rgb(" + this.borderColor[0] + "," + this.borderColor[1] + "," + this.borderColor[2] + ")";
        buf.append(this.borderThickness + "px " + this.borderStyle + " " + bdrColorStr);
        return buf.toString();
    }

    public String getBGSpecString() {
        StringBuffer buf = new StringBuffer();
        String bgImgAttr = "";
        bgImgAttr = this.bgImageURL != null && this.bgImageURL.length() > 0 ? "url('" + QbUtil.encodeURIComponent(this.bgImageURL) + "')" : "none";
        buf.append(this.id + ":");
        if ("fixed".equals(this.bgPosition)) {
            buf.append("none:" + this.bgPosition + ":" + this.bgRepeat + ":" + bgImgAttr);
        } else {
            buf.append(bgImgAttr + ":" + this.bgPosition + ":" + this.bgRepeat + ":none");
        }
        return buf.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int[] getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int[] bgColor) {
        this.bgColor = bgColor;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void setTransparent(boolean isTransparent) {
        this.isTransparent = isTransparent;
    }

    public boolean isUseBGImage() {
        return this.useBGImage;
    }

    public void setUseBGImage(boolean useBGImage) {
        this.useBGImage = useBGImage;
    }

    public String getBgImageURL() {
        return this.bgImageURL;
    }

    public void setBgImageURL(String bgImageURL) {
        this.bgImageURL = bgImageURL;
    }

    public String getBgPosition() {
        return this.bgPosition;
    }

    public void setBgPosition(String bgPosition) {
        this.bgPosition = bgPosition;
    }

    public String getBgRepeat() {
        return this.bgRepeat;
    }

    public void setBgRepeat(String bgRepeat) {
        this.bgRepeat = bgRepeat;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int borderThickness) {
        this.borderThickness = borderThickness;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int getBorderPadding() {
        return this.borderPadding;
    }

    public void setBorderPadding(int borderPadding) {
        this.borderPadding = borderPadding;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public String getFontAlign() {
        return this.fontAlign;
    }

    public void setFontAlign(String fontAlign) {
        this.fontAlign = fontAlign;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }
}

