/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.components;

import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public class ZIndexAttr {
    public static final String JSON_KEY_NAME = "name";
    public static final String JSON_KEY_TYPE = "type";
    public static final String JSON_KEY_ZINDEX = "zIndex";
    private String name;
    private String type;
    private int zIndex;

    public ZIndexAttr(String specStr) {
        this.setAttrFromString(specStr);
    }

    public ZIndexAttr(JSONObject jObj) {
        this.setAttrFromJSON(jObj);
    }

    private void setAttrFromString(String specStr) {
        StringTokenizer st = new StringTokenizer(specStr, ":");
        int tokens = st.countTokens();
        this.type = st.nextToken();
        this.name = st.nextToken();
        if (tokens == 3) {
            String zStr = st.nextToken();
            if (zStr.equals("")) {
                this.zIndex = 0;
            } else if (zStr.equals("NaN")) {
                this.zIndex = 0;
            } else {
                try {
                    this.zIndex = Integer.parseInt(zStr);
                }
                catch (NumberFormatException nfe) {
                    this.zIndex = 0;
                }
                if (this.zIndex > 50000) {
                    this.zIndex = 0;
                }
            }
        } else {
            this.zIndex = 0;
        }
    }

    private void setAttrFromJSON(JSONObject jObj) {
        this.name = jObj.optString(JSON_KEY_NAME);
        this.type = jObj.optString(JSON_KEY_TYPE);
        this.zIndex = jObj.optInt(JSON_KEY_ZINDEX);
    }

    public String toSpecString() {
        return this.type + ":" + this.name + ":" + this.zIndex;
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(JSON_KEY_NAME, (Object)this.name);
            jObj.put(JSON_KEY_TYPE, (Object)this.type);
            jObj.put(JSON_KEY_ZINDEX, this.zIndex);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return jObj;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int index) {
        this.zIndex = index;
    }
}

