/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.pak;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.util.Vector;
import quadbase.common.pak.AbstractFilePacker;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard3.api.DashboardLoader;
import quadbase.dashboard3.components.ComboSharedParam;
import quadbase.dashboard3.components.DashboardAttributes;
import quadbase.dashboard3.components.DrillDownInfo;
import quadbase.dashboard3.components.ExpandedSharedParam;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TextLabel;
import quadbase.reportorganizer.data.DataTreeDatabase;
import quadbase.reportorganizer.data.OrganizerDataImpl;
import quadbase.reportorganizer.data.OrganizerNode;
import quadbase.reportorganizer.data.PathImpl;
import quadbase.reportorganizer.data.Util;

public class DashboardPacker
extends AbstractFilePacker {
    private DashboardAttributes dba;
    private OrganizerNode rootNode = null;
    private static final String URL = "url(";

    public DashboardPacker(String dsbFilePath, String username) {
        super(dsbFilePath, username);
        this.PAK_TYPE = 1;
    }

    @Override
    protected void readAllPaths() throws Exception {
        this.dba = new DashboardLoader().loadDBAttributes(this.mainFilePath, this.username);
        this.readTemplatePaths();
        this.readImagePaths();
    }

    /*
     * WARNING - void declaration
     */
    private void readTemplatePaths() throws Exception {
        int i;
        TemplateInfo[] tInfo = this.dba.getTemplateInfos();
        DrillDownInfo[] dInfo = this.dba.getDrilldowns();
        this.templateNames = new Vector(tInfo.length + dInfo.length);
        this.templatePaths = new Vector(tInfo.length + dInfo.length);
        this.templateOrganizerPaths = new Vector(tInfo.length + dInfo.length);
        this.templateOrganizerNames = new Vector(tInfo.length + dInfo.length);
        for (i = 0; tInfo != null && i < tInfo.length; ++i) {
            void var6_6;
            String path = this.getDiskPath(tInfo[i].getName(), tInfo[i].getNodeID(), tInfo[i].getItemID());
            int idx = path.lastIndexOf(46);
            String string = "";
            if (idx >= 0) {
                String string2 = path.substring(idx);
            }
            this.templateNames.add(tInfo[i].getName() + "," + tInfo[i].getNodeID() + "," + tInfo[i].getItemID() + (String)var6_6);
            this.templatePaths.add(path);
            this.templateOrganizerNames.add(URLDecoder.decode(tInfo[i].getName(), "UTF-8"));
            this.templateOrganizerPaths.add(this.getOrganizerPath(tInfo[i].getNodeID()));
        }
        for (i = 0; dInfo != null && i < dInfo.length; ++i) {
            String string;
            String srcTemplateId = dInfo[i].getSrcTemplateInfoID();
            boolean found = false;
            for (TemplateInfo templateInfo : tInfo) {
                if (!srcTemplateId.equals(templateInfo.getTemplateID())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            String tmp = string = dInfo[i].getDestTemplateInfoID();
            int lastIdx = tmp.lastIndexOf(44);
            int itemID = Integer.valueOf(tmp.substring(lastIdx + 1));
            tmp = tmp.substring(0, lastIdx);
            lastIdx = tmp.lastIndexOf(44);
            int nodeID = Integer.valueOf(tmp.substring(lastIdx + 1));
            String name = tmp.substring(0, lastIdx);
            String path = this.getDiskPath(name, nodeID, itemID);
            int idx = path.lastIndexOf(46);
            String extension = "";
            if (idx >= 0) {
                extension = path.substring(idx);
            }
            if (this.templateNames.contains(string + extension)) continue;
            this.templateNames.add(string + extension);
            this.templatePaths.add(path);
            this.templateOrganizerNames.add(URLDecoder.decode(name, "UTF-8"));
            this.templateOrganizerPaths.add(this.getOrganizerPath(nodeID));
        }
    }

    private void readImagePaths() {
        ComboSharedParam[] combo;
        TextLabel[] textLabels;
        this.otherFileNames = new Vector();
        this.otherFilePaths = new Vector();
        this.addToOtherFilesList(this.dba.getBackground().getBgImgURL());
        for (TextLabel textLabel : textLabels = this.dba.getTextLabels()) {
            this.addToOtherFilesList(textLabel.getBgImageURL());
        }
        ExpandedSharedParam[] expSp = this.dba.getExpSpList();
        if (expSp != null) {
            for (ExpandedSharedParam element : expSp) {
                this.addToOtherFilesList(DashboardPacker.getPureBGImageUrl(element.getPanelAttr().getBgImageURL()));
            }
            for (ExpandedSharedParam element : expSp) {
                Vector<String[]> butnImageMap = element.getButnImageMap();
                for (int j = 0; j < butnImageMap.size(); ++j) {
                    String[] pair = butnImageMap.elementAt(j);
                    if (pair.equals("none")) continue;
                    this.addToOtherFilesList(pair[1]);
                }
            }
            for (ExpandedSharedParam element : expSp) {
                this.addToOtherFilesList(DashboardPacker.getPureBGImageUrl(element.getButnAttr().getBgImageURL()));
            }
        }
        if (this.dba.getDetParamPanel() != null) {
            this.addToOtherFilesList(this.dba.getDetParamPanel().getBgImageURL());
        }
        if ((combo = this.dba.getComboParams()) != null) {
            for (ComboSharedParam element : combo) {
                this.addToOtherFilesList(DashboardPacker.getPureBGImageUrl(element.getBgImageURL()));
            }
        }
        if (this.dba.getPseqParamPanel() != null) {
            this.addToOtherFilesList(this.dba.getPseqParamPanel().getBgImageURL());
        }
    }

    public static String getPureBGImageUrl(String url) {
        String imgUrl = url;
        if (url != null && url.toLowerCase().startsWith(URL)) {
            try {
                imgUrl = URLDecoder.decode(url.substring(URL.length(), url.length() - 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return DashboardPacker.removeStartingEndingDoubleQuotesFromUrlString(imgUrl);
    }

    private String addToOtherFilesList(String path) {
        File file;
        if (path == null || path.length() == 0 || path.equals("none") || path.equals("_$_none_$_")) {
            return null;
        }
        String result = null;
        if (!((path = DashboardPacker.removeStartingEndingDoubleQuotesFromUrlString(path)).toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("https://") || (file = new File(path)).isAbsolute())) {
            path = "Dashboard/" + path;
        }
        if (!this.otherFilePaths.contains(path)) {
            this.otherFilePaths.add(path);
            result = "images/" + this.getFileNameForPak(path);
            this.otherFileNames.add(result);
        }
        return result;
    }

    private static String removeStartingEndingDoubleQuotesFromUrlString(String url) {
        String urlPath = url;
        if (url != null && url.length() > 2 && url.startsWith("\"") && url.endsWith("\"")) {
            urlPath = url.substring(1, url.length() - 1);
        }
        return urlPath;
    }

    private String getFileNameForPak(String path) {
        String extension;
        String nameWithoutExtension;
        String name = QbUtil.getFileNameForPak(path);
        int idx = name.indexOf(46);
        if (idx >= 0) {
            nameWithoutExtension = name.substring(0, idx);
            extension = name.substring(idx);
        } else {
            nameWithoutExtension = name;
            extension = "";
        }
        int i = 1;
        while (this.otherFileNames.contains("images/" + name)) {
            name = nameWithoutExtension + "_" + i + extension;
        }
        return name;
    }

    private String getDiskPath(String name, int nodeID, int itemID) throws Exception {
        PathImpl pathImpl = new PathImpl(nodeID);
        Connection conn = OrganizerDataImpl.getConnection();
        String ownerID = (String)pathImpl.getValueAt(conn, itemID, 5);
        if (!OrganizerDataImpl.canReadFile((String)this.username, (int)itemID, (String)ownerID)) {
            String path = this.getOrganizerPath(nodeID);
            throw new Exception("Cannot read file " + path + "/" + name + " from Organizer.\nThe file does not exist or you don't have sufficient privileges.");
        }
        String path = (String)pathImpl.getValueAt(conn, itemID, 3);
        if (path == null || path.equals("")) {
            path = (String)pathImpl.getValueAt(conn, itemID, 4);
        }
        return path;
    }

    private String getOrganizerPath(int nodeID) throws Exception {
        if (this.rootNode == null) {
            this.rootNode = DataTreeDatabase.getTreeNode((int)0, (boolean)true);
        }
        OrganizerNode node = this.rootNode.findChild(nodeID);
        return Util.nodeToString((OrganizerNode)node);
    }
}

