/*
 * Decompiled with CFR 0.152.
 */
package quadbase.dashboard3.pak;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.AbstractReferencesUpdater;
import quadbase.common.pak.PakEntry;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.dashboard3.api.DashboardLoader;
import quadbase.dashboard3.api.DashboardSaver;
import quadbase.dashboard3.components.AlertAttr;
import quadbase.dashboard3.components.Background;
import quadbase.dashboard3.components.ComboSharedParam;
import quadbase.dashboard3.components.DashboardAttributes;
import quadbase.dashboard3.components.DrillDownInfo;
import quadbase.dashboard3.components.ExpandedSharedParam;
import quadbase.dashboard3.components.FolderAttributes;
import quadbase.dashboard3.components.SharedParam;
import quadbase.dashboard3.components.TemplateInfo;
import quadbase.dashboard3.components.TemplateParamForShare;
import quadbase.dashboard3.components.TextLabel;
import quadbase.dashboard3.components.ZIndexAttr;
import quadbase.dashboard3.pak.DashboardPacker;
import quadbase.reportdesigner.report.WriteDataFile;

public class DashboardReferencesUpdater
extends AbstractReferencesUpdater {
    private static final Logger LOGGER = Logger.getLogger(DashboardReferencesUpdater.class.getName());
    DashboardAttributes dashboardAttr;
    String userName;

    public DashboardReferencesUpdater(PakEntry mainPakEntry) {
        this(mainPakEntry, "");
    }

    public DashboardReferencesUpdater(PakEntry mainPakEntry, String userName) {
        this.mainPakEntry = mainPakEntry;
        this.userName = userName;
    }

    @Override
    public void updateReferences(PakEntry[] originalPakEntries, PakEntry[] newPakEntries) throws Exception {
        String path = this.mainPakEntry.getFullDiskPath();
        DashboardLoader loader = new DashboardLoader();
        this.dashboardAttr = loader.loadDBAttributes(path, this.userName);
        this.updateTemplatePaths(newPakEntries);
        this.updateImagePaths(originalPakEntries, newPakEntries);
        DashboardSaver saver = new DashboardSaver();
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        saver.saveDashboard(fstream, this.dashboardAttr);
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(null, fstream.toByteArray(), path);
    }

    private void updateTemplatePaths(PakEntry[] pakEntries) throws Exception {
        PakEntry pakEntry;
        TemplateInfo[] templateInfos = this.dashboardAttr.getTemplateInfos();
        for (int i = 0; templateInfos != null && i < templateInfos.length; ++i) {
            String templateInfoID = templateInfos[i].getTemplateID();
            pakEntry = this.getPakEntryByName(pakEntries, templateInfoID);
            if (!pakEntry.unpackFile || !pakEntry.insertToOrganizer) {
                throw new Exception(LanguageEncoder.getText("All templates from dashbord PAK must be inserted to Organizer\nif you want to unpack main dashboard file"));
            }
            templateInfos[i].setName(QbUtil.convertToHTMLFileName(pakEntry.organizerName));
            templateInfos[i].setNodeID(pakEntry.nodeID);
            templateInfos[i].setItemID(pakEntry.itemID);
            AlertAttr alertAttr = templateInfos[i].getAlertAttr();
            if (alertAttr == null) continue;
            alertAttr.setTemplateInfoID(this.getIdForDashboard(pakEntry));
        }
        DrillDownInfo[] ddInfos = this.dashboardAttr.getDrilldowns();
        for (int i = 0; ddInfos != null && i < ddInfos.length; ++i) {
            pakEntry = this.getPakEntryByName(pakEntries, ddInfos[i].getDestTemplateInfoID());
            if (!pakEntry.unpackFile || !pakEntry.insertToOrganizer) {
                throw new Exception(LanguageEncoder.getText("All templates from dashbord PAK must be inserted to Organizer\nif you want to unpack main dashboard file"));
            }
            ddInfos[i].setDestTemplateInfoID(this.getIdForDashboard(pakEntry));
            ddInfos[i].setDestPath(pakEntry.getFullDiskPath());
            ddInfos[i].setSrcTemplateInfoID(this.getIdForDashboard(this.getPakEntryByName(pakEntries, ddInfos[i].getSrcTemplateInfoID())));
        }
        SharedParam[] sharedParams = this.dashboardAttr.getSharedParams();
        for (int i = 0; sharedParams != null && i < sharedParams.length; ++i) {
            Vector<TemplateParamForShare> tpList = sharedParams[i].getTemplateParamList();
            for (int j = 0; j < tpList.size(); ++j) {
                TemplateParamForShare tpfs = tpList.elementAt(j);
                String oldName = tpfs.getTemplateInfoID();
                PakEntry pakEntry2 = this.getPakEntryByName(pakEntries, oldName);
                tpfs.setTemplateInfoID(this.getIdForDashboard(pakEntry2));
            }
        }
        FolderAttributes[] folders = this.dashboardAttr.getFolders();
        for (int i = 0; folders != null && i < folders.length; ++i) {
            String[] templateInfoIDList = folders[i].getTemplateList();
            for (int j = 0; j < templateInfoIDList.length; ++j) {
                templateInfoIDList[j] = this.getIdForDashboard(this.getPakEntryByName(pakEntries, templateInfoIDList[j]));
            }
            folders[i].setTemplateList(templateInfoIDList);
        }
        DrillDownInfo[] links = this.dashboardAttr.getLinkAttrs();
        ArrayList<DrillDownInfo> linksList = new ArrayList<DrillDownInfo>();
        for (int i = 0; links != null && i < links.length; ++i) {
            String destTemplateID = links[i].getDestTemplateInfoID();
            String srcTemplateID = links[i].getSrcTemplateInfoID();
            srcTemplateID = this.getIdForDashboard(this.getPakEntryByName(pakEntries, srcTemplateID));
            try {
                destTemplateID = this.getIdForDashboard(this.getPakEntryByName(pakEntries, destTemplateID));
            }
            catch (Exception ex) {
                continue;
            }
            links[i].setDestTemplateInfoID(destTemplateID);
            links[i].setSrcTemplateInfoID(srcTemplateID);
            linksList.add(links[i]);
        }
        this.dashboardAttr.setLinkAttrs(linksList.toArray(new DrillDownInfo[linksList.size()]));
        ZIndexAttr[] zAttr = this.dashboardAttr.getZIndexAttrs();
        for (int i = 0; zAttr != null && i < zAttr.length; ++i) {
            if (!zAttr[i].getType().equals("Template")) continue;
            String tinfoID = zAttr[i].getName();
            tinfoID = this.getIdForDashboard(this.getPakEntryByName(pakEntries, tinfoID));
            zAttr[i].setName(tinfoID);
        }
    }

    private void updateImagePaths(PakEntry[] originalPakEntries, PakEntry[] newPakEntries) throws Exception {
        int i;
        Background bgAttr = this.dashboardAttr.getBackground();
        String bgImageURL = bgAttr.getBgImgURL();
        if (bgImageURL != null && !bgImageURL.equals("") && !bgImageURL.equals("none")) {
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            bgAttr.setBgImgURL(bgImageURL);
        }
        TextLabel[] textLabels = this.dashboardAttr.getTextLabels();
        for (int i2 = 0; textLabels != null && i2 < textLabels.length; ++i2) {
            bgImageURL = textLabels[i2].getBgImageURL();
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            textLabels[i2].setBgImageURL(bgImageURL);
        }
        ExpandedSharedParam[] expSp = this.dashboardAttr.getExpSpList();
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            bgImageURL = DashboardPacker.getPureBGImageUrl(expSp[i].getPanelAttr().getBgImageURL());
            if (bgImageURL == null || bgImageURL.trim().length() == 0) continue;
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            expSp[i].getPanelAttr().setBgImageURL(bgImageURL);
        }
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            Vector<String[]> butnImageMap = expSp[i].getButnImageMap();
            for (int j = 0; butnImageMap != null && j < butnImageMap.size(); ++j) {
                String[] pair = butnImageMap.elementAt(j);
                bgImageURL = pair[1];
                pair[1] = bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            }
        }
        for (i = 0; expSp != null && i < expSp.length; ++i) {
            bgImageURL = expSp[i].getButnAttr().getBgImageURL();
            if (bgImageURL == null || bgImageURL.equals("") || bgImageURL.equals("none")) continue;
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            expSp[i].getButnAttr().setBgImageURL(bgImageURL);
        }
        if (this.dashboardAttr.getDetParamPanel() != null && (bgImageURL = this.dashboardAttr.getDetParamPanel().getBgImageURL()) != null && !bgImageURL.equals("") && !bgImageURL.equals("none")) {
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, bgImageURL, false);
            this.dashboardAttr.getDetParamPanel().setBgImageURL(bgImageURL);
        }
        ComboSharedParam[] combo = this.dashboardAttr.getComboParams();
        for (int i3 = 0; combo != null && i3 < combo.length; ++i3) {
            bgImageURL = combo[i3].getBgImageURL();
            if (bgImageURL == null || bgImageURL.equals("") || bgImageURL.equals("none")) continue;
            bgImageURL = this.getNewFilePathNoFail(originalPakEntries, newPakEntries, DashboardPacker.getPureBGImageUrl(bgImageURL), false);
            combo[i3].setBgImageURL(bgImageURL);
        }
    }

    private String getNewFilePathNoFail(PakEntry[] originalEntries, PakEntry[] newEntries, String oldPath, boolean isEncoded) {
        try {
            return this.getNewFilePath(originalEntries, newEntries, oldPath, isEncoded);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "PAK entry not found", e);
            return oldPath;
        }
    }

    private String getNewFilePath(PakEntry[] originalEntries, PakEntry[] newEntries, String oldPath, boolean isEncoded) throws Exception {
        String newPath;
        String relativePath;
        File file;
        if (oldPath == null || oldPath.length() == 0 || oldPath.equals("none") || oldPath.equals("_$_none_$_")) {
            return oldPath;
        }
        if (isEncoded) {
            oldPath = URLDecoder.decode(oldPath, "UTF-8");
        }
        if (!(oldPath.toLowerCase().startsWith("http://") || oldPath.toLowerCase().startsWith("https://") || (file = new File(oldPath)).isAbsolute())) {
            oldPath = "Dashboard/" + oldPath;
        }
        if ((relativePath = QbUtil.createRelativePath(oldPath, ServerMessage.getWorkingDirectory())) != null) {
            oldPath = relativePath;
        }
        if (oldPath.toLowerCase().startsWith("http://") || oldPath.toLowerCase().startsWith("https://")) {
            newPath = oldPath;
        } else {
            PakEntry pakEntry = this.getPakEntryByOriginalPath(originalEntries, newEntries, oldPath);
            if (!pakEntry.unpackFile) {
                return null;
            }
            newPath = pakEntry.url;
        }
        if (isEncoded) {
            newPath = URLEncoder.encode(newPath, "UTF-8");
        }
        return newPath;
    }

    private PakEntry getPakEntryByOriginalPath(PakEntry[] originalEntries, PakEntry[] newEntries, String originalPath) throws Exception {
        for (PakEntry originalEntrie : originalEntries) {
            if (!originalEntrie.getFullDiskPath().equals(originalPath)) continue;
            return this.getPakEntryByName(newEntries, originalEntrie.entryName);
        }
        throw new Exception("Entry " + originalPath + " not found in the PAK file");
    }

    private String getIdForDashboard(PakEntry pakEntry) {
        return QbUtil.convertToHTMLFileName(pakEntry.organizerName) + "," + pakEntry.nodeID + "," + pakEntry.itemID;
    }
}

