/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class ClassFileDataSource
extends ParameterizedDataSource {
    private String classfile;
    private QueryClassFileInfo queryInfo = null;
    private boolean isParameterized = false;

    public ClassFileDataSource(Element source) throws Exception {
        NodeList list = source.getChildNodes();
        if (list.getLength() == 0) {
            throw new Exception("The " + source.getTagName() + " tag cannot be empty");
        }
        Node text = list.item(0);
        if (text.getNodeType() != 4) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
        this.classfile = text.getNodeValue();
        if (this.classfile == null) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
        String tmp = source.getAttribute("isParameterized");
        if (tmp != null) {
            this.isParameterized = Boolean.valueOf(tmp);
        }
        if (this.isParameterized) {
            this.queryInfo = new QueryClassFileInfo(this.classfile);
        }
    }

    public ClassFileDataSource(String classname) {
        this.classfile = classname;
        if (ClassFileUtil.isParameterized(this.classfile)) {
            this.queryInfo = new QueryClassFileInfo(this.classfile);
            this.isParameterized = true;
        }
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return this.getDataSheet(startIndex, count, true);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        if (this.isParameterized()) {
            return new DataSheet(null, this.queryInfo, startIndex, count);
        }
        return new DataSheet(null, this.classfile, false, null, 3, startIndex, count);
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(this.queryInfo.getInParam(), parameters);
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        IQueryInParam[] params = this.queryInfo.getInParam();
        this.setDefaultParameters(params);
    }

    @Override
    public IQueryInParam[] getInParam() {
        if (!this.isParameterized) {
            return null;
        }
        return this.queryInfo.getInParam();
    }

    @Override
    public void writeXML(Element el) {
        Document doc = el.getOwnerDocument();
        el.setAttribute("Type", "class");
        el.setAttribute("isParameterized", this.isParameterized + "");
        el.appendChild(doc.createCDATASection(this.classfile));
    }

    @Override
    public boolean isParameterized() {
        return this.isParameterized;
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        if (!this.isParameterized) {
            return null;
        }
        return this.queryInfo;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("ClassFile");
        dsInfo.setLocation(this.classfile);
        if (this.isParameterized()) {
            dsInfo.setQueryParamSet(this.queryInfo.getInSet());
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        String encodedDataFile = this.classfile.replace('\\', '/');
        encodedDataFile = QbUtil.urlEncode(encodedDataFile);
        try {
            jObj.put("classFile", (Object)encodedDataFile);
            jObj.put("hasParam", this.isParameterized);
            if (this.isParameterized) {
                jObj.put("queryInfo", (Object)this.getQueryInfoJSON());
            }
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "class";
    }

    private JSONObject getQueryInfoJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("classFile", (Object)this.queryInfo.getClassFile());
        json.put("paramSet", (Object)ClassFileDataSource.getParamSetJSON(this.queryInfo.getInSet()));
        return json;
    }

    public static ClassFileDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String location = jObj.getString("classFile");
        location = QbUtil.urlDecode(location);
        ClassFileDataSource cfds = new ClassFileDataSource(location);
        cfds.isParameterized = jObj.optBoolean("hasParam");
        if (cfds.isParameterized()) {
            JSONObject queryInfoJSON = jObj.optJSONObject("queryInfo");
            JSONObject paramSetJSON = queryInfoJSON.optJSONObject("paramSet");
            QueryInParamSet paramSet = ClassFileDataSource.getParamSetFromJSON(paramSetJSON);
            try {
                QueryInParam[] qips = paramSet.getParameter();
                Object[] vals = new Object[qips.length];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = qips[i].getValue();
                    if (vals[i] != null) continue;
                    Object obj = qips[i].getDefaultValue();
                    vals[i] = new String[]{obj.toString()};
                }
                cfds.setParameters(vals);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cfds;
    }

    @Override
    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        if (this.fieldNames != null && this.dataTypes != null) {
            return;
        }
        try {
            QueryInParamSet paramSet = null;
            if (this.queryInfo != null) {
                paramSet = ClassFileUtil.getInSet(this.queryInfo.getClassFile());
            }
            int colCount = 0;
            colCount = 0;
            Object rsObj = ClassFileUtil.getResultSet(this.classfile, paramSet);
            if (rsObj instanceof IResultSet) {
                IResultSet rs = (IResultSet)rsObj;
                IRSMetaData md = rs.getMetaData();
                colCount = md.getColumnCount();
                this.fieldNames = new String[colCount];
                this.dataTypes = new String[colCount];
                for (int i = 0; i < colCount; ++i) {
                    this.fieldNames[i] = md.getColumnName(i + 1);
                    int dt = md.getColumnType(i + 1);
                    this.dataTypes[i] = DataType.getTypeName(dt);
                }
            } else if (rsObj instanceof quadbase.util.IResultSet) {
                quadbase.util.IResultSet rs = (quadbase.util.IResultSet)rsObj;
                quadbase.util.IRSMetaData md = rs.getMetaData();
                colCount = md.getColumnCount();
                this.fieldNames = new String[colCount];
                this.dataTypes = new String[colCount];
                for (int i = 0; i < colCount; ++i) {
                    this.fieldNames[i] = md.getColumnName(i + 1);
                    int dt = md.getColumnType(i + 1);
                    this.dataTypes[i] = DataType.getTypeName(dt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        return QueryParser.getDistinctValues((DBInfoBasic)((Object)this.getQueryFileInfo()), tableName, columnName);
    }
}

