/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.XMLUtil;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.DataSourcesNotReadyException;
import quadbase.datasource.DuplicateNameException;
import quadbase.datasource.InvalidDataSourcesNodeException;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.util.internal.QbUtil;

public class DataRegistry {
    private static boolean debug = false;
    private static String imagesDir = "img";
    private static final String DATABASES_IMAGE = "Database.gif";
    private static final String BIGDATAS_IMAGE = "BigData.gif";
    private static final String XMLFILES_IMAGE = "XML.gif";
    private static final String TXTFILES_IMAGE = "Text.gif";
    private static final String CLASSFILES_IMAGE = "Class.gif";
    private static final String EJBS_IMAGE = "EJB.gif";
    private static final String DATABASE_IMAGE = "Database.gif";
    private static final String BIGDATA_IMAGE = "BigData.gif";
    private static final String XMLFILE_IMAGE = "XML.gif";
    private static final String TXTFILE_IMAGE = "Text.gif";
    private static final String CLASSFILE_IMAGE = "Class.gif";
    private static final String EJB_IMAGE = "EJB.gif";
    private static final String QUERY_IMAGE = "SQL.gif";
    private static final String DATAVIEW_IMAGE = "DataView.gif";
    private static final String XMLQUERY_IMAGE = "XMLQuery.gif";
    private static final String SQLSTATEMENT_IMAGE = "SQL.gif";
    private static final String DATAVIEWQUERY_IMAGE = "DSQL.gif";
    private static final String SOAP_IMAGE = "soap.gif";
    private static final String SALESFORCE_IMAGE = "salesforce.gif";
    private static final String EXCEL_IMAGE = "excel.gif";
    private static final String NODE_ATTRIBUTE_REGISTRY_ID = "registryID";
    public static final String JSON_KEY_REGISTRYNAME = "registryName";
    public static final String JSON_KEY_NODELIST = "nodeList";
    public static final String JSON_KEY_NODEINDEX = "nodeIndex";
    public static final String JSON_KEY_PARENTINDEX = "parentIndex";
    public static final String JSON_KEY_NODEPATH = "nodePath";
    public static final String JSON_KEY_DISPLAYNAME = "displayName";
    public static final String JSON_KEY_NODENAME = "nodeName";
    public static final String JSON_KEY_ISLEAFNODE = "isLeafNode";
    public static final String DATA_VIEW_QUERY_NODE_ALREADY_EXIST = "Data view query node already exist.";
    private String encoding = "ISO-8859-1";
    private String xmlDataRegistry;
    private Hashtable datasources = new Hashtable();
    private boolean datasourcesReady = false;
    private Vector invisibleNodes;
    private Document document;
    private Node root;
    private boolean useCookie = true;
    int nodeCount;
    String registryName = null;

    public DataRegistry() {
    }

    public DataRegistry(String xmlDataRegistry) throws Exception {
        this();
        this.setDataRegistryFile(xmlDataRegistry);
    }

    public void setDataRegistryFile(String xmlDataRegistry) throws Exception {
        this.xmlDataRegistry = xmlDataRegistry;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.parseEncoding(xmlDataRegistry);
        DataInputStream in = new ReadDataFile().getInputStream(null, xmlDataRegistry, true);
        this.document = builder.parse(in);
        ((InputStream)in).close();
        this.setDataSourcesRoot(this.document);
    }

    public void setDataSourcesRoot(Node root) throws InvalidDataSourcesNodeException {
        this.root = this.getDataSourcesRoot(root);
        if (this.root == null) {
            throw new InvalidDataSourcesNodeException("Data Registry file missing (DataSources) element");
        }
    }

    public String getFile() {
        return this.xmlDataRegistry;
    }

    public void refresh() throws Exception {
        this.setDataRegistryFile(this.xmlDataRegistry);
        this.toHtmlString();
    }

    public String toHtmlString() throws IOException, InvalidDataSourcesNodeException {
        return this.toHtmlString(new Vector());
    }

    public String toHtmlString(Vector invisibleNodes) throws IOException, InvalidDataSourcesNodeException {
        if (this.root == null) {
            throw new InvalidDataSourcesNodeException("Data Sources Root or Data Registry File not set");
        }
        StringWriter str = new StringWriter();
        this.invisibleNodes = invisibleNodes;
        this.printHtml(str);
        str.flush();
        str.close();
        return str.toString();
    }

    public Hashtable getDataSources() throws DataSourcesNotReadyException {
        if (this.datasourcesReady) {
            return this.datasources;
        }
        throw new DataSourcesNotReadyException("need to invoke method (toHtmlString()) to parse the xml file first");
    }

    public void writeXmlFile(String xmlDataRegistry) throws Exception {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        PrintWriter out = new PrintWriter(osw);
        out.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        DataRegistry.writeXmlRoot(out, this.root);
        out.flush();
        out.close();
        byte[] data = fos.toByteArray();
        fos.close();
        new WriteDataFile().output(null, data, xmlDataRegistry);
    }

    public synchronized boolean insertDataViewQuery(Node parentNode, DataSourceInfo child) throws DuplicateNameException {
        if (parentNode.hasChildNodes()) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node chNode = children.item(i);
                if (!chNode.hasAttributes()) continue;
                String attrName = chNode.getAttributes().getNamedItem("name").getNodeValue();
                DataRegistry.debug("attrName = [" + attrName + "]");
                DataRegistry.debug("child.getName() = [" + child.getName() + "]");
                if (attrName == null || !attrName.equals(child.getName())) continue;
                throw new DuplicateNameException(DATA_VIEW_QUERY_NODE_ALREADY_EXIST);
            }
        }
        String typeName = child.getTypeName();
        Element childNode = this.document.createElement(typeName);
        if (!typeName.equals("DataViewQuery")) {
            return false;
        }
        this.createChildNode(child, childNode, child.getId());
        return parentNode.appendChild(childNode) != null;
    }

    public synchronized boolean updateDataViewQuery(Node parentNode, DataSourceInfo child) throws DuplicateNameException {
        if (parentNode.hasChildNodes()) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String attrName;
                Node chNode = children.item(i);
                if (!chNode.hasAttributes() || (attrName = chNode.getAttributes().getNamedItem("name").getNodeValue()) == null || !attrName.equals(child.getName())) continue;
                String typeName = child.getTypeName();
                Element childNode = this.document.createElement(typeName);
                if (!typeName.equals("DataViewQuery")) {
                    return false;
                }
                this.createChildNode(child, childNode, chNode.getAttributes().getNamedItem("id").getNodeValue());
                parentNode.removeChild(chNode);
                if (parentNode.appendChild(childNode) == null) continue;
                try {
                    this.writeXmlFile(this.xmlDataRegistry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    public synchronized boolean checkDataViewQuery(Node parentNode, DataSourceInfo child) throws DuplicateNameException {
        if (parentNode.hasChildNodes()) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String attrName;
                Node chNode = children.item(i);
                if (!chNode.hasAttributes() || (attrName = chNode.getAttributes().getNamedItem("name").getNodeValue()) == null || !attrName.equals(child.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean removeDataViewQuery(Node parentNode, DataSourceInfo child) throws DuplicateNameException {
        if (parentNode.hasChildNodes()) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String attrName;
                Node chNode = children.item(i);
                if (!chNode.hasAttributes() || (attrName = chNode.getAttributes().getNamedItem("name").getNodeValue()) == null || !attrName.equals(child.getName())) continue;
                return parentNode.removeChild(chNode) != null;
            }
        }
        return false;
    }

    private void createChildNode(DataSourceInfo child, Element childNode, String id) {
        childNode.setAttribute("id", id);
        childNode.setAttribute("name", child.getName());
        childNode.setAttribute("queryFile", child.getDataViewQueryFile());
        childNode.setAttribute("dataviewFile", child.getDataViewFile());
        Element sqlStatement = this.document.createElement("SQLStatement");
        CDATASection cdata = this.document.createCDATASection(child.getSql());
        sqlStatement.appendChild(cdata);
        childNode.appendChild(sqlStatement);
    }

    public synchronized boolean updateNodeDescription(String nodeID, String description) {
        boolean foundDescrNode = false;
        DataSourceInfo dsInfo = this.getDataSourceInfo(nodeID);
        if (dsInfo == null) {
            return false;
        }
        dsInfo.setDescription(description);
        Node node = dsInfo.getNode();
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node cn = children.item(i);
                if (cn.getNodeName() == null || !cn.getNodeName().equals("Description")) continue;
                boolean foundData = false;
                NodeList descrNL = children.item(i).getChildNodes();
                for (int j = 0; j < descrNL.getLength(); ++j) {
                    if (descrNL.item(j).getNodeType() != 4) continue;
                    descrNL.item(j).setNodeValue(description);
                    foundData = true;
                    break;
                }
                if (!foundData) {
                    CDATASection cdata = this.document.createCDATASection(description);
                    cn.appendChild(cdata);
                }
                foundDescrNode = true;
            }
        }
        if (!foundDescrNode) {
            Element descrElem = this.document.createElement("Description");
            CDATASection cdata = this.document.createCDATASection(description);
            descrElem.appendChild(cdata);
            node.appendChild(descrElem);
        }
        try {
            this.writeXmlFile(this.xmlDataRegistry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Document getDocument() {
        return this.document;
    }

    public Node getRoot() {
        return this.root;
    }

    public String getRegistryId() {
        if (!this.root.hasAttributes()) {
            return null;
        }
        Node registryIdMap = this.root.getAttributes().getNamedItem(NODE_ATTRIBUTE_REGISTRY_ID);
        if (registryIdMap == null) {
            return null;
        }
        return registryIdMap.getNodeValue();
    }

    public String getRootLastId() {
        if (!this.root.hasAttributes()) {
            return null;
        }
        Node lastIdMap = this.root.getAttributes().getNamedItem("lastID");
        if (lastIdMap == null) {
            return null;
        }
        return lastIdMap.getNodeValue();
    }

    public void setRootLastId(String value) {
        if (!this.root.hasAttributes()) {
            return;
        }
        Node lastIdMap = this.root.getAttributes().getNamedItem("lastID");
        if (lastIdMap == null) {
            return;
        }
        lastIdMap.setNodeValue(value);
    }

    public void setDataRegistryName(String registryName) {
        this.registryName = registryName;
    }

    public String getDataRegistryName() {
        return this.registryName;
    }

    public String getXmlDataRegistry() {
        return this.xmlDataRegistry;
    }

    public DataSourceInfo getDataSourceInfo(String idStr) {
        return (DataSourceInfo)this.datasources.get(idStr);
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public boolean getUseCookie() {
        return this.useCookie;
    }

    private void parseEncoding(String xml) throws Exception {
        DataInputStream in0 = new ReadDataFile().getInputStream(null, xml, true);
        BufferedReader in = new BufferedReader(new InputStreamReader(in0));
        String line = in.readLine();
        int index = line.indexOf("encoding");
        if (index == -1) {
            in.close();
            ((InputStream)in0).close();
            return;
        }
        int start = line.indexOf(34, index + 8);
        if (start == -1) {
            in.close();
            ((InputStream)in0).close();
            return;
        }
        int end = line.indexOf(34, start + 1);
        if (end == -1) {
            in.close();
            ((InputStream)in0).close();
            return;
        }
        this.encoding = line.substring(start + 1, end).trim();
    }

    private void printHtml(Writer writer) throws InvalidDataSourcesNodeException {
        PrintWriter out = new PrintWriter(writer);
        out.println("<script type=\"text/javascript\">");
        out.println("<!-- ");
        out.println("d = new dTree('d');");
        out.println("d.add(0,-1,\"" + QbUtil.escapeHTML(this.registryName == null ? "DataSource" : this.registryName) + "\");");
        out.println("d.config.useStatusText=true;");
        out.println("d.config.useCookies=" + this.getUseCookie() + ";");
        this.printFromRootNode(this.root, out);
        out.println("document.write(d);");
        out.println("-->\n </script>");
    }

    public JSONObject toJSONObject() throws InvalidDataSourcesNodeException, JSONException {
        return this.toJSONObject(new Vector());
    }

    public JSONObject toJSONObject(Vector invisibleNodes) throws InvalidDataSourcesNodeException, JSONException {
        JSONObject jObj = new JSONObject();
        if (invisibleNodes == null) {
            invisibleNodes = new Vector();
        }
        this.invisibleNodes = invisibleNodes;
        jObj.put(JSON_KEY_REGISTRYNAME, (Object)this.registryName);
        JSONArray nodeJArray = new JSONArray();
        this.toJSONArrayFromRootNode(this.root, nodeJArray);
        jObj.put(JSON_KEY_NODELIST, (Object)nodeJArray);
        return jObj;
    }

    private Node getDataSourcesRoot(Node root) {
        if (root.getNodeName().equals("DataSources")) {
            return root;
        }
        if (root.hasChildNodes()) {
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node temp = this.getDataSourcesRoot(nodeList.item(i));
                if (temp == null) continue;
                return temp;
            }
        }
        return null;
    }

    private void printFromRootNode(Node node, PrintWriter out) throws InvalidDataSourcesNodeException {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        this.nodeCount = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            this.printNode(children.item(i), out, 0, new boolean[0], true, "", ++this.nodeCount, 0);
        }
        this.datasourcesReady = true;
    }

    private void toJSONArrayFromRootNode(Node node, JSONArray nodeJArray) throws InvalidDataSourcesNodeException {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        this.nodeCount = 1;
        for (int i = 0; i < children.getLength(); ++i) {
            this.saveNodeToJSONArray(children.item(i), nodeJArray, 0, new boolean[0], true, "", this.nodeCount, 0);
        }
    }

    private void printNode(Node node, PrintWriter out, int level, boolean[] lastChilds, boolean recurse, String parentPath, int nodeIndex, int parentIndex) throws InvalidDataSourcesNodeException {
        boolean printChildren;
        String nodeName = node.getNodeName();
        if (nodeName.equals("Description")) {
            return;
        }
        boolean radioButton = this.needRadioButton(nodeName, node);
        String nodeAttributeName = null;
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            DataRegistry.debug("printing node map: ");
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node nodeMapItem = nodeMap.item(i);
                if (nodeMapItem.getNodeName().equals("name")) {
                    nodeAttributeName = nodeMapItem.getNodeValue();
                }
                if (!nodeName.equals("Database")) continue;
                DataRegistry.debug("   name = " + nodeMap.item(i).getNodeName() + " | value = " + nodeMap.item(i).getNodeValue());
            }
        }
        String thisPath = parentPath + (nodeAttributeName == null ? nodeName : nodeAttributeName) + "/";
        if (node.getNodeType() != 3) {
            if (radioButton) {
                DataSourceInfo dsInfo = new DataSourceInfo(node);
                this.datasources.put(thisPath, dsInfo);
            }
            this.printNode(nodeName, out, nodeAttributeName, radioButton, parentPath, nodeIndex, parentIndex);
        }
        if (!(printChildren = this.printChildren(parentPath, nodeName, nodeAttributeName))) {
            return;
        }
        if (recurse && !radioButton && node.hasChildNodes() || nodeName.equals("DataView") && node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            this.printNodeChildren(children, out, nodeName.equals("Database"), level, lastChilds, thisPath, nodeIndex);
        }
    }

    private void saveNodeToJSONArray(Node node, JSONArray nodeJArray, int level, boolean[] lastChilds, boolean recurse, String parentPath, int nodeIndex, int parentIndex) throws InvalidDataSourcesNodeException {
        if (node.getNodeType() == 3) {
            return;
        }
        String nodeName = node.getNodeName();
        if (nodeName.equals("Description")) {
            return;
        }
        boolean radioButton = this.needRadioButton(nodeName, node);
        String nodeAttributeName = null;
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node nodeMapItem = nodeMap.item(i);
                if (!nodeMapItem.getNodeName().equals("name")) continue;
                nodeAttributeName = nodeMapItem.getNodeValue();
            }
        }
        String thisPath = parentPath + (nodeAttributeName == null ? nodeName : nodeAttributeName) + "/";
        boolean printChildren = this.printChildren(parentPath, nodeName, nodeAttributeName);
        if (!printChildren) {
            return;
        }
        if (radioButton) {
            DataSourceInfo dsInfo = new DataSourceInfo(node);
            this.datasources.put(thisPath, dsInfo);
        }
        this.saveNodeToJSONArray(nodeName, nodeJArray, nodeAttributeName, radioButton, level, lastChilds, parentPath, nodeIndex, parentIndex);
        if (recurse && !radioButton && node.hasChildNodes() || nodeName.equals("DataView") && node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            this.saveNodeChildrenToJSONArray(children, nodeJArray, nodeName.equals("Database"), level, lastChilds, thisPath, nodeIndex, parentIndex);
        }
    }

    private void printNode(String nodeName, PrintWriter out, String nodeAttributeName, boolean radioButton, String parentPath, int nodeIndex, int parentIndex) {
        String thisPath = parentPath + (nodeAttributeName == null ? nodeName : nodeAttributeName) + "/";
        DataRegistry.debug("checking = " + thisPath);
        if (this.invisibleNodes != null && this.invisibleNodes.contains(thisPath)) {
            return;
        }
        out.print("d.add(" + nodeIndex + ", " + parentIndex + ", \"" + (nodeAttributeName == null ? nodeName : " " + nodeAttributeName) + "\", \"");
        if (radioButton) {
            out.print("javascript:select('" + thisPath + "', '" + nodeName + "');");
        }
        out.print("\", \"\", \"\", ");
        out.print("\"");
        this.printNodeImgTag(nodeName, out);
        out.print("\", ");
        out.print("\"");
        this.printNodeImgTag(nodeName, out);
        out.print("\"");
        out.print(");\n");
    }

    private void saveNodeToJSONArray(String nodeName, JSONArray nodeJArray, String nodeAttributeName, boolean radioButton, int level, boolean[] lastChilds, String parentPath, int nodeIndex, int parentIndex) {
        String thisPath = parentPath + (nodeAttributeName == null ? nodeName : nodeAttributeName) + "/";
        if (this.invisibleNodes != null && this.invisibleNodes.contains(thisPath)) {
            return;
        }
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(JSON_KEY_NODEINDEX, nodeIndex);
            jObj.put(JSON_KEY_PARENTINDEX, parentIndex);
            jObj.put(JSON_KEY_NODEPATH, (Object)thisPath);
            String displayName = nodeAttributeName == null ? nodeName : " " + nodeAttributeName;
            jObj.put(JSON_KEY_DISPLAYNAME, (Object)displayName);
            jObj.put(JSON_KEY_NODENAME, (Object)nodeName);
            jObj.put(JSON_KEY_ISLEAFNODE, radioButton);
            nodeJArray.put((Object)jObj);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private boolean needRadioButton(String nodeName, Node node) {
        if (nodeName.equals("TXTFile") || nodeName.equals("ClassFile") || nodeName.equals("EJB") || nodeName.equals("DataViewQuery") || nodeName.equals("XMLQuery") || nodeName.equals("Query") || nodeName.equals("SalesForceQuery") || nodeName.equals("SOAPView") || nodeName.equals("ExcelFile")) {
            return true;
        }
        if (nodeName.equals("DataView")) {
            return ServerMessage.isDataViewInQuickDesignerEnabled();
        }
        if (nodeName.equals("XMLFile")) {
            try {
                String isQbFormat = node.getAttributes().getNamedItem("isQBFormat").getNodeValue();
                return isQbFormat.trim().equalsIgnoreCase("true");
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void printNodeImgTag(String nodeName, PrintWriter out) {
        if (nodeName.equals("BigDatas")) {
            out.print(imagesDir + "/" + "BigData.gif");
        } else if (nodeName.equals("Databases")) {
            out.print(imagesDir + "/" + "Database.gif");
        } else if (nodeName.equals("XMLFiles")) {
            out.print(imagesDir + "/" + "XML.gif");
        } else if (nodeName.equals("TXTFiles")) {
            out.print(imagesDir + "/" + "Text.gif");
        } else if (nodeName.equals("ClassFiles")) {
            out.print(imagesDir + "/" + "Class.gif");
        } else if (nodeName.equals("EJBs")) {
            out.print(imagesDir + "/" + "EJB.gif");
        } else if (nodeName.equals("BigData")) {
            out.print(imagesDir + "/" + "BigData.gif");
        } else if (nodeName.equals("Database")) {
            out.print(imagesDir + "/" + "Database.gif");
        } else if (nodeName.equals("XMLFile")) {
            out.print(imagesDir + "/" + "XML.gif");
        } else if (nodeName.equals("TXTFile")) {
            out.print(imagesDir + "/" + "Text.gif");
        } else if (nodeName.equals("ClassFile")) {
            out.print(imagesDir + "/" + "Class.gif");
        } else if (nodeName.equals("EJB")) {
            out.print(imagesDir + "/" + "EJB.gif");
        } else if (nodeName.equals("Query")) {
            out.print(imagesDir + "/" + "SQL.gif");
        } else if (nodeName.equals("DataView")) {
            out.print(imagesDir + "/" + DATAVIEW_IMAGE);
        } else if (nodeName.equals("DataViewQuery")) {
            out.print(imagesDir + "/" + DATAVIEWQUERY_IMAGE);
        } else if (nodeName.equals("XMLQuery")) {
            out.print(imagesDir + "/" + XMLQUERY_IMAGE);
        } else if (nodeName.equals("SQLStatement")) {
            out.print(imagesDir + "/" + "SQL.gif");
        } else if (nodeName.equals("JNDIDataSources")) {
            out.print(imagesDir + "/" + "Database.gif");
        } else if (nodeName.equals("JNDIDataSource")) {
            out.print(imagesDir + "/" + "SQL.gif");
        } else if (nodeName.equals("SOAPService")) {
            out.print(imagesDir + "/" + SOAP_IMAGE);
        } else if (nodeName.equals("SOAPServices")) {
            out.print(imagesDir + "/" + SOAP_IMAGE);
        } else if (nodeName.equals("SOAPView")) {
            out.print(imagesDir + "/" + "XML.gif");
        } else if (nodeName.equals("SalesForceConnections")) {
            out.print(imagesDir + "/" + SALESFORCE_IMAGE);
        } else if (nodeName.equals("SalesForceConnection")) {
            out.print(imagesDir + "/" + SALESFORCE_IMAGE);
        } else if (nodeName.equals("SalesForceQuery")) {
            out.print(imagesDir + "/" + SALESFORCE_IMAGE);
        } else if (nodeName.equals("ExcelFiles")) {
            out.print(imagesDir + "/" + EXCEL_IMAGE);
        } else if (nodeName.equals("ExcelFile")) {
            out.print(imagesDir + "/" + EXCEL_IMAGE);
        }
    }

    private void printNodeChildren(NodeList children, PrintWriter out, boolean databaseParent, int level, boolean[] lastChilds, String parentPath, int nodeIndex) throws InvalidDataSourcesNodeException {
        if (databaseParent) {
            this.printDatabaseChildren(children, out, level, lastChilds, parentPath, nodeIndex);
            return;
        }
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            boolean childIsLast = i + 1 == len || i + 2 == len && children.item(i + 1).getNodeName().startsWith("#");
            boolean[] nextLastChilds = new boolean[lastChilds.length + 1];
            nextLastChilds[0] = childIsLast;
            for (int j = 0; j < lastChilds.length; ++j) {
                nextLastChilds[j + 1] = lastChilds[j];
            }
            this.printNode(children.item(i), out, level + 1, nextLastChilds, true, parentPath, ++this.nodeCount, nodeIndex);
        }
    }

    private void saveNodeChildrenToJSONArray(NodeList children, JSONArray nodeJArray, boolean databaseParent, int level, boolean[] lastChilds, String parentPath, int nodeIndex, int parentIndex) throws InvalidDataSourcesNodeException {
        if (databaseParent) {
            this.saveDBChildrenToJSONArray(children, nodeJArray, level, lastChilds, parentPath, nodeIndex);
            return;
        }
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            boolean childIsLast = i + 1 == len || i + 2 == len && children.item(i + 1).getNodeName().startsWith("#");
            boolean[] nextLastChilds = new boolean[lastChilds.length + 1];
            nextLastChilds[0] = childIsLast;
            for (int j = 0; j < lastChilds.length; ++j) {
                nextLastChilds[j + 1] = lastChilds[j];
            }
            this.saveNodeToJSONArray(children.item(i), nodeJArray, level + 1, nextLastChilds, true, parentPath, ++this.nodeCount, nodeIndex);
        }
    }

    private void printDatabaseChildren(NodeList databaseChilds, PrintWriter out, int level, boolean[] lastChilds, String parentPath, int nodeIndex) throws InvalidDataSourcesNodeException {
        int i;
        int tempNode;
        LinkedList<Node> queries = new LinkedList<Node>();
        LinkedList<Node> dataviews = new LinkedList<Node>();
        String queryPath = parentPath + "Queries/";
        String dataviewPath = parentPath + "Data Views/";
        int len = databaseChilds.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            Node child = databaseChilds.item(i2);
            if (child.getNodeName().equals("Query")) {
                boolean isStoredProcedure = false;
                NodeList detailList = child.getChildNodes();
                for (int j = 0; j < detailList.getLength(); ++j) {
                    Node sqlStatementNode;
                    String detailName = detailList.item(j).getNodeName();
                    if (detailName == null || !detailName.equals("SQLStatement") || (sqlStatementNode = detailList.item(j).getChildNodes().item(0)) == null || sqlStatementNode.getNodeType() != 4) continue;
                    String queryStr = sqlStatementNode.getNodeValue();
                    Pattern p = Pattern.compile("(?i)\\bfrom\\b");
                    if (p.matcher(queryStr).find()) continue;
                    isStoredProcedure = true;
                }
                if (isStoredProcedure) continue;
                queries.add(child);
                continue;
            }
            if (!child.getNodeName().equals("DataView")) continue;
            dataviews.add(child);
        }
        boolean[] nextLastChilds = new boolean[lastChilds.length + 1];
        for (int j = 0; j < lastChilds.length; ++j) {
            nextLastChilds[j + 1] = lastChilds[j];
        }
        DataRegistry.debug("checking queryPath = " + queryPath);
        if (!this.invisibleNodes.contains(queryPath)) {
            tempNode = ++this.nodeCount;
            nextLastChilds[0] = this.invisibleNodes.contains(dataviewPath);
            this.printNode("Query", out, null, false, parentPath, tempNode, nodeIndex);
            for (i = 0; i < queries.size(); ++i) {
                boolean childIsLast = i + 1 == queries.size();
                boolean[] nextNextLastChilds = new boolean[nextLastChilds.length + 1];
                nextNextLastChilds[0] = childIsLast;
                for (int j = 0; j < nextLastChilds.length; ++j) {
                    nextNextLastChilds[j + 1] = nextLastChilds[j];
                }
                this.printNode((Node)queries.get(i), out, level + 2, nextNextLastChilds, false, queryPath, ++this.nodeCount, tempNode);
            }
        }
        DataRegistry.debug("checking dataviewPath = " + dataviewPath);
        if (!this.invisibleNodes.contains(dataviewPath)) {
            tempNode = ++this.nodeCount;
            nextLastChilds[0] = true;
            this.printNode("DataView", out, null, false, parentPath, tempNode, nodeIndex);
            for (i = 0; i < dataviews.size(); ++i) {
                boolean childIsLast = i + 1 == dataviews.size();
                boolean[] nextNextLastChilds = new boolean[nextLastChilds.length + 1];
                nextNextLastChilds[0] = childIsLast;
                for (int j = 0; j < nextLastChilds.length; ++j) {
                    nextNextLastChilds[j + 1] = nextLastChilds[j];
                }
                Node dvNode = (Node)dataviews.get(i);
                this.printNode(dvNode, out, level + 2, nextNextLastChilds, true, dataviewPath, ++this.nodeCount, tempNode);
            }
        }
    }

    private void saveDBChildrenToJSONArray(NodeList databaseChilds, JSONArray nodeJArray, int level, boolean[] lastChilds, String parentPath, int nodeIndex) throws InvalidDataSourcesNodeException {
        int i;
        int tempNode;
        LinkedList<Node> queries = new LinkedList<Node>();
        LinkedList<Node> dataviews = new LinkedList<Node>();
        String queryPath = parentPath + "Queries/";
        String dataviewPath = parentPath + "Data Views/";
        int len = databaseChilds.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            Node child = databaseChilds.item(i2);
            if (child.getNodeName().equals("Query")) {
                boolean isStoredProcedure = false;
                NodeList detailList = child.getChildNodes();
                for (int j = 0; j < detailList.getLength(); ++j) {
                    Node sqlStatementNode;
                    String detailName = detailList.item(j).getNodeName();
                    if (detailName == null || !detailName.equals("SQLStatement") || (sqlStatementNode = detailList.item(j).getChildNodes().item(0)) == null || sqlStatementNode.getNodeType() != 4) continue;
                    String queryStr = sqlStatementNode.getNodeValue();
                    Pattern p = Pattern.compile("(?i)\\bfrom\\b");
                    if (p.matcher(queryStr).find()) continue;
                    isStoredProcedure = true;
                }
                if (isStoredProcedure) continue;
                queries.add(child);
                continue;
            }
            if (!child.getNodeName().equals("DataView")) continue;
            dataviews.add(child);
        }
        boolean[] nextLastChilds = new boolean[lastChilds.length + 1];
        for (int j = 0; j < lastChilds.length; ++j) {
            nextLastChilds[j + 1] = lastChilds[j];
        }
        DataRegistry.debug("checking queryPath = " + queryPath);
        if (!this.invisibleNodes.contains(queryPath)) {
            tempNode = ++this.nodeCount;
            nextLastChilds[0] = this.invisibleNodes.contains(dataviewPath);
            this.saveNodeToJSONArray("Query", nodeJArray, null, false, level + 1, nextLastChilds, parentPath, tempNode, nodeIndex);
            for (i = 0; i < queries.size(); ++i) {
                boolean childIsLast = i + 1 == queries.size();
                boolean[] nextNextLastChilds = new boolean[nextLastChilds.length + 1];
                nextNextLastChilds[0] = childIsLast;
                for (int j = 0; j < nextLastChilds.length; ++j) {
                    nextNextLastChilds[j + 1] = nextLastChilds[j];
                }
                this.saveNodeToJSONArray((Node)queries.get(i), nodeJArray, level + 2, nextNextLastChilds, false, queryPath, ++this.nodeCount, tempNode);
            }
        }
        DataRegistry.debug("checking dataviewPath = " + dataviewPath);
        if (!this.invisibleNodes.contains(dataviewPath)) {
            tempNode = ++this.nodeCount;
            nextLastChilds[0] = true;
            this.saveNodeToJSONArray("DataView", nodeJArray, null, false, level + 1, nextLastChilds, parentPath, tempNode, nodeIndex);
            for (i = 0; i < dataviews.size(); ++i) {
                boolean childIsLast = i + 1 == dataviews.size();
                boolean[] nextNextLastChilds = new boolean[nextLastChilds.length + 1];
                nextNextLastChilds[0] = childIsLast;
                for (int j = 0; j < nextLastChilds.length; ++j) {
                    nextNextLastChilds[j + 1] = nextLastChilds[j];
                }
                Node dvNode = (Node)dataviews.get(i);
                this.saveNodeToJSONArray(dvNode, nodeJArray, level + 2, nextNextLastChilds, true, dataviewPath, ++this.nodeCount, tempNode);
            }
        }
    }

    private boolean printChildren(String parentPath, String nodeName, String nodeAttributeName) {
        String path1 = parentPath + (nodeAttributeName == null ? nodeName : nodeAttributeName);
        String thisPath = path1 + "/";
        return this.invisibleNodes == null || !this.invisibleNodes.contains(thisPath) && !this.invisibleNodes.contains(path1);
    }

    private static void writeXmlRoot(PrintWriter out, Node root) {
        DataRegistry.writeXml(out, root, "");
    }

    private static void writeXml(PrintWriter out, Node node, String prefix) {
        String name = node.getNodeName();
        if (node.getNodeType() == 3) {
            String nodeVal = XMLUtil.encodeXML(node.getNodeValue().trim());
            out.print(nodeVal);
            return;
        }
        if (node.getNodeType() == 4) {
            DataRegistry.writeXmlCdata(out, node);
            return;
        }
        NamedNodeMap nodeMap = node.hasAttributes() ? node.getAttributes() : null;
        out.println();
        out.print(prefix);
        DataRegistry.writeXmlOpenTag(out, name, nodeMap);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            DataRegistry.writeXml(out, children.item(i), prefix + "  ");
        }
        DataRegistry.writeXmlCloseTag(out, name);
    }

    private static void writeXmlCdata(PrintWriter out, Node node) {
        if (node == null) {
            return;
        }
        String cdata = "<![CDATA[" + node.getNodeValue().trim() + "]]>";
        out.print(cdata);
    }

    private static void writeXmlOpenTag(PrintWriter out, String name, NamedNodeMap nodeMap) {
        out.print("<" + name);
        if (nodeMap != null) {
            out.print(" ");
            DataRegistry.writeXmlAttributes(out, nodeMap);
        }
        out.print(">");
    }

    private static void writeXmlAttributes(PrintWriter out, NamedNodeMap nodeMap) {
        if (nodeMap == null) {
            return;
        }
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            if (i > 0) {
                out.print(" ");
            }
            Node attr = nodeMap.item(i);
            out.print(attr.getNodeName() + "=\"" + XMLUtil.encodeXML(attr.getNodeValue()) + "\"");
        }
    }

    private static void writeXmlCloseTag(PrintWriter out, String name) {
        out.println("</" + name + ">");
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println("DEBUG: " + msg);
        }
    }

    public DataSourceInfo getDataSource(String dataviewQueryFile) {
        for (DataSourceInfo ds : this.datasources.values()) {
            String dvqFile = ds.getDataViewQueryFile();
            DataRegistry.debug("dvqFile = " + dvqFile);
            if (dvqFile == null || !dvqFile.equals(dataviewQueryFile)) continue;
            return ds;
        }
        return null;
    }
}

