/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import quadbase.common.util.SecuredParameterException;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasource.ClassFileDataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.DataViewDataSource;
import quadbase.datasource.DataViewQueryDataSource;
import quadbase.datasource.DatabaseDataSource;
import quadbase.datasource.DatabaseNodeInfo;
import quadbase.datasource.EjbDataSource;
import quadbase.datasource.ExcelDataSource;
import quadbase.datasource.JNDINodeInfo;
import quadbase.datasource.MemoryDataSource;
import quadbase.datasource.SalesForceDataSource;
import quadbase.datasource.SoapDataSource;
import quadbase.datasource.TextFileDataSource;
import quadbase.datasource.XmlFileDataSource;
import quadbase.datasource.XmlQueryDataSource;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryReader;
import quadbase.datasource.dataview.DataViewReader;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public abstract class DataSource {
    public static final String TEXTFILE_TYPE = "file";
    public static final String XMLFILE_TYPE = "xml";
    public static final String DATABASE_TYPE = "database";
    public static final String DATAVIEW_TYPE = "dataview";
    public static final String DATAVIEWQUERY_TYPE = "dataviewquery";
    public static final String CLASSFILE_TYPE = "class";
    public static final String XMLQUERY_TYPE = "xmlfilequery";
    public static final String EJB_TYPE = "ejb";
    public static final String SOAP_TYPE = "soap";
    public static final String SALESFORCE_TYPE = "salesforce";
    public static final String EXCEL_TYPE = "excel";
    public static final String MEMORY_TYPE = "memory";
    public static final String DATA_SOURCE_TYPE = "dataSourceType";
    public static final String OLAP_TYPE = "olap";
    protected static final int VERSION = 281;
    protected String securityLevel = null;
    protected boolean useSecuredParameters = false;
    protected String[] fieldNames = null;
    protected String[] dataTypes = null;

    public static DataSource readDataSource(Element source) throws Exception {
        String type = source.getAttribute("Type");
        if (type == null) {
            throw new Exception("Missing Type attribute in the " + source.getTagName() + " tag");
        }
        switch (type) {
            case "file": {
                return new TextFileDataSource(source);
            }
            case "xml": {
                return new XmlFileDataSource(source);
            }
            case "database": {
                return new DatabaseDataSource(source);
            }
            case "class": {
                return new ClassFileDataSource(source);
            }
            case "xmlfilequery": {
                return new XmlQueryDataSource(source);
            }
            case "ejb": {
                return new EjbDataSource(source);
            }
            case "soap": {
                return new SoapDataSource(source);
            }
            case "salesforce": {
                return new SalesForceDataSource(source);
            }
            case "excel": {
                return new ExcelDataSource(source);
            }
        }
        throw new Exception("Unknown data source type: " + type);
    }

    public static DataSource getDataSource(DataSourceInfo dsInfo) throws Exception {
        String type = dsInfo.getTypeName();
        if (type.equals("Query")) {
            if (dsInfo.getJNDINodeInfo() != null) {
                JNDINodeInfo jndi = dsInfo.getJNDINodeInfo();
                return new DatabaseDataSource(jndi.getJNDIName(), jndi.getEnv(), dsInfo.getSql(), dsInfo.getQueryParamSet());
            }
            DatabaseNodeInfo db = dsInfo.getDatabaseNodeInfo();
            return new DatabaseDataSource(db.getUrl(), db.getDriver(), db.getUserName(), db.getPassword(), dsInfo.getSql(), dsInfo.getQueryParamSet());
        }
        if (type.equals("DataViewQuery")) {
            String dvFilePath = dsInfo.getDataViewFile();
            if (dvFilePath != null) {
                if (!dvFilePath.startsWith("queries/")) {
                    dvFilePath = "queries/" + dvFilePath;
                }
                DataView dv = DataViewReader.getDataView(dvFilePath);
                DataViewQuery dvq = DataViewQueryReader.getDataViewQuery(dsInfo.getDataViewQueryFile());
                if (dsInfo.getJNDINodeInfo() != null) {
                    JNDINodeInfo jndi = dsInfo.getJNDINodeInfo();
                    return new DataViewQueryDataSource(jndi.getJNDIName(), jndi.getEnv(), dv, dvq);
                }
                DatabaseNodeInfo db = dsInfo.getDatabaseNodeInfo();
                return new DataViewQueryDataSource(db.getUrl(), db.getDriver(), db.getUserName(), db.getPassword(), dv, dvq);
            }
            DataView dv = dsInfo.getDataView();
            DataViewQuery dvq = dsInfo.getDataViewQuery();
            if (dsInfo.getJNDINodeInfo() != null) {
                JNDINodeInfo jndi = dsInfo.getJNDINodeInfo();
                return new DataViewQueryDataSource(jndi.getJNDIName(), jndi.getEnv(), dv, dvq);
            }
            DatabaseNodeInfo db = dsInfo.getDatabaseNodeInfo();
            return new DataViewQueryDataSource(db.getUrl(), db.getDriver(), db.getUserName(), db.getPassword(), dv, dvq);
        }
        if (type.equals("DataView")) {
            String dvFilePath = dsInfo.getDataViewFile();
            if (dvFilePath == null || dvFilePath.equals("")) {
                dvFilePath = dsInfo.getDataViewQueryFile();
            }
            if (!dvFilePath.startsWith("queries/")) {
                dvFilePath = "queries/" + dvFilePath;
            }
            DataView dv = DataViewReader.getDataView(dvFilePath);
            if (dsInfo.getJNDINodeInfo() != null) {
                JNDINodeInfo jndi = dsInfo.getJNDINodeInfo();
                return new DataViewDataSource(jndi.getJNDIName(), jndi.getEnv(), dv);
            }
            DatabaseNodeInfo db = dsInfo.getDatabaseNodeInfo();
            return new DataViewDataSource(db.getUrl(), db.getDriver(), db.getUserName(), db.getPassword(), dv);
        }
        if (type.equals("TXTFile")) {
            return new TextFileDataSource(dsInfo.getTextfileLocation());
        }
        if (type.equals("XMLFile")) {
            return new XmlFileDataSource(dsInfo.getTextfileLocation());
        }
        if (type.equals("ClassFile")) {
            return new ClassFileDataSource(dsInfo.getLocation());
        }
        if (type.equals("XMLQuery")) {
            XMLFileQueryInfo xFileQueryInfo = dsInfo.getXMLFileQueryInfo();
            String fileName = xFileQueryInfo.getFileName();
            fileName = OrganizerDataImpl.getPath((String)fileName);
            xFileQueryInfo.setFileName(fileName);
            fileName = xFileQueryInfo.getDTDName();
            if (fileName != null && !fileName.equals("")) {
                fileName = OrganizerDataImpl.getPath((String)fileName);
                xFileQueryInfo.setDTDName(fileName);
            }
            return new XmlQueryDataSource(xFileQueryInfo);
        }
        if (type.equals("EJB")) {
            EJBNode ejb = dsInfo.getEjbNode();
            String jndiName = ejb.getJNDIName();
            String homeName = ejb.getHomeName();
            String remoteName = ejb.getRemoteName();
            String selectedMethodName = ejb.getSelectedMethod();
            Object[] selMethodParamVal = ejb.getInputValue(selectedMethodName);
            return new EjbDataSource(jndiName, homeName, remoteName, selectedMethodName, selMethodParamVal);
        }
        if (type.equals("SOAPView")) {
            return new SoapDataSource(dsInfo.getSoapInfo());
        }
        if (type.equals("SalesForceQuery")) {
            return new SalesForceDataSource(dsInfo.getSalesForceQueryFileInfo());
        }
        if (type.equals("ExcelFile")) {
            return new ExcelDataSource(dsInfo.getExcelFileInfo());
        }
        if (type.equals(MEMORY_TYPE)) {
            return new MemoryDataSource(dsInfo.getMemoryColData());
        }
        throw new Exception("Unsupported data source type: " + type);
    }

    public boolean isParameterized() {
        return false;
    }

    public void setSecuredParameters(boolean useSecuredParameters, String securityLevel) {
        this.useSecuredParameters = useSecuredParameters;
        if (useSecuredParameters) {
            this.setSecurityLevel(securityLevel);
        } else {
            this.setSecurityLevel(null);
        }
    }

    protected void appendChildrenFromOuputStream(Element parent, OutputStream os) throws Exception {
        os.flush();
        String xml = "<FAKE_ROOT>" + os.toString() + "</FAKE_ROOT>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document newDoc = builder.parse(is);
        Document doc = parent.getOwnerDocument();
        NodeList children = newDoc.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            parent.appendChild(doc.importNode(children.item(i), true));
        }
    }

    public static DataSourceInfo getDataSourceInfo(JSONObject jObj) {
        try {
            DataSource ds = DataSource.getDataSource(jObj);
            return ds.getDataSourceInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataSource getDataSource(JSONObject jObj) throws JSONException {
        String dsType = jObj.getString(DATA_SOURCE_TYPE);
        if (dsType.equals(DATABASE_TYPE)) {
            return DatabaseDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(DATAVIEW_TYPE)) {
            return DataViewDataSource.readFromJSONObject(jObj);
        }
        if (dsType.toLowerCase().equals(DATAVIEWQUERY_TYPE)) {
            return DataViewQueryDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(TEXTFILE_TYPE)) {
            return TextFileDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(CLASSFILE_TYPE)) {
            return ClassFileDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(EJB_TYPE)) {
            return EjbDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(SALESFORCE_TYPE)) {
            return SalesForceDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(SOAP_TYPE)) {
            return SoapDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(XMLFILE_TYPE)) {
            return XmlFileDataSource.getXmlDataSourceFromJSONObject(jObj);
        }
        if (dsType.equals(XMLQUERY_TYPE)) {
            return XmlQueryDataSource.readFromJSONObject(jObj);
        }
        if (dsType.equals(EXCEL_TYPE)) {
            return ExcelDataSource.readFromJSONObject(jObj);
        }
        return null;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public final String[] getFieldNames() {
        try {
            if (this.fieldNames == null) {
                this.setFieldNamesAndDataTypes();
            }
        }
        catch (Exception e) {
            return new String[0];
        }
        return this.fieldNames;
    }

    public final String[] getDataTypes() {
        try {
            if (this.dataTypes == null) {
                this.setFieldNamesAndDataTypes();
            }
        }
        catch (Exception e) {
            return new String[0];
        }
        return this.dataTypes;
    }

    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        if (this.fieldNames != null && this.dataTypes != null) {
            return;
        }
        DataSheet ds = this.getDataSheet();
        this.fieldNames = ds.getFieldNames();
        int[] dts = ds.getOriginalDataTypes();
        this.dataTypes = new String[dts.length];
        for (int i = 0; i < dts.length; ++i) {
            this.dataTypes[i] = DataType.getTypeName(dts[i]);
        }
    }

    public abstract DataSourceInfo getDataSourceInfo();

    public abstract void writeXML(Element var1) throws Exception;

    public DataSheet getDataSheet() throws Exception, SecuredParameterException {
        return this.getDataSheet(0, -1);
    }

    public abstract DataSheet getDataSheet(int var1, int var2) throws Exception, SecuredParameterException;

    public abstract DataSheet getDataSheet(int var1, int var2, boolean var3) throws Exception, SecuredParameterException;

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.put(DATA_SOURCE_TYPE, (Object)this.getType());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.toJSONObj(jObj);
    }

    protected abstract JSONObject toJSONObj(JSONObject var1);

    public abstract String getType();

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(String securityLevel) {
        this.securityLevel = securityLevel;
    }
}

