/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.param.ParamUtil;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.datasource.DatabaseNodeInfo;
import quadbase.datasource.InvalidDataSourcesNodeException;
import quadbase.datasource.JNDINodeInfo;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryReader;
import quadbase.datasource.dataview.DataViewReader;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.ReadXMLDataSources;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.XMLNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.datasourcemanager.manager.xmlschema.XMLSchemaTree;
import quadbase.reportdesigner.ReportAPI.DbData;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.IQueryMultiValueInParam;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.util.SimpleQueryMultiValueInParam;

public class DataSourceInfo {
    public static final String NODE_ATTRIBUTE_NAME = "name";
    public static final String NODE_ATTRIBUTE_LOCATION = "location";
    public static final String NODE_ATTRIBUTE_DTD = "dtd";
    public static final String NODE_ATTRIBUTE_VERIFY = "verify";
    public static final String NODE_ATTRIBUTE_QUERY_FILE = "queryFile";
    public static final String NODE_ATTRIBUTE_DATAVIEW_FILE = "dataviewFile";
    public static final String NODE_ATTRIBUTE_ID = "id";
    public static final String NODE_ATTRIBUTE_LAST_ID = "lastID";
    public static final String PARAMETER = "Parameter";
    private String typeName;
    private String name;
    private String description;
    private String id;
    private Node node;
    private String textFileLocation;
    private String location;
    private String queryQueryFile;
    private String dataViewQueryFile;
    private String dataViewQueryParentName;
    private DataView dataView;
    private DatabaseNodeInfo databaseNodeInfo;
    private JNDINodeInfo jndiNodeInfo;
    private String sql;
    private QueryInParamSet queryParamSet;
    private String dataviewFile;
    private DataViewQuery dataViewQuery;
    private XMLFileQueryInfo xmlFileQueryInfo;
    private EJBNode ejbNode;
    private SOAPQueryFileInfo soapInfo;
    private SalesForceQueryFileInfo sfQueryInfo;
    private ExcelFileInfo excelInfo;
    private String backupQuery;
    private DbData dbData;
    private boolean attributesFromReport;
    private ColData[] memoryColData;

    public DataSourceInfo() {
    }

    public DataSourceInfo(Node node) throws InvalidDataSourcesNodeException {
        this.node = node;
        this.typeName = node.getNodeName();
        this.parseDescription(node);
        if (this.typeName.equals("TXTFile")) {
            this.parseTxtfile(node);
        } else if (this.typeName.equals("ClassFile")) {
            this.parseClassfile(node);
        } else if (this.typeName.equals("EJB")) {
            this.parseEjb(node);
        } else if (this.typeName.equals("DataView")) {
            this.parseDataview(node);
        } else if (this.typeName.equals("DataViewQuery")) {
            this.parseDataviewQuery(node);
        } else if (this.typeName.equals("XMLFile")) {
            this.parseXmlFile(node);
        } else if (this.typeName.equals("XMLQuery")) {
            this.parseXmlQuery(node);
        } else if (this.typeName.equals("Query")) {
            this.parseQuery(node);
        } else if (this.typeName.equals("SOAPView")) {
            this.parseSOAPView(node);
        } else if (this.typeName.equals("SalesForceQuery")) {
            this.parseSalesForceQuery(node);
        } else if (this.typeName.equals("ExcelFile")) {
            this.parseExcelDataSource(node);
        } else {
            throw new InvalidDataSourcesNodeException("Unsupported Datasource in XML node (" + this.typeName + ")");
        }
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            if (nodeMap.getNamedItem(NODE_ATTRIBUTE_ID) != null) {
                this.id = nodeMap.getNamedItem(NODE_ATTRIBUTE_ID).getNodeValue();
            }
            if (nodeMap.getNamedItem(NODE_ATTRIBUTE_NAME) != null) {
                this.name = nodeMap.getNamedItem(NODE_ATTRIBUTE_NAME).getNodeValue();
            }
        }
        this.attributesFromReport = false;
    }

    private void parseTxtfile(Node node) throws InvalidDataSourcesNodeException {
        if (!node.hasAttributes()) {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
        NamedNodeMap nodeMap = node.getAttributes();
        this.textFileLocation = nodeMap.getNamedItem(NODE_ATTRIBUTE_LOCATION).getNodeValue();
        this.parseDescription(node);
    }

    private void parseClassfile(Node node) throws InvalidDataSourcesNodeException {
        if (!node.hasAttributes()) {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
        NamedNodeMap nodeMap = node.getAttributes();
        this.location = nodeMap.getNamedItem(NODE_ATTRIBUTE_LOCATION).getNodeValue();
    }

    private void parseSOAPView(Node node) throws InvalidDataSourcesNodeException {
        try {
            Element parent = (Element)node.getParentNode();
            String wsdlUri = parent.getAttribute("wsdlUri");
            Element el = (Element)node;
            String serviceNameNamespace = el.getAttribute("serviceNameNamespace");
            String serviceNameLocalName = el.getAttribute("serviceNameLocalName");
            QName serviceName = new QName(serviceNameNamespace, serviceNameLocalName);
            String portName = el.getAttribute("portName");
            String operationName = el.getAttribute("operationName");
            String schemaTreeFileName = el.getAttribute("schemaTreeFileName");
            String returnParamName = el.getAttribute("returnParamName");
            SOAPParam[] params = SOAPParam.readArrayXML(node);
            SOAPViewNode svn = new SOAPViewNode(null);
            svn.setSchemaTreeFileName(schemaTreeFileName);
            svn.setReturnParamName(returnParamName);
            this.soapInfo = new SOAPQueryFileInfo(wsdlUri, serviceName, portName, operationName, svn.getXmlFieldInfo(), params);
            this.queryParamSet = this.soapInfo.getInSet();
        }
        catch (Exception e) {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseSalesForceQuery(Node node) throws InvalidDataSourcesNodeException {
        try {
            Element el;
            NodeList queries;
            Element parent = (Element)node.getParentNode();
            String username = parent.getAttribute("username");
            String password = parent.getAttribute("password");
            if (parent.getAttributeNode("encryptedPassword") != null) {
                password = Coder.decode(parent.getAttribute("encryptedPassword"));
            }
            if ((queries = (el = (Element)node).getElementsByTagName("SOQLQuery")) == null || queries.getLength() == 0) {
                throw new InvalidDataSourcesNodeException("SOQLQuery element not found in the " + el.getNodeName() + " element.");
            }
            Element queryElement = (Element)queries.item(0);
            String query = XMLUtil.readCDATA(queryElement);
            this.queryParamSet = null;
            NodeList params = el.getElementsByTagName("QUERY_PARAMETER_SET");
            if (params != null && params.getLength() > 0) {
                this.queryParamSet = QueryInParamSet.readXML(params.item(0), 0);
            }
            this.sfQueryInfo = new SalesForceQueryFileInfo(username, password, query, this.queryParamSet);
        }
        catch (Exception e) {
            if (e instanceof InvalidDataSourcesNodeException) {
                throw (InvalidDataSourcesNodeException)e;
            }
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseExcelDataSource(Node node) throws InvalidDataSourcesNodeException {
        try {
            String filename = DataSourceInfo.getAttribute(node, "filename");
            String sheetName = DataSourceInfo.getAttribute(node, "sheetName");
            int minRow = Integer.parseInt(DataSourceInfo.getAttribute(node, "minRow"));
            int minColumn = Integer.parseInt(DataSourceInfo.getAttribute(node, "minColumn"));
            int maxRow = Integer.parseInt(DataSourceInfo.getAttribute(node, "maxRow"));
            int maxColumn = Integer.parseInt(DataSourceInfo.getAttribute(node, "maxColumn"));
            boolean includeNewData = Boolean.valueOf(DataSourceInfo.getAttribute(node, "includeNewData"));
            boolean hasHeader = Boolean.valueOf(DataSourceInfo.getAttribute(node, "hasHeader"));
            boolean dataAreRows = Boolean.valueOf(DataSourceInfo.getAttribute(node, "dataAreRows"));
            this.excelInfo = new ExcelFileInfo(filename, sheetName, minRow, minColumn, maxRow, maxColumn, includeNewData, hasHeader, dataAreRows);
            NodeList typeList = ((Element)node).getElementsByTagName("DATATYPE");
            if (typeList != null && typeList.getLength() > 0) {
                int[] dataTypes = new int[typeList.getLength()];
                for (int i = 0; i < typeList.getLength(); ++i) {
                    dataTypes[i] = Integer.parseInt(XMLUtil.readCDATA(typeList.item(i)));
                }
                this.excelInfo.setDataTypes(dataTypes);
            }
        }
        catch (Exception e) {
            if (e instanceof InvalidDataSourcesNodeException) {
                throw (InvalidDataSourcesNodeException)e;
            }
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseEjb(Node node) throws InvalidDataSourcesNodeException {
        try {
            this.ejbNode = DataSourceInfo.getEjbNode(node);
        }
        catch (Exception e) {
            throw new InvalidDataSourcesNodeException(e.getMessage());
        }
    }

    private static EJBNode getEjbNode(Node node) throws Exception {
        String methodname;
        Node tmp;
        int i;
        String baseName = DataSourceInfo.getAttribute(node, NODE_ATTRIBUTE_NAME);
        EJBNode subNode = new EJBNode(baseName);
        String ID = DataSourceInfo.getAttribute(node, NODE_ATTRIBUTE_ID);
        subNode.setID(ID);
        subNode.setJNDIName(DataSourceInfo.getAttribute(node, "jndiname"));
        subNode.setHomeName(DataSourceInfo.getAttribute(node, "homename"));
        subNode.setRemoteName(DataSourceInfo.getAttribute(node, "remotename"));
        int count = Integer.parseInt(DataSourceInfo.getAttribute(node, "size"));
        String envSizeStr = DataSourceInfo.getAttribute(node, "envsize");
        int envsize = 0;
        if (envSizeStr != null) {
            envsize = Integer.parseInt(envSizeStr);
        }
        String[] methods = new String[count];
        Hashtable<String, Class[]> paramTable = new Hashtable<String, Class[]>();
        Hashtable retTable = new Hashtable();
        Hashtable<String, Object[]> valueTable = new Hashtable<String, Object[]>();
        XMLNode methodNode = new XMLNode(node);
        for (i = 0; i < count; ++i) {
            tmp = methodNode.getNextElement("Method");
            if (tmp == null) continue;
            methods[i] = DataSourceInfo.getAttribute(tmp, NODE_ATTRIBUTE_NAME);
        }
        methodNode = new XMLNode(node);
        for (i = 0; i < count; ++i) {
            tmp = methodNode.getNextElement("ParamType");
            if (tmp == null) continue;
            methodname = DataSourceInfo.getAttribute(tmp, "methodname");
            int paramSize = Integer.parseInt(DataSourceInfo.getAttribute(tmp, "size"));
            Class[] param = new Class[paramSize];
            for (int j = 0; j < paramSize; ++j) {
                String paramType = DataSourceInfo.getAttribute(tmp, "param" + (j + 1));
                param[j] = EJBUtil.mapTypeToClass(paramType);
            }
            paramTable.put(methodname, param);
        }
        methodNode = new XMLNode(node);
        for (i = 0; i < count; ++i) {
            tmp = methodNode.getNextElement("ReturnType");
            if (tmp == null) continue;
            methodname = DataSourceInfo.getAttribute(tmp, "methodname");
            String returnType = DataSourceInfo.getAttribute(tmp, "returntype");
            Class<?> retType = Class.forName(returnType);
            retTable.put(methodname, retType);
        }
        methodNode = new XMLNode(node);
        for (i = 0; i < count; ++i) {
            tmp = methodNode.getNextElement("ParamValue");
            if (tmp == null) continue;
            methodname = DataSourceInfo.getAttribute(tmp, "methodname");
            int valueSize = Integer.parseInt(DataSourceInfo.getAttribute(tmp, "size"));
            Object[] values = new Object[valueSize];
            XMLNode valueNode = new XMLNode(tmp);
            for (int j = 0; j < valueSize; ++j) {
                Node tmpNode = valueNode.getNextElement("Value");
                String valueType = DataSourceInfo.getAttribute(tmpNode, "type");
                String value = DataSourceInfo.getAttribute(tmpNode, "value");
                values[j] = EJBUtil.getRuntimeInputValue(valueType, value);
            }
            valueTable.put(methodname, values);
        }
        methodNode = new XMLNode(node);
        Node tmp2 = methodNode.getNextElement("Selected");
        String methodname2 = DataSourceInfo.getAttribute(tmp2, NODE_ATTRIBUTE_NAME);
        methodNode = new XMLNode(node);
        Hashtable<String, String> env = null;
        if (envsize > 0) {
            env = new Hashtable<String, String>();
            for (int i2 = 0; i2 < envsize; ++i2) {
                Node tmp22 = methodNode.getNextElement("Environment");
                if (tmp22 == null) continue;
                String key = DataSourceInfo.getAttribute(tmp22, NODE_ATTRIBUTE_NAME);
                String val = DataSourceInfo.getAttribute(tmp22, "value");
                env.put(key, val);
            }
        }
        subNode.setMethods(methods);
        subNode.setParamTable(paramTable);
        subNode.setRetTable(retTable);
        subNode.setValueTable(valueTable);
        subNode.setSelectedMethod(methodname2);
        subNode.setEnvironment(env);
        return subNode;
    }

    private void parseDataview(Node node) throws InvalidDataSourcesNodeException {
        if (node.getParentNode().getNodeName().equals("JNDIDataSource")) {
            this.jndiNodeInfo = new JNDINodeInfo(node.getParentNode());
        } else {
            this.databaseNodeInfo = new DatabaseNodeInfo(node.getParentNode());
        }
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            Node dvQueryFileNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_QUERY_FILE);
            if (dvQueryFileNode != null) {
                this.dataViewQueryFile = dvQueryFileNode.getNodeValue();
            }
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseDataviewQuery(Node node) throws InvalidDataSourcesNodeException {
        this.sql = null;
        if (node.getParentNode().getParentNode().getNodeName().equals("JNDIDataSource")) {
            this.jndiNodeInfo = new JNDINodeInfo(node.getParentNode().getParentNode());
        } else {
            this.databaseNodeInfo = new DatabaseNodeInfo(node.getParentNode().getParentNode());
        }
        this.dataViewQueryParentName = node.getParentNode().getAttributes().getNamedItem(NODE_ATTRIBUTE_NAME).getNodeValue();
        if (node.hasAttributes()) {
            Node dvFile;
            NamedNodeMap nodeMap = node.getAttributes();
            Node dvQueryFileNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_QUERY_FILE);
            if (dvQueryFileNode != null) {
                this.dataViewQueryFile = dvQueryFileNode.getNodeValue();
            }
            if ((dvFile = nodeMap.getNamedItem(NODE_ATTRIBUTE_DATAVIEW_FILE)) != null) {
                this.dataviewFile = dvFile.getNodeValue();
            }
            if (!node.hasChildNodes()) {
                throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("SQLStatement") || !child.hasChildNodes()) continue;
                NodeList sqlChilds = child.getChildNodes();
                for (int j = 0; j < sqlChilds.getLength(); ++j) {
                    Node sqlNode = sqlChilds.item(j);
                    if (sqlNode.getNodeType() != 4) continue;
                    this.sql = sqlNode.getNodeValue();
                }
            }
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseXmlFile(Node node) throws InvalidDataSourcesNodeException {
        try {
            this.textFileLocation = node.getAttributes().getNamedItem(NODE_ATTRIBUTE_LOCATION).getNodeValue();
        }
        catch (Exception e) {
            throw new InvalidDataSourcesNodeException(e.getMessage());
        }
    }

    private void parseXmlQuery(Node node) throws InvalidDataSourcesNodeException {
        String xmlFileName = null;
        String dtdFileName = null;
        String conditionStatement = null;
        boolean isVerify = false;
        String dtdTreeFileName = null;
        try {
            dtdTreeFileName = node.getParentNode().getAttributes().getNamedItem("dtdTreeFileName").getNodeValue();
        }
        catch (Exception e) {
            throw new InvalidDataSourcesNodeException("cannot find dtdTreeFileName from XMLQuery parent node");
        }
        Node parentNode = node.getParentNode();
        if (parentNode.hasAttributes()) {
            Node isVerifyNode;
            Node dtdFileNode;
            NamedNodeMap nodeMap = parentNode.getAttributes();
            Node xmlFileNameNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_LOCATION);
            if (xmlFileNameNode != null) {
                xmlFileName = xmlFileNameNode.getNodeValue();
            }
            if ((dtdFileNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_DTD)) != null) {
                dtdFileName = dtdFileNode.getNodeValue();
            }
            if ((isVerifyNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_VERIFY)) != null) {
                isVerify = Boolean.valueOf(isVerifyNode.getNodeValue());
            }
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
        if (!node.hasChildNodes()) {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("ConditionStatement") || !child.hasChildNodes()) continue;
            NodeList sqlChilds = child.getChildNodes();
            for (int j = 0; j < sqlChilds.getLength(); ++j) {
                Node sqlNode = sqlChilds.item(j);
                if (sqlNode.getNodeType() != 4) continue;
                conditionStatement = sqlNode.getNodeValue();
            }
        }
        XMLFieldInfo[] allFields = DataSourceInfo.getXMLAllFields(dtdTreeFileName);
        XMLFieldInfo[] selectedFields = null;
        try {
            selectedFields = DataSourceInfo.getXMLSelectedFields(node, allFields);
            this.queryParamSet = this.getQueryParamSet(node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidDataSourcesNodeException(e.getMessage());
        }
        this.xmlFileQueryInfo = new XMLFileQueryInfo(xmlFileName, selectedFields, conditionStatement, allFields, dtdFileName, isVerify, this.queryParamSet);
    }

    private static XMLFieldInfo[] getXMLAllFields(String xmlFileName) {
        if (xmlFileName == null) {
            return null;
        }
        DefaultMutableTreeNode root = null;
        if (xmlFileName.toLowerCase().endsWith(".ddt")) {
            DTD dtd = DTDUtil.readDTD(xmlFileName);
            DTDElement rootElt = dtd.getRootElement();
            Hashtable<String, DTDElement> elements = dtd.getElements();
            root = DTDUtil.buildTree(rootElt, elements, new DefaultMutableTreeNode(rootElt), true);
        } else {
            try {
                XMLSchemaTree schemaTree = XMLSchemaTree.load(xmlFileName);
                root = (DefaultMutableTreeNode)schemaTree.getModel().getRoot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DTDUtil.getXMLAllFields(root);
    }

    private static XMLFieldInfo[] getXMLSelectedFields(Node node, XMLFieldInfo[] allFields) throws Exception {
        XMLQueryNode queryNode = DataSourceInfo.getXMLQueryNode(node);
        Object[] temp = queryNode.getSelectedFields().toArray();
        XMLFieldInfo[] info = new XMLFieldInfo[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            info[i] = (XMLFieldInfo)temp[i];
            boolean found = false;
            for (int j = 0; j < allFields.length && !found; ++j) {
                if (!info[i].getDisplayName().equals(allFields[j].getDisplayName())) continue;
                if (info[i].getXMLType() == 1) {
                    info[i].setElementDataType(allFields[j].getElementDataType());
                    if (allFields[j].getElementDataType().equals("date")) {
                        info[i].setDateFormat(allFields[j].getDateFormat());
                    }
                } else if (info[i].getXMLType() == 2) {
                    info[i].setAttributeDataType(allFields[j].getAttributeDataType());
                    if (allFields[j].getAttributeDataType().equals("date")) {
                        info[i].setDateFormat(allFields[j].getDateFormat());
                    }
                }
                found = true;
            }
        }
        return info;
    }

    private static XMLQueryNode getXMLQueryNode(Node node) throws Exception {
        Node tmp;
        if (node == null) {
            return null;
        }
        String baseName = DataSourceInfo.getAttribute(node, NODE_ATTRIBUTE_NAME);
        XMLQueryNode subNode = new XMLQueryNode(baseName);
        String ID = DataSourceInfo.getAttribute(node, NODE_ATTRIBUTE_ID);
        subNode.setID(ID);
        int count = Integer.parseInt(DataSourceInfo.getAttribute(node, "fieldCt"));
        Vector<XMLFieldInfo> fields = new Vector<XMLFieldInfo>();
        XMLNode fieldNode = new XMLNode(node);
        for (int i = 0; i < count; ++i) {
            tmp = fieldNode.getNextElement("SelectedField");
            if (tmp == null) continue;
            XMLFieldInfo field = new XMLFieldInfo();
            String pathStr = DataSourceInfo.getAttribute(tmp, "path");
            String[] path = XMLFieldInfo.createPathFromString(pathStr);
            int xmlType = Integer.parseInt(DataSourceInfo.getAttribute(tmp, "xmltype"));
            boolean isExpandable = DataSourceInfo.getBooleanAttribute(tmp, "isExpandable");
            boolean isRequired = DataSourceInfo.getBooleanAttribute(tmp, "isRequired");
            String alias = DataSourceInfo.getAttribute(tmp, "alias");
            if (alias.trim().equals("")) {
                alias = null;
            }
            field.setPath(path);
            field.setXMLType(xmlType);
            field.setIsExpandable(isExpandable);
            field.setIsRequired(isRequired);
            field.setAlias(alias);
            if (xmlType == 1) {
                String eltDataType = DataSourceInfo.getAttribute(tmp, "eltDataType");
                field.setElementDataType(eltDataType);
                String dateFormat = DataSourceInfo.getAttribute(tmp, "dateFormat");
                if (dateFormat == null || dateFormat.trim().equals("")) {
                    field.setDateFormat(null);
                } else {
                    field.setDateFormat(dateFormat);
                }
                field.setAttributeDataType(null);
            } else if (xmlType == 2) {
                String attrName = DataSourceInfo.getAttribute(tmp, "attrName");
                String attrDataType = DataSourceInfo.getAttribute(tmp, "attrDataType");
                field.setAttributeName(attrName);
                field.setAttributeDataType(attrDataType);
                String dateFormat = DataSourceInfo.getAttribute(tmp, "dateFormat");
                if (dateFormat == null || dateFormat.trim().equals("")) {
                    field.setDateFormat(null);
                } else {
                    field.setDateFormat(dateFormat);
                }
                field.setElementDataType(null);
            }
            fields.addElement(field);
        }
        XMLNode queryNode = new XMLNode(node);
        tmp = queryNode.getNextElement("ConditionStatement");
        if (tmp != null) {
            subNode.setConditionStatement(ReadXMLDataSources.getData(tmp));
        }
        subNode.setSelectedFields(fields);
        return subNode;
    }

    private static String getAttribute(Node domNode, String attr) {
        NamedNodeMap nodeMap = domNode.getAttributes();
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private static boolean getBooleanAttribute(Node domNode, String str) {
        return Boolean.valueOf(DataSourceInfo.getAttribute(domNode, str));
    }

    private void parseQuery(Node node) throws InvalidDataSourcesNodeException {
        this.sql = null;
        if (node.getParentNode().getNodeName().equals("JNDIDataSource")) {
            this.jndiNodeInfo = new JNDINodeInfo(node.getParentNode());
        } else {
            this.databaseNodeInfo = new DatabaseNodeInfo(node.getParentNode());
        }
        if (node.hasAttributes()) {
            NamedNodeMap nodeMap = node.getAttributes();
            Node queryFileNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_QUERY_FILE);
            if (queryFileNode != null) {
                this.queryQueryFile = queryFileNode.getNodeValue();
            }
            if (!node.hasChildNodes()) {
                throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeName().equals("SQLStatement") && child.hasChildNodes()) {
                    try {
                        this.sql = XMLUtil.readCDATA(child);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!child.getNodeName().equals("QUERY_PARAMETER_SET")) continue;
                try {
                    this.queryParamSet = QueryInParamSet.readXML(child, 0);
                    continue;
                }
                catch (Exception e) {
                    throw new InvalidDataSourcesNodeException(e.getMessage());
                }
            }
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + this.typeName + ") contains incorrect attributes");
        }
    }

    private void parseDescription(Node node) {
        if (!node.hasChildNodes()) {
            this.description = "";
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 3 || !child.getNodeName().equals("Description")) continue;
            if (!child.hasChildNodes()) {
                return;
            }
            try {
                this.description = XMLUtil.readCDATA(child);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public Node getNode() {
        return this.node;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public QueryInParamSet getQueryParamSet() {
        QueryInParam[] params;
        if (this.queryParamSet == null) {
            return this.queryParamSet;
        }
        for (QueryInParam param : params = this.queryParamSet.getParameter()) {
            Object defaultValue = param.getDefaultValue();
            if (defaultValue != null && param.getValue() == null) {
                param.setValue(defaultValue);
            }
            if (!(param instanceof QueryMultiValueInParam) || ((QueryMultiValueInParam)param).getValues() != null) continue;
            Vector<Object> v = new Vector<Object>();
            v.add(defaultValue);
            ((QueryMultiValueInParam)param).setValues(v);
        }
        return this.queryParamSet;
    }

    public String getTextfileLocation() {
        return this.textFileLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public SOAPQueryFileInfo getSoapInfo() {
        return this.soapInfo;
    }

    public void setSoapInfo(SOAPQueryFileInfo soapInfo) {
        this.soapInfo = soapInfo;
    }

    public String getDataViewQueryFile() {
        return this.dataViewQueryFile;
    }

    public void setDataViewQueryFile(String dataViewQueryFile) {
        this.dataViewQueryFile = dataViewQueryFile;
    }

    public String getDataViewQueryParentName() {
        return this.dataViewQueryParentName;
    }

    public String getDataViewFile() {
        return this.dataviewFile;
    }

    public void setDataViewFile(String dataviewFile) {
        this.dataviewFile = dataviewFile;
    }

    public String getQueryQueryFile() {
        return this.queryQueryFile;
    }

    public DatabaseNodeInfo getDatabaseNodeInfo() {
        return this.databaseNodeInfo;
    }

    public JNDINodeInfo getJNDINodeInfo() {
        return this.jndiNodeInfo;
    }

    public XMLFileQueryInfo getXMLFileQueryInfo() {
        return this.xmlFileQueryInfo;
    }

    public SalesForceQueryFileInfo getSalesForceQueryFileInfo() {
        return this.sfQueryInfo;
    }

    public void setSalesForceQueryInfo(SalesForceQueryFileInfo sfQueryInfo) {
        this.sfQueryInfo = sfQueryInfo;
    }

    public ExcelFileInfo getExcelFileInfo() {
        return this.excelInfo;
    }

    public void setExcelFileInfo(ExcelFileInfo excelInfo) {
        this.excelInfo = excelInfo;
    }

    public EJBNode getEjbNode() {
        return this.ejbNode;
    }

    public DataView getDataView() {
        return this.dataView;
    }

    public void setDataView(DataView dv) {
        this.dataView = dv;
    }

    public DataViewQuery getDataViewQuery() {
        return this.dataViewQuery;
    }

    public void setDataViewQuery(DataViewQuery dvq) {
        this.dataViewQuery = dvq;
    }

    public String getBackupQuery() {
        return this.backupQuery;
    }

    public void setAttributesFromReport(QbReport report) throws Exception {
        int dbSourceType;
        this.name = "";
        this.id = "";
        this.attributesFromReport = true;
        this.backupQuery = report.getReportObj().getBackupQuery();
        int dataSourceType = report.getDataSourceType();
        if (dataSourceType == -1 || dataSourceType == 0 && report.report.useBackupData) {
            dataSourceType = report.getReportObj().getOriginalSourceData();
        }
        if ((dbSourceType = report.report.getDBSourceType()) != -1) {
            if (dbSourceType == Manager.QUERY) {
                this.typeName = "Query";
                DBInfoBasic dbInfoObj = report.getReportObj().dbInfo;
                this.sql = dbInfoObj.getQuery();
                if (QueryParser.hasParameters(this.sql)) {
                    this.queryParamSet = ParamUtil.getQueryParamSet((QueryFileInfo)dbInfoObj);
                }
                if (dbInfoObj.isUseJNDIDataSource()) {
                    this.jndiNodeInfo = new JNDINodeInfo(report);
                } else {
                    this.databaseNodeInfo = new DatabaseNodeInfo(report);
                }
                return;
            }
            if (dbSourceType == Manager.DATAVIEW) {
                this.typeName = "DataViewQuery";
                byte[][] queryFileBytes = report.report.getQueryFileBytes();
                if (queryFileBytes == null) {
                    throw new Exception("Report doesn't have Data View Information");
                }
                this.dataView = this.getDataView(queryFileBytes[0]);
                this.dataViewQuery = this.getDataViewQuery(queryFileBytes[1]);
                DBInfoBasic dbInfoObj = report.getReportObj().dbInfo;
                this.sql = dbInfoObj.getQuery();
                if (QueryParser.hasParameters(this.sql)) {
                    this.queryParamSet = ParamUtil.getQueryParamSet((QueryFileInfo)dbInfoObj);
                }
                if (dbInfoObj.isUseJNDIDataSource()) {
                    this.jndiNodeInfo = new JNDINodeInfo(report);
                } else {
                    this.databaseNodeInfo = new DatabaseNodeInfo(report);
                }
                if (dataSourceType == 0) {
                    this.typeName = "memory";
                    this.memoryColData = report.report.getColData();
                }
                return;
            }
        }
        switch (dataSourceType) {
            case 2: {
                this.typeName = "TXTFile";
                this.textFileLocation = report.getInputData().getDataFile();
                return;
            }
            case 4: {
                this.typeName = "XMLFile";
                this.textFileLocation = report.getInputData().getXMLFile();
                return;
            }
            case 6: {
                this.typeName = "ClassFile";
                this.location = report.getInputData().getClassFile();
                return;
            }
            case 5: {
                this.typeName = "EJB";
                String jndiName = report.report.jndiName;
                this.ejbNode = new EJBNode(jndiName);
                this.ejbNode.setJNDIName(jndiName);
                this.ejbNode.setHomeName(report.report.homeName);
                this.ejbNode.setRemoteName(report.report.remoteName);
                this.ejbNode.setSelectedMethod(report.report.selectedMethodName);
                this.ejbNode.setParamTable(null);
                this.ejbNode.setEnvironment(report.report.environment);
                return;
            }
            case 7: {
                this.typeName = "XMLQuery";
                this.xmlFileQueryInfo = report.getInputData().getXMLFileQueryInfo();
                this.queryParamSet = this.xmlFileQueryInfo.getInSet();
                return;
            }
            case 1: {
                this.typeName = "Query";
                DBInfoBasic dbInfoObj = report.getReportObj().dbInfo;
                this.sql = dbInfoObj.getQuery();
                if (QueryParser.hasParameters(this.sql)) {
                    this.queryParamSet = ParamUtil.getQueryParamSet((QueryFileInfo)dbInfoObj);
                }
                if (dbInfoObj.isUseJNDIDataSource()) {
                    this.jndiNodeInfo = new JNDINodeInfo(report);
                } else {
                    this.databaseNodeInfo = new DatabaseNodeInfo(report);
                }
                return;
            }
            case 11: {
                this.typeName = "SalesForceQuery";
                this.sfQueryInfo = report.getInputData().getSalesForceQueryInfo();
                if (this.sfQueryInfo.isParameterized()) {
                    this.queryParamSet = ParamUtil.getQueryParamSet(this.sfQueryInfo);
                }
                return;
            }
            case 12: {
                this.typeName = "SOAPView";
                this.soapInfo = report.report.soapInfo;
                if (this.soapInfo.isParameterized()) {
                    this.queryParamSet = ParamUtil.getQueryParamSet(this.soapInfo);
                }
                return;
            }
            case 13: {
                this.typeName = "ExcelFile";
                this.excelInfo = report.report.excelInfo;
                return;
            }
            case 0: {
                this.typeName = "memory";
                this.memoryColData = report.report.getColData();
                return;
            }
        }
        System.out.println("DataSourceType = " + dataSourceType + ".... NONE MATCH");
    }

    private DataView getDataView(byte[] bDataViewObj) {
        try {
            ByteArrayInputStream bai = new ByteArrayInputStream(bDataViewObj);
            DataView dv = DataViewReader.getDataView(new DataInputStream(bai));
            bai.close();
            return dv;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private DataViewQuery getDataViewQuery(byte[] bDataViewQueryObj) {
        try {
            ByteArrayInputStream bai = new ByteArrayInputStream(bDataViewQueryObj);
            DataViewQuery dvq = DataViewQueryReader.getDataViewQuery(new DataInputStream(bai));
            bai.close();
            return dvq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private QueryInParamSet getQueryParamSet(Node domNode) throws Exception {
        XMLNode xmlNode = new XMLNode(domNode);
        Node node = xmlNode.getNextElement(PARAMETER);
        if (node == null && (node = xmlNode.getNextElement("QUERY_PARAMETER_SET")) != null) {
            try {
                return QueryInParamSet.readXML(node, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static quadbase.common.util.IQueryMultiValueInParam cast(IQueryMultiValueInParam rparam) {
        String columnName = rparam.getColumnName();
        Object defaultValue = rparam.getDefaultValue();
        String paramName = rparam.getParamName();
        String promptName = rparam.getPromptName();
        int sqlType = rparam.getSqlType();
        String tableName = rparam.getTableName();
        boolean mapToColumn = rparam.isMapToColumn();
        Vector values = rparam.getValues();
        SimpleQueryMultiValueInParam cparam = new SimpleQueryMultiValueInParam(paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, values);
        return cparam;
    }

    public boolean areAttributesFromReport() {
        return this.attributesFromReport;
    }

    public void setDbData(DbData reportDbData) {
        this.dbData = reportDbData;
    }

    public DbData getDbData() {
        return this.dbData;
    }

    public quadbase.ChartAPI.DbData getDbDataForChart() {
        String[] names;
        try {
            IRSMetaData metaData = this.dbData.getMetaData();
            names = new String[metaData.getColumnCount()];
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                names[i] = metaData.getColumnName(i + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return new quadbase.ChartAPI.DbData(names, this.dbData.getData());
    }

    public ColData[] getMemoryColData() {
        return this.memoryColData;
    }

    public void setMemoryColData(ColData[] memoryColData) {
        this.memoryColData = memoryColData;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setQueryParamSet(QueryInParamSet queryParamSet) {
        this.queryParamSet = queryParamSet;
    }

    public void setDatabaseNodeInfo(DatabaseNodeInfo databaseNodeInfo) {
        this.databaseNodeInfo = databaseNodeInfo;
    }

    public void setJndiNodeInfo(JNDINodeInfo jndiNodeInfo) {
        this.jndiNodeInfo = jndiNodeInfo;
    }

    public void setEjbNode(EJBNode ejbNode) {
        this.ejbNode = ejbNode;
    }

    public void setTextFileLocation(String textFileLocation) {
        this.textFileLocation = textFileLocation;
    }

    public void setXmlFileQueryInfo(XMLFileQueryInfo xmlFileQueryInfo) {
        this.xmlFileQueryInfo = xmlFileQueryInfo;
    }
}

