/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.util.Hashtable;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.DatabaseDataSource;
import quadbase.datasource.DatabaseNodeInfo;
import quadbase.datasource.JNDINodeInfo;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewReader;
import quadbase.datasource.dataview.DataViewWriter;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class DataViewDataSource
extends DataSource {
    DataView dataView;
    DBInfo dbInfo;

    public DataViewDataSource(String url, String driverName, String userName, String password, DataView dv) {
        this(url, driverName, userName, password, null, dv);
    }

    public DataViewDataSource(String url, String driverName, String userName, String password, Vector addnDB, DataView dv) {
        this.dbInfo = new DBInfo(url, driverName, userName, password, "SELECT 1");
        this.dbInfo.setAdditionalDb(addnDB);
        this.dataView = dv;
    }

    public DataViewDataSource(String jndiName, Hashtable env, DataView dv) {
        this.dbInfo = new DBInfo(jndiName, "SELECT 1", env);
        this.dataView = dv;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("DataView");
        dsInfo.setDataView(this.dataView);
        if (this.dbInfo.isUseJNDIDataSource()) {
            JNDINodeInfo jndiNode = new JNDINodeInfo(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties());
            dsInfo.setJndiNodeInfo(jndiNode);
        } else {
            String url = this.dbInfo.getURLString();
            String drivername = this.dbInfo.getDriverName();
            String username = this.dbInfo.getUserID();
            String password = this.dbInfo.getPassword();
            DatabaseNodeInfo dbNode = new DatabaseNodeInfo(url, drivername, username, password);
            dsInfo.setDatabaseNodeInfo(dbNode);
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("dbInfo", (Object)DatabaseDataSource.getDbInfoJSON(this.dbInfo, null));
            jObj.put("dataView", (Object)DataViewWriter.toJSONObject(this.dataView));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "dataview";
    }

    public static DataViewDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        JSONObject dbJObj = jObj.getJSONObject("dbInfo");
        DBInfo localDBInfo = DatabaseDataSource.readDBInfoFromJSON(dbJObj);
        JSONObject dvJObj = jObj.getJSONObject("dataView");
        DataView dv = DataViewReader.getDataView(dvJObj);
        DataViewDataSource dvds = null;
        dvds = localDBInfo.isUseJNDIDataSource() ? new DataViewDataSource(localDBInfo.getJNDIName(), localDBInfo.getEnvProperties(), dv) : new DataViewDataSource(localDBInfo.getURLString(), localDBInfo.getDriverName(), localDBInfo.getUserID(), localDBInfo.getPassword(), localDBInfo.getAdditionalDb(), dv);
        return dvds;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        throw new UnsupportedOperationException("This method not supported for DataViewDataSource.");
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        throw new UnsupportedOperationException("This method not supported for DataViewDataSource.");
    }

    @Override
    public void writeXML(Element el) throws Exception {
        throw new UnsupportedOperationException("This method not supported for DataViewDataSource.");
    }
}

