/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.SecuredParameterException;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.DatabaseDataSource;
import quadbase.datasource.DatabaseNodeInfo;
import quadbase.datasource.JNDINodeInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryConverter;
import quadbase.datasource.dataview.DataViewQueryFilters;
import quadbase.datasource.dataview.DataViewQueryReader;
import quadbase.datasource.dataview.DataViewQueryWriter;
import quadbase.datasource.dataview.DataViewReader;
import quadbase.datasource.dataview.DataViewWriter;
import quadbase.datasource.dataview.SQLQuery;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class DataViewQueryDataSource
extends ParameterizedDataSource {
    private DataView dataView;
    private DataViewQuery dataViewQuery;
    private String extraCondition;
    private HashMap parameters;
    private DBInfo dbInfo;

    public DataViewQueryDataSource(String url, String driver, String username, String password, DataView dataView, DataViewQuery dataViewQuery) {
        this(url, driver, username, password, null, dataView, dataViewQuery);
    }

    public DataViewQueryDataSource(String url, String driver, String username, String password, Vector<String> addnDB, DataView dataView, DataViewQuery dataViewQuery) {
        this.dbInfo = new DBInfo(url, driver, username, password, "SELECT 1");
        this.dataView = dataView;
        this.dataViewQuery = dataViewQuery;
        if (addnDB != null) {
            this.dbInfo.setAdditionalDb(addnDB);
        }
        this.setDefaultFilters();
    }

    public DataViewQueryDataSource(String jndiName, Hashtable<String, String> env, DataView dataView, DataViewQuery dataViewQuery) {
        this(jndiName, env, null, dataView, dataViewQuery);
    }

    public DataViewQueryDataSource(String jndiName, Hashtable<String, String> env, Vector<String> addnDB, DataView dataView, DataViewQuery dataViewQuery) {
        this.dbInfo = new DBInfo(jndiName, "SELECT 1", env);
        this.dataView = dataView;
        this.dataViewQuery = dataViewQuery;
        if (addnDB != null) {
            this.dbInfo.setAdditionalDb(addnDB);
        }
        this.setDefaultFilters();
    }

    @Override
    public boolean isParameterized() {
        return this.dataViewQuery.getParamSet() != null && this.dataViewQuery.getParamSet().getParameter().length != 0;
    }

    @Override
    public IQueryInParam[] getInParam() {
        if (this.isParameterized()) {
            return this.dataViewQuery.getParamSet().getParameter();
        }
        return null;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception, SecuredParameterException {
        return this.getDataSheet(startIndex, count, true);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception, SecuredParameterException {
        return this.getDatabaseDataSource().getDataSheet(startIndex, count, isAdmin);
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        return this.getDatabaseDataSource().getQueryFileInfo();
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        this.setDefaultParameters(this.getInParam());
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(this.getInParam(), parameters);
    }

    @Override
    public void writeXML(Element el) throws Exception {
        this.getDatabaseDataSource().writeXML(el);
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("DataViewQuery");
        dsInfo.setDataView(this.dataView);
        dsInfo.setDataViewQuery(this.dataViewQuery);
        if (this.dbInfo.isUseJNDIDataSource()) {
            JNDINodeInfo jndiNode = new JNDINodeInfo(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties());
            dsInfo.setJndiNodeInfo(jndiNode);
        } else {
            String url = this.dbInfo.getURLString();
            String drivername = this.dbInfo.getDriverName();
            String username = this.dbInfo.getUserID();
            String password = this.dbInfo.getPassword();
            DatabaseNodeInfo dbNode = new DatabaseNodeInfo(url, drivername, username, password);
            dsInfo.setDatabaseNodeInfo(dbNode);
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("databaseNodeInfo", (Object)DatabaseDataSource.getDbInfoJSON(this.dbInfo, null));
            jObj.put("dataView", (Object)DataViewWriter.toJSONObject(this.dataView));
            jObj.put("dataViewQuery", (Object)DataViewQueryWriter.toJSONObject(this.dataViewQuery));
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "dataviewquery";
    }

    public static DataViewQueryDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        JSONObject dbJson = jObj.getJSONObject("databaseNodeInfo");
        DBInfo myDbInfo = DatabaseDataSource.readDBInfoFromJSON(dbJson);
        JSONObject dvJson = jObj.getJSONObject("dataView");
        DataView dv = DataViewReader.getDataView(dvJson);
        JSONObject dvqJson = jObj.getJSONObject("dataViewQuery");
        DataViewQuery dvq = DataViewQueryReader.getDataViewQuery(dvqJson);
        DataViewQueryDataSource.replaceAliasesInParameters(dvq, dv);
        DataViewQueryDataSource dvqds = null;
        if (myDbInfo.isUseJNDIDataSource()) {
            dvqds = new DataViewQueryDataSource(myDbInfo.getJNDIName(), myDbInfo.getEnvProperties(), dv, dvq);
        } else {
            String urlStr = myDbInfo.getURLString();
            String driverName = myDbInfo.getDriverName();
            String userName = myDbInfo.getUserID();
            String password = myDbInfo.getPassword();
            Vector<String> addnDB = myDbInfo.getAdditionalDb();
            dvqds = new DataViewQueryDataSource(urlStr, driverName, userName, password, addnDB, dv, dvq);
        }
        return dvqds;
    }

    private static void replaceAliasesInParameters(DataViewQuery dvq, DataView dv) {
        QueryInParam[] parameters;
        if (dvq.getParamSet() == null) {
            return;
        }
        for (QueryInParam parameter : parameters = dvq.getParamSet().getParameter()) {
            String realColumnName = dvq.getRealColumn(parameter.getColumnName(), dv);
            if (realColumnName == null) continue;
            parameter.setColumnName(realColumnName);
        }
    }

    @Override
    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        this.fieldNames = this.dataViewQuery.getVisibleFieldsNames(this.dataView);
        DatabaseDataSource databaseDataSource = this.getDatabaseDataSource();
        this.dataTypes = databaseDataSource.getDataTypes();
    }

    private String createQuery() {
        SQLQuery sqlQuery = DataViewQueryConverter.createQuery(this.dataView, this.dataViewQuery, this.dbInfo.getDriverName());
        if (this.extraCondition != null) {
            sqlQuery.appendWhereCondition(this.extraCondition);
        }
        return sqlQuery.toString();
    }

    public DatabaseDataSource getDatabaseDataSource() {
        QueryInParamSet paramSet = null;
        if (this.isParameterized()) {
            IQueryInParam[] params = this.getInParam();
            QueryInParam[] inParam = new QueryInParam[params.length];
            for (int i = 0; i < params.length; ++i) {
                inParam[i] = params[i] instanceof IQueryMultiValueInParam ? new QueryMultiValueInParam((IQueryMultiValueInParam)params[i], this.dbInfo.getQuery()) : new QueryInParam(params[i], this.dbInfo.getQuery());
            }
            paramSet = new QueryInParamSet(inParam);
        }
        DatabaseDataSource databaseDataSource = this.dbInfo.isUseJNDIDataSource() ? new DatabaseDataSource(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties(), this.createQuery(), paramSet) : new DatabaseDataSource(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.createQuery(), paramSet);
        databaseDataSource.setSecuredParameters(this.useSecuredParameters, this.getSecurityLevel());
        return databaseDataSource;
    }

    private void setDefaultFilters() {
        int[] aggrOrders;
        DataViewQueryFilters filters = this.dataViewQuery.getFilters();
        int fieldCount = this.dataViewQuery.getTotalFields();
        int[] sortOrders = filters.getSortOrders();
        if (sortOrders == null) {
            sortOrders = new int[fieldCount];
            for (int i = 0; i < sortOrders.length; ++i) {
                sortOrders[i] = -1;
            }
            filters.setSortOrders(sortOrders);
        }
        if ((aggrOrders = filters.getAggrOrders()) == null) {
            aggrOrders = new int[fieldCount];
            for (int i = 0; i < aggrOrders.length; ++i) {
                aggrOrders[i] = -1;
            }
            filters.setAggrOrders(aggrOrders);
        }
        String[] aggrs = filters.getAggregations();
        aggrs = this.setDefaultStringArray(aggrs, fieldCount);
        filters.setAggregations(aggrs);
        String[] sorts = filters.getSorts();
        sorts = this.setDefaultStringArray(sorts, fieldCount);
        filters.setSorts(sorts);
        String[] conds = filters.getConditions();
        conds = this.setDefaultStringArray(conds, fieldCount);
        filters.setConditions(conds);
    }

    private String[] setDefaultStringArray(String[] strs, int length) {
        if (strs == null) {
            strs = new String[length];
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = "";
            }
        } else {
            for (int i = 0; i < strs.length; ++i) {
                if (strs[i] != null) continue;
                strs[i] = "";
            }
        }
        return strs;
    }

    public DataView getDataView() {
        return this.dataView;
    }

    public void setDataView(DataView dataView) {
        this.dataView = dataView;
    }

    public DataViewQuery getDataViewQuery() {
        return this.dataViewQuery;
    }

    public void setDataViewQuery(DataViewQuery dataViewQuery) {
        this.dataViewQuery = dataViewQuery;
    }

    public String getExtraCondition() {
        return this.extraCondition;
    }

    public void setExtraCondition(String extraCondition) {
        this.extraCondition = extraCondition;
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        return QueryParser.getDistinctValues((DBInfoBasic)((Object)this.getQueryFileInfo()), tableName, columnName);
    }

    public byte[][] getQueryFileBytes() {
        try {
            byte[][] queryFileBytes = new byte[2][];
            ByteArrayOutputStream dataViewStream = new ByteArrayOutputStream();
            DataViewWriter.save(this.getDataView(), dataViewStream);
            queryFileBytes[0] = dataViewStream.toByteArray();
            dataViewStream.close();
            ByteArrayOutputStream dataViewQueryStream = new ByteArrayOutputStream();
            DataViewQueryWriter.saveDataViewQueryFile(this.getDataViewQuery(), dataViewQueryStream);
            queryFileBytes[1] = dataViewQueryStream.toByteArray();
            dataViewQueryStream.close();
            return queryFileBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

