/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.ReadSecParamFile;
import quadbase.common.util.SecParamInfoList;
import quadbase.common.util.SecuredParameterException;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.DatabaseNodeInfo;
import quadbase.datasource.JNDINodeInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.datasource.util.QueryFileInfo;
import quadbase.datasource.util.QueryInParam;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.reportdesigner.ReportAPI.DBInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public class DatabaseDataSource
extends ParameterizedDataSource {
    private DBInfo dbInfo;
    private SecParamInfoList paramInfoList = null;
    private QueryInParamSet paramSet;

    public DatabaseDataSource(Element source) throws Exception {
        this.dbInfo = this.readXMLInternal(source);
        if (this.isParameterized()) {
            quadbase.common.paramquery.QueryFileInfo qfi = (quadbase.common.paramquery.QueryFileInfo)this.getQueryFileInfo();
            this.paramSet = qfi.getInSet();
        }
    }

    public DatabaseDataSource(String url, String driver, String username, String password, String query, QueryInParamSet inSet) {
        if (inSet == null) {
            this.dbInfo = new DBInfo(url, driver, username, password, query);
        } else {
            this.dbInfo = new QueryFileInfo(url, driver, username, password, query);
            this.setParametersInternal(inSet);
        }
        this.paramSet = inSet;
    }

    public DatabaseDataSource(String jndiName, Hashtable<String, String> env, String query, QueryInParamSet inSet) {
        if (inSet == null) {
            this.dbInfo = new DBInfo(jndiName, query, env);
        } else {
            this.dbInfo = new QueryFileInfo(jndiName, query, (Hashtable)env);
            this.setParametersInternal(inSet);
        }
        this.paramSet = inSet;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception, SecuredParameterException {
        return this.getDataSheet(startIndex, count, true);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        SecParamInfoList secList;
        if (this.isParameterized()) {
            for (quadbase.reportdesigner.util.IQueryInParam param : ReportUtil.getInParam(this.dbInfo)) {
                Object firstValue = param.getValue();
                if (firstValue instanceof Vector) {
                    Vector v = (Vector)firstValue;
                    firstValue = v.size() > 0 ? v.get(0) : null;
                }
                if (firstValue != null && firstValue.toString().length() != 0) continue;
                ColData[] emptyData = new ColData[]{new ColData("qbCount", 2, 1)};
                return new DataSheet(null, emptyData);
            }
        }
        if (this.useSecuredParameters && !isAdmin && (secList = this.getSecuredParamInfoList()) != null) {
            DBInfo tmpInfo = this.cloneDBInfo(this.dbInfo);
            try {
                secList.appendConditions(tmpInfo, this.getSecurityLevel());
            }
            catch (SecuredParameterException e) {
                return new DataSheet(null, tmpInfo, false, null, startIndex, 0);
            }
            return new DataSheet(null, tmpInfo, false, null, startIndex, count);
        }
        return new DataSheet(null, this.dbInfo, false, null, startIndex, count);
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        IQueryInParam[] params = ReportUtil.getInParam(this.dbInfo);
        this.setDefaultParameters(params);
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(ReportUtil.getInParam(this.dbInfo), parameters);
    }

    @Override
    public boolean isParameterized() {
        return this.dbInfo instanceof IQueryFileInfo;
    }

    @Override
    public IQueryInParam[] getInParam() {
        if (!this.isParameterized()) {
            return null;
        }
        return ReportUtil.getInParam(this.dbInfo);
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "database");
        this.writeXmlInternal(el);
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        if (!this.isParameterized()) {
            return null;
        }
        quadbase.reportdesigner.util.IQueryInParam[] params = ReportUtil.getInParam(this.dbInfo);
        if (params == null) {
            return null;
        }
        quadbase.common.paramquery.QueryInParam[] inParam = new quadbase.common.paramquery.QueryInParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            inParam[i] = params[i] instanceof IQueryMultiValueInParam ? new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)params[i]), this.dbInfo.getQuery()) : new quadbase.common.paramquery.QueryInParam(params[i], this.dbInfo.getQuery());
        }
        QueryInParamSet inSet = new QueryInParamSet(inParam);
        quadbase.reportdesigner.util.IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(this.dbInfo);
        if (paramInSequence != null && paramInSequence.length > 0 && paramInSequence[0] != null) {
            quadbase.common.paramquery.QueryInParam[][] newParamInSequence = new quadbase.common.paramquery.QueryInParam[paramInSequence.length][paramInSequence[0].length];
            for (int i = 0; i < paramInSequence.length; ++i) {
                for (int j = 0; j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    newParamInSequence[i][j] = inSet.getParameter(paramInSequence[i][j].getParamName());
                }
            }
            inSet = new QueryInParamSet(inParam, newParamInSequence);
        }
        return new quadbase.common.paramquery.QueryFileInfo(null, 0, new DBInfoBasic(this.dbInfo), inSet);
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DBInfo jndi;
        String jndiName;
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("Query");
        dsInfo.setSql(this.dbInfo.getQuery());
        if (this.isParameterized()) {
            quadbase.common.paramquery.QueryFileInfo qfi = (quadbase.common.paramquery.QueryFileInfo)this.getQueryFileInfo();
            dsInfo.setQueryParamSet(qfi.getInSet());
        }
        if ((jndiName = (jndi = this.dbInfo).getJNDIName()) == null || jndiName.equals("")) {
            dsInfo.setDatabaseNodeInfo(new DatabaseNodeInfo(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword()));
        } else {
            dsInfo.setJndiNodeInfo(new JNDINodeInfo(jndi.getJNDIName(), jndi.getEnvProperties()));
        }
        return dsInfo;
    }

    private void writeXmlInternal(Element el) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
        new DBInfoBasic(this.dbInfo).writeXML(out);
        if (this.dbInfo instanceof IQueryFileInfo) {
            quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence;
            quadbase.reportdesigner.util.IQueryInParam[] params = ReportUtil.getInParam(this.dbInfo);
            if (params != null) {
                for (quadbase.reportdesigner.util.IQueryInParam param : params) {
                    quadbase.common.paramquery.QueryInParam currP = null;
                    currP = param instanceof IQueryMultiValueInParam ? new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)param), this.dbInfo.getQuery()) : new quadbase.common.paramquery.QueryInParam(param, this.dbInfo.getQuery());
                    currP.setSqlSelect(((QueryInParam)param).getSqlSelect());
                    currP.writeXML(out);
                }
            }
            if ((parameterInPromptSequence = ReportUtil.getParamInSequence(this.dbInfo)) != null) {
                for (quadbase.reportdesigner.util.IQueryInParam[] element : parameterInPromptSequence) {
                    out.write("<PARAM_ORDER>\n");
                    for (quadbase.reportdesigner.util.IQueryInParam element2 : element) {
                        if (element2 == null) continue;
                        out.write("<PARAM_NAME>" + element2.getParamName() + "</PARAM_NAME>\n");
                    }
                    out.write("</PARAM_ORDER>\n");
                }
            }
        }
        out.flush();
        this.appendChildrenFromOuputStream(el, os);
    }

    private DBInfo readXMLInternal(Element source) throws Exception {
        quadbase.common.paramquery.QueryFileInfo tmpInfo;
        NodeList list = source.getElementsByTagName("DATABASE");
        if (list.getLength() == 0) {
            throw new Exception("Missing DATABASE tag in the " + source.getTagName() + " tag");
        }
        DBInfoBasic dbInfoBasic = DBInfoBasic.readXML(list.item(0), 281);
        if (dbInfoBasic == null) {
            throw new Exception("Missing or invalid DATABASE element.");
        }
        String queryFilename = null;
        NodeList nodeList = source.getChildNodes();
        Vector<quadbase.common.paramquery.QueryInParam> params = new Vector<quadbase.common.paramquery.QueryInParam>();
        Vector vect2 = new Vector();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equalsIgnoreCase("QUERYFILE")) {
                queryFilename = XMLUtil.readCDATA(node);
                break;
            }
            if (node.getNodeName().equalsIgnoreCase("PARAMETER")) {
                quadbase.common.paramquery.QueryInParam p = quadbase.common.paramquery.QueryInParam.readXML(node, 0);
                if (p == null) continue;
                params.addElement(p);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("PARAM_ORDER")) continue;
            Vector<String> paramName = new Vector<String>();
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; nodeList2 != null && j < nodeList2.getLength(); ++j) {
                Node child2 = nodeList2.item(j);
                if (!child2.getNodeName().equalsIgnoreCase("PARAM_NAME")) continue;
                paramName.addElement(XMLUtil.readText(child2));
            }
            vect2.addElement(paramName);
        }
        if ((queryFilename == null || queryFilename.equals("")) && params.size() == 0) {
            return new DBInfo((IDatabaseInfo)dbInfoBasic);
        }
        if (params.size() > 0) {
            quadbase.common.paramquery.QueryInParam[] pArray = new quadbase.common.paramquery.QueryInParam[params.size()];
            for (int i = 0; i < pArray.length; ++i) {
                pArray[i] = (quadbase.common.paramquery.QueryInParam)params.elementAt(i);
            }
            QueryInParamSet inSet = new QueryInParamSet(pArray);
            if (vect2.size() > 0) {
                quadbase.common.paramquery.QueryInParam[][] paramInSequence = new quadbase.common.paramquery.QueryInParam[vect2.size()][vect2.size()];
                for (int i = 0; i < vect2.size(); ++i) {
                    Vector paramName = (Vector)vect2.elementAt(i);
                    for (int j = 0; j < paramName.size(); ++j) {
                        paramInSequence[i][j] = inSet.getParameter((String)paramName.elementAt(j));
                    }
                }
                inSet.setParameterInPromptSequence(paramInSequence);
            }
            tmpInfo = new quadbase.common.paramquery.QueryFileInfo("", 0, dbInfoBasic, inSet);
        } else {
            tmpInfo = quadbase.common.paramquery.QueryFileInfo.readFile(queryFilename);
        }
        QueryFileInfo queryInfo = tmpInfo.isUseJNDIDataSource() ? new QueryFileInfo(tmpInfo.getJNDIName(), tmpInfo.getQuery(), (Hashtable)tmpInfo.getEnvProperties()) : new QueryFileInfo(tmpInfo.getURLString(), tmpInfo.getDriverName(), tmpInfo.getUserID(), tmpInfo.getPassword(), tmpInfo.getQuery());
        queryInfo.setInParam(DatabaseDataSource.toReportDesignerParam(tmpInfo.getInParam()));
        queryInfo.setParameterInPromptSequence(DatabaseDataSource.toReportDesignerParam2(tmpInfo.getParameterInPromptSequence()));
        return queryInfo;
    }

    private void setParametersInternal(QueryInParamSet paramSet) {
        ((QueryFileInfo)this.dbInfo).setInParam(DatabaseDataSource.toReportDesignerParam(paramSet.getParameter()));
        ((QueryFileInfo)this.dbInfo).setParameterInPromptSequence(DatabaseDataSource.toReportDesignerParam2(paramSet.getParameterInPromptSequence()));
    }

    private SecParamInfoList getSecuredParamInfoList() {
        if (this.paramInfoList != null) {
            return this.paramInfoList;
        }
        String xmlFile = OrganizerDataImpl.getQuickDesignerSecuredParameters();
        if (xmlFile == null) {
            return null;
        }
        try {
            ReadSecParamFile readFile = new ReadSecParamFile(new File(xmlFile));
            this.paramInfoList = readFile.createParamInfoList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.paramInfoList;
    }

    private DBInfo cloneDBInfo(DBInfo info) {
        if (info instanceof QueryFileInfo) {
            if (info.getJNDIName() != null && info.getJNDIName().length() > 0) {
                QueryFileInfo tmpInfo = new QueryFileInfo(info.getJNDIName(), info.getQuery(), (Hashtable)info.getEnvProperties());
                tmpInfo.setInParam(((QueryFileInfo)info).getInParam());
                return tmpInfo;
            }
            QueryFileInfo tmpInfo = new QueryFileInfo(info.getURLString(), info.getDriverName(), info.getUserID(), info.getPassword(), info.getQuery());
            tmpInfo.setInParam(((QueryFileInfo)info).getInParam());
            return tmpInfo;
        }
        if (info.getJNDIName() != null && info.getJNDIName().length() > 0) {
            return new DBInfo(info.getJNDIName(), info.getQuery(), info.getEnvProperties());
        }
        return new DBInfo(info.getURLString(), info.getDriverName(), info.getUserID(), info.getPassword(), info.getQuery());
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            String dbType = this.dbInfo.isUseJNDIDataSource() ? "jndi" : "db";
            jObj.put("dbType", (Object)dbType);
            jObj.put("dbInfo", (Object)DatabaseDataSource.getDbInfoJSON(this.dbInfo, this.paramSet));
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "database";
    }

    public static DatabaseDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String dbType = jObj.getString("dbType");
        JSONObject dbInfoJObj = jObj.getJSONObject("dbInfo");
        DBInfo dbInfo = DatabaseDataSource.readDBInfoFromJSON(dbInfoJObj);
        boolean hasParam = dbInfoJObj.getBoolean("hasParam");
        QueryInParamSet jParamSet = null;
        if (hasParam) {
            JSONObject paramSetJObj = dbInfoJObj.getJSONObject("paramSet");
            jParamSet = DatabaseDataSource.getParamSetFromJSON(paramSetJObj);
        }
        if (dbType.equals("db")) {
            return new DatabaseDataSource(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword(), dbInfo.getQuery(), jParamSet);
        }
        return new DatabaseDataSource(dbInfo.getJNDIName(), dbInfo.getEnvProperties(), dbInfo.getQuery(), jParamSet);
    }

    static JSONObject getDbInfoJSON(DBInfo dbInfo, QueryInParamSet paramSet) {
        JSONObject json = new JSONObject();
        try {
            json.put("isJNDI", dbInfo.isUseJNDIDataSource());
            if (!dbInfo.isUseJNDIDataSource()) {
                json.put("driverName", (Object)dbInfo.getDriverName());
                json.put("urlString", (Object)dbInfo.getURLString());
                json.put("userName", (Object)Coder.encode(dbInfo.getUserID()));
                json.put("password", (Object)Coder.encode(dbInfo.getPassword()));
            } else {
                json.put("jndiName", (Object)dbInfo.getJNDIName());
                json.put("providerURL", (Object)dbInfo.getProviderURL());
                json.put("contextFactory", (Object)dbInfo.getContextFactory());
            }
            if (dbInfo.getEnvProperties() != null) {
                JSONArray envJSON = new JSONArray();
                Enumeration<String> envEnum = dbInfo.getEnvProperties().keys();
                while (envEnum.hasMoreElements()) {
                    JSONObject o = new JSONObject();
                    String key = envEnum.nextElement();
                    String val = dbInfo.getEnvProperties().get(key);
                    o.put("key", (Object)key);
                    o.put("value", (Object)val);
                    envJSON.put((Object)o);
                }
                json.put("envProperties", (Object)envJSON);
            }
            json.put("query", (Object)QbUtil.encodeURIComponent(dbInfo.getQuery()));
            if (paramSet != null && dbInfo instanceof QueryFileInfo) {
                json.put("hasParam", true);
                json.put("paramSet", (Object)DatabaseDataSource.getParamSetJSON(paramSet));
            } else {
                json.put("hasParam", false);
            }
            Vector<String> additionalDB = dbInfo.getAdditionalDb();
            if (additionalDB != null && additionalDB.size() > 0) {
                json.put("hasAdditionalDB", true);
                JSONArray addDbJSON = new JSONArray();
                for (int i = 0; i < additionalDB.size(); ++i) {
                    String dbURL = additionalDB.elementAt(i);
                    addDbJSON.put((Object)QbUtil.urlEncode(dbURL));
                }
                json.put("additionalDB", (Object)addDbJSON);
            } else {
                json.put("hasAdditionalDB", false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    static DBInfo readDBInfoFromJSON(JSONObject jObj) throws JSONException {
        boolean isJNDI = jObj.optBoolean("isJNDI");
        String urlString = jObj.optString("urlString", "");
        String driverName = jObj.optString("driverName", "");
        String userName = jObj.optString("userName", "");
        String password = jObj.optString("password", "");
        String query = jObj.optString("query", "");
        query = QbUtil.urlDecode(query);
        userName = Coder.decode(userName);
        password = Coder.decode(password);
        String jndiName = jObj.optString("jndiName", null);
        Hashtable<String, String> envProp = null;
        if (jObj.has("envProperties")) {
            envProp = new Hashtable<String, String>();
            JSONArray ja = jObj.getJSONArray("envProperties");
            for (int i = 0; i < ja.length(); ++i) {
                JSONArray pair = ja.getJSONArray(i);
                String key = pair.getString(0);
                String val = pair.getString(1);
                envProp.put(key, val);
            }
        }
        DBInfo result = isJNDI ? new DBInfo(jndiName, query, envProp) : new DBInfo(urlString, driverName, userName, password, query);
        boolean hasAdditionalDB = jObj.getBoolean("hasAdditionalDB");
        if (hasAdditionalDB) {
            JSONArray ja = jObj.getJSONArray("additionalDB");
            Vector<String> vect = new Vector<String>();
            for (int i = 0; i < ja.length(); ++i) {
                vect.add(ja.getString(i));
            }
            result.setAdditionalDb(vect);
        }
        return result;
    }

    @Override
    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        DatabaseInfo databaseInfo = null;
        databaseInfo = this.dbInfo.isUseJNDIDataSource() ? new DatabaseInfo(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties()) : new DatabaseInfo(this.dbInfo.getDriverName(), this.dbInfo.getURLString(), this.dbInfo.getUserID(), this.dbInfo.getPassword());
        Object[][] tableInfo = databaseInfo.getTableInfo(this.dbInfo.getQuery(), true);
        this.fieldNames = new String[tableInfo.length];
        this.dataTypes = new String[tableInfo.length];
        for (int i = 0; i < tableInfo.length; ++i) {
            this.fieldNames[i] = (String)tableInfo[i][0];
            this.dataTypes[i] = DataType.getTypeName((Integer)tableInfo[i][1]);
        }
        databaseInfo.getConnection().finalize();
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        return QueryParser.getDistinctValues((DBInfoBasic)((Object)this.getQueryFileInfo()), tableName, columnName);
    }

    public DBInfo getDbInfo() {
        return this.dbInfo;
    }
}

