/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.datasource.InvalidDataSourcesNodeException;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.util.IDatabaseInfo;

public class DatabaseNodeInfo {
    private String name;
    private String url;
    private String driver;
    private String userName;
    private String password;
    private Vector<String> additionalDb;
    private boolean requireLogin;
    private int tableNameFormat;
    public static final String NODE_ATTRIBUTE_URL = "url";
    public static final String NODE_ATTRIBUTE_DRIVER = "driver";
    public static final String NODE_ATTRIBUTE_REQUIRE_LOGIN = "requireLogin";
    public static final String NODE_ATTRIBUTE_USERNAME = "userName";
    public static final String NODE_ATTRIBUTE_PASSWORD = "password";
    public static final String NODE_ATTRIBUTE_TABLE_NAME_FORMAT = "tableNameFormat";
    public static final String NODE_ATTRIBUTE_ADDITIONAL_DB = "additionalDb";
    public static final String NODE_ATTRIBUTE_ENCRYPTEDPASSWORD = "encryptedPassword";

    public DatabaseNodeInfo(Node databaseNode) throws InvalidDataSourcesNodeException {
        if (!(databaseNode.getNodeName().equals("BigData") || databaseNode.getNodeName().equals("Database") || databaseNode.getNodeName().equals("JNDIDataSource"))) {
            throw new InvalidDataSourcesNodeException("expected a database node, non database node found");
        }
        this.setAttributes(databaseNode);
    }

    public DatabaseNodeInfo(QbReport report) throws Exception {
        if (report.getReportObj().getOriginalSourceData() != 1) {
            throw new Exception("Report data source mismatch -- need Database Resource");
        }
        this.setAttributes(report);
    }

    public DatabaseNodeInfo(String url, String driver, String username, String password) {
        this.url = url;
        this.driver = driver;
        this.userName = username;
        this.password = password;
        this.requireLogin = username != null && !username.trim().equals("");
        this.tableNameFormat = 0;
        this.name = "";
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public boolean getRequireLogin() {
        return this.requireLogin;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public Vector<String> getAdditionalDb() {
        return this.additionalDb;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void setAttributes(Node databaseNode) throws InvalidDataSourcesNodeException {
        if (databaseNode.hasAttributes()) {
            NamedNodeMap nodeMap = databaseNode.getAttributes();
            Node nameNode = nodeMap.getNamedItem("name");
            Node urlNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_URL);
            Node driverNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_DRIVER);
            Node requireLoginNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_REQUIRE_LOGIN);
            Node usernameNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_USERNAME);
            Node passwordNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_PASSWORD);
            Node additionalDbNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_ADDITIONAL_DB);
            Node encryptedPasswordNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_ENCRYPTEDPASSWORD);
            this.name = nameNode == null ? "" : nameNode.getNodeValue();
            this.url = urlNode == null ? "" : urlNode.getNodeValue();
            this.driver = driverNode == null ? "" : driverNode.getNodeValue();
            this.requireLogin = requireLoginNode == null ? false : Boolean.valueOf(requireLoginNode.getNodeValue());
            this.userName = usernameNode == null ? "" : usernameNode.getNodeValue();
            this.password = passwordNode == null ? (encryptedPasswordNode == null ? "" : Coder.decode(encryptedPasswordNode.getNodeValue())) : passwordNode.getNodeValue();
            try {
                Node tableNameFormatNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_TABLE_NAME_FORMAT);
                this.tableNameFormat = tableNameFormatNode == null ? 0 : Integer.parseInt(tableNameFormatNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidDataSourcesNodeException("XML node (" + databaseNode.getNodeName() + ") contains incorrect attributes");
            }
            this.additionalDb = additionalDbNode == null ? null : DatabaseNode.getAdditionalDb(additionalDbNode.getNodeValue());
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + databaseNode.getNodeName() + ") contains incorrect attributes");
        }
    }

    private void setAttributes(QbReport report) throws Exception {
        IDatabaseInfo idbinfo = report.getInputData().getDatabaseInfo();
        if (idbinfo instanceof DBInfoBasic && ((DBInfoBasic)((Object)idbinfo)).isUseJNDIDataSource()) {
            throw new Exception("Need Database Data source, not JNDI");
        }
        this.name = "";
        this.url = idbinfo.getURLString();
        this.driver = idbinfo.getDriverName();
        this.userName = idbinfo.getUserID();
        this.password = idbinfo.getPassword();
        this.tableNameFormat = 0;
        this.additionalDb = idbinfo instanceof DBInfoBasic ? ((DBInfoBasic)((Object)idbinfo)).getAdditionalDb() : null;
        this.requireLogin = !this.userName.trim().equals("");
    }
}

